/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.tasks.TaskBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@ApiStatus.Internal
final class YouTrackPluginAdvertiserService {
    @NonNls
    private static final String YOUTRACK_PLUGIN_ID = "com.github.jk1.ytplugin";
    @NonNls
    private static final String SHOW_TIME_TRACKING_NOTIFICATION = "tasks.youtrack.plugin.ad.show.time.tracking.notification";
    private boolean myNotificationWasShownPerAppSession = false;

    YouTrackPluginAdvertiserService() {
    }

    @NotNull
    public static YouTrackPluginAdvertiserService getInstance() {
        YouTrackPluginAdvertiserService youTrackPluginAdvertiserService = (YouTrackPluginAdvertiserService)ApplicationManager.getApplication().getService(YouTrackPluginAdvertiserService.class);
        if (youTrackPluginAdvertiserService == null) {
            YouTrackPluginAdvertiserService.$$$reportNull$$$0(0);
        }
        return youTrackPluginAdvertiserService;
    }

    public synchronized void showTimeTrackingNotification() {
        if (this.myNotificationWasShownPerAppSession) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (!propertiesComponent.getBoolean(SHOW_TIME_TRACKING_NOTIFICATION, true)) {
            return;
        }
        PluginId pluginId = PluginId.getId((String)YOUTRACK_PLUGIN_ID);
        if (PluginManagerCore.isPluginInstalled((PluginId)pluginId)) {
            return;
        }
        Notification notification = PluginsAdvertiser.getNotificationGroup().createNotification(TaskBundle.message((String)"notification.title.more.time.tracking.features", (Object[])new Object[0]), TaskBundle.message((String)"notification.content.time.tracking.in.youtrack.plugin", (Object[])new Object[0]), NotificationType.INFORMATION).setDisplayId("tasks.youtrack").setSuggestionType(true).setListener((NotificationListener)new NotificationListener.UrlOpeningListener(false)).addAction((AnAction)NotificationAction.createSimpleExpiring((String)TaskBundle.message((String)"notification.content.do.not.show.again", (Object[])new Object[0]), () -> propertiesComponent.setValue(SHOW_TIME_TRACKING_NOTIFICATION, "false", "true")));
        notification.notify(YouTrackPluginAdvertiserService.detectCurrentProject());
        this.myNotificationWasShownPerAppSession = true;
    }

    @Nullable
    private static Project detectCurrentProject() {
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        return frame != null ? frame.getProject() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/youtrack/YouTrackPluginAdvertiserService", "getInstance"));
    }
}

