/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.callusage;

import com.intellij.profiler.CallTreeState;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.ProxyCallTreeNode;
import com.intellij.profiler.model.RichCallTreeModel;
import com.intellij.profiler.model.TreeNode;
import com.intellij.profiler.model.TreeUtilKt;
import com.intellij.profiler.ui.callusage.CallTreeUIModel;
import com.intellij.profiler.ui.callusage.CallUsageNodeKt;
import com.intellij.profiler.ui.callusage.ChildrenAccess;
import com.intellij.profiler.ui.callusage.DirectChildrenAccess;
import com.intellij.profiler.ui.callusage.MainCallTreeUIModel;
import com.intellij.profiler.ui.callusage.SimpleFilteredChildrenAccess;
import com.intellij.profiler.ui.callusage.TreeFilter;
import com.intellij.profiler.ui.callusage.UIVisibleCallTreeNode;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001*\b\u0000\u0018\u00002\u00020\u0001:\u000234B?\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016J(\u0010\u0018\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001a0\u00192\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001aJ,\u0010\u001b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001a0\u0019*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001a0\u0019H\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ3\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020&2\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001aJ\u0014\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010'\u001a\u00060(R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R$\u0010,\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0011j\u0002`\u001a0-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00065"}, d2={"Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel;", "Lcom/intellij/profiler/ui/callusage/CallTreeUIModel;", "richTreeModel", "Lcom/intellij/profiler/model/RichCallTreeModel;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "metrics", "Lcom/intellij/profiler/api/ValueMetric;", "callTreeStateProvider", "Lkotlin/Function0;", "Lcom/intellij/profiler/CallTreeState;", "shouldUseDiffColumns", "", "<init>", "(Lcom/intellij/profiler/model/RichCallTreeModel;Lcom/intellij/profiler/api/ValueMetric;Lkotlin/jvm/functions/Function0;Z)V", "getShouldUseDiffColumns", "()Z", "callTree", "Lcom/intellij/profiler/model/CallTreeNode;", "getCallTree", "()Lcom/intellij/profiler/model/CallTreeNode;", "getFraction", "", "node", "Lcom/intellij/profiler/ui/callusage/UIVisibleCallTreeNode;", "getPathFromRootToNode", "", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "trimFoldedNodes", "fireModelChanged", "", "path", "Ljavax/swing/tree/TreePath;", "oldChildren", "", "", "newChildren", "(Ljavax/swing/tree/TreePath;[Ljava/lang/Object;[Ljava/lang/Object;)V", "recursionCount", "", "hideLessThanOnePercentCallsFilter", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$HideSmallNodesCallTreeFilter;", "filteredChildrenAccess", "com/intellij/profiler/ui/callusage/MainCallTreeUIModel$filteredChildrenAccess$1", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$filteredChildrenAccess$1;", "childrenAccess", "Lcom/intellij/profiler/ui/callusage/ChildrenAccess;", "getChildrenAccess", "()Lcom/intellij/profiler/ui/callusage/ChildrenAccess;", "treeNodeToggledViewFraction", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "view", "TreeNodeToggledViewFraction", "HideSmallNodesCallTreeFilter", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nMainCallTreeUIModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainCallTreeUIModel.kt\ncom/intellij/profiler/ui/callusage/MainCallTreeUIModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n360#2,7:114\n1#3:121\n*S KotlinDebug\n*F\n+ 1 MainCallTreeUIModel.kt\ncom/intellij/profiler/ui/callusage/MainCallTreeUIModel\n*L\n46#1:114,7\n*E\n"})
public final class MainCallTreeUIModel
extends CallTreeUIModel {
    @Nullable
    private final RichCallTreeModel<BaseCallStackElement> richTreeModel;
    @NotNull
    private final Function0<CallTreeState> callTreeStateProvider;
    private final boolean shouldUseDiffColumns;
    @NotNull
    private final HideSmallNodesCallTreeFilter hideLessThanOnePercentCallsFilter;
    @NotNull
    private final filteredChildrenAccess.1 filteredChildrenAccess;

    public MainCallTreeUIModel(@Nullable RichCallTreeModel<BaseCallStackElement> richTreeModel, @Nullable ValueMetric metrics, @NotNull Function0<CallTreeState> callTreeStateProvider, boolean shouldUseDiffColumns) {
        Intrinsics.checkNotNullParameter(callTreeStateProvider, (String)"callTreeStateProvider");
        RichCallTreeModel<BaseCallStackElement> richCallTreeModel = richTreeModel;
        super(richCallTreeModel != null ? richCallTreeModel.getCallTree() : null, metrics);
        this.richTreeModel = richTreeModel;
        this.callTreeStateProvider = callTreeStateProvider;
        this.shouldUseDiffColumns = shouldUseDiffColumns;
        HideSmallNodesCallTreeFilter hideSmallNodesCallTreeFilter = this.hideLessThanOnePercentCallsFilter = new HideSmallNodesCallTreeFilter();
        DirectChildrenAccess<CallTreeNode<BaseCallStackElement>> directChildrenAccess = this.getDirectAccessChildren();
        this.filteredChildrenAccess = new SimpleFilteredChildrenAccess<CallTreeNode<? extends BaseCallStackElement>>(hideSmallNodesCallTreeFilter, directChildrenAccess){

            public boolean isEnabled() {
                TreeFilter<T> treeFilter = this.getFilter();
                return treeFilter != null ? treeFilter.isEnabled() : false;
            }
        };
    }

    public /* synthetic */ MainCallTreeUIModel(RichCallTreeModel richCallTreeModel, ValueMetric valueMetric, Function0 function0, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            richCallTreeModel = null;
        }
        if ((n & 2) != 0) {
            valueMetric = null;
        }
        if ((n & 4) != 0) {
            function0 = MainCallTreeUIModel::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(richCallTreeModel, valueMetric, (Function0<CallTreeState>)function0, bl);
    }

    @Override
    public boolean getShouldUseDiffColumns() {
        return this.shouldUseDiffColumns;
    }

    @Nullable
    public final CallTreeNode<BaseCallStackElement> getCallTree() {
        RichCallTreeModel<BaseCallStackElement> richCallTreeModel = this.richTreeModel;
        return richCallTreeModel != null ? richCallTreeModel.getCallTree() : null;
    }

    @Override
    public double getFraction(@NotNull UIVisibleCallTreeNode<BaseCallStackElement> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        return this.treeNodeToggledViewFraction(node).getFractionValue();
    }

    @NotNull
    public final List<CallTreeNode<BaseCallStackElement>> getPathFromRootToNode(@NotNull CallTreeNode<? extends BaseCallStackElement> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = this.getRoot();
        CallTreeNode rootsParent = object != null ? object.getParent() : null;
        CallTreeNode<? extends BaseCallStackElement> realNode = node instanceof ProxyCallTreeNode ? ((ProxyCallTreeNode)node).getBaseNode() : node;
        List fullPath = CollectionsKt.plus((Collection)CallUsageNodeKt.traverseParents(realNode, (Function1<? super CallTreeNode<? extends BaseCallStackElement>, Boolean>)((Function1)arg_0 -> MainCallTreeUIModel.getPathFromRootToNode$lambda$1(rootsParent, arg_0))), realNode);
        return this.trimFoldedNodes(fullPath);
    }

    private final List<CallTreeNode<BaseCallStackElement>> trimFoldedNodes(List<? extends CallTreeNode<? extends BaseCallStackElement>> $this$trimFoldedNodes) {
        List result2 = new ArrayList();
        int idx = 0;
        while (idx < $this$trimFoldedNodes.size()) {
            int n;
            block3: {
                CallTreeNode<? extends BaseCallStackElement> node = $this$trimFoldedNodes.get(idx++);
                ((Collection)result2).add(node);
                if (idx >= $this$trimFoldedNodes.size()) break;
                if (!(node instanceof FoldingNodesGroup) || !((FoldingNodesGroup)node).isFolded()) continue;
                List<TreeNode> visibleChildren = TreeUtilKt.visibleChildren((TreeNode)node);
                List<? extends CallTreeNode<? extends BaseCallStackElement>> $this$indexOfFirst$iv = $this$trimFoldedNodes;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<? extends CallTreeNode<? extends BaseCallStackElement>> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    CallTreeNode<? extends BaseCallStackElement> item$iv;
                    CallTreeNode<? extends BaseCallStackElement> it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (CollectionsKt.contains((Iterable)visibleChildren, it)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            idx = n;
        }
        return result2;
    }

    public final void fireModelChanged() {
        block0: {
            Object object = this.getRoot();
            if (object == null) break block0;
            Object it = object;
            boolean bl = false;
            this.treeStructureChanged(new TreePath(it), new int[0], null);
        }
    }

    public final void fireModelChanged(@NotNull TreePath path, @Nullable Object[] oldChildren, @Nullable Object[] newChildren) {
        int n;
        MainCallTreeUIModel mainCallTreeUIModel;
        TreePath treePath;
        int[] nArray;
        int n2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object[] objectArray = oldChildren;
        if (!(objectArray == null || objectArray.length == 0)) {
            int n3 = 0;
            n2 = oldChildren.length;
            nArray = new int[n2];
            treePath = path;
            mainCallTreeUIModel = this;
            while (n3 < n2) {
                nArray[n] = n = n3++;
            }
            mainCallTreeUIModel.treeNodesRemoved(treePath, nArray, oldChildren);
        }
        if (!((objectArray = newChildren) == null || objectArray.length == 0)) {
            int n4 = 0;
            n2 = newChildren.length;
            nArray = new int[n2];
            treePath = path;
            mainCallTreeUIModel = this;
            while (n4 < n2) {
                nArray[n] = n = n4++;
            }
            mainCallTreeUIModel.treeNodesInserted(treePath, nArray, newChildren);
        }
    }

    public final int recursionCount(@NotNull CallTreeNode<? extends BaseCallStackElement> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        RichCallTreeModel<BaseCallStackElement> richCallTreeModel = this.richTreeModel;
        return richCallTreeModel != null ? richCallTreeModel.recursionCount(node) : 0;
    }

    @Override
    @NotNull
    public ChildrenAccess<CallTreeNode<BaseCallStackElement>> getChildrenAccess() {
        return this.filteredChildrenAccess;
    }

    @NotNull
    public final TreeNodeToggledViewFraction treeNodeToggledViewFraction(@NotNull UIVisibleCallTreeNode<BaseCallStackElement> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return ((CallTreeState)((Object)this.callTreeStateProvider.invoke())).getShowPercentsOfRoot() ? new TreeNodeToggledViewFraction(view.getFractionOfAllCallsDouble(), TreeNodeToggledViewFraction.Type.OfRoot) : new TreeNodeToggledViewFraction(view.getFractionOfParentCallDouble(), TreeNodeToggledViewFraction.Type.OfParent);
    }

    private static final CallTreeState _init_$lambda$0() {
        return ((CommonProfilerUiOptions)CallUsageNodeKt.getSettings().getState()).getCallTreeState();
    }

    private static final boolean getPathFromRootToNode$lambda$1(CallTreeNode $rootsParent, CallTreeNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it != $rootsParent;
    }

    public MainCallTreeUIModel() {
        this(null, null, null, false, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\b2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$HideSmallNodesCallTreeFilter;", "Lcom/intellij/profiler/ui/callusage/TreeFilter;", "Lcom/intellij/profiler/model/CallTreeNode;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/CallUsageNode;", "<init>", "(Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel;)V", "isEnabled", "", "apply", "value", "intellij.profiler.common"})
    private final class HideSmallNodesCallTreeFilter
    implements TreeFilter<CallTreeNode<? extends BaseCallStackElement>> {
        @Override
        public boolean isEnabled() {
            return ((CallTreeState)((Object)MainCallTreeUIModel.this.callTreeStateProvider.invoke())).getHideLessOnePercents();
        }

        @Override
        public boolean apply(@NotNull CallTreeNode<? extends BaseCallStackElement> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return MainCallTreeUIModel.this.treeNodeToggledViewFraction(MainCallTreeUIModel.this.getUIVisibleNodeView(value)).getFractionValue() >= 0.01;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction;", "", "fractionValue", "", "type", "Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction$Type;", "<init>", "(DLcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction$Type;)V", "getFractionValue", "()D", "getType", "()Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction$Type;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Type", "intellij.profiler.common"})
    public static final class TreeNodeToggledViewFraction {
        private final double fractionValue;
        @NotNull
        private final Type type;

        public TreeNodeToggledViewFraction(double fractionValue, @NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.fractionValue = fractionValue;
            this.type = type;
        }

        public final double getFractionValue() {
            return this.fractionValue;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final double component1() {
            return this.fractionValue;
        }

        @NotNull
        public final Type component2() {
            return this.type;
        }

        @NotNull
        public final TreeNodeToggledViewFraction copy(double fractionValue, @NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new TreeNodeToggledViewFraction(fractionValue, type);
        }

        public static /* synthetic */ TreeNodeToggledViewFraction copy$default(TreeNodeToggledViewFraction treeNodeToggledViewFraction, double d, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                d = treeNodeToggledViewFraction.fractionValue;
            }
            if ((n & 2) != 0) {
                type = treeNodeToggledViewFraction.type;
            }
            return treeNodeToggledViewFraction.copy(d, type);
        }

        @NotNull
        public String toString() {
            return "TreeNodeToggledViewFraction(fractionValue=" + this.fractionValue + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.fractionValue);
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TreeNodeToggledViewFraction)) {
                return false;
            }
            TreeNodeToggledViewFraction treeNodeToggledViewFraction = (TreeNodeToggledViewFraction)other;
            if (Double.compare(this.fractionValue, treeNodeToggledViewFraction.fractionValue) != 0) {
                return false;
            }
            return this.type == treeNodeToggledViewFraction.type;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/callusage/MainCallTreeUIModel$TreeNodeToggledViewFraction$Type;", "", "<init>", "(Ljava/lang/String;I)V", "OfParent", "OfRoot", "intellij.profiler.common"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type OfParent = new Type();
            public static final /* enum */ Type OfRoot = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.OfParent, Type.OfRoot};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

