/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializationManagerImpl;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.Processors;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePaths;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.intellij.util.indexing.impl.storage.IndexStorageLayoutLocator;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.CompareIndicesKt;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.StoredIndexedFileResolver;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import com.jetbrains.performancePlugin.utils.indexes.CurrentIndexedFileResolver;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 Y2\u00020\u0001:\u0002YZB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J4\u0010&\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'\u0012\u0004\u0012\u00020(0\u00172\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*2\u0006\u0010!\u001a\u00020\u000eH\u0002J.\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00112\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002JV\u00101\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u00020,0\u00112\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J\u008a\u0001\u00106\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\f\u00104\u001a\b\u0012\u0004\u0012\u00020,0\u00112\u001c\u00107\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u001c\u0010:\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u008a\u0001\u0010;\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\f\u00104\u001a\b\u0012\u0004\u0012\u00020,0\u00112\u001c\u0010:\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u001c\u00107\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u0006\u0010/\u001a\u0002002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0080\u0001\u0010<\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\u001c\u0010:\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\f\u00104\u001a\b\u0012\u0004\u0012\u00020,0\u00112\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H20\u001b2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H20\u001b2\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J&\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H30@\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H30AH\u0002JB\u0010B\u001a\u0014\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00020D0C\"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0006\u0010!\u001a\u00020\u000e2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'H\u0002J|\u0010E\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0006\u0010F\u001a\u00020,2\u001c\u00107\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u001c\u0010:\u001a\u0018\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u000209\u0012\u0002\b\u0003082\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020%H\u0002J`\u0010G\u001a\u00020 \"\u0004\b\u0000\u00102\"\u0004\b\u0001\u001032\u0006\u0010F\u001a\u00020,2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30'2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30@2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002H30@2\u0006\u0010$\u001a\u00020%H\u0002J \u0010J\u001a\u00020K2\u000e\u00105\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010L\u001a\u00020\u0003H\u0002J \u0010J\u001a\u00020K2\u000e\u00105\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010F\u001a\u00020,H\u0002J \u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u00112\u0006\u0010F\u001a\u00020,2\b\b\u0002\u0010O\u001a\u00020\u0003H\u0002J \u0010P\u001a\b\u0012\u0004\u0012\u00020N0\u00112\u0006\u0010F\u001a\u00020,2\b\b\u0002\u0010O\u001a\u00020\u0003H\u0002J0\u0010Q\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\u00032\u000e\u00105\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010F\u001a\u00020,2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010S\u001a\u00020K2\u0006\u0010T\u001a\u00020U2\u000e\u00105\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030'2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020U0\u00112\u0006\u0010T\u001a\u00020UH\u0002J\u0014\u0010W\u001a\u00020\u0003*\u00020\u00032\u0006\u0010X\u001a\u00020\u0003H\u0002R!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R-\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00170\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0015\u001a\u0004\b\u0018\u0010\u0013R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0015\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006["}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getStoredIndicesDirectory", "Ljava/nio/file/Path;", "getFailureDiagnosticDirectory", "ignoredFilesPatterns", "", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "Lkotlin/Lazy;", "ignoredPatternsForReporting", "Lkotlin/Pair;", "getIgnoredPatternsForReporting", "ignoredPatternsForReporting$delegate", "fileTypesWithNoStubTree", "", "getFileTypesWithNoStubTree", "()Ljava/util/Set;", "fileTypesWithNoStubTree$delegate", "compareIndexes", "", "storedIndexDir", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "findFileBasedIndexExtension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "Lcom/intellij/openapi/Disposable;", "id", "Lcom/intellij/util/indexing/ID;", "resolveFiles", "Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "storedIndexedFileResolver", "Lcom/jetbrains/performancePlugin/commands/StoredIndexedFileResolver;", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "compareCurrentAndStoredIndexData", "K", "V", "resolvedFiles", "extension", "compareForwardIndexes", "currentIndex", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "storedIndex", "compareInvertedIndexes", "checkNoKeysAreMissing", "allStoredKeys", "allCurrentKeys", "toMap", "", "Lcom/intellij/util/indexing/ValueContainer;", "openStoredIndex", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex;", "Lcom/intellij/util/indexing/impl/storage/VfsAwareMapReduceIndex$IndexerIdHolder;", "compareFileData", "fileDescriptor", "assertForwardIndexDataAreTheSameForFile", "expectedData0", "actualData0", "isKnownError", "", "fileNameOrIndexData", "createAttachmentsForActualFile", "Lcom/intellij/openapi/diagnostic/Attachment;", "pathPrefix", "createAttachmentsForExpectedFile", "buildFileDataMismatchMessage", "reason", "doesFileHaveProvidedIndex", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileAndAllRelevantSiblings", "withIndent", "indent", "Companion", "FileDescriptor", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCompareIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 8 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,692:1\n1#2:693\n1279#3,2:694\n1293#3,4:696\n1454#3,5:711\n1202#3,2:716\n1230#3,4:718\n1202#3,2:722\n1230#3,4:724\n1246#3,4:730\n1246#3,4:736\n1863#3,2:742\n1863#3,2:744\n1557#3:746\n1628#3,3:747\n1557#3:750\n1628#3,3:751\n1557#3:760\n1628#3,3:761\n827#3:764\n855#3,2:765\n1557#3:767\n1628#3,3:768\n827#3:771\n855#3,2:772\n1863#3,2:774\n1863#3,2:776\n827#3:778\n855#3,2:779\n1755#3,3:781\n503#4,7:700\n462#4:728\n412#4:729\n462#4:734\n412#4:735\n487#4,7:784\n126#5:707\n153#5,3:708\n37#6,2:740\n18#6:756\n1251#7,2:754\n3829#8:757\n4344#8,2:758\n*S KotlinDebug\n*F\n+ 1 CompareIndices.kt\ncom/jetbrains/performancePlugin/commands/CompareIndices\n*L\n190#1:694,2\n190#1:696,4\n261#1:711,5\n376#1:716,2\n376#1:718,4\n428#1:722,2\n428#1:724,4\n543#1:730,4\n544#1:736,4\n588#1:742,2\n600#1:744,2\n610#1:746\n610#1:747,3\n617#1:750\n617#1:751,3\n135#1:760\n135#1:761,3\n135#1:764\n135#1:765,2\n143#1:767\n143#1:768,3\n143#1:771\n143#1:772,2\n143#1:774,2\n148#1:776,2\n158#1:778\n158#1:779,2\n271#1:781,3\n223#1:700,7\n543#1:728\n543#1:729\n544#1:734\n544#1:735\n431#1:784,7\n223#1:707\n223#1:708,3\n581#1:740,2\n659#1:756\n648#1:754,2\n659#1:757\n659#1:758,2\n*E\n"})
public final class CompareIndices
extends AbstractCommand {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy ignoredFilesPatterns$delegate;
    @NotNull
    private final Lazy ignoredPatternsForReporting$delegate;
    @NotNull
    private final Lazy fileTypesWithNoStubTree$delegate;
    private static final int LIMIT_OF_ERRORS_PER_COLLECTOR = 100;

    public CompareIndices(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
        this.ignoredFilesPatterns$delegate = LazyKt.lazy(CompareIndices::ignoredFilesPatterns_delegate$lambda$5);
        this.ignoredPatternsForReporting$delegate = LazyKt.lazy(CompareIndices::ignoredPatternsForReporting_delegate$lambda$10);
        this.fileTypesWithNoStubTree$delegate = LazyKt.lazy(CompareIndices::fileTypesWithNoStubTree_delegate$lambda$12);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Path storedIndexDir = this.getStoredIndicesDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CompareIndices._execute$lambda$0(project2, actionCallback, this, storedIndexDir));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final Path getStoredIndicesDirectory() {
        String property;
        String string = property = System.getProperty("compare.indices.command.stored.indexes.directory");
        if (string == null) {
            boolean bl = false;
            String string2 = "Path to stored indices is not specified";
            throw new IllegalStateException(string2.toString());
        }
        String it = string;
        boolean bl = false;
        Path path = Paths.get(it, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"let(...)");
        return path;
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.indices.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-indices", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    private final List<String> getIgnoredFilesPatterns() {
        Lazy lazy = this.ignoredFilesPatterns$delegate;
        return (List)lazy.getValue();
    }

    private final List<Pair<String, String>> getIgnoredPatternsForReporting() {
        Lazy lazy = this.ignoredPatternsForReporting$delegate;
        return (List)lazy.getValue();
    }

    private final Set<String> getFileTypesWithNoStubTree() {
        Lazy lazy = this.fileTypesWithNoStubTree$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void compareIndexes(Path storedIndexDir, ProgressIndicator indicator, Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        indicator.setText(IndexingBundle.message((String)"index.content.diagnostic.reading", (Object[])new Object[0]));
        IndexContentDiagnostic storedIndexContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(storedIndexDir));
        StoredIndexedFileResolver storedIndexedFileResolver = new StoredIndexedFileResolver(storedIndexContentDiagnostic);
        Path path = failureDiagnosticDirectory.resolve("files-resolution-errors");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        ToDirectoryWritingErrorCollector filesErrorCollector = new ToDirectoryWritingErrorCollector("resolve-files", path, 100);
        List<FileDescriptor> resolvedFiles = this.resolveFiles(storedIndexedFileResolver, filesErrorCollector, indicator, project);
        if (filesErrorCollector.getNumberOfErrors() > 0) {
            throw new IllegalArgumentException("Some files cannot be resolved. See <failure-diagnostics-dir>/files-resolution-errors");
        }
        CompareIndicesKt.access$getLOG$p().info("Stored index directory contains: " + StoreIndices.Companion.dumpDirectory(storedIndexDir));
        List idsToCompare = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()), CompareIndices::compareIndexes$lambda$13), CompareIndices::compareIndexes$lambda$14));
        CompareIndicesKt.access$getLOG$p().info("Comparing indexes concurrently");
        Iterable $this$associateWith$iv = idsToCompare;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            ID iD = (ID)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            String string = iD.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + iD.getName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            ToDirectoryWritingErrorCollector toDirectoryWritingErrorCollector = new ToDirectoryWritingErrorCollector(string, path2, 100);
            object.put(t, toDirectoryWritingErrorCollector);
        }
        Map errorCollectors = result$iv;
        AtomicInteger finishedCounter = new AtomicInteger();
        ConcurrentTasksProgressManager comparisonTaskProgressManager = new ConcurrentTasksProgressManager(indicator, idsToCompare.size());
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(idsToCompare, indicator, arg_0 -> CompareIndices.compareIndexes$lambda$19(comparisonTaskProgressManager, errorCollectors, this, resolvedFiles, storedIndexDir, project, finishedCounter, idsToCompare, arg_0));
        Map $this$filterValues$iv = errorCollectors;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            ToDirectoryWritingErrorCollector it = (ToDirectoryWritingErrorCollector)entry.getValue();
            boolean bl = false;
            if (!(it.getNumberOfErrors() > 0)) continue;
            result$iv2.put(entry.getKey(), entry.getValue());
        }
        $this$filterValues$iv = result$iv2;
        boolean $i$f$map = false;
        result$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add((ID)it.getKey());
        }
        List failedIndexes = (List)destination$iv$iv;
        if (!((Collection)failedIndexes).isEmpty()) {
            throw new RuntimeException("Comparison has failed for indexes [" + CollectionsKt.joinToString$default((Iterable)failedIndexes, null, null, null, (int)0, null, CompareIndices::compareIndexes$lambda$22, (int)31, null) + "]. Details are saved to " + failureDiagnosticDirectory);
        }
        CompareIndicesKt.access$getLOG$p().info("Success. All indices are equal: " + CollectionsKt.joinToString$default((Iterable)idsToCompare, null, null, null, (int)0, null, CompareIndices::compareIndexes$lambda$23, (int)31, null));
    }

    private final Pair<FileBasedIndexExtension<?, ?>, Disposable> findFileBasedIndexExtension(ID<?, ?> id, Path storedIndexDir) {
        Pair pair;
        if (Intrinsics.areEqual((Object)id.getName(), (Object)"Stubs")) {
            SerializationManagerImpl storedSerializationManager = new SerializationManagerImpl(storedIndexDir.resolve("rep.names"), true);
            Map nameStorageDump = storedSerializationManager.dumpNameStorage();
            CompareIndicesKt.access$getLOG$p().info("stored stub element name storage " + nameStorageDump);
            StubForwardIndexExternalizer stubForwardIndexExternalizer = StubForwardIndexExternalizer.createFileLocalExternalizer();
            Intrinsics.checkNotNullExpressionValue((Object)stubForwardIndexExternalizer, (String)"createFileLocalExternalizer(...)");
            StubForwardIndexExternalizer stubForwardIndexExternalizer2 = stubForwardIndexExternalizer;
            FileBasedIndexExtension storedStubUpdatingIndex = (FileBasedIndexExtension)new StubUpdatingIndex(stubForwardIndexExternalizer2, (SerializationManagerEx)storedSerializationManager);
            pair = TuplesKt.to((Object)storedStubUpdatingIndex, (Object)storedSerializationManager);
        } else {
            Object object = FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(arg_0 -> CompareIndices.findFileBasedIndexExtension$lambda$25(arg_0 -> CompareIndices.findFileBasedIndexExtension$lambda$24(id, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)object);
            FileBasedIndexExtension usualExtension = (FileBasedIndexExtension)object;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable emptyDisposable = disposable;
            pair = TuplesKt.to((Object)usualExtension, (Object)emptyDisposable);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileDescriptor> resolveFiles(StoredIndexedFileResolver storedIndexedFileResolver, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void destination$iv;
        void $this$flatMapTo$iv;
        Iterable iterable = CurrentIndexedFileResolver.INSTANCE.getAllToBeIndexedFilesInProject(project, indicator).values();
        Collection collection = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Set it = (Set)element$iv;
            boolean bl = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet allCurrentFiles = (HashSet)destination$iv;
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.resolving.files", new Object[0]));
        indicator.setIndeterminate(false);
        List<FileDescriptor> fileDescriptors = Collections.synchronizedList(new ArrayList());
        AtomicInteger finished = new AtomicInteger();
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(CollectionsKt.toList((Iterable)storedIndexedFileResolver.getOriginalIndexedFiles()), indicator, arg_0 -> CompareIndices.resolveFiles$lambda$29(this, errorCollector, indicator, finished, storedIndexedFileResolver, allCurrentFiles, fileDescriptors, project, arg_0));
        Intrinsics.checkNotNull(fileDescriptors);
        return fileDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K, V> void compareCurrentAndStoredIndexData(List<FileDescriptor> resolvedFiles, FileBasedIndexExtension<K, V> extension, Path storedIndexDir, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.preparing.indexes", new Object[0]));
        indicator.setIndeterminate(true);
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
        ActionsKt.runReadAction(() -> CompareIndices.compareCurrentAndStoredIndexData$lambda$30(fileBasedIndex2, indexId, project));
        UpdatableIndex updatableIndex = fileBasedIndex2.getIndex(indexId);
        Intrinsics.checkNotNullExpressionValue((Object)updatableIndex, (String)"getIndex(...)");
        UpdatableIndex currentIndex = updatableIndex;
        VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> storedIndex = this.openStoredIndex(storedIndexDir, extension);
        try {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            indicator.setText2("");
            if (!(extension.needsForwardIndexWhenSharing() || !(extension instanceof SingleEntryFileBasedIndexExtension))) {
                boolean bl = false;
                String string = "Index " + indexId.getName() + " is SingleEntryFileBasedIndexExtension and does not need forward index. This is a wrong index because SingleEntryFileBasedIndexExtension by its nature effectively consists of only the forward index.";
                throw new IllegalStateException(string.toString());
            }
            if (extension.needsForwardIndexWhenSharing()) {
                this.compareForwardIndexes(extension, resolvedFiles, currentIndex, (UpdatableIndex)storedIndex, errorCollector, indicator, project);
            }
            if (!(extension instanceof SingleEntryFileBasedIndexExtension)) {
                this.compareInvertedIndexes(extension, resolvedFiles, (UpdatableIndex)storedIndex, currentIndex, errorCollector, indicator, project);
            }
        }
        finally {
            storedIndex.dispose();
        }
    }

    private final <K, V> void compareForwardIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object object = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.forward.index", (Object[])object));
        object = ((Iterable)resolvedFiles).iterator();
        int n = 0;
        while (object.hasNext()) {
            int finished = n++;
            FileDescriptor resolvedFile = (FileDescriptor)object.next();
            indicator.setFraction((double)finished / (double)resolvedFiles.size());
            indicator.setText2(resolvedFile.getCurrentFile().getUrl());
            this.compareFileData(resolvedFile, currentIndex, storedIndex, extension, errorCollector, project);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void compareInvertedIndexes(FileBasedIndexExtension<K, V> extension, List<FileDescriptor> resolvedFiles, UpdatableIndex<K, V, FileContent, ?> storedIndex, UpdatableIndex<K, V, FileContent, ?> currentIndex, ErrorCollector errorCollector, ProgressIndicator indicator, Project project) {
        void $this$associateByTo$iv$iv;
        ID iD = extension.getName();
        Intrinsics.checkNotNullExpressionValue((Object)iD, (String)"getName(...)");
        ID indexId = iD;
        Object[] objectArray = new Object[]{indexId.getName()};
        indicator.setText(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index", objectArray));
        indicator.setText2(PerformanceTestingBundle.message("compare.indexes.comparing.inverted.index.collecting.keys", new Object[0]));
        indicator.setIndeterminate(true);
        HashSet allStoredKeys = new HashSet();
        errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$33(storedIndex, allStoredKeys, project));
        HashSet allCurrentKeys = new HashSet();
        errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$35(currentIndex, allCurrentKeys, project));
        this.checkNoKeysAreMissing(extension, storedIndex, resolvedFiles, allStoredKeys, allCurrentKeys, errorCollector, project);
        Iterable $this$associateBy$iv = resolvedFiles;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object entry : $this$associateByTo$iv$iv) {
            void it;
            FileDescriptor fileDescriptor = (FileDescriptor)entry;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getOriginalFilePath().getOriginalFileSystemId(), entry);
        }
        Map originalFileIdToFileDescriptor = destination$iv$iv;
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        Iterator iterator2 = ((Iterable)allStoredKeys).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Map storedFileIdToValue;
            int index = n++;
            Object storedKey = iterator2.next();
            indicator.setFraction((double)index / (double)allStoredKeys.size());
            if ((Map)errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$38(this, storedIndex, storedKey)) == null || (Map)errorCollector.runCatchingError(() -> CompareIndices.compareInvertedIndexes$lambda$40(this, currentIndex, storedKey)) == null) continue;
            for (Map.Entry entry : storedFileIdToValue.entrySet()) {
                FileDescriptor fileDescriptor;
                int currentFileId;
                Map currentFileIdToValue;
                Object currentValue;
                int storedFileId = ((Number)entry.getKey()).intValue();
                Object storedValue = entry.getValue();
                if ((FileDescriptor)originalFileIdToFileDescriptor.get(storedFileId) == null || IndexDataComparer.INSTANCE.areValuesTheSame(extension, storedValue, currentValue = currentFileIdToValue.get(currentFileId = FileBasedIndexImpl.getFileId((VirtualFile)fileDescriptor.getCurrentFile()))) || !this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) continue;
                errorCollector.runCatchingError((Function0)new Function0(this, storedKey, extension, fileDescriptor, project, storedValue, currentValue){
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ K $storedKey;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ FileDescriptor $fileDescriptor;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ V $storedValue;
                    final /* synthetic */ V $currentValue;
                    {
                        this.this$0 = $receiver;
                        this.$storedKey = $storedKey;
                        this.$extension = $extension;
                        this.$fileDescriptor = $fileDescriptor;
                        this.$project = $project;
                        this.$storedValue = $storedValue;
                        this.$currentValue = $currentValue;
                    }

                    public final Void invoke() {
                        String message = CompareIndices.access$buildFileDataMismatchMessage(this.this$0, "Values mismatch for key " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$storedKey), this.$extension, this.$fileDescriptor, this.$project);
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("expected-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$storedValue)));
                        ((Collection)attachments).add(new Attachment("actual-value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(this.$currentValue)));
                        CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this.this$0, this.$fileDescriptor, null, 2, null));
                        Collection $this$toTypedArray$iv = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Attachment[] attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <K, V> void checkNoKeysAreMissing(FileBasedIndexExtension<K, V> extension, UpdatableIndex<K, V, FileContent, ?> storedIndex, List<FileDescriptor> resolvedFiles, Set<? extends K> allStoredKeys, Set<? extends K> allCurrentKeys, ErrorCollector errorCollector, Project project) {
        Set missingKeys = SetsKt.minus(allStoredKeys, (Iterable)allCurrentKeys);
        if (!((Collection)missingKeys).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = resolvedFiles;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FileDescriptor fileDescriptor = (FileDescriptor)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.getOriginalFilePath().getOriginalFileSystemId(), element$iv$iv);
            }
            Map originalFileIdToFileDescriptor = destination$iv$iv;
            for (Object missingKey : missingKeys) {
                Map storedFileIdToValue;
                if ((Map)errorCollector.runCatchingError(() -> CompareIndices.checkNoKeysAreMissing$lambda$44(this, storedIndex, missingKey, originalFileIdToFileDescriptor)) == null || storedFileIdToValue.isEmpty()) continue;
                FileDescriptor fileDescriptor = (FileDescriptor)originalFileIdToFileDescriptor.get(storedFileIdToValue.entrySet().iterator().next().getKey());
                if (!this.getIgnoredPatternsForReporting().isEmpty() && this.isKnownError(extension, IndexDataPresenter.INSTANCE.getPresentableIndexKey(missingKey))) continue;
                FileDescriptor fileDescriptor2 = fileDescriptor;
                Intrinsics.checkNotNull((Object)fileDescriptor2);
                if (this.isKnownError(extension, fileDescriptor2)) continue;
                errorCollector.runCatchingError((Function0)new Function0(missingKey, storedFileIdToValue, originalFileIdToFileDescriptor, this, extension, project){
                    final /* synthetic */ K $missingKey;
                    final /* synthetic */ Map<Integer, V> $storedFileIdToValue;
                    final /* synthetic */ Map<Integer, FileDescriptor> $originalFileIdToFileDescriptor;
                    final /* synthetic */ CompareIndices this$0;
                    final /* synthetic */ FileBasedIndexExtension<K, V> $extension;
                    final /* synthetic */ Project $project;
                    {
                        this.$missingKey = $missingKey;
                        this.$storedFileIdToValue = $storedFileIdToValue;
                        this.$originalFileIdToFileDescriptor = $originalFileIdToFileDescriptor;
                        this.this$0 = $receiver;
                        this.$extension = $extension;
                        this.$project = $project;
                    }

                    public final Void invoke() {
                        StringBuilder stringBuilder;
                        FileBasedIndexExtension<K, V> fileBasedIndexExtension = this.$extension;
                        K k = this.$missingKey;
                        Attachment[] attachmentArray = this.$storedFileIdToValue;
                        Map<Integer, FileDescriptor> object2 = this.$originalFileIdToFileDescriptor;
                        CompareIndices compareIndices = this.this$0;
                        Project project = this.$project;
                        StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                        boolean bl = false;
                        StringBuilder stringBuilder2 = $this$invoke_u24lambda_u240.append("Index " + fileBasedIndexExtension.getName().getName() + ": key is unknown to actual index data: " + IndexDataPresenter.INSTANCE.getPresentableIndexKey(k));
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder3 = $this$invoke_u24lambda_u240.append("The key must be present in the index for the following files: ");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                        Iterator<Map.Entry<Integer, V>> iterator2 = attachmentArray.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)iterator2.next().getKey()).intValue();
                            if (object2.get(storedFileId) == null) continue;
                            StringBuilder stringBuilder4 = $this$invoke_u24lambda_u240.append(CompareIndices.access$withIndent(compareIndices, CompareIndices.access$buildFileDataMismatchMessage(compareIndices, "Key is not available in the actual index for the file", fileBasedIndexExtension, fileDescriptor, project), "  "));
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)$this$invoke_u24lambda_u240.append('\n'), (String)"append(...)");
                        }
                        String string = stringBuilder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String message = string;
                        ArrayList<E> attachments = new ArrayList<E>();
                        ((Collection)attachments).add(new Attachment("key.txt", IndexDataPresenter.INSTANCE.getPresentableIndexKey(this.$missingKey)));
                        int nextMismatchedFileId = 1;
                        for (Map.Entry entry : this.$storedFileIdToValue.entrySet()) {
                            FileDescriptor fileDescriptor;
                            int storedFileId = ((Number)entry.getKey()).intValue();
                            V storedValue = entry.getValue();
                            if (this.$originalFileIdToFileDescriptor.get(storedFileId) == null) continue;
                            String pathPrefix = "file-and-value-" + nextMismatchedFileId++ + "/";
                            ((Collection)attachments).add(new Attachment(pathPrefix + "value.txt", IndexDataPresenter.INSTANCE.getPresentableIndexValue(storedValue)));
                            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.access$createAttachmentsForActualFile(this.this$0, fileDescriptor, pathPrefix));
                        }
                        Collection collection = attachments;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = collection;
                        attachmentArray = thisCollection$iv.toArray(new Attachment[0]);
                        throw new RuntimeExceptionWithAttachments(message, Arrays.copyOf(attachmentArray, attachmentArray.length));
                    }
                });
            }
        }
    }

    private final <V> Map<Integer, V> toMap(ValueContainer<V> $this$toMap) {
        HashMap map = new HashMap();
        $this$toMap.forEach((arg_0, arg_1) -> CompareIndices.toMap$lambda$46((arg_0, arg_1) -> CompareIndices.toMap$lambda$45(map, arg_0, arg_1), arg_0, arg_1));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized <K, V> VfsAwareMapReduceIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> openStoredIndex(Path storedIndexDir, FileBasedIndexExtension<K, V> extension) {
        String propertyName = "index_root_path";
        String oldValue = System.setProperty(propertyName, ((Object)storedIndexDir.toAbsolutePath()).toString());
        try {
            VfsAwareMapReduceIndex vfsAwareMapReduceIndex = new VfsAwareMapReduceIndex(extension, IndexStorageLayoutLocator.getLayout(extension));
            return vfsAwareMapReduceIndex;
        }
        finally {
            SystemProperties.setProperty((String)propertyName, (String)oldValue);
        }
    }

    private final <K, V> void compareFileData(FileDescriptor fileDescriptor, UpdatableIndex<K, V, FileContent, ?> currentIndex, UpdatableIndex<K, V, FileContent, ?> storedIndex, FileBasedIndexExtension<K, V> extension, ErrorCollector errorCollector, Project project) {
        Map map = (Map)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$48(storedIndex, fileDescriptor));
        if (map == null) {
            return;
        }
        Map storedData = map;
        Map map2 = (Map)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$50(currentIndex, fileDescriptor));
        if (map2 == null) {
            return;
        }
        Map currentData = map2;
        if ((Unit)errorCollector.runCatchingError(() -> CompareIndices.compareFileData$lambda$51(this, fileDescriptor, extension, storedData, currentData, project)) == null) {
            return;
        }
    }

    private final <K, V> void assertForwardIndexDataAreTheSameForFile(FileDescriptor fileDescriptor, FileBasedIndexExtension<K, V> extension, Map<K, ? extends V> expectedData0, Map<K, ? extends V> actualData0, Project project) {
        Map expectedData = null;
        Map actualData = null;
        if (Intrinsics.areEqual((Object)extension.getName(), (Object)StubUpdatingIndex.INDEX_ID) && CollectionsKt.contains((Iterable)this.getFileTypesWithNoStubTree(), (Object)fileDescriptor.getOriginalFilePath().getFileType())) {
            SerializedStubTree serializedStubTree;
            Map.Entry it;
            Map map;
            Object k;
            Map.Entry it$iv$iv;
            boolean bl;
            Map map2;
            Map $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = expectedData0;
            boolean $i$f$mapValues = false;
            Map map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl2 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            expectedData = destination$iv$iv;
            $this$mapValues$iv = actualData0;
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                bl = false;
                it = (Map.Entry)element$iv$iv$iv;
                k = it$iv$iv.getKey();
                map = map2;
                boolean bl3 = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.intellij.psi.stubs.SerializedStubTree");
                serializedStubTree = ((SerializedStubTree)v).withoutStub();
                map.put(k, serializedStubTree);
            }
            actualData = destination$iv$iv;
        } else {
            expectedData = expectedData0;
            actualData = actualData0;
        }
        if (IndexDataComparer.INSTANCE.areIndexedDataOfFileTheSame(extension, expectedData, actualData)) {
            return;
        }
        if (this.getIgnoredPatternsForReporting().isEmpty() || !this.isKnownError(extension, fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath())) {
            String message = this.buildFileDataMismatchMessage("Indexed data maps do not match for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath(), extension, fileDescriptor, project);
            Attachment expectedDataAttachment = expectedData.isEmpty() ? new Attachment("expected-data-is-empty.txt", "") : new Attachment("expected-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(expectedData));
            Attachment actualDataAttachment = actualData.isEmpty() ? new Attachment("actual-data-is-empty.txt", "") : new Attachment("actual-data.txt", IndexDataPresenter.INSTANCE.getPresentableKeyValueMap(actualData));
            Object[] objectArray = new Attachment[]{expectedDataAttachment, actualDataAttachment};
            ArrayList attachments = CollectionsKt.arrayListOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForActualFile$default(this, fileDescriptor, null, 2, null));
            CollectionsKt.addAll((Collection)attachments, (Iterable)CompareIndices.createAttachmentsForExpectedFile$default(this, fileDescriptor, null, 2, null));
            Collection $this$toTypedArray$iv = attachments;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new Attachment[0]);
            throw new RuntimeExceptionWithAttachments(message, (Attachment[])Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, String fileNameOrIndexData) {
        String fileExtension = FilesKt.getExtension((File)new File(fileNameOrIndexData));
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileNameOrIndexData + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    private final boolean isKnownError(FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor) {
        String fileExtension = fileDescriptor.getCurrentFile().getExtension();
        Iterable $this$forEach$iv = this.getIgnoredPatternsForReporting();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)extension.getName().getName()) || !Intrinsics.areEqual((Object)it.getSecond(), (Object)fileExtension)) continue;
            CompareIndicesKt.access$getLOG$p().info("Reporting index mismatch of " + fileExtension + " in " + extension.getName().getName() + " extension is ignored");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForActualFile(FileDescriptor fileDescriptor, String pathPrefix) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(fileDescriptor.getCurrentFile());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CoreAttachmentFactory.createAttachment((String)(pathPrefix + "actual-file/" + file.getName()), (VirtualFile)file));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List createAttachmentsForActualFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForActualFile(fileDescriptor, string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Attachment> createAttachmentsForExpectedFile(FileDescriptor fileDescriptor, String pathPrefix) {
        List list;
        VirtualFile expectedFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(fileDescriptor.getOriginalFilePath().getOriginalFileUrl());
        if (expectedFile != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.findFileAndAllRelevantSiblings(expectedFile);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CoreAttachmentFactory.createAttachment((String)(pathPrefix + "expected-file/" + file.getName()), (VirtualFile)file));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List createAttachmentsForExpectedFile$default(CompareIndices compareIndices, FileDescriptor fileDescriptor, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return compareIndices.createAttachmentsForExpectedFile(fileDescriptor, string);
    }

    private final String buildFileDataMismatchMessage(String reason, FileBasedIndexExtension<?, ?> extension, FileDescriptor fileDescriptor, Project project) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildFileDataMismatchMessage_u24lambda_u2458 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append("Index mismatch " + extension.getName().getName() + " for " + fileDescriptor.getOriginalFilePath().getPortableFilePath().getPresentablePath() + ": " + reason);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append("File of expected data:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append(this.withIndent(fileDescriptor.getOriginalFilePath().toString(), "  "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append("File of actual data:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        IndexedFilePath actualIndexedFilePath = IndexedFilePaths.INSTANCE.createIndexedFilePath(fileDescriptor.getCurrentFile(), project);
        StringBuilder stringBuilder6 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append(this.withIndent(actualIndexedFilePath.toString(), "  "));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        if (this.doesFileHaveProvidedIndex(fileDescriptor.getCurrentFile(), extension, project)) {
            StringBuilder stringBuilder7 = $this$buildFileDataMismatchMessage_u24lambda_u2458.append("  Index " + extension.getName().getName() + " of this file is provided by index infrastructure extension");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doesFileHaveProvidedIndex(VirtualFile file, FileBasedIndexExtension<?, ?> extension, Project project) {
        boolean bl;
        block1: {
            void $this$any$iv;
            int fileId = FileBasedIndex.getFileId((VirtualFile)file);
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()), arg_0 -> CompareIndices.doesFileHaveProvidedIndex$lambda$59(project, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor it = (FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor)element$iv;
                boolean bl2 = false;
                if (!it.hasIndexForFile(file, fileId, extension)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private final List<VirtualFile> findFileAndAllRelevantSiblings(VirtualFile file) {
        if (!Intrinsics.areEqual((Object)file.getExtension(), (Object)"class")) {
            return CollectionsKt.listOf((Object)file);
        }
        v0 = file.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getNameWithoutExtension(...)");
        fullClassName = v0;
        baseClassName = StringsKt.substringBefore$default((String)fullClassName, (String)"$", null, (int)2, null);
        v1 = file.getParent();
        if (v1 == null) {
            return CollectionsKt.listOf((Object)file);
        }
        parent = v1;
        parent.refresh(false, true);
        $this$orEmpty$iv = parent.getChildren();
        $i$f$orEmpty = false;
        v2 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            v2 = new VirtualFile[]{};
        }
        $this$orEmpty$iv = v2;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var11_11 = ((void)$this$filterTo$iv$iv).length;
        for (var10_10 = 0; var10_10 < var11_11; ++var10_10) {
            it = element$iv$iv = $this$filterTo$iv$iv[var10_10];
            $i$a$-filter-CompareIndices$findFileAndAllRelevantSiblings$1 = false;
            if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"class")) ** GOTO lbl-1000
            if (Intrinsics.areEqual((Object)it.getNameWithoutExtension(), (Object)fullClassName)) ** GOTO lbl-1000
            v3 = it.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getNameWithoutExtension(...)");
            if (StringsKt.startsWith$default((String)v3, (String)(baseClassName + "$"), (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> CompareIndices.withIndent$lambda$62(indent, arg_0), (int)30, null);
    }

    private static final void _execute$lambda$0(Project $project, ActionCallbackProfilerStopper $actionCallback, CompareIndices this$0, Path $storedIndexDir) {
        String string = PerformanceTestingBundle.message("comparing.indexes", new Object[0]);
        new Task.Modal($project, $actionCallback, this$0, $storedIndexDir, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            final /* synthetic */ CompareIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            {
                this.$project = $project;
                this.$actionCallback = $actionCallback;
                this.this$0 = $receiver;
                this.$storedIndexDir = $storedIndexDir;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!StubForwardIndexExternalizer.USE_SHAREABLE_STUBS) {
                    this.$actionCallback.reject("Index comparison available only with with -Didea.uses.shareable.serialized.stubs=true");
                    return;
                }
                try {
                    CompareIndices.access$compareIndexes(this.this$0, this.$storedIndexDir, indicator, this.$project);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CompareIndicesKt.access$getLOG$p().error(e);
                    this.$actionCallback.reject(e.getMessage());
                }
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredFilesPatterns_delegate$lambda$5() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.indices.list.of.files.to.ignore.from.comparison");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String listPath = string;
        Path path = Paths.get(listPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List patterns = (List)destination$iv$iv;
        CompareIndicesKt.access$getLOG$p().info("The following files will be ignored from indexes comparison:\n" + CollectionsKt.joinToString$default((Iterable)patterns, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredPatternsForReporting_delegate$lambda$10() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.indices.list.of.patterns.to.ignore.from.reporting");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String fileWithPatterns = string;
        List patternsList = new ArrayList();
        Path path = Paths.get(fileWithPatterns, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{" "};
            List attrs = StringsKt.split$default((CharSequence)it2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            patternsList.add(new Pair(attrs.get(0), attrs.get(1)));
        }
        CompareIndicesKt.access$getLOG$p().info("The following patterns will be ignored from failure reporting: ");
        $this$forEach$iv = patternsList;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it3 = (Pair)element$iv;
            boolean bl = false;
            CompareIndicesKt.access$getLOG$p().info("Files ." + it3.getFirst() + " in index " + it3.getSecond());
        }
        return patternsList;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set fileTypesWithNoStubTree_delegate$lambda$12() {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        String string = System.getProperty("compare.indices.file.types.with.no.stub.tree", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String[] stringArray = new String[]{","};
        Iterable $this$filterNot$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    private static final boolean compareIndexes$lambda$13(FileBasedIndexExtension it) {
        return it.dependsOnFileContent() && !Intrinsics.areEqual((Object)it.getName().getName(), (Object)"HashFragmentIndex");
    }

    private static final ID compareIndexes$lambda$14(FileBasedIndexExtension it) {
        return it.getName();
    }

    private static final Pair compareIndexes$lambda$19$lambda$16(CompareIndices this$0, ID $id, Path $storedIndexDir) {
        Intrinsics.checkNotNull((Object)$id);
        return this$0.findFileBasedIndexExtension($id, $storedIndexDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean compareIndexes$lambda$19(ConcurrentTasksProgressManager $comparisonTaskProgressManager, Map $errorCollectors, CompareIndices this$0, List $resolvedFiles, Path $storedIndexDir, Project $project, AtomicInteger $finishedCounter, List $idsToCompare, ID id) {
        SubTaskProgressIndicator subTaskProgressIndicator = $comparisonTaskProgressManager.createSubTaskIndicator(1);
        Intrinsics.checkNotNullExpressionValue((Object)subTaskProgressIndicator, (String)"createSubTaskIndicator(...)");
        SubTaskProgressIndicator subIndicator = subTaskProgressIndicator;
        Pair pair = (Pair)ActionsKt.runReadAction(() -> CompareIndices.compareIndexes$lambda$19$lambda$16(this$0, id, $storedIndexDir));
        FileBasedIndexExtension extension = (FileBasedIndexExtension)pair.component1();
        Disposable disposable = (Disposable)pair.component2();
        try {
            Object errorCollector = (ToDirectoryWritingErrorCollector)MapsKt.getValue((Map)$errorCollectors, (Object)id);
            this$0.compareCurrentAndStoredIndexData($resolvedFiles, (FileBasedIndexExtension)extension, $storedIndexDir, (ProgressIndicator)subIndicator, (ErrorCollector)errorCollector, $project);
        }
        catch (Exception e) {
            CompareIndicesKt.access$getLOG$p().warn("Index comparison for " + id.getName() + " has failed", (Throwable)e);
        }
        finally {
            Object object;
            Object object2 = this$0;
            try {
                CompareIndices $this$compareIndexes_u24lambda_u2419_u24lambda_u2417 = object2;
                boolean bl = false;
                Disposer.dispose((Disposable)disposable);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                CompareIndicesKt.access$getLOG$p().warn((Throwable)it);
            }
        }
        CompareIndicesKt.access$getLOG$p().info("Index comparison has finished for " + $finishedCounter.incrementAndGet() + " / " + $idsToCompare.size());
        return true;
    }

    private static final CharSequence compareIndexes$lambda$22(ID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final CharSequence compareIndexes$lambda$23(ID it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final boolean findFileBasedIndexExtension$lambda$24(ID $id, FileBasedIndexExtension ex) {
        return Intrinsics.areEqual((Object)ex.getName(), (Object)$id);
    }

    private static final boolean findFileBasedIndexExtension$lambda$25(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final VirtualFile resolveFiles$lambda$29$lambda$28(StoredIndexedFileResolver $storedIndexedFileResolver, IndexedFilePath $originalFilePath, Project $project) {
        Intrinsics.checkNotNull((Object)$originalFilePath);
        return $storedIndexedFileResolver.findFileInCurrentProject($originalFilePath, $project);
    }

    private static final boolean resolveFiles$lambda$29(CompareIndices this$0, ErrorCollector $errorCollector, ProgressIndicator $indicator, AtomicInteger $finished, StoredIndexedFileResolver $storedIndexedFileResolver, HashSet $allCurrentFiles, List $fileDescriptors, Project $project, IndexedFilePath originalFilePath) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = this$0.getIgnoredFilesPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)originalFilePath.getPortableFilePath(), (String)it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        VirtualFile virtualFile = (VirtualFile)$errorCollector.runCatchingError(() -> CompareIndices.resolveFiles$lambda$29$lambda$28($storedIndexedFileResolver, originalFilePath, $project));
        if (virtualFile == null) {
            return true;
        }
        VirtualFile currentFile = virtualFile;
        $indicator.setFraction((double)$finished.incrementAndGet() / (double)$storedIndexedFileResolver.getOriginalIndexedFiles().size());
        $indicator.setText2(currentFile.getUrl());
        if ($allCurrentFiles.contains(currentFile)) {
            Intrinsics.checkNotNull((Object)$fileDescriptors);
            Collection collection = $fileDescriptors;
            Intrinsics.checkNotNull((Object)originalFilePath);
            collection.add(new FileDescriptor(originalFilePath, currentFile));
        }
        return true;
    }

    private static final Unit compareCurrentAndStoredIndexData$lambda$30(FileBasedIndexImpl $fileBasedIndex, ID $indexId, Project $project) {
        $fileBasedIndex.ensureUpToDate($indexId, $project, GlobalSearchScope.allScope((Project)$project));
        return Unit.INSTANCE;
    }

    private static final boolean compareInvertedIndexes$lambda$33$lambda$32(UpdatableIndex $storedIndex, HashSet $allStoredKeys, Project $project) {
        return $storedIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)$allStoredKeys), GlobalSearchScope.allScope((Project)$project), null);
    }

    private static final boolean compareInvertedIndexes$lambda$33(UpdatableIndex $storedIndex, HashSet $allStoredKeys, Project $project) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$33$lambda$32($storedIndex, $allStoredKeys, $project));
    }

    private static final boolean compareInvertedIndexes$lambda$35$lambda$34(UpdatableIndex $currentIndex, HashSet $allCurrentKeys, Project $project) {
        return $currentIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)$allCurrentKeys), GlobalSearchScope.allScope((Project)$project), null);
    }

    private static final boolean compareInvertedIndexes$lambda$35(UpdatableIndex $currentIndex, HashSet $allCurrentKeys, Project $project) {
        return (Boolean)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$35$lambda$34($currentIndex, $allCurrentKeys, $project));
    }

    private static final Map compareInvertedIndexes$lambda$38$lambda$37(CompareIndices this$0, UpdatableIndex $storedIndex, Object $storedKey) {
        Object object = $storedKey;
        Intrinsics.checkNotNull((Object)object);
        ValueContainer valueContainer = $storedIndex.getData(object);
        Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
        return this$0.toMap(valueContainer);
    }

    private static final Map compareInvertedIndexes$lambda$38(CompareIndices this$0, UpdatableIndex $storedIndex, Object $storedKey) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$38$lambda$37(this$0, $storedIndex, $storedKey));
    }

    private static final Map compareInvertedIndexes$lambda$40$lambda$39(CompareIndices this$0, UpdatableIndex $currentIndex, Object $storedKey) {
        Object object = $storedKey;
        Intrinsics.checkNotNull((Object)object);
        ValueContainer valueContainer = $currentIndex.getData(object);
        Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
        return this$0.toMap(valueContainer);
    }

    private static final Map compareInvertedIndexes$lambda$40(CompareIndices this$0, UpdatableIndex $currentIndex, Object $storedKey) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareInvertedIndexes$lambda$40$lambda$39(this$0, $currentIndex, $storedKey));
    }

    private static final Map checkNoKeysAreMissing$lambda$44$lambda$43(CompareIndices this$0, UpdatableIndex $storedIndex, Object $missingKey, Map $originalFileIdToFileDescriptor) {
        Object object = $missingKey;
        Intrinsics.checkNotNull((Object)object);
        ValueContainer valueContainer = $storedIndex.getData(object);
        Intrinsics.checkNotNullExpressionValue((Object)valueContainer, (String)"getData(...)");
        Map $this$filterKeys$iv = this$0.toMap(valueContainer);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            int it = ((Number)entry$iv.getKey()).intValue();
            boolean bl = false;
            Integer n = it;
            if (!$originalFileIdToFileDescriptor.containsKey(n)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    private static final Map checkNoKeysAreMissing$lambda$44(CompareIndices this$0, UpdatableIndex $storedIndex, Object $missingKey, Map $originalFileIdToFileDescriptor) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.checkNoKeysAreMissing$lambda$44$lambda$43(this$0, $storedIndex, $missingKey, $originalFileIdToFileDescriptor));
    }

    private static final boolean toMap$lambda$45(HashMap $map, int fileId, Object value) {
        if (value != null) {
            Integer n = fileId;
            ((Map)$map).put(n, value);
        }
        return true;
    }

    private static final boolean toMap$lambda$46(Function2 $tmp0, int p0, Object p1) {
        return (Boolean)$tmp0.invoke((Object)p0, p1);
    }

    private static final Map compareFileData$lambda$48$lambda$47(UpdatableIndex $storedIndex, FileDescriptor $fileDescriptor) {
        return $storedIndex.getIndexedFileData($fileDescriptor.getOriginalFilePath().getOriginalFileSystemId());
    }

    private static final Map compareFileData$lambda$48(UpdatableIndex $storedIndex, FileDescriptor $fileDescriptor) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareFileData$lambda$48$lambda$47($storedIndex, $fileDescriptor));
    }

    private static final Map compareFileData$lambda$50$lambda$49(UpdatableIndex $currentIndex, FileDescriptor $fileDescriptor) {
        return $currentIndex.getIndexedFileData(FileBasedIndex.getFileId((VirtualFile)$fileDescriptor.getCurrentFile()));
    }

    private static final Map compareFileData$lambda$50(UpdatableIndex $currentIndex, FileDescriptor $fileDescriptor) {
        return (Map)ActionsKt.runReadAction(() -> CompareIndices.compareFileData$lambda$50$lambda$49($currentIndex, $fileDescriptor));
    }

    private static final Unit compareFileData$lambda$51(CompareIndices this$0, FileDescriptor $fileDescriptor, FileBasedIndexExtension $extension, Map $storedData, Map $currentData, Project $project) {
        this$0.assertForwardIndexDataAreTheSameForFile($fileDescriptor, $extension, $storedData, $currentData, $project);
        return Unit.INSTANCE;
    }

    private static final FileBasedIndexInfrastructureExtension.FileIndexingStatusProcessor doesFileHaveProvidedIndex$lambda$59(Project $project, FileBasedIndexInfrastructureExtension it) {
        return it.createFileIndexingStatusProcessor($project);
    }

    private static final CharSequence withIndent$lambda$62(String $indent, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $indent + it;
    }

    public static final /* synthetic */ String access$buildFileDataMismatchMessage(CompareIndices $this, String reason, FileBasedIndexExtension extension, FileDescriptor fileDescriptor, Project project) {
        return $this.buildFileDataMismatchMessage(reason, extension, fileDescriptor, project);
    }

    public static final /* synthetic */ List access$createAttachmentsForActualFile(CompareIndices $this, FileDescriptor fileDescriptor, String pathPrefix) {
        return $this.createAttachmentsForActualFile(fileDescriptor, pathPrefix);
    }

    public static final /* synthetic */ String access$withIndent(CompareIndices $this, String $receiver, String indent) {
        return $this.withIndent($receiver, indent);
    }

    public static final /* synthetic */ void access$compareIndexes(CompareIndices $this, Path storedIndexDir, ProgressIndicator indicator, Project project) {
        $this.compareIndexes(storedIndexDir, indicator, project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices$Companion;", "", "<init>", "()V", "LIMIT_OF_ERRORS_PER_COLLECTOR", "", "intellij.performanceTesting"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareIndices$FileDescriptor;", "", "originalFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getOriginalFilePath", "()Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "getCurrentFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.performanceTesting"})
    private static final class FileDescriptor {
        @NotNull
        private final IndexedFilePath originalFilePath;
        @NotNull
        private final VirtualFile currentFile;

        public FileDescriptor(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            this.originalFilePath = originalFilePath;
            this.currentFile = currentFile;
        }

        @NotNull
        public final IndexedFilePath getOriginalFilePath() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile getCurrentFile() {
            return this.currentFile;
        }

        @NotNull
        public final IndexedFilePath component1() {
            return this.originalFilePath;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.currentFile;
        }

        @NotNull
        public final FileDescriptor copy(@NotNull IndexedFilePath originalFilePath, @NotNull VirtualFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)originalFilePath, (String)"originalFilePath");
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            return new FileDescriptor(originalFilePath, currentFile);
        }

        public static /* synthetic */ FileDescriptor copy$default(FileDescriptor fileDescriptor, IndexedFilePath indexedFilePath, VirtualFile virtualFile, int n, Object object) {
            if ((n & 1) != 0) {
                indexedFilePath = fileDescriptor.originalFilePath;
            }
            if ((n & 2) != 0) {
                virtualFile = fileDescriptor.currentFile;
            }
            return fileDescriptor.copy(indexedFilePath, virtualFile);
        }

        @NotNull
        public String toString() {
            return "FileDescriptor(originalFilePath=" + this.originalFilePath + ", currentFile=" + this.currentFile + ")";
        }

        public int hashCode() {
            int result = this.originalFilePath.hashCode();
            result = result * 31 + this.currentFile.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileDescriptor)) {
                return false;
            }
            FileDescriptor fileDescriptor = (FileDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.originalFilePath, (Object)fileDescriptor.originalFilePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentFile, (Object)fileDescriptor.currentFile);
        }
    }
}

