/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.compiler.charts.jps;

import com.intellij.java.compiler.charts.jps.CompilationChartsJpsBundle;
import com.intellij.java.compiler.charts.jps.CompilationStatusBuilderMessage;
import com.intellij.java.compiler.charts.jps.CompileStatisticBuilderMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.BuilderService;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.service.SharedThreadPool;

public class ChartsBuilderService
extends BuilderService {
    private static final Logger LOG = Logger.getInstance(ChartsBuilderService.class);
    public static final String COMPILATION_STATISTIC_BUILDER_ID = "jps.compile.statistic";
    public static final String COMPILATION_STATUS_BUILDER_ID = "jps.compile.status";

    @NotNull
    public List<? extends ModuleLevelBuilder> createModuleLevelBuilders() {
        if (Boolean.getBoolean("compilation.charts")) {
            LOG.info("Compilation charts enabled.");
            List<ChartsModuleLevelBuilder> list = List.of(new ChartsModuleLevelBuilder());
            if (list == null) {
                ChartsBuilderService.$$$reportNull$$$0(0);
            }
            return list;
        }
        List list = List.of();
        if (list == null) {
            ChartsBuilderService.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/java/compiler/charts/jps/ChartsBuilderService", "createModuleLevelBuilders"));
    }

    private static class ChartsModuleLevelBuilder
    extends ModuleLevelBuilder {
        private static final Logger LOG = Logger.getInstance(ChartsModuleLevelBuilder.class);

        protected ChartsModuleLevelBuilder() {
            super(BuilderCategory.TRANSLATOR);
            LOG.debug(CompilationChartsJpsBundle.message("compilation.charts.jps.registered", new Object[0]));
        }

        public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(0);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(1);
            }
            if (dirtyFilesHolder == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(2);
            }
            if (outputConsumer == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(3);
            }
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }

        @NotNull
        public List<String> getCompilableFileExtensions() {
            List<String> list = List.of();
            if (list == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getPresentableName() {
            String string = StringUtil.capitalize((String)ChartsModuleLevelBuilder.getBuilderName());
            if (string == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        public static String getBuilderName() {
            return "charts";
        }

        public void buildStarted(@NotNull CompileContext context) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(6);
            }
            context.processMessage((BuildMessage)new CompilationStatusBuilderMessage("START"));
            SharedThreadPool.getInstance().execute((Runnable)new CompileStatisticService(context));
        }

        public void buildFinished(@NotNull CompileContext context) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(7);
            }
            context.processMessage((BuildMessage)new CompilationStatusBuilderMessage("FINISH"));
        }

        public void chunkBuildStarted(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(8);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(9);
            }
            context.processMessage((BuildMessage)CompileStatisticBuilderMessage.create(chunk.getTargets(), "STARTED"));
        }

        public void chunkBuildFinished(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
            if (context == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(10);
            }
            if (chunk == null) {
                ChartsModuleLevelBuilder.$$$reportNull$$$0(11);
            }
            context.processMessage((BuildMessage)CompileStatisticBuilderMessage.create(chunk.getTargets(), "FINISHED"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chunk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dirtyFilesHolder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputConsumer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/compiler/charts/jps/ChartsBuilderService$ChartsModuleLevelBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/compiler/charts/jps/ChartsBuilderService$ChartsModuleLevelBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompilableFileExtensions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "build";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "buildStarted";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFinished";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "chunkBuildStarted";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "chunkBuildFinished";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CompileStatisticService
    implements Runnable {
        private final MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        private final OperatingSystemMXBean os = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        private final CompileContext context;

        private CompileStatisticService(CompileContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    BuildMessage message;
                    if ((message = CompileStatisticBuilderMessage.create(this.memory, this.os)) != null) {
                        this.context.processMessage(message);
                    }
                    TimeUnit.SECONDS.sleep(1L);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

