/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipRetriever;
import com.intellij.ide.util.TipRetrieversInfo;
import com.intellij.ide.util.TipUtilsKt;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0017\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/util/TipUtils;", "", "<init>", "()V", "getTip", "Lcom/intellij/ide/util/TipAndTrickBean;", "feature", "Lcom/intellij/featureStatistics/FeatureDescriptor;", "getGroupDisplayNameForTip", "", "Lorg/jetbrains/annotations/Nls;", "tip", "loadAndParseTip", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "contextComponent", "Ljava/awt/Component;", "loadAndParseTipStrict", "checkTipFileExist", "", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nTipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipUtils.kt\ncom/intellij/ide/util/TipUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,389:1\n183#2,2:390\n*S KotlinDebug\n*F\n+ 1 TipUtils.kt\ncom/intellij/ide/util/TipUtils\n*L\n81#1:390,2\n*E\n"})
public final class TipUtils {
    @NotNull
    public static final TipUtils INSTANCE = new TipUtils();

    private TipUtils() {
    }

    @Nullable
    public final TipAndTrickBean getTip(@Nullable FeatureDescriptor feature) {
        if (feature == null) {
            return null;
        }
        String tipId = feature.getTipId();
        if (tipId == null) {
            TipUtilsKt.access$getLOG$p().warn("No Tip of the day for feature " + feature.getId());
            return null;
        }
        TipAndTrickBean tip = TipAndTrickBean.findById((String)tipId);
        if (tip == null && ((CharSequence)tipId).length() > 0) {
            tip = new TipAndTrickBean();
            tip.fileName = tipId + ".html";
        }
        return tip;
    }

    @JvmStatic
    @Nullable
    public static final String getGroupDisplayNameForTip(@NotNull TipAndTrickBean tip) {
        FeatureDescriptor featureDescriptor;
        Object object;
        Object v2;
        ProductivityFeaturesRegistry registry;
        block3: {
            Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
            ProductivityFeaturesRegistry productivityFeaturesRegistry = ProductivityFeaturesRegistry.getInstance();
            if (productivityFeaturesRegistry == null) {
                return null;
            }
            registry = productivityFeaturesRegistry;
            Set set = registry.getFeatureIds();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFeatureIds(...)");
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), arg_0 -> TipUtils.getGroupDisplayNameForTip$lambda$0(registry, arg_0));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FeatureDescriptor it = (FeatureDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTipId(), (Object)tip.getId())) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((object = (featureDescriptor = (FeatureDescriptor)v2)) == null || (object = object.getGroupId()) == null) {
            return null;
        }
        GroupDescriptor groupDescriptor = registry.getGroupDescriptor((String)object);
        return groupDescriptor != null ? groupDescriptor.getDisplayName() : null;
    }

    @JvmStatic
    @NotNull
    public static final List<TextParagraph> loadAndParseTip(@NotNull TipAndTrickBean tip, @Nullable Component contextComponent) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        return TipUtilsKt.access$loadAndParseTip(tip, contextComponent, false);
    }

    @TestOnly
    @NotNull
    public final List<TextParagraph> loadAndParseTipStrict(@NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        return TipUtilsKt.access$loadAndParseTip(tip, null, true);
    }

    public final boolean checkTipFileExist(@NotNull TipAndTrickBean tip) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
        TipRetrieversInfo retrievers = TipUtilsKt.access$getTipRetrievers(tip);
        for (TipRetriever retriever : retrievers.getTipRetrievers()) {
            String string = tip.fileName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileName");
            if (retriever.getTipUrl(string) == null) continue;
            return true;
        }
        return false;
    }

    private static final FeatureDescriptor getGroupDisplayNameForTip$lambda$0(ProductivityFeaturesRegistry $registry, String it) {
        return $registry.getFeatureDescriptor(it);
    }
}

