/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection c, Transformer t) {
        HashMap buckets = new HashMap();
        for (Object value : c) {
            Object key2 = t.transform(value);
            LinkedList bucket = (LinkedList)buckets.get(key2);
            if (bucket == null) {
                bucket = new LinkedList();
                buckets.put(key2, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static void reverse(Map source, Map target) {
        for (Object key2 : source.keySet()) {
            target.put(source.get(key2), key2);
        }
    }

    public static Collection filter(Collection c, Predicate p) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (p.evaluate(it.next())) continue;
            it.remove();
        }
        return c;
    }

    public static List transform(Collection c, Transformer t) {
        ArrayList<Object> result2 = new ArrayList<Object>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            result2.add(t.transform(it.next()));
        }
        return result2;
    }

    public static Map getIndexMap(List list2) {
        HashMap indexes = new HashMap();
        int index = 0;
        Iterator it = list2.iterator();
        while (it.hasNext()) {
            indexes.put(it.next(), new Integer(index++));
        }
        return indexes;
    }
}

