/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.threadDumpParser;

import com.intellij.diagnostic.CoroutineDumperKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.threadDumpParser.ThreadOperation;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ThreadDumpParser {
    private static final Pattern ourThreadStartPattern = Pattern.compile("^\"(.+)\".+(prio=\\d+ (?:os_prio=[^\\s]+ )?.*tid=[^\\s]+ nid=[^\\s]+|[Ii][Dd]=\\d+) ([^\\[]+)");
    private static final Pattern ourForcedThreadStartPattern = Pattern.compile("^Thread (\\d+): \\(state = (.+)\\)");
    private static final Pattern ourYourkitThreadStartPattern = Pattern.compile("(.+) \\[([A-Z_, ]*)]");
    private static final Pattern ourYourkitThreadStartPattern2 = Pattern.compile("(.+) (?:State:)? (.+) CPU usage on sample: .+");
    private static final Pattern ourThreadStatePattern = Pattern.compile("java\\.lang\\.Thread\\.State: (.+) \\((.+)\\)");
    private static final Pattern ourThreadStatePattern2 = Pattern.compile("java\\.lang\\.Thread\\.State: (.+)");
    private static final Pattern ourWaitingForLockPattern = Pattern.compile("- waiting (on|to lock) <(.+)>");
    private static final Pattern ourParkingToWaitForLockPattern = Pattern.compile("- parking to wait for {2}<(.+)>");
    @NonNls
    private static final String PUMP_EVENT = "java.awt.EventDispatchThread.pumpOneEventForFilters";
    private static final Pattern ourIdleTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at java\\.util\\.TimerThread\\.mainLoop");
    private static final Pattern ourIdleSwingTimerThreadPattern = Pattern.compile("java\\.lang\\.Object\\.wait\\([^()]+\\)\\s+at javax\\.swing\\.TimerQueue\\.run");
    private static final String AT_JAVA_LANG_OBJECT_WAIT = "at java.lang.Object.wait(";
    private static final Pattern ourLockedOwnableSynchronizersPattern = Pattern.compile("- <(0x[\\da-f]+)> \\(.*\\)");
    private static final String[] IMPORTANT_THREAD_DUMP_WORDS = (String[])ContainerUtil.ar((Object[])new String[]{"tid", "nid", "wait", "parking", "prio", "os_prio", "java"});

    private ThreadDumpParser() {
    }

    @NotNull
    public static List<ThreadState> parse(String threadDump) {
        String line;
        ArrayList<ThreadState> result2 = new ArrayList<ThreadState>();
        StringBuilder lastThreadStack = new StringBuilder();
        ThreadState lastThreadState = null;
        boolean expectingThreadState = false;
        boolean haveNonEmptyStackTrace = false;
        StringBuilder coroutineDump = null;
        Iterator<Object> iterator = StringUtil.tokenize((String)threadDump, (String)"\r\n").iterator();
        while (iterator.hasNext() && !"---------- Event counts ----------".equals(line = (String)iterator.next())) {
            if (CoroutineDumperKt.isCoroutineDumpHeader((String)line)) {
                coroutineDump = new StringBuilder();
            }
            if (coroutineDump != null) {
                coroutineDump.append(line).append("\n");
                continue;
            }
            if (line.startsWith("============") || line.contains("Java-level deadlock")) break;
            ThreadState state = ThreadDumpParser.tryParseThreadStart(line.trim());
            if (state != null) {
                if (lastThreadState != null) {
                    lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
                }
                lastThreadState = state;
                result2.add(lastThreadState);
                lastThreadStack.setLength(0);
                haveNonEmptyStackTrace = false;
                lastThreadStack.append(line).append("\n");
                expectingThreadState = true;
                continue;
            }
            boolean parsedThreadState = false;
            if (expectingThreadState) {
                expectingThreadState = false;
                parsedThreadState = ThreadDumpParser.tryParseThreadState(line, lastThreadState);
            }
            lastThreadStack.append(line).append("\n");
            if (parsedThreadState || !line.trim().startsWith("at")) continue;
            haveNonEmptyStackTrace = true;
        }
        if (lastThreadState != null) {
            lastThreadState.setStackTrace(lastThreadStack.toString(), !haveNonEmptyStackTrace);
        }
        for (ThreadState threadState : result2) {
            ThreadDumpParser.inferThreadStateDetail(threadState);
        }
        for (ThreadState threadState : result2) {
            String lockId = ThreadDumpParser.findWaitingForLock(threadState.getStackTrace());
            ThreadState lockOwner = ThreadDumpParser.findLockOwner(result2, lockId, true);
            if (lockOwner == null) {
                lockOwner = ThreadDumpParser.findLockOwner(result2, lockId, false);
            }
            if (lockOwner == null) continue;
            if (threadState.isAwaitedBy(lockOwner)) {
                threadState.addDeadlockedThread(lockOwner);
                lockOwner.addDeadlockedThread(threadState);
            }
            lockOwner.addWaitingThread(threadState);
        }
        ThreadDumpParser.sortThreads(result2);
        if (coroutineDump != null) {
            ThreadState coroutineState = new ThreadState("Coroutine dump", "undefined");
            coroutineState.setStackTrace(coroutineDump.toString(), false);
            result2.add(coroutineState);
        }
        ArrayList<ThreadState> arrayList = result2;
        if (arrayList == null) {
            ThreadDumpParser.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    private static ThreadState findLockOwner(List<? extends ThreadState> result2, @Nullable String lockId, boolean ignoreWaiting) {
        if (lockId == null) {
            return null;
        }
        String marker = "- locked <" + lockId + ">";
        for (ThreadState threadState : result2) {
            String trace = threadState.getStackTrace();
            if (!trace.contains(marker) || ignoreWaiting && trace.contains(AT_JAVA_LANG_OBJECT_WAIT)) continue;
            return threadState;
        }
        for (ThreadState threadState : result2) {
            if (threadState.getOwnableSynchronizers() == null || !threadState.getOwnableSynchronizers().equals(lockId)) continue;
            return threadState;
        }
        return null;
    }

    public static void sortThreads(List<? extends ThreadState> result2) {
        result2.sort((o1, o2) -> ThreadDumpParser.getInterestLevel(o2) - ThreadDumpParser.getInterestLevel(o1));
    }

    @Nullable
    private static String findLockedOwnableSynchronizers(String stackTrace) {
        Matcher m = ourLockedOwnableSynchronizersPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    private static String findWaitingForLock(String stackTrace) {
        Matcher m = ourWaitingForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(2);
        }
        m = ourParkingToWaitForLockPattern.matcher(stackTrace);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static int getInterestLevel(ThreadState state) {
        if (state.isEmptyStackTrace()) {
            return -10;
        }
        if (state.isKnownJDKThread()) {
            return -5;
        }
        if (state.isSleeping()) {
            return -2;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return -1;
        }
        return state.getStackDepth();
    }

    static boolean isKnownJdkThread(@NotNull String stackTrace) {
        if (stackTrace == null) {
            ThreadDumpParser.$$$reportNull$$$0(1);
        }
        return stackTrace.contains("java.lang.ref.Reference$ReferenceHandler.run") || stackTrace.contains("java.lang.ref.Finalizer$FinalizerThread.run") || stackTrace.contains("sun.awt.AWTAutoShutdown.run") || stackTrace.contains("sun.java2d.Disposer.run") || stackTrace.contains("sun.awt.windows.WToolkit.eventLoop") || ourIdleTimerThreadPattern.matcher(stackTrace).find() || ourIdleSwingTimerThreadPattern.matcher(stackTrace).find();
    }

    public static void inferThreadStateDetail(ThreadState threadState) {
        @NonNls String stackTrace = threadState.getStackTrace();
        if (stackTrace.contains("at java.net.PlainSocketImpl.socketAccept") || stackTrace.contains("at java.net.PlainDatagramSocketImpl.receive") || stackTrace.contains("at java.net.SocketInputStream.socketRead") || stackTrace.contains("at java.net.PlainSocketImpl.socketConnect")) {
            threadState.setOperation(ThreadOperation.Socket);
        } else if (stackTrace.contains("at java.io.FileInputStream.readBytes")) {
            threadState.setOperation(ThreadOperation.IO);
        } else if (stackTrace.contains("at java.lang.Thread.sleep")) {
            String javaThreadState = threadState.getJavaThreadState();
            if (!Thread.State.RUNNABLE.name().equals(javaThreadState)) {
                threadState.setThreadStateDetail("sleeping");
            }
        }
        if (threadState.isEDT()) {
            if (stackTrace.contains("java.awt.EventQueue.getNextEvent")) {
                threadState.setThreadStateDetail("idle");
            }
            int modality = 0;
            int pos = 0;
            while ((pos = stackTrace.indexOf(PUMP_EVENT, pos)) >= 0) {
                ++modality;
                pos += PUMP_EVENT.length();
            }
            threadState.setExtraState("modality level " + modality);
        }
        threadState.setOwnableSynchronizers(ThreadDumpParser.findLockedOwnableSynchronizers(threadState.getStackTrace()));
    }

    @Nullable
    private static ThreadState tryParseThreadStart(String line) {
        Matcher m = ourThreadStartPattern.matcher(line);
        if (m.find()) {
            ThreadState state = new ThreadState(m.group(1), m.group(3));
            if (line.contains(" daemon ")) {
                state.setDaemon(true);
            }
            return state;
        }
        m = ourForcedThreadStartPattern.matcher(line);
        if (m.matches()) {
            return new ThreadState(m.group(1), m.group(2));
        }
        boolean daemon = line.contains(" [DAEMON]");
        if (daemon) {
            line = StringUtil.replace((String)line, (String)" [DAEMON]", (String)"");
        }
        if ((m = ThreadDumpParser.matchYourKit(line)) != null) {
            ThreadState state = new ThreadState(m.group(1), m.group(2));
            state.setDaemon(daemon);
            return state;
        }
        return null;
    }

    @Nullable
    private static Matcher matchYourKit(String line) {
        Matcher m;
        if (line.contains("[") && (m = ourYourkitThreadStartPattern.matcher(line)).matches()) {
            return m;
        }
        if (line.contains("CPU usage on sample:") && (m = ourYourkitThreadStartPattern2.matcher(line)).matches()) {
            return m;
        }
        return null;
    }

    private static boolean tryParseThreadState(String line, ThreadState threadState) {
        Matcher m = ourThreadStatePattern.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            threadState.setThreadStateDetail(m.group(2).trim());
            return true;
        }
        m = ourThreadStatePattern2.matcher(line);
        if (m.find()) {
            threadState.setJavaThreadState(m.group(1));
            return true;
        }
        return false;
    }

    public static String normalizeText(@NonNls String text2) {
        StringBuilder builder2 = new StringBuilder(text2.length());
        text2 = text2.replaceAll("(\\S[ \\t\\x0B\\f\\r]+)(at\\s+)", "$1\n$2");
        text2 = text2.replaceAll("(\\\\n|\\\\r|\\\\t)+(at\\s+)", "\n$2");
        String[] lines = text2.split("\n");
        boolean first = true;
        boolean inAuxInfo = false;
        for (String line : lines) {
            StringBuilder lastLine;
            if (!inAuxInfo && (line.startsWith("JNI global references") || line.trim().equals("Heap"))) {
                builder2.append("\n");
                inAuxInfo = true;
            }
            if (inAuxInfo) {
                builder2.append(ThreadDumpParser.trimSuffix(line)).append("\n");
                continue;
            }
            if (line.startsWith("at breakpoint")) {
                builder2.append(" ").append(ThreadDumpParser.trimSuffix(line));
                continue;
            }
            if (!first && (ThreadDumpParser.mustHaveNewLineBefore(line) || StringUtil.endsWith((CharSequence)builder2, (CharSequence)")"))) {
                if (!StringUtil.endsWith((CharSequence)builder2, (CharSequence)"\n")) {
                    builder2.append("\n");
                }
                if (line.startsWith("\"")) {
                    builder2.append("\n");
                }
            }
            first = false;
            int i = builder2.lastIndexOf("\n");
            CharSequence charSequence = lastLine = i == -1 ? builder2 : builder2.subSequence(i + 1, builder2.length());
            if (!line.matches("\\s+.*") && lastLine.length() > 0 && (lastLine.toString().matches("\\s*at") || ContainerUtil.or((Object[])IMPORTANT_THREAD_DUMP_WORDS, word -> line.startsWith((String)word)))) {
                builder2.append(" ");
            }
            builder2.append(ThreadDumpParser.trimSuffix(line));
        }
        return builder2.toString();
    }

    private static boolean mustHaveNewLineBefore(String line) {
        int nonWs = CharArrayUtil.shiftForward((CharSequence)line, (int)0, (String)" \t");
        if (nonWs < line.length()) {
            line = line.substring(nonWs);
        }
        if (line.startsWith("at")) {
            return true;
        }
        if (line.startsWith("Caused")) {
            return true;
        }
        if (line.startsWith("- locked")) {
            return true;
        }
        if (line.startsWith("- waiting")) {
            return true;
        }
        if (line.startsWith("- parking to wait")) {
            return true;
        }
        if (line.startsWith("java.lang.Thread.State")) {
            return true;
        }
        return line.startsWith("\"");
    }

    private static String trimSuffix(String line) {
        int len;
        for (len = line.length(); 0 < len && line.charAt(len - 1) <= ' '; --len) {
        }
        return len < line.length() ? line.substring(0, len) : line;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/threadDumpParser/ThreadDumpParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/threadDumpParser/ThreadDumpParser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownJdkThread";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1 -> new IllegalArgumentException(string2);
        };
    }
}

