/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram.profiles;

import ai.grazie.detector.ngram.profiles.LanguageProfile;
import ai.grazie.nlp.langs.Language;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001:\u0001(B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J!\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u00c2\u0003J5\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032 \b\u0002\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0007H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\t\u0010\"\u001a\u00020\u0006H\u00d6\u0001J\u001a\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060%0$H\u0016J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060%0$2\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J(\u0010&\u001a\u00020\u00132\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u00050\u0005H\u0002J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lai/grazie/detector/ngram/profiles/LanguageProfileImpl;", "Lai/grazie/detector/ngram/profiles/LanguageProfile;", "locale", "Lai/grazie/nlp/langs/Language;", "ngrams", "", "", "", "(Lai/grazie/nlp/langs/Language;Ljava/util/Map;)V", "gramLengths", "", "getGramLengths", "()Ljava/util/List;", "getLocale", "()Lai/grazie/nlp/langs/Language;", "numGrams", "getNumGrams", "()I", "stats", "Lai/grazie/detector/ngram/profiles/LanguageProfileImpl$Stats;", "component1", "component2", "copy", "equals", "", "other", "", "getFrequency", "gram", "getMaxGramCount", "", "length", "getMinGramCount", "getNumGramOccurrences", "hashCode", "iterateGrams", "", "", "makeStats", "toString", "Stats", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nLanguageProfileImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageProfileImpl.kt\nai/grazie/detector/ngram/profiles/LanguageProfileImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class LanguageProfileImpl
implements LanguageProfile {
    @NotNull
    private final Language locale;
    @NotNull
    private final Map<Integer, Map<String, Integer>> ngrams;
    @NotNull
    private final Stats stats;

    public LanguageProfileImpl(@NotNull Language locale, @NotNull Map<Integer, ? extends Map<String, Integer>> ngrams) {
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        this.locale = locale;
        this.ngrams = ngrams;
        this.stats = this.makeStats(this.ngrams);
    }

    @Override
    @NotNull
    public Language getLocale() {
        return this.locale;
    }

    @Override
    @NotNull
    public List<Integer> getGramLengths() {
        return CollectionsKt.sorted((Iterable)new ArrayList(this.ngrams.keySet()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumGrams() {
        Iterable iterable = this.ngrams.values();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Map map = (Map)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.size();
            n = n2 + n3;
        }
        return n;
    }

    private final Stats makeStats(Map<Integer, ? extends Map<String, Integer>> ngrams) {
        HashMap numOccurrences = new HashMap(6);
        HashMap minGramCounts = new HashMap(6);
        HashMap maxGramCounts = new HashMap(6);
        for (Map.Entry<Integer, ? extends Map<String, Integer>> entry2 : ngrams.entrySet()) {
            int key2 = ((Number)entry2.getKey()).intValue();
            Map<String, Integer> value = entry2.getValue();
            long count = 0L;
            Long min = null;
            Long max = null;
            Object object = value.values().iterator();
            while (object.hasNext()) {
                int integer = ((Number)object.next()).intValue();
                count += (long)integer;
                if (min == null || min > (long)integer) {
                    min = integer;
                }
                if (max != null && max >= (long)integer) continue;
                max = integer;
            }
            Integer n = key2;
            Long l = count;
            ((Map)numOccurrences).put(n, l);
            object = minGramCounts;
            n = key2;
            Long l2 = min;
            l = l2 != null ? l2 : 0L;
            object.put(n, l);
            object = maxGramCounts;
            n = key2;
            Long l3 = max;
            l = l3 != null ? l3 : 0L;
            object.put(n, l);
        }
        return new Stats(numOccurrences, minGramCounts, maxGramCounts);
    }

    @Override
    public int getFrequency(@NotNull String gram) {
        Intrinsics.checkNotNullParameter((Object)gram, (String)"gram");
        Map<String, Integer> map = this.ngrams.get(gram.length());
        if (map == null) {
            return 0;
        }
        Map<String, Integer> map2 = map;
        Integer n = map2.get(gram);
        if (n == null) {
            return 0;
        }
        return n;
    }

    @Override
    public int getNumGrams(int length) {
        Map<String, Integer> map = this.ngrams.get(length);
        return map != null ? map.size() : 0;
    }

    @Override
    public long getNumGramOccurrences(int length) {
        Long l = this.stats.getNumOccurrences().get(length);
        return l != null ? l : 0L;
    }

    @Override
    public long getMinGramCount(int length) {
        Long l = this.stats.getMinGramCounts().get(length);
        return l != null ? l : 0L;
    }

    @Override
    public long getMaxGramCount(int length) {
        Long l = this.stats.getMaxGramCounts().get(length);
        return l != null ? l : 0L;
    }

    @Override
    @NotNull
    public Iterable<Map.Entry<String, Integer>> iterateGrams() {
        ArrayList result2 = new ArrayList();
        for (Map<String, Integer> stringIntegerMap : this.ngrams.values()) {
            result2.addAll(stringIntegerMap.entrySet());
        }
        return result2;
    }

    @Override
    @NotNull
    public Iterable<Map.Entry<String, Integer>> iterateGrams(int length) {
        return ((Map)MapsKt.getValue(this.ngrams, (Object)length)).entrySet();
    }

    @NotNull
    public final Language component1() {
        return this.locale;
    }

    private final Map<Integer, Map<String, Integer>> component2() {
        return this.ngrams;
    }

    @NotNull
    public final LanguageProfileImpl copy(@NotNull Language locale, @NotNull Map<Integer, ? extends Map<String, Integer>> ngrams) {
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        return new LanguageProfileImpl(locale, ngrams);
    }

    public static /* synthetic */ LanguageProfileImpl copy$default(LanguageProfileImpl languageProfileImpl, Language language, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            language = languageProfileImpl.locale;
        }
        if ((n & 2) != 0) {
            map = languageProfileImpl.ngrams;
        }
        return languageProfileImpl.copy(language, map);
    }

    @NotNull
    public String toString() {
        return "LanguageProfileImpl(locale=" + this.locale + ", ngrams=" + this.ngrams + ")";
    }

    public int hashCode() {
        int result2 = this.locale.hashCode();
        result2 = result2 * 31 + ((Object)this.ngrams).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LanguageProfileImpl)) {
            return false;
        }
        LanguageProfileImpl languageProfileImpl = (LanguageProfileImpl)other;
        if (this.locale != languageProfileImpl.locale) {
            return false;
        }
        return Intrinsics.areEqual(this.ngrams, languageProfileImpl.ngrams);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003JK\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"Lai/grazie/detector/ngram/profiles/LanguageProfileImpl$Stats;", "", "numOccurrences", "", "", "", "minGramCounts", "maxGramCounts", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getMaxGramCounts", "()Ljava/util/Map;", "getMinGramCounts", "getNumOccurrences", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "nlp-detect"})
    public static final class Stats {
        @NotNull
        private final Map<Integer, Long> numOccurrences;
        @NotNull
        private final Map<Integer, Long> minGramCounts;
        @NotNull
        private final Map<Integer, Long> maxGramCounts;

        public Stats(@NotNull Map<Integer, Long> numOccurrences, @NotNull Map<Integer, Long> minGramCounts, @NotNull Map<Integer, Long> maxGramCounts) {
            Intrinsics.checkNotNullParameter(numOccurrences, (String)"numOccurrences");
            Intrinsics.checkNotNullParameter(minGramCounts, (String)"minGramCounts");
            Intrinsics.checkNotNullParameter(maxGramCounts, (String)"maxGramCounts");
            this.numOccurrences = numOccurrences;
            this.minGramCounts = minGramCounts;
            this.maxGramCounts = maxGramCounts;
        }

        @NotNull
        public final Map<Integer, Long> getNumOccurrences() {
            return this.numOccurrences;
        }

        @NotNull
        public final Map<Integer, Long> getMinGramCounts() {
            return this.minGramCounts;
        }

        @NotNull
        public final Map<Integer, Long> getMaxGramCounts() {
            return this.maxGramCounts;
        }

        @NotNull
        public final Map<Integer, Long> component1() {
            return this.numOccurrences;
        }

        @NotNull
        public final Map<Integer, Long> component2() {
            return this.minGramCounts;
        }

        @NotNull
        public final Map<Integer, Long> component3() {
            return this.maxGramCounts;
        }

        @NotNull
        public final Stats copy(@NotNull Map<Integer, Long> numOccurrences, @NotNull Map<Integer, Long> minGramCounts, @NotNull Map<Integer, Long> maxGramCounts) {
            Intrinsics.checkNotNullParameter(numOccurrences, (String)"numOccurrences");
            Intrinsics.checkNotNullParameter(minGramCounts, (String)"minGramCounts");
            Intrinsics.checkNotNullParameter(maxGramCounts, (String)"maxGramCounts");
            return new Stats(numOccurrences, minGramCounts, maxGramCounts);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, Map map, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map = stats.numOccurrences;
            }
            if ((n & 2) != 0) {
                map2 = stats.minGramCounts;
            }
            if ((n & 4) != 0) {
                map3 = stats.maxGramCounts;
            }
            return stats.copy(map, map2, map3);
        }

        @NotNull
        public String toString() {
            return "Stats(numOccurrences=" + this.numOccurrences + ", minGramCounts=" + this.minGramCounts + ", maxGramCounts=" + this.maxGramCounts + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.numOccurrences).hashCode();
            result2 = result2 * 31 + ((Object)this.minGramCounts).hashCode();
            result2 = result2 * 31 + ((Object)this.maxGramCounts).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (!Intrinsics.areEqual(this.numOccurrences, stats.numOccurrences)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.minGramCounts, stats.minGramCounts)) {
                return false;
            }
            return Intrinsics.areEqual(this.maxGramCounts, stats.maxGramCounts);
        }
    }
}

