/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.sf.freecol.client.gui.mapviewer.TileBounds;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public final class MapViewerBounds {
    private Dimension size = null;
    private Tile focus = null;
    private int hSpace;
    private int vSpace;
    private int centerRows;
    private int centerColumns;
    private int columnEvenYOffset;
    private int columnOddYOffset;
    private Map.Position topLeftVisibleTile = new Map.Position(-1, -1);
    private Point topLeftVisibleTilePoint = new Point(0, 0);
    private Map.Position bottomRightVisibleTile = new Map.Position(-1, -1);
    private boolean alignedTop = false;
    private boolean alignedBottom = false;
    private boolean alignedLeft = false;
    private boolean alignedRight = false;
    private TileBounds tileBounds;

    MapViewerBounds() {
        this.size = new Dimension(0, 0);
        this.tileBounds = new TileBounds(new Dimension(0, 0), 1.0f);
    }

    void updateSizeVariables(TileBounds tileBounds) {
        this.tileBounds = tileBounds;
        this.vSpace = (this.size.height - tileBounds.getHeight()) / 2;
        this.hSpace = (this.size.width - tileBounds.getWidth()) / 2;
        this.centerRows = this.vSpace / tileBounds.getHalfHeight() + 1;
        int vExtra = this.vSpace % tileBounds.getHeight();
        if (vExtra != 0) {
            ++this.centerRows;
        }
        this.centerColumns = this.hSpace / tileBounds.getWidth() + 1;
        int hExtra = this.hSpace % tileBounds.getWidth();
        this.columnEvenYOffset = hExtra > tileBounds.getHalfWidth() ? 1 : 0;
        this.columnOddYOffset = hExtra == 0 ? -1 : 0;
        this.positionMap();
    }

    public int setOffsetFocus(Tile tile) {
        if (tile == null) {
            return 0;
        }
        this.setFocus(tile);
        this.positionMap();
        int ret = 0;
        int moveX = -1;
        Map map = tile.getMap();
        int tx = tile.getX();
        int ty = tile.getY();
        int width = this.bottomRightVisibleTile.getX() - this.topLeftVisibleTile.getX();
        if (this.topLeftVisibleTile.getX() <= 0) {
            if (tx <= width / 4) {
                ret = -1;
            } else if (tx >= 3 * width / 4) {
                ret = 1;
            } else {
                moveX = tx + width / 4;
                ret = -1;
            }
        } else if (this.bottomRightVisibleTile.getX() >= width - 1) {
            if (tx >= this.bottomRightVisibleTile.getX() - width / 4) {
                ret = 1;
            } else if (tx <= this.bottomRightVisibleTile.getX() - 3 * width / 4) {
                ret = -1;
            } else {
                moveX = tx - width / 4;
                ret = 1;
            }
        } else {
            moveX = tx - width / 4;
            ret = 1;
        }
        if (moveX >= 0) {
            Tile other = map.getTile(moveX, ty);
            this.setFocus(other);
        } else {
            this.setFocus(tile);
        }
        return ret;
    }

    public boolean scrollMap(Direction direction) {
        Tile extraScrollTile;
        Tile t = this.getFocus();
        if (t == null) {
            return false;
        }
        Map map = t.getMap();
        int fx = t.getX();
        int fy = t.getY();
        if ((t = t.getNeighbourOrNull(direction)) == null) {
            return false;
        }
        if (Direction.longSides.contains(direction) && (extraScrollTile = t.getNeighbourOrNull(direction)) != null) {
            t = extraScrollTile;
        }
        int tx = t.getX();
        int ty = t.getY();
        int mapHeight = map.getHeight();
        int mapWidth = map.getWidth();
        int y = this.isMapNearTop(ty) && this.isMapNearTop(fy) ? (ty <= fy ? fy : this.centerRows) : (this.isMapNearBottom(ty, mapHeight) && this.isMapNearBottom(fy, mapHeight) ? (ty >= fy ? fy : mapHeight - this.centerRows) : ty);
        int x = this.isMapNearLeft(tx, ty) && this.isMapNearLeft(fx, fy) ? (tx <= fx ? fx : this.getLeftColumns(ty)) : (this.isMapNearRight(tx, ty, mapWidth) && this.isMapNearRight(fx, fy, mapWidth) ? (tx >= fx ? fx : mapWidth - this.getRightColumns(ty)) : tx);
        if (x == fx && y == fy) {
            return false;
        }
        this.setFocus(map.getTile(x, y));
        return true;
    }

    public boolean onScreen(Tile tile) {
        return !(tile.getX() - 1 <= this.topLeftVisibleTile.getX() && !this.alignedLeft || tile.getX() + 2 >= this.bottomRightVisibleTile.getX() && !this.alignedRight || tile.getY() - 2 <= this.topLeftVisibleTile.getY() && !this.alignedTop || tile.getY() + 3 >= this.bottomRightVisibleTile.getY() && !this.alignedBottom);
    }

    public Point calculateTilePosition(Tile tile, boolean rhs) {
        if (!this.isTileVisible(tile)) {
            return null;
        }
        Point p = this.tileToPoint(tile);
        if (!rhs) {
            return p;
        }
        return new Point(p.x + this.tileBounds.getWidth(), p.y);
    }

    public boolean setFocus(Tile focus) {
        if (focus == null || this.focus == focus) {
            return false;
        }
        this.focus = focus;
        this.positionMap();
        return true;
    }

    void positionMap() {
        int leftColumnX;
        int rightColumn;
        int leftColumn;
        int topRowY;
        int topRow;
        int bottomRow;
        if (this.focus == null) {
            return;
        }
        int x = this.focus.getX();
        int y = this.focus.getY();
        Map map = this.focus.getMap();
        int mapWidth = map.getWidth();
        int mapHeight = map.getHeight();
        int leftColumns = this.getLeftColumns(y);
        int rightColumns = this.getRightColumns(y);
        this.alignedTop = false;
        this.alignedBottom = false;
        if (this.size.height / this.tileBounds.getHalfHeight() - 1 >= mapHeight) {
            bottomRow = mapHeight - 1;
            this.alignedTop = true;
            topRow = 0;
            topRowY = 0;
        } else if (this.isMapNearTop(y)) {
            this.alignedTop = true;
            bottomRow = this.size.height / this.tileBounds.getHalfHeight() - 1;
            if (this.size.height % this.tileBounds.getHalfHeight() != 0) {
                ++bottomRow;
            }
            topRow = 0;
            topRowY = 0;
        } else if (this.isMapNearBottom(y, mapHeight)) {
            this.alignedBottom = true;
            bottomRow = mapHeight - 1;
            topRow = this.size.height / this.tileBounds.getHalfHeight();
            if (this.size.height % this.tileBounds.getHalfHeight() > 0) {
                ++topRow;
            }
            topRow = mapHeight - topRow;
            topRowY = this.size.height - this.tileBounds.getHeight() - (bottomRow - topRow) * this.tileBounds.getHalfHeight();
        } else {
            bottomRow = y + this.centerRows - 1;
            topRow = y - this.centerRows;
            topRowY = this.vSpace - this.centerRows * this.tileBounds.getHalfHeight();
        }
        this.alignedLeft = false;
        this.alignedRight = false;
        if (this.size.width / (this.tileBounds.getWidth() - 1) >= mapWidth) {
            this.alignedLeft = true;
            leftColumn = 0;
            rightColumn = mapWidth - 1;
            leftColumnX = 0;
        } else if (this.isMapNearLeft(x, y)) {
            this.alignedLeft = true;
            leftColumn = 0;
            rightColumn = this.size.width / this.tileBounds.getWidth() - 1;
            if (this.size.width % this.tileBounds.getWidth() > 0) {
                ++rightColumn;
            }
            leftColumnX = 0;
        } else if (this.isMapNearRight(x, y, mapWidth)) {
            this.alignedRight = true;
            rightColumn = mapWidth - 1;
            leftColumn = this.size.width / this.tileBounds.getWidth();
            if (this.size.width % this.tileBounds.getWidth() > 0) {
                ++leftColumn;
            }
            leftColumnX = this.size.width - this.tileBounds.getWidth() - this.tileBounds.getHalfWidth() - leftColumn * this.tileBounds.getWidth();
            leftColumn = rightColumn - leftColumn;
        } else {
            leftColumn = x - leftColumns;
            rightColumn = x + rightColumns;
            leftColumnX = (this.size.width - this.tileBounds.getWidth()) / 2 - leftColumns * this.tileBounds.getWidth();
        }
        this.topLeftVisibleTile = new Map.Position(leftColumn, topRow);
        this.bottomRightVisibleTile = new Map.Position(rightColumn, bottomRow);
        this.topLeftVisibleTilePoint = new Point(leftColumnX, topRowY);
    }

    private int getLeftColumns(int y) {
        return this.centerColumns + ((y & 1) == 0 ? this.columnEvenYOffset : this.columnOddYOffset);
    }

    private int getRightColumns(int y) {
        return this.centerColumns - ((y & 1) == 0 ? this.columnEvenYOffset : this.columnOddYOffset);
    }

    private boolean isMapNearTop(int y) {
        return y < this.centerRows;
    }

    private boolean isMapNearBottom(int y, int mapHeight) {
        return y >= mapHeight - this.centerRows;
    }

    private boolean isMapNearLeft(int x, int y) {
        return x < this.getLeftColumns(y);
    }

    private boolean isMapNearRight(int x, int y, int mapWidth) {
        return x >= mapWidth - this.getRightColumns(y);
    }

    Point tileToPoint(Tile tile) {
        int tileX = tile.getX();
        int tileY = tile.getY();
        int x = this.topLeftVisibleTilePoint.x + this.tileBounds.getWidth() * (tileX - this.topLeftVisibleTile.getX()) + (tileY & 1) * this.tileBounds.getHalfWidth();
        int y = this.topLeftVisibleTilePoint.y + this.tileBounds.getHalfHeight() * (tileY - this.topLeftVisibleTile.getY());
        return new Point(x, y);
    }

    public Rectangle calculateDrawnTileBounds(Tile tile) {
        if (!this.isTileVisible(tile)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Point p = this.tileToPoint(tile);
        return new Rectangle(p.x - this.tileBounds.getHalfWidth(), p.y - this.tileBounds.getHeight(), this.tileBounds.getWidth() * 2, this.tileBounds.getHeight() * 2);
    }

    Map.Position getTopLeftVisibleTile() {
        return this.topLeftVisibleTile;
    }

    Point getTopLeftVisibleTilePoint() {
        return this.topLeftVisibleTilePoint;
    }

    Dimension getSize() {
        return this.size;
    }

    public Tile getFocus() {
        return this.focus;
    }

    Tile convertToMapTile(Map map, int x, int y) {
        if (map == null || this.focus == null) {
            return null;
        }
        Point p = this.tileToPoint(this.focus);
        int leftOffset = p.x + this.tileBounds.getHalfWidth();
        int topOffset = p.y + this.tileBounds.getHalfHeight();
        int fx = this.focus.getX();
        int fy = this.focus.getY();
        int dcol = (x - leftOffset + (x > leftOffset ? this.tileBounds.getHalfWidth() : -this.tileBounds.getHalfWidth())) / this.tileBounds.getWidth();
        int drow = (y - topOffset + (y > topOffset ? this.tileBounds.getHalfHeight() : -this.tileBounds.getHalfHeight())) / this.tileBounds.getHeight();
        int px = leftOffset + dcol * this.tileBounds.getWidth();
        int py = topOffset + drow * this.tileBounds.getHeight();
        int newCol = fx + dcol;
        int newRow = fy + drow * 2;
        Direction direction = null;
        if (x > px) {
            if (y > py) {
                if (y - py > this.tileBounds.getHalfHeight() - (x - px) / 2) {
                    direction = Direction.SE;
                }
            } else if (y - py < (x - px) / 2 - this.tileBounds.getHalfHeight()) {
                direction = Direction.NE;
            }
        } else if (y > py) {
            if (y - py > (x - px) / 2 + this.tileBounds.getHalfHeight()) {
                direction = Direction.SW;
            }
        } else if (y - py < (px - x) / 2 - this.tileBounds.getHalfHeight()) {
            direction = Direction.NW;
        }
        int col = newCol;
        int row = newRow;
        if (direction != null) {
            Map.Position step = direction.step(newCol, newRow);
            col = step.x;
            row = step.y;
        }
        return map.getTile(col, row);
    }

    void changeSize(Dimension size, TileBounds tileBounds) {
        this.size = size;
        this.updateSizeVariables(tileBounds);
    }

    boolean isTileVisible(Tile tile) {
        if (tile == null) {
            return false;
        }
        return tile.getX() >= this.topLeftVisibleTile.getX() && tile.getX() <= this.bottomRightVisibleTile.getX() && tile.getY() >= this.topLeftVisibleTile.getY() && tile.getY() <= this.bottomRightVisibleTile.getY();
    }

    TileBounds getTileBounds() {
        return this.tileBounds;
    }
}

