/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction31c;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.android.tools.smali.dexlib2.util.Preconditions;

public class ImmutableInstruction31c
extends ImmutableInstruction
implements Instruction31c {
    public static final Format FORMAT = Format.Format31c;
    protected final int registerA;
    protected final ImmutableReference reference;

    public ImmutableInstruction31c(Opcode opcode, int registerA, Reference reference) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(registerA);
        this.reference = ImmutableReferenceFactory.of(opcode.referenceType, reference);
    }

    public static ImmutableInstruction31c of(Instruction31c instruction) {
        if (instruction instanceof ImmutableInstruction31c) {
            return (ImmutableInstruction31c)instruction;
        }
        return new ImmutableInstruction31c(instruction.getOpcode(), instruction.getRegisterA(), instruction.getReference());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public ImmutableReference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

