/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.openide.util.Lookup;

public class CloseButton {
    public static JButton create(Runnable onClose) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(onClose) : new Impl(onClose);
    }

    public static JButton createSmall(Runnable onClose) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.createSmall(onClose) : new Impl(onClose);
    }

    protected CloseButton() {
    }

    public static class Impl
    extends JButton {
        public Impl(final Runnable onClose) {
            super("Close");
            if (onClose != null) {
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        onClose.run();
                    }
                });
            }
        }
    }

    public static abstract class Provider {
        public abstract JButton create(Runnable var1);

        public JButton createSmall(Runnable onClose) {
            return this.create(onClose);
        }
    }
}

