/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.PerFieldSimilarityWrapper;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.util.plugin.SolrCoreAware;

public class SchemaSimilarityFactory
extends SimilarityFactory
implements SolrCoreAware {
    private static final String INIT_OPT = "defaultSimFromFieldType";
    private String defaultSimFromFieldType;
    private volatile SolrCore core;
    private volatile Similarity similarity;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(SolrParams args) {
        this.defaultSimFromFieldType = args.get(INIT_OPT, null);
        super.init(args);
    }

    @Override
    public Similarity getSimilarity() {
        if (null == this.core) {
            throw new IllegalStateException("SchemaSimilarityFactory can not be used until SolrCoreAware.inform has been called");
        }
        if (null == this.similarity) {
            BM25Similarity defaultSim = null;
            if (null == this.defaultSimFromFieldType) {
                defaultSim = new BM25Similarity();
            } else {
                FieldType defSimFT = this.core.getLatestSchema().getFieldTypeByName(this.defaultSimFromFieldType);
                if (null == defSimFT) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SchemaSimilarityFactory configured with defaultSimFromFieldType='" + this.defaultSimFromFieldType + "' but that <fieldType> does not exist");
                }
                defaultSim = defSimFT.getSimilarity();
                if (null == defaultSim) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SchemaSimilarityFactory configured with defaultSimFromFieldType='" + this.defaultSimFromFieldType + "' but that <fieldType> does not define a <similarity>");
                }
            }
            this.similarity = new SchemaSimilarity((Similarity)defaultSim);
        }
        return this.similarity;
    }

    private class SchemaSimilarity
    extends PerFieldSimilarityWrapper {
        private Similarity defaultSimilarity;

        public SchemaSimilarity(Similarity defaultSimilarity) {
            this.defaultSimilarity = defaultSimilarity;
        }

        public Similarity get(String name) {
            FieldType fieldType = SchemaSimilarityFactory.this.core.getLatestSchema().getFieldTypeNoEx(name);
            if (fieldType == null) {
                return this.defaultSimilarity;
            }
            Similarity similarity = fieldType.getSimilarity();
            return similarity == null ? this.defaultSimilarity : similarity;
        }

        public String toString() {
            return "SchemaSimilarity. Default: " + (this.get("") == null ? "null" : this.get("").toString());
        }
    }
}

