/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.util.stats.MetricUtils;

public class SolrMetricsContext {
    private final String registryName;
    private final SolrMetricManager metricManager;
    private final String tag;
    private final Set<String> metricNames = ConcurrentHashMap.newKeySet();

    public SolrMetricsContext(SolrMetricManager metricManager, String registryName, String tag) {
        this.registryName = registryName;
        this.metricManager = metricManager;
        this.tag = tag;
    }

    public Object nullNumber() {
        return this.metricManager.nullNumber();
    }

    public Object notANumber() {
        return this.metricManager.notANumber();
    }

    public Object nullString() {
        return this.metricManager.nullString();
    }

    public Object nullObject() {
        return this.metricManager.nullObject();
    }

    public String getTag() {
        return this.tag;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    public Set<String> getMetricNames() {
        return this.metricNames;
    }

    public void unregister() {
        this.metricManager.unregisterGauges(this.registryName, this.tag);
    }

    public SolrMetricsContext getChildContext(Object child) {
        SolrMetricsContext childContext = new SolrMetricsContext(this.metricManager, this.registryName, SolrMetricProducer.getUniqueMetricTag(child, this.tag));
        return childContext;
    }

    public void registerMetricName(String name) {
        this.metricNames.add(name);
    }

    public Map<String, Object> getMetricsSnapshot() {
        return MetricUtils.convertMetrics(this.getMetricRegistry(), this.metricNames);
    }

    public Meter meter(String metricName, String ... metricPath) {
        return this.metricManager.meter(this, this.registryName, metricName, metricPath);
    }

    public Counter counter(String metricName, String ... metricPath) {
        return this.metricManager.counter(this, this.registryName, metricName, metricPath);
    }

    public void gauge(Gauge<?> gauge, boolean force, String metricName, String ... metricPath) {
        this.metricManager.registerGauge(this, this.registryName, gauge, this.tag, force ? SolrMetricManager.ResolutionStrategy.REPLACE : SolrMetricManager.ResolutionStrategy.ERROR, metricName, metricPath);
    }

    public Timer timer(String metricName, String ... metricPath) {
        return this.metricManager.timer(this, this.registryName, metricName, metricPath);
    }

    public Histogram histogram(String metricName, String ... metricPath) {
        return this.metricManager.histogram(this, this.registryName, metricName, metricPath);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricManager.registry(this.registryName);
    }
}

