/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.handler.export.SingleValueSortDoc;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;

class DoubleValueSortDoc
extends SingleValueSortDoc {
    protected SortValue value2;

    @Override
    public SortValue getSortValue(String field) {
        if (this.value1.getField().equals(field)) {
            return this.value1;
        }
        if (this.value2.getField().equals(field)) {
            return this.value2;
        }
        return null;
    }

    @Override
    public void setNextReader(LeafReaderContext context) throws IOException {
        this.ord = context.ord;
        this.docBase = context.docBase;
        this.value1.setNextReader(context);
        this.value2.setNextReader(context);
    }

    @Override
    public void reset() {
        this.docId = -1;
        this.docBase = -1;
        this.ord = -1;
        this.value1.reset();
        this.value2.reset();
    }

    @Override
    public void setValues(int docId) throws IOException {
        this.docId = docId;
        this.value1.setCurrentValue(docId);
        this.value2.setCurrentValue(docId);
    }

    @Override
    public void setGlobalValues(SortDoc previous) {
        DoubleValueSortDoc doubleValueSortDoc = (DoubleValueSortDoc)previous;
        this.value1.toGlobalValue(doubleValueSortDoc.value1);
        this.value2.toGlobalValue(doubleValueSortDoc.value2);
    }

    @Override
    public void setValues(SortDoc sortDoc) {
        this.docId = sortDoc.docId;
        this.ord = sortDoc.ord;
        this.docBase = sortDoc.docBase;
        this.value1.setCurrentValue(((DoubleValueSortDoc)sortDoc).value1);
        this.value2.setCurrentValue(((DoubleValueSortDoc)sortDoc).value2);
    }

    public DoubleValueSortDoc(SortValue value1, SortValue value2) {
        super(value1);
        this.value2 = value2;
    }

    @Override
    public SortDoc copy() {
        return new DoubleValueSortDoc(this.value1.copy(), this.value2.copy());
    }

    @Override
    public boolean lessThan(Object o) {
        DoubleValueSortDoc sd = (DoubleValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        comp = this.value2.compareTo(sd.value2);
        if (comp == -1) {
            return true;
        }
        if (comp == 1) {
            return false;
        }
        return this.docId + this.docBase > sd.docId + sd.docBase;
    }

    @Override
    public int compareTo(SortDoc o) {
        DoubleValueSortDoc sd = (DoubleValueSortDoc)o;
        int comp = this.value1.compareTo(sd.value1);
        if (comp == 0) {
            comp = this.value2.compareTo(sd.value2);
            if (comp == 0) {
                return sd.docId + sd.docBase - (this.docId + this.docBase);
            }
            return comp;
        }
        return comp;
    }
}

