/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.opennlp.SentenceAttributeExtractor;
import org.apache.lucene.analysis.opennlp.tools.NLPLemmatizerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.SentenceAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10352: no dictionary support yet")
public class OpenNLPLemmatizerFilter
extends TokenFilter {
    private final NLPLemmatizerOp lemmatizerOp;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private Iterator<AttributeSource> sentenceTokenAttrsIter = null;
    private final SentenceAttributeExtractor sentenceAttributeExtractor;
    private String[] lemmas = new String[0];
    private int lemmaNum = 0;

    public OpenNLPLemmatizerFilter(TokenStream input, NLPLemmatizerOp lemmatizerOp) {
        super(input);
        this.lemmatizerOp = lemmatizerOp;
        this.sentenceAttributeExtractor = new SentenceAttributeExtractor(input, (SentenceAttribute)this.addAttribute(SentenceAttribute.class));
    }

    public final boolean incrementToken() throws IOException {
        boolean isEndOfCurrentSentence;
        boolean bl = isEndOfCurrentSentence = this.lemmaNum >= this.lemmas.length;
        if (isEndOfCurrentSentence) {
            boolean noSentencesLeft;
            boolean bl2 = noSentencesLeft = this.sentenceAttributeExtractor.allSentencesProcessed() || this.nextSentence().isEmpty();
            if (noSentencesLeft) {
                return false;
            }
        }
        this.clearAttributes();
        this.sentenceTokenAttrsIter.next().copyTo((AttributeSource)this);
        if (!this.keywordAtt.isKeyword()) {
            this.termAtt.setEmpty().append(this.lemmas[this.lemmaNum++]);
        }
        return true;
    }

    private List<AttributeSource> nextSentence() throws IOException {
        this.lemmaNum = 0;
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> typeList = new ArrayList<String>();
        List<AttributeSource> sentenceAttributes = this.sentenceAttributeExtractor.extractSentenceAttributes();
        for (AttributeSource attributeSource : sentenceAttributes) {
            if (((KeywordAttribute)attributeSource.getAttribute(KeywordAttribute.class)).isKeyword()) continue;
            tokenList.add(((CharTermAttribute)attributeSource.getAttribute(CharTermAttribute.class)).toString());
            typeList.add(((TypeAttribute)attributeSource.getAttribute(TypeAttribute.class)).type());
        }
        String[] sentenceTokens = tokenList.toArray(new String[0]);
        String[] sentenceTokenTypes = typeList.toArray(new String[0]);
        this.lemmas = this.lemmatizerOp.lemmatize(sentenceTokens, sentenceTokenTypes);
        this.sentenceTokenAttrsIter = sentenceAttributes.iterator();
        return this.sentenceAttributeExtractor.getSentenceAttributes();
    }

    public void reset() throws IOException {
        super.reset();
        this.sentenceAttributeExtractor.reset();
        this.clear();
    }

    private void clear() {
        this.sentenceTokenAttrsIter = null;
        this.lemmas = new String[0];
        this.lemmaNum = 0;
    }
}

