/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.esri;

import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorContains;
import com.esri.core.geometry.OperatorCrosses;
import com.esri.core.geometry.OperatorDisjoint;
import com.esri.core.geometry.OperatorEquals;
import com.esri.core.geometry.OperatorExportToWkt;
import com.esri.core.geometry.OperatorIntersects;
import com.esri.core.geometry.OperatorOverlaps;
import com.esri.core.geometry.OperatorSimpleRelation;
import com.esri.core.geometry.OperatorTouches;
import com.esri.core.geometry.OperatorWithin;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SpatialReference;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWithCRS;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.esri.Factory;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.opengis.geometry.DirectPosition;

final class Wrapper
extends GeometryWithCRS<Geometry> {
    private final Geometry geometry;
    private static final Supplier<OperatorSimpleRelation>[] PREDICATES = new Supplier[SpatialOperatorName.OVERLAPS.ordinal() + 1];

    Wrapper(Geometry geometry) {
        this.geometry = geometry;
    }

    @Override
    public Geometries<Geometry> factory() {
        return Factory.INSTANCE;
    }

    @Override
    public Object implementation() {
        return this.geometry;
    }

    @Override
    public GeneralEnvelope getEnvelope() {
        Envelope2D envelope2D = new Envelope2D();
        this.geometry.queryEnvelope2D(envelope2D);
        GeneralEnvelope generalEnvelope = this.createEnvelope();
        generalEnvelope.setRange(0, envelope2D.xmin, envelope2D.xmax);
        generalEnvelope.setRange(1, envelope2D.ymin, envelope2D.ymax);
        return generalEnvelope;
    }

    @Override
    public DirectPosition getCentroid() {
        Point2D point2D = OperatorCentroid2D.local().execute(this.geometry, null);
        return new DirectPosition2D(this.getCoordinateReferenceSystem(), point2D.x, point2D.y);
    }

    @Override
    public double[] getPointCoordinates() {
        double[] dArray;
        if (!(this.geometry instanceof Point)) {
            return null;
        }
        Point point = (Point)this.geometry;
        if (point.hasZ()) {
            dArray = new double[3];
            dArray[2] = point.getZ();
        } else {
            dArray = new double[2];
        }
        dArray[1] = point.getY();
        dArray[0] = point.getX();
        return dArray;
    }

    @Override
    public double[] getAllCoordinates() {
        if (this.geometry instanceof MultiVertexGeometry) {
            Point2D[] point2DArray = ((MultiVertexGeometry)this.geometry).getCoordinates2D();
            double[] dArray = new double[point2DArray.length * 2];
            int n = 0;
            for (Point2D point2D : point2DArray) {
                dArray[n++] = point2D.x;
                dArray[n++] = point2D.y;
            }
            return dArray;
        }
        return null;
    }

    @Override
    protected Geometry mergePolylines(Iterator<?> iterator) {
        Polyline polyline = new Polyline();
        boolean bl = false;
        Geometry geometry = this.geometry;
        block0: while (true) {
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                if (point.isEmpty()) {
                    bl = false;
                } else {
                    double d = ((Point)geometry).getX();
                    double d2 = ((Point)geometry).getY();
                    if (bl) {
                        polyline.lineTo(d, d2);
                    } else {
                        polyline.startPath(d, d2);
                        bl = true;
                    }
                }
            } else {
                polyline.add((MultiPath)geometry, false);
                bl = false;
            }
            while (iterator.hasNext()) {
                geometry = (Geometry)iterator.next();
                if (geometry == null) continue;
                continue block0;
            }
            break;
        }
        return polyline;
    }

    @Override
    protected boolean predicateSameCRS(SpatialOperatorName spatialOperatorName, GeometryWrapper<Geometry> geometryWrapper) {
        Supplier<OperatorSimpleRelation> supplier;
        int n = spatialOperatorName.ordinal();
        if (n >= 0 && n < PREDICATES.length && (supplier = PREDICATES[n]) != null) {
            return supplier.get().execute(this.geometry, ((Wrapper)geometryWrapper).geometry, Wrapper.srs(), null);
        }
        return super.predicateSameCRS(spatialOperatorName, geometryWrapper);
    }

    @Override
    protected Object operationSameCRS(SQLMM sQLMM, GeometryWrapper<Geometry> geometryWrapper, Object object) {
        Geometry geometry;
        switch (sQLMM) {
            case ST_Dimension: {
                return this.geometry.getDimension();
            }
            case ST_CoordDim: {
                return this.geometry.hasZ() ? 3 : 2;
            }
            case ST_GeometryType: {
                return this.geometry.getType().name();
            }
            case ST_IsEmpty: {
                return this.geometry.isEmpty();
            }
            case ST_Is3D: {
                return this.geometry.hasZ();
            }
            case ST_IsMeasured: {
                return this.geometry.hasM();
            }
            case ST_X: {
                return ((Point)this.geometry).getX();
            }
            case ST_Y: {
                return ((Point)this.geometry).getY();
            }
            case ST_Z: {
                return ((Point)this.geometry).getZ();
            }
            case ST_Envelope: {
                return this.getEnvelope();
            }
            case ST_Boundary: {
                geometry = this.geometry.getBoundary();
                break;
            }
            case ST_Simplify: {
                geometry = GeometryEngine.simplify((Geometry)this.geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_ConvexHull: {
                geometry = GeometryEngine.convexHull((Geometry)this.geometry);
                break;
            }
            case ST_Buffer: {
                geometry = GeometryEngine.buffer((Geometry)this.geometry, (SpatialReference)Wrapper.srs(), (double)((Number)object).doubleValue());
                break;
            }
            case ST_Intersection: {
                geometry = GeometryEngine.intersect((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Union: {
                geometry = GeometryEngine.union((Geometry[])new Geometry[]{this.geometry, ((Wrapper)geometryWrapper).geometry}, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Difference: {
                geometry = GeometryEngine.difference((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_SymDifference: {
                geometry = GeometryEngine.symmetricDifference((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
                break;
            }
            case ST_Distance: {
                return GeometryEngine.distance((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Equals: {
                return GeometryEngine.equals((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Disjoint: {
                return GeometryEngine.disjoint((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Touches: {
                return GeometryEngine.touches((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Crosses: {
                return GeometryEngine.crosses((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Within: {
                return GeometryEngine.within((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Contains: {
                return GeometryEngine.contains((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_Overlaps: {
                return GeometryEngine.overlaps((Geometry)this.geometry, (Geometry)((Wrapper)geometryWrapper).geometry, (SpatialReference)Wrapper.srs());
            }
            case ST_AsText: {
                return GeometryEngine.geometryToWkt((Geometry)this.geometry, (int)0);
            }
            case ST_GeomFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)object), (int)0, (Geometry.Type)Geometry.Type.Unknown);
            }
            case ST_PointFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)object), (int)0, (Geometry.Type)Geometry.Type.Point);
            }
            case ST_MPointFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)object), (int)0, (Geometry.Type)Geometry.Type.MultiPoint);
            }
            case ST_LineFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)object), (int)0, (Geometry.Type)Geometry.Type.Line);
            }
            case ST_PolyFromText: {
                return GeometryEngine.geometryFromWkt((String)((String)object), (int)0, (Geometry.Type)Geometry.Type.Polygon);
            }
            case ST_Intersects: {
                return OperatorIntersects.local().execute(this.geometry, ((Wrapper)geometryWrapper).geometry, Wrapper.srs(), null);
            }
            case ST_Centroid: {
                geometry = new Point(OperatorCentroid2D.local().execute(this.geometry, null));
                break;
            }
            default: {
                return super.operationSameCRS(sQLMM, geometryWrapper, object);
            }
        }
        return geometry;
    }

    private static SpatialReference srs() {
        return null;
    }

    @Override
    public String formatWKT(double d) {
        return OperatorExportToWkt.local().execute(0, this.geometry, null);
    }

    static {
        Wrapper.PREDICATES[SpatialOperatorName.EQUALS.ordinal()] = OperatorEquals::local;
        Wrapper.PREDICATES[SpatialOperatorName.DISJOINT.ordinal()] = OperatorDisjoint::local;
        Wrapper.PREDICATES[SpatialOperatorName.INTERSECTS.ordinal()] = OperatorIntersects::local;
        Wrapper.PREDICATES[SpatialOperatorName.TOUCHES.ordinal()] = OperatorTouches::local;
        Wrapper.PREDICATES[SpatialOperatorName.CROSSES.ordinal()] = OperatorCrosses::local;
        Wrapper.PREDICATES[SpatialOperatorName.WITHIN.ordinal()] = OperatorWithin::local;
        Wrapper.PREDICATES[SpatialOperatorName.CONTAINS.ordinal()] = OperatorContains::local;
        Wrapper.PREDICATES[SpatialOperatorName.OVERLAPS.ordinal()] = OperatorOverlaps::local;
        Wrapper.PREDICATES[SpatialOperatorName.BBOX.ordinal()] = new BBOX();
    }

    private static final class BBOX
    extends OperatorSimpleRelation
    implements Supplier<OperatorSimpleRelation> {
        private BBOX() {
        }

        @Override
        public OperatorSimpleRelation get() {
            return this;
        }

        public Operator.Type getType() {
            return Operator.Type.Intersects;
        }

        public boolean execute(Geometry geometry, Geometry geometry2, SpatialReference spatialReference, ProgressTracker progressTracker) {
            return !OperatorDisjoint.local().execute(geometry, geometry2, spatialReference, progressTracker);
        }
    }
}

