/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolUtils;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientDatanodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientDatanodeProtocol,
ProtocolTranslator,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ClientDatanodeProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private final ClientDatanodeProtocolPB rpcProxy;
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto VOID_REFRESH_NAMENODES = ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto VOID_GET_DATANODE_INFO = ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetVolumeReportRequestProto VOID_GET_DATANODE_STORAGE_INFO = ClientDatanodeProtocolProtos.GetVolumeReportRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.StartReconfigurationRequestProto VOID_START_RECONFIG = ReconfigurationProtocolProtos.StartReconfigurationRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto VOID_GET_BALANCER_BANDWIDTH = ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.EvictWritersRequestProto VOID_EVICT_WRITERS = ClientDatanodeProtocolProtos.EvictWritersRequestProto.newBuilder().build();

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public ClientDatanodeProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, conf, factory, 0);
    }

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr(dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory(conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr(dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        Configuration confWithNoIpcIdle = new Configuration(conf);
        confWithNoIpcIdle.setInt("ipc.client.connection.maxidletime", 0);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser(locatedBlock.getBlock().getLocalBlock().toString());
        ticket.addToken(locatedBlock.getBlockToken());
        return ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, confWithNoIpcIdle, NetUtils.getDefaultSocketFactory(conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine(conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine2.class);
        return RPC.getProxy(ClientDatanodeProtocolPB.class, RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), addr, ticket, conf, factory, socketTimeout);
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock b) throws IOException {
        ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto req = ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto.newBuilder().setBlock(PBHelperClient.convert(b)).build();
        return ShadedProtobufHelper.ipc(() -> this.rpcProxy.getReplicaVisibleLength(NULL_CONTROLLER, req).getLength());
    }

    @Override
    public void refreshNamenodes() throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.refreshNamenodes(NULL_CONTROLLER, VOID_REFRESH_NAMENODES));
    }

    @Override
    public void deleteBlockPool(String bpid, boolean force) throws IOException {
        ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto req = ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto.newBuilder().setBlockPool(bpid).setForce(force).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.deleteBlockPool(NULL_CONTROLLER, req));
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto req = ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto.newBuilder().setBlock(PBHelperClient.convert(block)).setToken(PBHelperClient.convert(token)).build();
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto resp = ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBlockLocalPathInfo(NULL_CONTROLLER, req));
        return new BlockLocalPathInfo(PBHelperClient.convert(resp.getBlock()), resp.getLocalPath(), resp.getLocalMetaPath());
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, ClientDatanodeProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), methodName);
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void shutdownDatanode(boolean forUpgrade) throws IOException {
        ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request = ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto.newBuilder().setForUpgrade(forUpgrade).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.shutdownDatanode(NULL_CONTROLLER, request));
    }

    @Override
    public void evictWriters() throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.evictWriters(NULL_CONTROLLER, VOID_EVICT_WRITERS));
    }

    @Override
    public DatanodeLocalInfo getDatanodeInfo() throws IOException {
        ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto response = ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDatanodeInfo(NULL_CONTROLLER, VOID_GET_DATANODE_INFO));
        return PBHelperClient.convert(response.getLocalInfo());
    }

    @Override
    public void startReconfiguration() throws IOException {
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.startReconfiguration(NULL_CONTROLLER, VOID_START_RECONFIG));
    }

    @Override
    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        return ReconfigurationProtocolUtils.getReconfigurationStatus(ShadedProtobufHelper.ipc(() -> this.rpcProxy.getReconfigurationStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS)));
    }

    @Override
    public List<String> listReconfigurableProperties() throws IOException {
        ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto response = ShadedProtobufHelper.ipc(() -> this.rpcProxy.listReconfigurableProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES));
        return response.getNameList();
    }

    @Override
    public void triggerBlockReport(BlockReportOptions options) throws IOException {
        ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto.Builder builder = ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto.newBuilder().setIncremental(options.isIncremental());
        if (options.getNamenodeAddr() != null) {
            builder.setNnAddress(NetUtils.getHostPortString(options.getNamenodeAddr()));
        }
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.triggerBlockReport(NULL_CONTROLLER, builder.build()));
    }

    @Override
    public long getBalancerBandwidth() throws IOException {
        ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto response = ShadedProtobufHelper.ipc(() -> this.rpcProxy.getBalancerBandwidth(NULL_CONTROLLER, VOID_GET_BALANCER_BANDWIDTH));
        return response.getBandwidth();
    }

    @Override
    public void submitDiskBalancerPlan(String planID, long planVersion, String planFile, String planData, boolean skipDateCheck) throws IOException {
        ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanRequestProto request = ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanRequestProto.newBuilder().setPlanID(planID).setPlanVersion(planVersion).setPlanFile(planFile).setPlan(planData).setIgnoreDateCheck(skipDateCheck).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.submitDiskBalancerPlan(NULL_CONTROLLER, request));
    }

    @Override
    public void cancelDiskBalancePlan(String planID) throws IOException {
        ClientDatanodeProtocolProtos.CancelPlanRequestProto request = ClientDatanodeProtocolProtos.CancelPlanRequestProto.newBuilder().setPlanID(planID).build();
        ShadedProtobufHelper.ipc(() -> this.rpcProxy.cancelDiskBalancerPlan(NULL_CONTROLLER, request));
    }

    @Override
    public DiskBalancerWorkStatus queryDiskBalancerPlan() throws IOException {
        ClientDatanodeProtocolProtos.QueryPlanStatusRequestProto request = ClientDatanodeProtocolProtos.QueryPlanStatusRequestProto.newBuilder().build();
        ClientDatanodeProtocolProtos.QueryPlanStatusResponseProto response = ShadedProtobufHelper.ipc(() -> this.rpcProxy.queryDiskBalancerPlan(NULL_CONTROLLER, request));
        DiskBalancerWorkStatus.Result result = DiskBalancerWorkStatus.Result.NO_PLAN;
        if (response.hasResult()) {
            result = DiskBalancerWorkStatus.Result.values()[response.getResult()];
        }
        return new DiskBalancerWorkStatus(result, response.hasPlanID() ? response.getPlanID() : null, response.hasPlanFile() ? response.getPlanFile() : null, response.hasCurrentStatus() ? response.getCurrentStatus() : null);
    }

    @Override
    public String getDiskBalancerSetting(String key) throws IOException {
        ClientDatanodeProtocolProtos.DiskBalancerSettingRequestProto request = ClientDatanodeProtocolProtos.DiskBalancerSettingRequestProto.newBuilder().setKey(key).build();
        ClientDatanodeProtocolProtos.DiskBalancerSettingResponseProto response = ShadedProtobufHelper.ipc(() -> this.rpcProxy.getDiskBalancerSetting(NULL_CONTROLLER, request));
        return response.hasValue() ? response.getValue() : null;
    }

    @Override
    public List<DatanodeVolumeInfo> getVolumeReport() throws IOException {
        ArrayList<DatanodeVolumeInfo> volumeInfoList = new ArrayList<DatanodeVolumeInfo>();
        ClientDatanodeProtocolProtos.GetVolumeReportResponseProto volumeReport = ShadedProtobufHelper.ipc(() -> this.rpcProxy.getVolumeReport(NULL_CONTROLLER, VOID_GET_DATANODE_STORAGE_INFO));
        List<HdfsProtos.DatanodeVolumeInfoProto> volumeProtoList = volumeReport.getVolumeInfoList();
        for (HdfsProtos.DatanodeVolumeInfoProto proto : volumeProtoList) {
            volumeInfoList.add(new DatanodeVolumeInfo(proto.getPath(), proto.getUsedSpace(), proto.getFreeSpace(), proto.getReservedSpace(), proto.getReservedSpaceForReplicas(), proto.getNumBlocks(), PBHelperClient.convertStorageType(proto.getStorageType())));
        }
        return volumeInfoList;
    }
}

