/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.codeInspection.unsorted;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AlphaUnsortedPropertiesFileInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(AlphaUnsortedPropertiesFileInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                PropertiesFile propertiesFile;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((propertiesFile = AlphaUnsortedPropertiesFileInspection.findPropertiesFile(file)) == null) {
                    return;
                }
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                String resourceBundleBaseName = resourceBundle.getBaseName();
                if (!AlphaUnsortedPropertiesFileInspection.isResourceBundleAlphaSortedExceptOneFile(resourceBundle, propertiesFile)) {
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description1", resourceBundleBaseName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new PropertiesSorterQuickFix(false)});
                    return;
                }
                if (!propertiesFile.isAlphaSorted()) {
                    PropertiesSorterQuickFix fix = new PropertiesSorterQuickFix(true);
                    holder.registerProblem((PsiElement)file, PropertiesBundle.message("inspection.alpha.unsorted.properties.file.description", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$1", "visitFile"));
            }
        };
    }

    @Nullable
    private static PropertiesFile findPropertiesFile(@NotNull PsiFile file) {
        PropertiesFile propertiesFile;
        if (file == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(1);
        }
        if (!((propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) instanceof PropertiesFileImpl)) {
            return null;
        }
        for (AlphaUnsortedPropertiesFileInspectionSuppressor filter : (AlphaUnsortedPropertiesFileInspectionSuppressor[])AlphaUnsortedPropertiesFileInspectionSuppressor.EP_NAME.getExtensions()) {
            if (!filter.suppressInspectionFor(propertiesFile)) continue;
            return null;
        }
        return propertiesFile;
    }

    private static boolean isResourceBundleAlphaSortedExceptOneFile(@NotNull ResourceBundle resourceBundle, @NotNull PropertiesFile exceptedFile) {
        if (resourceBundle == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(2);
        }
        if (exceptedFile == null) {
            AlphaUnsortedPropertiesFileInspection.$$$reportNull$$$0(3);
        }
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            if (!(file instanceof PropertiesFileImpl)) {
                return true;
            }
            if (file.equals(exceptedFile) || file.isAlphaSorted()) continue;
            return false;
        }
        return true;
    }

    private static void sortPropertiesFile(PropertiesFile file) {
        ArrayList<IProperty> properties = new ArrayList<IProperty>(file.getProperties());
        properties.sort(Comparator.comparing(IProperty::getKey, String.CASE_INSENSITIVE_ORDER));
        PropertiesList propertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)file.getContainingFile(), PropertiesList.class);
        if (propertiesList == null) {
            return;
        }
        char delimiter = PropertiesCodeStyleSettings.getInstance(file.getProject()).getDelimiter();
        StringBuilder rawText = new StringBuilder(propertiesList.getDocCommentText());
        for (int i = 0; i < properties.size(); ++i) {
            String key;
            IProperty property = (IProperty)properties.get(i);
            String value = property.getValue();
            String commentAboveProperty = property.getDocCommentText();
            if (commentAboveProperty != null) {
                rawText.append(commentAboveProperty);
            }
            if ((key = property.getKey()) == null) continue;
            String propertyText = PropertiesElementFactory.getPropertyText(key, value != null ? value : "", Character.valueOf(delimiter), null, PropertyKeyValueFormat.FILE);
            rawText.append(propertyText);
            if (i == properties.size() - 1) continue;
            rawText.append("\n");
        }
        PropertiesFile fakeFile = PropertiesElementFactory.createPropertiesFile(file.getProject(), rawText.toString());
        PropertiesList fakePropertiesList = (PropertiesList)PsiTreeUtil.findChildOfType((PsiElement)fakeFile.getContainingFile(), PropertiesList.class);
        LOG.assertTrue(fakePropertiesList != null);
        propertiesList.replace((PsiElement)fakePropertiesList);
    }

    @NotNull
    public String getShortName() {
        return "AlphaUnsortedPropertiesFile";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptedFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/properties/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findPropertiesFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isResourceBundleAlphaSortedExceptOneFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PropertiesSorterQuickFix
    implements LocalQuickFix {
        private final boolean myOnlyCurrentFile;

        private PropertiesSorterQuickFix(boolean onlyCurrentFile) {
            this.myOnlyCurrentFile = onlyCurrentFile;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message("properties.sorter.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Collection<PropertiesFile> filesToSort;
            if (project == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(2);
            }
            boolean force = (filesToSort = this.getFilesToSort(descriptor.getPsiElement().getContainingFile())).size() == 1;
            for (PropertiesFile file : filesToSort) {
                if (!force && file.isAlphaSorted()) continue;
                AlphaUnsortedPropertiesFileInspection.sortPropertiesFile(file);
            }
        }

        @NotNull
        private Collection<PropertiesFile> getFilesToSort(@NotNull PsiFile file) {
            PropertiesFile propertiesFile;
            if (file == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(3);
            }
            if ((propertiesFile = AlphaUnsortedPropertiesFileInspection.findPropertiesFile(file)) == null) {
                List<PropertiesFile> list = Collections.emptyList();
                if (list == null) {
                    PropertiesSorterQuickFix.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (this.myOnlyCurrentFile) {
                Set<PropertiesFile> set = Collections.singleton(propertiesFile);
                if (set == null) {
                    PropertiesSorterQuickFix.$$$reportNull$$$0(5);
                }
                return set;
            }
            List<PropertiesFile> list = propertiesFile.getResourceBundle().getPropertiesFiles();
            if (list == null) {
                PropertiesSorterQuickFix.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/properties/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/properties/codeInspection/unsorted/AlphaUnsortedPropertiesFileInspection$PropertiesSorterQuickFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesToSort";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesToSort";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

