/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.psi.util;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\u001a9\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u000b\u001a7\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000b\u001aC\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000f\u001a<\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u001a8\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a5\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a5\u0010\f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a(\u0010\u001f\u001a\u00020\u0007*\u00020\n2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\f\u0010!\u001a\u00020\u0001*\u00020\u0005H\u0002\u00a8\u0006\""}, d2={"updateIgnoreBlock", "", "project", "Lcom/intellij/openapi/project/Project;", "ignoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredGroupDescription", "", "newEntries", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;[Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;)V", "addNewElementsToIgnoreBlock", "vcs", "Lcom/intellij/openapi/vcs/VcsKey;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/openapi/vcs/VcsKey;[Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;)V", "addNewElements", "", "ignoreEntryRoot", "changeIgnoreFile", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "provider", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;)V", "getOrCreateIgnoreBlockContentTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/Document;", "createIgnoreGroup", "text", "", "toText", "ignoredFileContentProvider", "save", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIgnoreFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreFileUtil.kt\ncom/intellij/openapi/vcs/changes/ignore/psi/util/IgnoreFileUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,188:1\n11165#2:189\n11500#2,3:190\n827#3:193\n855#3,2:194\n209#4,8:196\n209#4,8:204\n*S KotlinDebug\n*F\n+ 1 IgnoreFileUtil.kt\ncom/intellij/openapi/vcs/changes/ignore/psi/util/IgnoreFileUtilKt\n*L\n106#1:189\n106#1:190,3\n107#1:193\n107#1:194,2\n117#1:196,8\n129#1:204,8\n*E\n"})
public final class IgnoreFileUtilKt {
    @TestOnly
    public static final void updateIgnoreBlock(@NotNull Project project, @NotNull VirtualFile ignoreFile, @NotNull String ignoredGroupDescription, IgnoredFileDescriptor ... newEntries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        Intrinsics.checkNotNullParameter((Object)ignoredGroupDescription, (String)"ignoredGroupDescription");
        Intrinsics.checkNotNullParameter((Object)newEntries, (String)"newEntries");
        IgnoreFileUtilKt.changeIgnoreFile$default(project, ignoreFile, null, arg_0 -> IgnoreFileUtilKt.updateIgnoreBlock$lambda$0(ignoredGroupDescription, ignoreFile, newEntries, arg_0), 4, null);
    }

    public static final void addNewElementsToIgnoreBlock(@NotNull Project project, @NotNull VirtualFile ignoreFile, @NotNull String ignoredGroupDescription, IgnoredFileDescriptor ... newEntries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        Intrinsics.checkNotNullParameter((Object)ignoredGroupDescription, (String)"ignoredGroupDescription");
        Intrinsics.checkNotNullParameter((Object)newEntries, (String)"newEntries");
        IgnoreFileUtilKt.addNewElementsToIgnoreBlock(project, ignoreFile, ignoredGroupDescription, null, Arrays.copyOf(newEntries, newEntries.length));
    }

    public static final void addNewElementsToIgnoreBlock(@NotNull Project project, @NotNull VirtualFile ignoreFile, @NotNull String ignoredGroupDescription, @Nullable VcsKey vcs, IgnoredFileDescriptor ... newEntries) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        Intrinsics.checkNotNullParameter((Object)ignoredGroupDescription, (String)"ignoredGroupDescription");
        Intrinsics.checkNotNullParameter((Object)newEntries, (String)"newEntries");
        IgnoreFileUtilKt.changeIgnoreFile(project, ignoreFile, vcs, (Function1<? super IgnoredFileContentProvider, Unit>)((Function1)arg_0 -> IgnoreFileUtilKt.addNewElementsToIgnoreBlock$lambda$1(ignoredGroupDescription, ignoreFile, newEntries, arg_0)));
    }

    public static /* synthetic */ void addNewElementsToIgnoreBlock$default(Project project, VirtualFile virtualFile, String string, VcsKey vcsKey, IgnoredFileDescriptor[] ignoredFileDescriptorArray, int n, Object object) {
        if ((n & 8) != 0) {
            vcsKey = null;
        }
        IgnoreFileUtilKt.addNewElementsToIgnoreBlock(project, virtualFile, string, vcsKey, ignoredFileDescriptorArray);
    }

    public static final void addNewElements(@NotNull Project project, @NotNull VirtualFile ignoreFile, @NotNull List<? extends IgnoredFileDescriptor> newEntries, @Nullable VcsKey vcs, @Nullable VirtualFile ignoreEntryRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ignoreFile, (String)"ignoreFile");
        Intrinsics.checkNotNullParameter(newEntries, (String)"newEntries");
        IgnoreFileUtilKt.changeIgnoreFile(project, ignoreFile, vcs, (Function1<? super IgnoredFileContentProvider, Unit>)((Function1)arg_0 -> IgnoreFileUtilKt.addNewElements$lambda$3(ignoreFile, newEntries, ignoreEntryRoot, arg_0)));
    }

    public static /* synthetic */ void addNewElements$default(Project project, VirtualFile virtualFile, List list, VcsKey vcsKey, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 8) != 0) {
            vcsKey = null;
        }
        if ((n & 0x10) != 0) {
            virtualFile2 = null;
        }
        IgnoreFileUtilKt.addNewElements(project, virtualFile, list, vcsKey, virtualFile2);
    }

    private static final void changeIgnoreFile(Project project, VirtualFile ignoreFile, VcsKey vcs, Function1<? super IgnoredFileContentProvider, Unit> action) {
        Object object = vcs;
        if (object == null) {
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)ignoreFile);
            object = abstractVcs != null ? abstractVcs.getKeyInstanceMethod() : null;
            if (object == null) {
                return;
            }
        }
        VcsKey determinedVcs = object;
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(project, determinedVcs);
        if (ignoredFileContentProvider == null) {
            return;
        }
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        ApplicationManager.getApplication().invokeAndWait(() -> IgnoreFileUtilKt.changeIgnoreFile$lambda$5(project, ignoreFile, action, ignoredFileContentProvider2));
    }

    static /* synthetic */ void changeIgnoreFile$default(Project project, VirtualFile virtualFile, VcsKey vcsKey, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            vcsKey = null;
        }
        IgnoreFileUtilKt.changeIgnoreFile(project, virtualFile, vcsKey, (Function1<? super IgnoredFileContentProvider, Unit>)function1);
    }

    private static final void updateIgnoreBlock(String ignoredGroupDescription, VirtualFile ignoreFile, IgnoredFileDescriptor[] newEntries, IgnoredFileContentProvider provider) {
        Document document = FileDocumentManager.getInstance().getDocument(ignoreFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        TextRange contentTextRange = IgnoreFileUtilKt.getOrCreateIgnoreBlockContentTextRange(document2, ignoredGroupDescription);
        String newEntriesText = ArraysKt.joinToString$default((Object[])newEntries, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, arg_0 -> IgnoreFileUtilKt.updateIgnoreBlock$lambda$6(provider, ignoreFile, arg_0), (int)26, null);
        document2.replaceString(contentTextRange.getStartOffset(), contentTextRange.getEndOffset(), (CharSequence)newEntriesText);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addNewElementsToIgnoreBlock(String ignoredGroupDescription, VirtualFile ignoreFile, IgnoredFileDescriptor[] newEntries, IgnoredFileContentProvider provider) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Document document = FileDocumentManager.getInstance().getDocument(ignoreFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        TextRange contentRange = IgnoreFileUtilKt.getOrCreateIgnoreBlockContentTextRange(document2, ignoredGroupDescription);
        Set existingEntries = CollectionsKt.toSet((Iterable)StringsKt.lines((CharSequence)document2.getCharsSequence().subSequence(contentRange.getStartOffset(), contentRange.getEndOffset())));
        IgnoredFileDescriptor[] ignoredFileDescriptorArray = newEntries;
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var16_17 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IgnoreFileUtilKt.toText$default((IgnoredFileDescriptor)it, provider, ignoreFile, null, 4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (existingEntries.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String newEntriesText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
        document2.insertString(contentRange.getEndOffset(), (CharSequence)newEntriesText);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextRange getOrCreateIgnoreBlockContentTextRange(Document ignoreFile, String ignoredGroupDescription) {
        TextRange textRange;
        int groupDescrLine;
        CharSequence text;
        block10: {
            int n;
            CharSequence charSequence = ignoreFile.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            text = charSequence;
            Sequence $this$indexOfFirst$iv = StringsKt.lineSequence((CharSequence)text);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)ignoredGroupDescription)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = groupDescrLine = -1;
        }
        if (groupDescrLine == -1) {
            String ignoreGroupToAppend = IgnoreFileUtilKt.createIgnoreGroup(text, ignoredGroupDescription);
            ignoreFile.insertString(ignoreFile.getTextLength(), (CharSequence)ignoreGroupToAppend);
            int lastIndex = ignoreFile.getTextLength();
            textRange = new TextRange(lastIndex, lastIndex);
        } else {
            int n;
            int emptyLine;
            block11: {
                int n2;
                void $this$indexOfFirst$iv;
                int groupDescrStartOffset = ignoreFile.getLineStartOffset(groupDescrLine);
                CharSequence tail = text.subSequence(groupDescrStartOffset, ignoreFile.getTextLength());
                Iterator iterator = SequencesKt.drop((Sequence)StringsKt.lineSequence((CharSequence)tail), (int)1);
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.isBlank((CharSequence)it) || StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) {
                        n2 = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n2 = emptyLine = -1;
            }
            if (emptyLine == -1) {
                ignoreFile.insertString(ignoreFile.getTextLength(), (CharSequence)"\n");
                n = ignoreFile.getTextLength();
            } else {
                n = ignoreFile.getLineStartOffset(emptyLine + 1 + groupDescrLine);
            }
            int groupEndOffset = n;
            int contentStartOffset = ignoreFile.getLineCount() <= groupDescrLine + 1 ? groupEndOffset : ignoreFile.getLineStartOffset(groupDescrLine + 1);
            textRange = new TextRange(contentStartOffset, groupEndOffset);
        }
        return textRange;
    }

    private static final String createIgnoreGroup(CharSequence text, String ignoredGroupDescription) {
        StringBuilder stringBuilder;
        boolean newlineRequired = text.length() > 0 && StringsKt.last((CharSequence)text) != '\n';
        StringBuilder $this$createIgnoreGroup_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (newlineRequired) {
            $this$createIgnoreGroup_u24lambda_u2411.append("\n");
        }
        $this$createIgnoreGroup_u24lambda_u2411.append(ignoredGroupDescription);
        $this$createIgnoreGroup_u24lambda_u2411.append("\n");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String toText(IgnoredFileDescriptor $this$toText, IgnoredFileContentProvider ignoredFileContentProvider, VirtualFile ignoreFile, VirtualFile ignoreEntryRoot) {
        String string;
        String ignorePath = $this$toText.getPath();
        String ignoreMask = $this$toText.getMask();
        if (ignorePath != null) {
            VirtualFile virtualFile = ignoreEntryRoot;
            if (virtualFile == null && (virtualFile = ignoreFile.getParent()) == null) {
                throw new IllegalStateException("Cannot determine ignore file path for " + ignoreFile);
            }
            VirtualFile ignoreFileContainingDir = virtualFile;
            String string2 = ignoredFileContentProvider.buildIgnoreEntryContent(ignoreFileContainingDir, $this$toText);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = ignoreMask;
            if (string == null) {
                throw new IllegalStateException("IgnoredFileBean: path and mask cannot be null at the same time");
            }
        }
        return string;
    }

    static /* synthetic */ String toText$default(IgnoredFileDescriptor ignoredFileDescriptor, IgnoredFileContentProvider ignoredFileContentProvider, VirtualFile virtualFile, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 4) != 0) {
            virtualFile2 = null;
        }
        return IgnoreFileUtilKt.toText(ignoredFileDescriptor, ignoredFileContentProvider, virtualFile, virtualFile2);
    }

    private static final void save(VirtualFile $this$save) {
        Document document;
        if ($this$save.isDirectory() || !$this$save.isValid()) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        if (documentManager.isFileModified($this$save) && (document = documentManager.getDocument($this$save)) != null) {
            ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> IgnoreFileUtilKt.save$lambda$12(documentManager, document));
        }
    }

    private static final Unit updateIgnoreBlock$lambda$0(String $ignoredGroupDescription, VirtualFile $ignoreFile, IgnoredFileDescriptor[] $newEntries, IgnoredFileContentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        IgnoreFileUtilKt.updateIgnoreBlock($ignoredGroupDescription, $ignoreFile, $newEntries, provider);
        return Unit.INSTANCE;
    }

    private static final Unit addNewElementsToIgnoreBlock$lambda$1(String $ignoredGroupDescription, VirtualFile $ignoreFile, IgnoredFileDescriptor[] $newEntries, IgnoredFileContentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        IgnoreFileUtilKt.addNewElementsToIgnoreBlock($ignoredGroupDescription, $ignoreFile, $newEntries, provider);
        return Unit.INSTANCE;
    }

    private static final CharSequence addNewElements$lambda$3$lambda$2(IgnoredFileContentProvider $provider, VirtualFile $ignoreFile, VirtualFile $ignoreEntryRoot, IgnoredFileDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IgnoreFileUtilKt.toText(it, $provider, $ignoreFile, $ignoreEntryRoot);
    }

    private static final Unit addNewElements$lambda$3(VirtualFile $ignoreFile, List $newEntries, VirtualFile $ignoreEntryRoot, IgnoredFileContentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Document document = FileDocumentManager.getInstance().getDocument($ignoreFile);
        if (document == null) {
            return Unit.INSTANCE;
        }
        Document document2 = document;
        if (document2.getTextLength() != 0) {
            CharSequence charSequence = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            if (StringsKt.last((CharSequence)charSequence) != '\n') {
                document2.insertString(document2.getTextLength(), (CharSequence)"\n");
            }
        }
        int textEndOffset = document2.getTextLength();
        String text = CollectionsKt.joinToString$default((Iterable)$newEntries, (CharSequence)"\n", null, (CharSequence)"\n", (int)0, null, arg_0 -> IgnoreFileUtilKt.addNewElements$lambda$3$lambda$2(provider, $ignoreFile, $ignoreEntryRoot, arg_0), (int)26, null);
        document2.insertString(textEndOffset, (CharSequence)text);
        return Unit.INSTANCE;
    }

    private static final Unit changeIgnoreFile$lambda$5$lambda$4(Project $project, VirtualFile $ignoreFile, Function1 $action, IgnoredFileContentProvider $ignoredFileContentProvider) {
        if ($project.isDisposed()) {
            return Unit.INSTANCE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($ignoreFile);
        if (!((psiFile != null ? psiFile.getLanguage() : null) instanceof IgnoreLanguage)) {
            return Unit.INSTANCE;
        }
        $action.invoke((Object)$ignoredFileContentProvider);
        IgnoreFileUtilKt.save($ignoreFile);
        return Unit.INSTANCE;
    }

    private static final void changeIgnoreFile$lambda$5(Project $project, VirtualFile $ignoreFile, Function1 $action, IgnoredFileContentProvider $ignoredFileContentProvider) {
        ActionsKt.runUndoTransparentWriteAction(() -> IgnoreFileUtilKt.changeIgnoreFile$lambda$5$lambda$4($project, $ignoreFile, $action, $ignoredFileContentProvider));
    }

    private static final CharSequence updateIgnoreBlock$lambda$6(IgnoredFileContentProvider $provider, VirtualFile $ignoreFile, IgnoredFileDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IgnoreFileUtilKt.toText$default(it, $provider, $ignoreFile, null, 4, null);
    }

    private static final void save$lambda$12(FileDocumentManager $documentManager, Document $document) {
        $documentManager.saveDocumentAsIs($document);
    }
}

