/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImplKt;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0016\u001a\u00020\rJ\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0018J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010'\u001a\u00020 H\u0016J\b\u0010(\u001a\u00020 H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u001f\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020 X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u0014\u0010)\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\"R\u0014\u0010+\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0014\u0010-\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\"R\u0014\u0010/\u001a\u00020 X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\"\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/ProjectConfigurationFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "addChosenFiles", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/vcs/AbstractVcs;Lkotlin/jvm/functions/Function1;)V", "foundProjectConfigurationFiles", "Ljava/util/concurrent/atomic/AtomicBoolean;", "vcsIgnoreManager", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "install", "filterNotProjectConfigurationFiles", "", "files", "unchangedFileStatusChanged", "upToDate", "", "doFilterFiles", "doActionOnChosenFiles", "notificationDisplayId", "", "getNotificationDisplayId", "()Ljava/lang/String;", "askedBeforeProperty", "getAskedBeforeProperty", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "notificationTitle", "notificationMessage", "showActionText", "getShowActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "viewFilesDialogTitle", "getViewFilesDialogTitle", "intellij.platform.vcs.impl"})
public final class ProjectConfigurationFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements ChangeListListener {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final AbstractVcs vcs;
    @NotNull
    private final Function1<Collection<? extends VirtualFile>, Unit> addChosenFiles;
    @NotNull
    private final AtomicBoolean foundProjectConfigurationFiles;
    private final VcsIgnoreManager vcsIgnoreManager;
    @NotNull
    private final String notificationDisplayId;
    @NotNull
    private final String askedBeforeProperty;
    @NotNull
    private final String doForCurrentProjectProperty;
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @NotNull
    private final String muteActionText;
    @NotNull
    private final String viewFilesDialogTitle;

    public ProjectConfigurationFilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull AbstractVcs vcs, @NotNull Function1<? super Collection<? extends VirtualFile>, Unit> addChosenFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter(addChosenFiles, (String)"addChosenFiles");
        super(project, parentDisposable);
        this.parentDisposable = parentDisposable;
        this.vcs = vcs;
        this.addChosenFiles = addChosenFiles;
        this.foundProjectConfigurationFiles = new AtomicBoolean();
        this.vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
        this.notificationDisplayId = "project.configuration.files.added.notification";
        this.askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
        this.doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
        String string = VcsBundle.message((String)"project.configuration.files.add.notification.action.view", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showActionText = string;
        String string2 = VcsBundle.message((String)"project.configuration.files.add.notification.action.add", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.forCurrentProjectActionText = string2;
        String string3 = VcsBundle.message((String)"project.configuration.files.add.notification.action.mute", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.muteActionText = string3;
        Object[] objectArray = new Object[]{this.vcs.getDisplayName()};
        String string4 = VcsBundle.message((String)"project.configuration.files.view.dialog.title", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.viewFilesDialogTitle = string4;
    }

    public final void install() {
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect(this.parentDisposable);
        Topic topic = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    @NotNull
    public final List<VirtualFile> filterNotProjectConfigurationFiles(@NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Collection<VirtualFile> projectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)files);
        if (!projectConfigurationFiles.isEmpty() && this.foundProjectConfigurationFiles.compareAndSet(false, true)) {
            Object[] objectArray = new Object[]{projectConfigurationFiles};
            ProjectConfigurationFilesProcessorImplKt.access$getLOG$p().debug("Found new project configuration files ", objectArray);
        }
        return CollectionsKt.minus((Iterable)files, (Iterable)projectConfigurationFiles);
    }

    public void unchangedFileStatusChanged(boolean upToDate) {
        if (upToDate && this.foundProjectConfigurationFiles.compareAndSet(true, false)) {
            List<VirtualFile> list = ChangeListManagerImpl.getInstanceImpl(this.getProject()).getUnversionedFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getUnversionedFiles(...)");
            Collection<VirtualFile> unversionedProjectConfigurationFiles = this.doFilterFiles((Collection<? extends VirtualFile>)list);
            if (!unversionedProjectConfigurationFiles.isEmpty()) {
                this.setForCurrentProject(VcsImplUtil.isProjectSharedInVcs(this.getProject()));
                this.processFiles(CollectionsKt.toList((Iterable)unversionedProjectConfigurationFiles));
            }
        }
    }

    @Override
    @NotNull
    public Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        VirtualFile projectConfigDir = ProjectConfigurationFilesProcessorImplKt.access$getProjectConfigDir(this.getProject());
        return SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), arg_0 -> ProjectConfigurationFilesProcessorImpl.doFilterFiles$lambda$0(projectConfigDir, arg_0)), (Function1)((Function1)new Function1<VirtualFile, Boolean>((Object)this.vcsIgnoreManager){

            public final Boolean invoke(VirtualFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((VcsIgnoreManager)this.receiver).isPotentiallyIgnoredFile(p0);
            }
        })));
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.addChosenFiles.invoke(files);
    }

    @Override
    @NotNull
    public String getNotificationDisplayId() {
        return this.notificationDisplayId;
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        Object[] objectArray = new Object[]{this.vcs.getDisplayName()};
        String string = VcsBundle.message((String)"project.configuration.files.add.notification.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    @NotNull
    protected String getViewFilesDialogTitle() {
        return this.viewFilesDialogTitle;
    }

    private static final boolean doFilterFiles$lambda$0(VirtualFile $projectConfigDir, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectConfigurationFilesProcessorImplKt.access$getConfigurationFilesExtensionsOutsideStoreDirectory$p().contains(it.getExtension()) || ProjectConfigurationFilesProcessorImplKt.access$isProjectConfigurationFile($projectConfigDir, it);
    }
}

