/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.ComponentPrinter;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.hierarchy.ExistingHierarchy;
import org.assertj.swing.hierarchy.NewHierarchy;
import org.assertj.swing.hierarchy.SingleComponentHierarchy;

public final class BasicComponentPrinter
implements ComponentPrinter {
    private static final String INDENTATION = "  ";
    private static final ComponentMatcher ALWAYS_MATCHES = BasicComponentPrinter.alwaysMatches();
    private final ComponentHierarchy hierarchy;

    @Nonnull
    private static ComponentMatcher alwaysMatches() {
        return new ComponentMatcher(){

            @Override
            public boolean matches(@Nullable Component c) {
                return true;
            }
        };
    }

    @Nonnull
    public static ComponentPrinter printerWithNewAwtHierarchy() {
        return new BasicComponentPrinter(NewHierarchy.ignoreExistingComponents());
    }

    @Nonnull
    public static ComponentPrinter printerWithCurrentAwtHierarchy() {
        return new BasicComponentPrinter(new ExistingHierarchy());
    }

    protected BasicComponentPrinter(@Nonnull ComponentHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    @Nonnull
    protected final ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out) {
        this.printComponents(out, ALWAYS_MATCHES);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nullable Container root) {
        this.printComponents(out, ALWAYS_MATCHES, root);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type) {
        this.printComponents(out, type, null);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type, @Nullable Container root) {
        BasicComponentPrinter.print(this.hierarchy(root), new TypeMatcher((Class)Preconditions.checkNotNull(type)), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher2) {
        this.printComponents(out, matcher2, null);
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher2, @Nullable Container root) {
        BasicComponentPrinter.print(this.hierarchy(root), (ComponentMatcher)Preconditions.checkNotNull((Object)matcher2), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Nonnull
    private ComponentHierarchy hierarchy(@Nullable Container root) {
        return root != null ? new SingleComponentHierarchy(root, this.hierarchy) : this.hierarchy;
    }

    @RunsInEDT
    private static void print(@Nonnull ComponentHierarchy hierarchy, @Nonnull ComponentMatcher matcher2, @Nonnull PrintStream out) {
        GuiActionRunner.execute(() -> {
            for (Component component2 : hierarchy.roots()) {
                BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)component2), hierarchy, matcher2, 0, out);
            }
        });
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, @Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher matcher2, int level, @Nonnull PrintStream out) {
        if (matcher2.matches(c)) {
            BasicComponentPrinter.print(c, level, out);
        }
        for (Component child : h.childrenOf(c)) {
            BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)child), h, matcher2, level + 1, out);
        }
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, int level, @Nonnull PrintStream out) {
        for (int i = 0; i < level; ++i) {
            out.print(INDENTATION);
        }
        out.println(Formatting.format(c));
    }
}

