/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.SshApiBundle;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshConnectionConfigPatchConverter;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Text;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import java.util.UUID;
import kotlin.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="sshConfig")
public class SshConfig
implements Cloneable {
    public static final int DEFAULT_PORT = 22;
    @NonNls
    public static final String DEFAULT_KEY_PATH = "/.ssh/id_rsa";
    private static final int DEFAULT_INVALID_PORT = -1;
    @NotNull
    private String myId;
    private boolean isProjectLevel;
    @NotNull
    private String myHost = "";
    @NotNull
    private String myLiteralPort = "";
    private int myPort = -1;
    @Deprecated
    @NotNull
    private String myLiteralLocalPort = "";
    @Deprecated
    private int myLocalPort = -1;
    @NotNull
    private String myUsername = "";
    @NotNull
    private AuthType myAuthType = AuthType.KEY_PAIR;
    @NotNull
    private String myKeyPath = "";
    @NotNull
    private NameFormat myNameFormat;
    @Nullable
    @NlsSafe
    private String myCustomName;
    @Nullable
    private SshConnectionConfigPatch myConnectionConfigPatch;
    @Attribute(value="useOpenSSHConfig")
    @NotNull
    private String mySerializedUseOpenSSHConfig = "";

    @Attribute(value="id")
    @NotNull
    @NonNls
    public String getId() {
        String string = this.myId;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setId(@NotNull String id) {
        if (id == null) {
            SshConfig.$$$reportNull$$$0(1);
        }
        this.myId = id;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setProjectLevel(boolean projectLevel) {
        this.isProjectLevel = projectLevel;
    }

    @Attribute(value="host")
    @NotNull
    @NlsSafe
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setHost(@Nullable String host) {
        this.myHost = StringUtil.notNullize((String)host);
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = Math.max(port, -1);
        this.myLiteralPort = String.valueOf(this.myPort);
    }

    @Attribute(value="port")
    @NotNull
    @NlsSafe
    public String getLiteralPort() {
        String string = this.myLiteralPort;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setLiteralPort(@Nullable String literalPort) {
        this.myLiteralPort = StringUtil.notNullize((String)literalPort);
        this.myPort = SshConfig.parseSshPort(literalPort);
    }

    @Deprecated
    @Attribute(value="localPort")
    @NotNull
    public String getLiteralLocalPort() {
        String string = this.myLiteralLocalPort;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Deprecated
    public void setLiteralLocalPort(@Nullable String literalLocalPort) {
        this.myLiteralLocalPort = StringUtil.notNullize((String)literalLocalPort);
        this.myLocalPort = SshConfig.parseSshPort(literalLocalPort);
    }

    @Deprecated
    @Transient
    public int getLocalPort() {
        return this.myLocalPort;
    }

    @Deprecated
    public void setLocalPort(int localPort) {
        this.myLocalPort = Math.max(localPort, -1);
        this.myLiteralLocalPort = String.valueOf(this.myLocalPort);
    }

    @Attribute(value="username")
    @NlsSafe
    @NotNull
    public String getUsername() {
        String string = this.myUsername;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setUsername(@Nullable String username) {
        this.myUsername = StringUtil.notNullize((String)username);
    }

    @Attribute(value="authType")
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            SshConfig.$$$reportNull$$$0(6);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.$$$reportNull$$$0(7);
        }
        this.myAuthType = authType;
    }

    @Attribute(value="keyPath")
    @NotNull
    public String getKeyPath() {
        String string = this.myKeyPath;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setKeyPath(@Nullable String keyPath) {
        this.myKeyPath = StringUtil.notNullize((String)keyPath);
    }

    @Transient
    public boolean isOpenSshConfigUsageForced() {
        if (StringUtil.isEmpty((String)this.mySerializedUseOpenSSHConfig)) {
            return !PlatformUtils.isDataGrip();
        }
        return Boolean.parseBoolean(this.mySerializedUseOpenSSHConfig);
    }

    @Transient
    public void setOpenSshConfigUsageForced(boolean useOpenSSHConfig) {
        this.mySerializedUseOpenSSHConfig = String.valueOf(useOpenSSHConfig);
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    @Nullable
    public SshConnectionConfigPatch getConnectionConfigPatch() {
        return this.myConnectionConfigPatch;
    }

    @Attribute(value="connectionConfig", converter=SshConnectionConfigPatchConverter.class)
    @Text
    public void setConnectionConfigPatch(@Nullable SshConnectionConfigPatch patch) {
        this.myConnectionConfigPatch = patch;
    }

    public void mergeKeyPath(@Nullable String keyPath) {
        if (!StringUtil.isEmpty((String)this.myKeyPath)) {
            return;
        }
        if (StringUtil.isEmpty((String)keyPath)) {
            return;
        }
        this.myKeyPath = keyPath;
    }

    @Transient
    @NotNull
    public String getName() {
        String string = this.myNameFormat.getName(this);
        if (string == null) {
            SshConfig.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Deprecated
    @Attribute(value="nameFormat")
    @NotNull
    public NameFormat getSerializedNameFormat() {
        NameFormat nameFormat = this.myNameFormat;
        if (nameFormat == null) {
            SshConfig.$$$reportNull$$$0(10);
        }
        return nameFormat;
    }

    @Deprecated
    public void setSerializedNameFormat(@Nullable NameFormat nameFormat) {
        this.myNameFormat = nameFormat == null ? NameFormat.INITIAL : nameFormat;
    }

    @Deprecated
    @Attribute(value="customName")
    @Nullable
    public String getSerializedCustomName() {
        return this.myCustomName;
    }

    @Deprecated
    public void setSerializedCustomName(@Nullable String customName) {
        this.myCustomName = StringUtil.nullize((String)customName, (boolean)true);
    }

    public void setCustomName(@Nullable String customName) {
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            this.myCustomName = null;
            if (this.myNameFormat == NameFormat.CUSTOM) {
                this.myNameFormat = NameFormat.DESCRIPTIVE;
            }
            return;
        }
        this.setNonemptyCustomName(customName);
    }

    public void mergeCustomName(@Nullable String customName) {
        if (this.myCustomName != null && this.myNameFormat == NameFormat.CUSTOM) {
            return;
        }
        if ((customName = StringUtil.nullize((String)customName, (boolean)true)) == null) {
            return;
        }
        this.setNonemptyCustomName(customName);
    }

    private void setNonemptyCustomName(@NotNull String customName) {
        if (customName == null) {
            SshConfig.$$$reportNull$$$0(11);
        }
        if (customName.equals(NameFormat.DESCRIPTIVE.getName(this))) {
            this.myCustomName = null;
            this.myNameFormat = NameFormat.DESCRIPTIVE;
        } else {
            this.myCustomName = customName;
            this.myNameFormat = NameFormat.CUSTOM;
        }
    }

    @Nullable
    public String getCustomName() {
        return this.myNameFormat == NameFormat.CUSTOM ? this.myCustomName : null;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String string = this.myNameFormat.getPresentableShortName(this);
        if (string == null) {
            SshConfig.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nls
    @Nullable
    public String getPresentableAddition() {
        return this.myNameFormat.getPresentableAddition(this);
    }

    @Nls
    @NotNull
    public String getPresentableFullName() {
        String string = this.getPresentableShortName();
        if (string == null) {
            SshConfig.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public AuthData getAuthDataFromForPasswordSafe() {
        AuthData data = new AuthData();
        switch (this.myAuthType) {
            case PASSWORD: {
                Pair<Credentials, Boolean> credentials = this.getPasswordCredentialsFromPasswordSafe();
                data.setPasswordAuth((Credentials)credentials.getFirst(), (Boolean)credentials.getSecond());
                break;
            }
            case KEY_PAIR: {
                Pair<Credentials, Boolean> credentialsFromPasswordSafe = this.getPassphraseCredentialsFromPasswordSafe();
                data.setKeyAuth((Credentials)credentialsFromPasswordSafe.getFirst(), (Boolean)credentialsFromPasswordSafe.getSecond());
                break;
            }
        }
        AuthData authData = data;
        if (authData == null) {
            SshConfig.$$$reportNull$$$0(14);
        }
        return authData;
    }

    @Nullable
    public Credentials getCredentials() {
        return switch (this.myAuthType) {
            case AuthType.PASSWORD -> (Credentials)this.getPasswordCredentialsFromPasswordSafe().getFirst();
            case AuthType.KEY_PAIR -> (Credentials)this.getPassphraseCredentialsFromPasswordSafe().getFirst();
            default -> null;
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshConfig sshConfig = (SshConfig)o;
        return this.isProjectLevel == sshConfig.isProjectLevel && this.myId.equals(sshConfig.myId) && this.myHost.equals(sshConfig.myHost) && this.myLiteralPort.equals(sshConfig.myLiteralPort) && this.myLiteralLocalPort.equals(sshConfig.myLiteralLocalPort) && this.myUsername.equals(sshConfig.myUsername) && this.myAuthType == sshConfig.myAuthType && this.myKeyPath.equals(sshConfig.myKeyPath) && this.myNameFormat == sshConfig.myNameFormat && this.mySerializedUseOpenSSHConfig.equals(sshConfig.mySerializedUseOpenSSHConfig) && Objects.equals(this.myCustomName, sshConfig.myCustomName) && Objects.equals(this.myConnectionConfigPatch, sshConfig.myConnectionConfigPatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getId(), this.isProjectLevel(), this.getHost(), this.getLiteralPort(), this.getLiteralLocalPort(), this.getAuthType(), this.getKeyPath(), this.getUsername(), this.myNameFormat, this.myCustomName, this.isOpenSshConfigUsageForced(), this.getConnectionConfigPatch()});
    }

    @NotNull
    public RemoteCredentials copyToCredentials() {
        RemoteCredentials remoteCredentials = this.copyToCredentials(this.getAuthDataFromForPasswordSafe());
        if (remoteCredentials == null) {
            SshConfig.$$$reportNull$$$0(15);
        }
        return remoteCredentials;
    }

    @NotNull
    public RemoteCredentials copyToCredentials(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.$$$reportNull$$$0(16);
        }
        RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
        holder.setHost(this.getHost());
        holder.setLiteralPort(this.getLiteralPort());
        holder.setAuthType(this.getAuthType());
        holder.setUserName(this.getUsername());
        holder.setPassword(data.getPassword());
        holder.setPassphrase(data.getPassphrase());
        holder.setStorePassword(data.isSavePassword());
        holder.setStorePassphrase(data.isSavePassphrase());
        holder.setPrivateKeyFile(this.getKeyPath());
        holder.setOpenSshConfigUsageForced(this.isOpenSshConfigUsageForced());
        holder.setConnectionConfigPatch(this.getConnectionConfigPatch());
        RemoteCredentialsHolder remoteCredentialsHolder = holder;
        if (remoteCredentialsHolder == null) {
            SshConfig.$$$reportNull$$$0(17);
        }
        return remoteCredentialsHolder;
    }

    @NotNull
    public static SshConfig create(boolean projectLevel, String host, int port, String username, AuthType authType, @Nullable String keyPath) {
        SshConfig config = new SshConfig(true);
        config.setProjectLevel(projectLevel);
        config.setHost(host);
        config.setPort(port);
        config.setUsername(username);
        config.setAuthType(authType);
        config.setKeyPath(keyPath);
        SshConfig sshConfig = config;
        if (sshConfig == null) {
            SshConfig.$$$reportNull$$$0(18);
        }
        return sshConfig;
    }

    @Deprecated
    public SshConfig() {
        this(false);
    }

    public SshConfig(boolean latestFormat) {
        this.myId = UUID.randomUUID().toString();
        this.myNameFormat = latestFormat ? NameFormat.DESCRIPTIVE : NameFormat.INITIAL;
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPasswordCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.PASSWORD);
    }

    @NotNull
    protected Pair<Credentials, Boolean> getPassphraseCredentialsFromPasswordSafe() {
        return SshConfig.getCredentialsAndMemoryOnlyStatus(this, AuthType.KEY_PAIR);
    }

    public void eraseAuthDataFromPasswordSafe() {
        for (AuthType value : AuthType.values()) {
            if (value == AuthType.OPEN_SSH) continue;
            PasswordSafe.getInstance().set(SshConfig.createAttributes(this, false, value), null, false);
        }
        this.eraseConfigPatchAuthDataFromPasswordSafe();
    }

    public void saveAuthDataToPasswordSafe(@NotNull AuthData data) {
        if (data == null) {
            SshConfig.$$$reportNull$$$0(19);
        }
        Credentials passwordCredentials = null;
        boolean passwordMemoryOnly = false;
        Credentials passphraseCredentials = null;
        boolean passphraseMemoryOnly = false;
        switch (this.getAuthType()) {
            case PASSWORD: {
                String password = data.getPassword();
                passwordMemoryOnly = !data.isSavePassword();
                passwordCredentials = password == null ? null : new Credentials(null, password);
                break;
            }
            case KEY_PAIR: {
                String passphrase = data.getPassphrase();
                passphraseMemoryOnly = !data.isSavePassphrase();
                passphraseCredentials = passphrase == null ? null : new Credentials(null, passphrase);
                break;
            }
            default: {
                return;
            }
        }
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, passwordMemoryOnly, AuthType.PASSWORD), passwordCredentials, passwordMemoryOnly);
        PasswordSafe.getInstance().set(SshConfig.createAttributes(this, passphraseMemoryOnly, AuthType.KEY_PAIR), passphraseCredentials, passphraseMemoryOnly);
        this.saveConfigPatchCredentialsToPasswordSafe(this.myConnectionConfigPatch);
    }

    public void setConnectionConfigPatchAuthData() {
        Credentials proxyCredentials;
        if (this.myConnectionConfigPatch != null && this.myConnectionConfigPatch.getProxyParams() != null && (proxyCredentials = this.getConfigPatchAuthDataCredentialsFromPasswordSafe(this.myConnectionConfigPatch.getProxyParams())) != null) {
            this.setConfigPatchAuthData(this.myConnectionConfigPatch.getProxyParams(), proxyCredentials);
        }
    }

    private CredentialAttributes createConnectionConfigPatchAttributes(SshConnectionConfigPatch.ProxyParams proxyParams) {
        String serviceName = CredentialAttributesKt.generateServiceName((String)"SshProxyServerPassword", (String)(SshConfig.makeNotEmpty(proxyParams.getProxyHost(), "<host>") + ":" + SshConfig.makeNotEmpty(String.valueOf(proxyParams.getProxyPort()), "<port>") + " " + this.getId()));
        return new CredentialAttributes(serviceName, null, false);
    }

    private void saveConfigPatchAuthDataToPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData authData = proxyParams.getAuthData();
        if (authData != null) {
            PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(proxyParams), new Credentials(authData.getUsername(), authData.getPassword()));
        }
    }

    private void eraseConfigPatchAuthDataFromPasswordSafe() {
        if (this.myConnectionConfigPatch != null && this.myConnectionConfigPatch.getProxyParams() != null) {
            PasswordSafe.getInstance().set(this.createConnectionConfigPatchAttributes(this.myConnectionConfigPatch.getProxyParams()), null);
        }
    }

    private Credentials getConfigPatchAuthDataCredentialsFromPasswordSafe(SshConnectionConfigPatch.ProxyParams proxyParams) {
        return PasswordSafe.getInstance().get(this.createConnectionConfigPatchAttributes(proxyParams));
    }

    private void setConfigPatchAuthData(SshConnectionConfigPatch.ProxyParams proxyParams, Credentials proxyCredentials) {
        SshConnectionConfigPatch.ProxyParams.ProxyAuthData authData = proxyParams.getAuthData();
        if (authData != null) {
            String username = proxyCredentials.getUserName();
            String password = proxyCredentials.getPasswordAsString();
            if (username != null && !password.isEmpty()) {
                authData.setUsername(username);
                authData.setPassword(password);
            } else {
                proxyParams.setAuthData(null);
            }
        }
    }

    public void saveConfigPatchCredentialsToPasswordSafe(SshConnectionConfigPatch patch) {
        if (patch != null && patch.getProxyParams() != null) {
            SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = patch.getProxyParams().getAuthData();
            if (proxyAuthData != null) {
                this.saveConfigPatchAuthDataToPasswordSafe(patch.getProxyParams());
            } else {
                this.eraseConfigPatchAuthDataFromPasswordSafe();
            }
        }
    }

    @NotNull
    public PresentableId createPresentableId() {
        PresentableId presentableId = Objects.requireNonNull(PresentableId.createId((String)this.getId(), (String)this.getName()));
        if (presentableId == null) {
            SshConfig.$$$reportNull$$$0(20);
        }
        return presentableId;
    }

    public SshConfigVisibility getVisibility() {
        return this.isProjectLevel ? SshConfigVisibility.Project : SshConfigVisibility.App;
    }

    public SshConfig clone() {
        SshConfig result;
        try {
            result = (SshConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public String toString() {
        return "SshConfig{myId='" + this.myId + "', isProjectLevel=" + this.isProjectLevel + ", myHost='" + this.myHost + "', myLiteralPort='" + this.myLiteralPort + "', myPort=" + this.myPort + ", myLiteralLocalPort='" + this.myLiteralLocalPort + "', myLocalPort=" + this.myLocalPort + ", myUsername='" + this.myUsername + "', myAuthType=" + this.myAuthType + ", myKeyPath='" + this.myKeyPath + "', myNameFormat=" + this.myNameFormat + ", mySerializedUseOpenSSHConfig=" + this.mySerializedUseOpenSSHConfig + ", myConnectionConfigPatch=" + this.myConnectionConfigPatch + "}";
    }

    @NotNull
    private static Pair<Credentials, Boolean> getCredentialsAndMemoryOnlyStatus(SshConfig server, @NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.$$$reportNull$$$0(21);
        }
        if (authType == AuthType.OPEN_SSH) {
            throw new IllegalStateException("Unexpected AuthType " + authType);
        }
        CredentialAttributes attributes = SshConfig.createAttributes(server, false, authType);
        Credentials credentials = PasswordSafe.getInstance().get(attributes);
        boolean memoryOnly = credentials == null ? true : PasswordSafe.getInstance().isPasswordStoredOnlyInMemory(attributes, credentials);
        return new Pair((Object)credentials, (Object)memoryOnly);
    }

    private static CredentialAttributes createAttributes(SshConfig config, Boolean isPasswordMemoryOnly, @NotNull AuthType authType) {
        if (authType == null) {
            SshConfig.$$$reportNull$$$0(22);
        }
        String type = switch (authType) {
            case AuthType.PASSWORD -> "Password";
            case AuthType.KEY_PAIR -> "Passphrase";
            default -> throw new IllegalStateException("Unexpected AuthType " + authType);
        };
        String serviceName = CredentialAttributesKt.generateServiceName((String)("SshConfig" + type), (String)(SshConfig.makeNotEmpty(config.getHost(), "<host>") + ":" + SshConfig.makeNotEmpty(config.getLiteralPort(), "<port>") + " " + config.getId()));
        return new CredentialAttributes(serviceName, null, isPasswordMemoryOnly.booleanValue());
    }

    @NotNull
    private static String makeNotEmpty(@Nullable String value, @NotNull String defaultValue) {
        if (defaultValue == null) {
            SshConfig.$$$reportNull$$$0(23);
        }
        String string = StringUtil.isEmpty((String)value) ? defaultValue : value;
        if (string == null) {
            SshConfig.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static void parseContent(@NotNull String name, @NotNull SshConfig config) {
        Pair<String, String> pair;
        if (name == null) {
            SshConfig.$$$reportNull$$$0(25);
        }
        if (config == null) {
            SshConfig.$$$reportNull$$$0(26);
        }
        if ((pair = SshConfig.cutPiece(name, '@', "<username>")) == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setUsername((String)pair.getSecond());
        pair = SshConfig.cutPiece(name, ':', "<host>");
        if (pair == null) {
            return;
        }
        name = (String)pair.getFirst();
        config.setHost((String)pair.getSecond());
        boolean foundPort = false;
        Pair<String, String> pair2 = SshConfig.cutPiece(name, ':', "<port>");
        if (pair2 != null) {
            foundPort = true;
            name = (String)pair2.getFirst();
            config.setLiteralPort((String)pair2.getSecond());
        }
        if ((pair2 = SshConfig.cutPiece(name, ' ', "<port>")) == null) {
            return;
        }
        name = (String)pair2.getFirst();
        if (foundPort) {
            config.setLiteralLocalPort((String)pair2.getSecond());
        } else {
            config.setLiteralPort((String)pair2.getSecond());
            config.setLiteralLocalPort("");
        }
        if ("(p)".equals(name) || "password".equals(name)) {
            config.setAuthType(AuthType.PASSWORD);
        } else if ("(k)".equals(name) || "key".equals(name)) {
            config.setAuthType(AuthType.KEY_PAIR);
        } else if ("(o)".equals(name) || "agent".equals(name)) {
            config.setAuthType(AuthType.OPEN_SSH);
        }
    }

    @Nullable
    private static @Nullable Pair<@NotNull String, @Nullable String> cutPiece(@NotNull String text, char separator, @Nullable String defaultValue) {
        int indexOfSeparator;
        if (text == null) {
            SshConfig.$$$reportNull$$$0(27);
        }
        if ((indexOfSeparator = text.indexOf(separator)) < 0) {
            return null;
        }
        String value = text.substring(0, indexOfSeparator);
        if (defaultValue != null && defaultValue.equals(value)) {
            value = null;
        }
        return new Pair((Object)text.substring(indexOfSeparator + 1), (Object)value);
    }

    public static int parseSshPort(@Nullable String port) {
        return Math.max(StringUtil.parseInt((String)port, (int)-1), -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 7, 11, 16, 19, 21, 22, 23, 25, 26, 27 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customName";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 16: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPort";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralLocalPort";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsername";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedNameFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableShortName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFullName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthDataFromForPasswordSafe";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToCredentials";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentableId";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNotEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setId";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setNonemptyCustomName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyToCredentials";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveAuthDataToPasswordSafe";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCredentialsAndMemoryOnlyStatus";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "makeNotEmpty";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "cutPiece";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 7, 11, 16, 19, 21, 22, 23, 25, 26, 27 -> new IllegalArgumentException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NameFormat {
        INITIAL{

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    1.$$$reportNull$$$0(0);
                }
                @NonNls String auth = switch (config.getAuthType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case AuthType.PASSWORD -> "p";
                    case AuthType.KEY_PAIR -> "k";
                    case AuthType.OPEN_SSH -> "o";
                };
                String string = NameFormat.getBasicDescription(config) + " (" + auth + ")";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = DESCRIPTIVE.getPresentableShortName(config);
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    1.$$$reportNull$$$0(4);
                }
                String string = DESCRIPTIVE.getPresentableAddition(config);
                if (string == null) {
                    1.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableAddition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        }
        ,
        DESCRIPTIVE{

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    2.$$$reportNull$$$0(0);
                }
                @NonNls String auth = switch (config.getAuthType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case AuthType.PASSWORD -> "password";
                    case AuthType.KEY_PAIR -> "key";
                    case AuthType.OPEN_SSH -> "agent";
                };
                String string = NameFormat.getBasicDescription(config) + " " + auth;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    2.$$$reportNull$$$0(2);
                }
                @Nullable String username = config.getUsername();
                @Nullable String host = config.getHost();
                @Nullable String port = config.getLiteralPort();
                String string = (String)(StringUtil.isEmpty((String)username) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.username", new Object[0]) + ">" : username) + "@" + (String)(StringUtil.isEmpty((String)host) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.host", new Object[0]) + ">" : host) + ":" + (String)(StringUtil.isEmpty((String)port) ? "<" + SshApiBundle.message("ssh.config.name.presentation.placeholder.port", new Object[0]) + ">" : port) + (String)(config.getLocalPort() == -1 ? "" : ":" + config.getLocalPort());
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    2.$$$reportNull$$$0(4);
                }
                String string = switch (config.getAuthType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case AuthType.PASSWORD -> SshApiBundle.message("ssh.config.name.presentation.auth.password", new Object[0]);
                    case AuthType.KEY_PAIR -> SshApiBundle.message("ssh.config.name.presentation.auth.key", new Object[0]);
                    case AuthType.OPEN_SSH -> SshApiBundle.message("ssh.config.name.presentation.auth.openssh.agent", new Object[0]);
                };
                if (string == null) {
                    2.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableAddition";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }
        }
        ,
        CUSTOM{

            @Override
            @NonNls
            @NotNull
            public String getName(@NotNull SshConfig config) {
                if (config == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (config.myCustomName != null) {
                    String string = config.myCustomName;
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = DESCRIPTIVE.getName(config);
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            @Nls
            @NotNull
            public String getPresentableShortName(@NotNull SshConfig config) {
                if (config == null) {
                    3.$$$reportNull$$$0(3);
                }
                if (config.myCustomName != null) {
                    String string = config.myCustomName;
                    if (string == null) {
                        3.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = DESCRIPTIVE.getPresentableShortName(config);
                if (string == null) {
                    3.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Override
            @Nls
            @Nullable
            public String getPresentableAddition(@NotNull SshConfig config) {
                if (config == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (config.myCustomName != null) {
                    return null;
                }
                return DESCRIPTIVE.getPresentableAddition(config);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableShortName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableShortName";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getPresentableAddition";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 4, 5 -> new IllegalStateException(string);
                };
            }
        };


        @NonNls
        @NotNull
        public abstract String getName(@NotNull SshConfig var1);

        @Nls
        @NotNull
        public abstract String getPresentableShortName(@NotNull SshConfig var1);

        @Nls
        @Nullable
        public abstract String getPresentableAddition(@NotNull SshConfig var1);

        @NotNull
        private static String getBasicDescription(@NotNull SshConfig config) {
            if (config == null) {
                NameFormat.$$$reportNull$$$0(0);
            }
            String string = SshConfig.makeNotEmpty(config.getUsername(), "<username>") + "@" + SshConfig.makeNotEmpty(config.getHost(), "<host>") + ":" + SshConfig.makeNotEmpty(config.getLiteralPort(), "<port>") + (String)(config.getLocalPort() == -1 ? "" : ":" + config.getLocalPort());
            if (string == null) {
                NameFormat.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$NameFormat";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBasicDescription";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class AuthData
    implements Cloneable {
        private String myPassword;
        private boolean mySavePassword;
        private String myPassphrase;
        private boolean mySavePassphrase;

        @Contract(value="!null, null->fail")
        public void setPasswordAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.clean();
            if (credentials != null) {
                this.setPassword(credentials.getPasswordAsString());
                this.setSavePassword(memoryOnly == false);
            }
        }

        @Contract(value="!null, null->fail")
        public void setKeyAuth(@Nullable Credentials credentials, Boolean memoryOnly) {
            this.clean();
            if (credentials != null) {
                this.setPassphrase(credentials.getPasswordAsString());
                this.setSavePassphrase(memoryOnly == false);
            }
        }

        private void clean() {
            this.myPassword = null;
            this.mySavePassword = false;
            this.myPassphrase = null;
            this.mySavePassphrase = false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthData data = (AuthData)o;
            return this.mySavePassword == data.mySavePassword && this.mySavePassphrase == data.mySavePassphrase && Objects.equals(this.myPassword, data.myPassword) && Objects.equals(this.myPassphrase, data.myPassphrase);
        }

        public int hashCode() {
            return Objects.hash(this.getPassword(), this.isSavePassword(), this.getPassphrase(), this.isSavePassphrase());
        }

        public String getPassword() {
            return this.myPassword;
        }

        public void setPassword(String password) {
            this.myPassword = password;
        }

        public boolean isSavePassword() {
            return this.mySavePassword;
        }

        public void setSavePassword(boolean savePassword) {
            this.mySavePassword = savePassword;
        }

        public String getPassphrase() {
            return this.myPassphrase;
        }

        public void setPassphrase(String passphrase) {
            this.myPassphrase = passphrase;
        }

        public boolean isSavePassphrase() {
            return this.mySavePassphrase;
        }

        public void setSavePassphrase(boolean savePassphrase) {
            this.mySavePassphrase = savePassphrase;
        }

        public AuthData clone() {
            try {
                return (AuthData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean hasNoCredentials(@NotNull AuthType authType, @NotNull String keyPath) {
            if (authType == null) {
                AuthData.$$$reportNull$$$0(0);
            }
            if (keyPath == null) {
                AuthData.$$$reportNull$$$0(1);
            }
            return switch (authType) {
                default -> throw new IncompatibleClassChangeError();
                case AuthType.OPEN_SSH -> false;
                case AuthType.PASSWORD -> {
                    if (this.myPassword == null) {
                        yield true;
                    }
                    yield false;
                }
                case AuthType.KEY_PAIR -> keyPath.isEmpty() || this.myPassphrase == null && SshConfigManager.getInstance(null).isPassphraseMayBeRequired(keyPath);
            };
        }

        @NotNull
        public static AuthData create(@Nullable String password, @Nullable String passphrase, boolean savePassword, boolean savePassphrase) {
            AuthData data = new AuthData();
            data.setPassword(password);
            data.setSavePassword(savePassword);
            data.setPassphrase(passphrase);
            data.setSavePassphrase(savePassphrase);
            AuthData authData = data;
            if (authData == null) {
                AuthData.$$$reportNull$$$0(2);
            }
            return authData;
        }

        @NotNull
        public static AuthData create(@NotNull RemoteCredentials credentials) {
            if (credentials == null) {
                AuthData.$$$reportNull$$$0(3);
            }
            return AuthData.create(credentials.getPassword(), credentials.getPassphrase(), credentials.isStorePassword(), credentials.isStorePassphrase());
        }

        @NotNull
        public static AuthData create(@NotNull AuthType authType, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
            if (authType == null) {
                AuthData.$$$reportNull$$$0(4);
            }
            AuthData data = new AuthData();
            AuthData authData = switch (authType) {
                default -> throw new IncompatibleClassChangeError();
                case AuthType.OPEN_SSH -> data;
                case AuthType.PASSWORD -> {
                    data.setPassword(credentials == null ? null : credentials.getPasswordAsString());
                    data.setSavePassword(saveCredentialsInPermanentStore);
                    yield data;
                }
                case AuthType.KEY_PAIR -> {
                    data.setPassphrase(credentials == null ? null : credentials.getPasswordAsString());
                    data.setSavePassphrase(saveCredentialsInPermanentStore);
                    yield data;
                }
            };
            if (authData == null) {
                AuthData.$$$reportNull$$$0(5);
            }
            return authData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "authType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyPath";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "credentials";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/config/unified/SshConfig$AuthData";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNoCredentials";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

