/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcs.log.impl.VcsFileStatusInfoKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.FileRename;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitFileHistoryKt;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogHistoryHandler;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 -2\u00020\u0001:\u0001-B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0016\"\u00020\nH\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018JK\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u00132\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0016\"\u00020\nH\u0000\u00a2\u0006\u0004\b\u0017\u0010\u001bJ\u0012\u0010\u001c\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000fH\u0001\u00a2\u0006\u0002\b\u001dJT\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J#\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\t2\u000b\u0010'\u001a\u00070\n\u00a2\u0006\u0002\b(2\u0006\u0010)\u001a\u00020\u0007H\u0002J,\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lgit4idea/history/GitFileHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "startingRevisions", "", "", "fullHistory", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Ljava/util/List;Z)V", "Lorg/jetbrains/annotations/NotNull;", "load", "", "consumer", "Lkotlin/Function1;", "Lgit4idea/GitFileRevision;", "parameters", "", "load$intellij_vcs_git", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "renameConsumer", "Lgit4idea/history/FileRename;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "getFilePath", "getFilePath$intellij_vcs_git", "runGitLog", "logParser", "Lgit4idea/history/GitLogParser;", "Lgit4idea/history/GitLogFullRecord;", "startPath", "visitedCommits", "", "getParentsAndPathsIfRename", "Lgit4idea/history/GitFileHistory$Companion$FileHistoryStart;", "commit", "Lorg/jetbrains/annotations/NonNls;", "filePath", "createLogHandler", "Lgit4idea/commands/GitLineHandler;", "parser", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitFileHistory.kt\ngit4idea/history/GitFileHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n774#2:285\n865#2,2:286\n1863#2:288\n1863#2,2:289\n1864#2:291\n1557#2:292\n1628#2,3:293\n295#2,2:296\n*S KotlinDebug\n*F\n+ 1 GitFileHistory.kt\ngit4idea/history/GitFileHistory\n*L\n83#1:285\n83#1:286,2\n83#1:288\n84#1:289,2\n83#1:291\n153#1:292\n153#1:293,3\n144#1:296,2\n*E\n"})
public final class GitFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final List<String> startingRevisions;
    private final boolean fullHistory;
    @NotNull
    private final FilePath path;

    public GitFileHistory(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @NotNull List<String> startingRevisions, boolean fullHistory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(startingRevisions, (String)"startingRevisions");
        this.project = project;
        this.root = root;
        this.startingRevisions = startingRevisions;
        this.fullHistory = fullHistory;
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        this.path = filePath;
    }

    public /* synthetic */ GitFileHistory(Project project, VirtualFile virtualFile, FilePath filePath, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(project, virtualFile, filePath, list, bl);
    }

    public final void load$intellij_vcs_git(@NotNull Function1<? super GitFileRevision, Unit> consumer, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.load$intellij_vcs_git(consumer, (Function1<? super FileRename, Unit>)((Function1)GitFileHistory::load$lambda$0), Arrays.copyOf(parameters, parameters.length));
    }

    /*
     * WARNING - void declaration
     */
    public final void load$intellij_vcs_git(@NotNull Function1<? super GitFileRevision, Unit> consumer, @NotNull Function1<? super FileRename, Unit> renameConsumer, String ... parameters) throws VcsException {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter(renameConsumer, (String)"renameConsumer");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        GitLogParser<GitLogFullRecord> logParser = Companion.createLogParser$intellij_vcs_git(this.project);
        Set visitedCommits = new LinkedHashSet();
        Object[] objectArray = new Companion.FileHistoryStart[]{new Companion.FileHistoryStart(this.startingRevisions, this.path)};
        LinkedList linkedList = ContainerUtil.newLinkedList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)linkedList, (String)"newLinkedList(...)");
        LinkedList starts = linkedList;
        while (!((Collection)starts).isEmpty()) {
            Companion.FileHistoryStart fileHistoryStart = (Companion.FileHistoryStart)starts.removeFirst();
            List<String> startRevisions = fileHistoryStart.component1();
            FilePath startPath = fileHistoryStart.component2();
            List<String> lastCommits = this.runGitLog(logParser, startPath, visitedCommits, consumer, CollectionsKt.plus((Collection)startRevisions, (Iterable)ArraysKt.toList((Object[])parameters)));
            if (lastCommits.isEmpty()) continue;
            for (String lastCommit : lastCommits) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                List<Companion.FileHistoryStart> parents = this.getParentsAndPathsIfRename(lastCommit, startPath);
                Iterable $this$filter$iv = parents;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Companion.FileHistoryStart it = (Companion.FileHistoryStart)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getPath(), (Object)startPath))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Companion.FileHistoryStart it = (Companion.FileHistoryStart)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = it.getRevisions();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String prevRevision = (String)element$iv2;
                        boolean bl2 = false;
                        renameConsumer.invoke((Object)new FileRename(prevRevision, lastCommit, it.getPath(), startPath));
                    }
                }
                starts.addAll((Collection)parents);
            }
        }
    }

    @TestOnly
    @NotNull
    public final FilePath getFilePath$intellij_vcs_git() {
        return this.path;
    }

    private final List<String> runGitLog(GitLogParser<GitLogFullRecord> logParser, FilePath startPath, Set<String> visitedCommits, Function1<? super GitFileRevision, Unit> consumer, List<String> parameters) throws VcsException {
        GitLineHandler handler = this.createLogHandler(logParser, startPath, parameters);
        Ref.BooleanRef skipFurtherOutput = new Ref.BooleanRef();
        List lastCommits = new ArrayList();
        GitLogOutputSplitter<Object> splitter = new GitLogOutputSplitter<Object>(handler, logParser, arg_0 -> GitFileHistory.runGitLog$lambda$5(arg_0 -> GitFileHistory.runGitLog$lambda$4(skipFurtherOutput, visitedCommits, this, lastCommits, startPath, consumer, arg_0), arg_0));
        Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
        splitter.reportErrors();
        return lastCommits;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Companion.FileHistoryStart> getParentsAndPathsIfRename(String commit, FilePath filePath) throws VcsException {
        void $this$mapTo$iv$iv;
        Iterable rename;
        GitCommitRequirements requirements = new GitCommitRequirements(false, GitCommitRequirements.DiffRenames.Limit.Default.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS, 1, null);
        GitLineHandler h = new GitLineHandler(this.project, this.root, GitCommand.SHOW, requirements.configParameters());
        GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.PARENTS};
        GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(this.project, GitLogParser.NameStatus.STATUS, gitLogOptionArray);
        Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"createDefaultParser(...)");
        GitLogParser<GitLogFullRecord> parser = gitLogParser;
        h.setStdoutSuppressed(true);
        GitExecutable gitExecutable = h.getExecutable();
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        h.addParameters(requirements.commandParameters(this.project, gitExecutable));
        String[] stringArray = new String[]{"--follow", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit};
        h.addParameters(stringArray);
        h.endOptions();
        stringArray = new FilePath[]{filePath};
        h.addRelativePaths((FilePath[])stringArray);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        String output = string;
        List<GitLogFullRecord> list = parser.parse(output);
        Intrinsics.checkNotNullExpressionValue(list, (String)"parse(...)");
        List<GitLogFullRecord> records = list;
        if (records.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = ((GitLogFullRecord)CollectionsKt.first(records)).getParentsHashes();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParentsHashes(...)");
        Object[] parentsHashes = objectArray;
        List renames = CollectionsKt.toMutableList((Collection)GitFileHistoryKt.access$mapNotNullValues(ArraysKt.zip((Object[])parentsHashes, (Iterable)records), GitFileHistory::getParentsAndPathsIfRename$lambda$6));
        if (records.size() < parentsHashes.length && this.fullHistory) {
            for (String parent : ArraysKt.drop((Object[])parentsHashes, (int)records.size())) {
                Intrinsics.checkNotNull((Object)parent);
                if (GitLogHistoryHandler.Companion.getRename$intellij_vcs_git(this.project, this.root, parent, commit, filePath) == null) continue;
                renames.add(new Pair((Object)parent, (Object)rename));
            }
        }
        Iterable $this$map$iv = renames;
        boolean $i$f$map = false;
        rename = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String parent = (String)pair.component1();
            VcsFileStatusInfo status = (VcsFileStatusInfo)pair.component2();
            Intrinsics.checkNotNull((Object)parent);
            FilePath filePath2 = GitContentRevision.createPath(this.root, status.getFirstPath());
            Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"createPath(...)");
            collection.add(new Companion.FileHistoryStart(parent, filePath2));
        }
        return (List)destination$iv$iv;
    }

    private final GitLineHandler createLogHandler(GitLogParser<GitLogFullRecord> parser, FilePath path, List<String> parameters) {
        GitLineHandler h = new GitLineHandler(this.project, this.root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"--name-status", parser.getPretty(), "--encoding=UTF-8"};
        h.addParameters(stringArray);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.project) && Registry.Companion.is("git.file.history.full")) {
            stringArray = new String[]{"--full-history", "--simplify-merges"};
            h.addParameters(stringArray);
        }
        h.addParameters(parameters);
        h.endOptions();
        stringArray = new FilePath[]{path};
        h.addRelativePaths((FilePath[])stringArray);
        return h;
    }

    private static final Unit load$lambda$0(FileRename it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit runGitLog$lambda$4(Ref.BooleanRef $skipFurtherOutput, Set $visitedCommits, GitFileHistory this$0, List $lastCommits, FilePath $startPath, Function1 $consumer, GitLogFullRecord record) {
        if ($skipFurtherOutput.element || $visitedCommits.contains(record.getHash())) {
            return Unit.INSTANCE;
        }
        String string = record.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
        $visitedCommits.add(string);
        List<VcsFileStatusInfo> list = record.getStatusInfos();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatusInfos(...)");
        VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list);
        if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.NEW && !this$0.path.isDirectory()) {
            String string2 = record.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHash(...)");
            $lastCommits.add(string2);
            if (!this$0.fullHistory) {
                $skipFurtherOutput.element = true;
            }
        }
        Project project = this$0.project;
        VirtualFile virtualFile = this$0.root;
        Intrinsics.checkNotNull((Object)record);
        GitFileRevision revision = Companion.createGitFileRevision$intellij_vcs_git(project, virtualFile, record, $startPath);
        $consumer.invoke((Object)revision);
        return Unit.INSTANCE;
    }

    private static final void runGitLog$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final VcsFileStatusInfo getParentsAndPathsIfRename$lambda$6(GitLogFullRecord record) {
        Object v1;
        block1: {
            List<VcsFileStatusInfo> list = record.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatusInfos(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VcsFileStatusInfo p0 = (VcsFileStatusInfo)element$iv;
                boolean bl = false;
                boolean $i$f$getParentsAndPathsIfRename$lambda$6$stub_for_inlining = false;
                if (!VcsFileStatusInfoKt.isRenamed((VcsFileStatusInfo)p0)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @JvmStatic
    public static final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer, @NotNull Consumer<? super VcsException> exceptionConsumer, @NotNull Consumer<FileRename> renameConsumer, String ... parameters) {
        Companion.loadHistory(project, path, startingFrom, consumer, exceptionConsumer, renameConsumer, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        return Companion.collectHistoryForRevision(project, path, startingFrom, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return Companion.collectHistory(project, path, parameters);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011Jc\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00130\u00182\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00130\u00182\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJk\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\u001f2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020!0\u001f2\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010\"J?\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010&J7\u0010'\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0007\u00a2\u0006\u0002\u0010(\u00a8\u0006*"}, d2={"Lgit4idea/history/GitFileHistory$Companion;", "", "<init>", "()V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Lgit4idea/history/GitLogFullRecord;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createGitFileRevision", "Lgit4idea/GitFileRevision;", "project", "Lcom/intellij/openapi/project/Project;", "record", "createGitFileRevision$intellij_vcs_git", "createLogParser", "Lgit4idea/history/GitLogParser;", "createLogParser$intellij_vcs_git", "loadHistory", "", "path", "startingFrom", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "consumer", "Lkotlin/Function1;", "renameConsumer", "Lgit4idea/history/FileRename;", "parameters", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "Ljava/util/function/Consumer;", "exceptionConsumer", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/util/function/Consumer;[Ljava/lang/String;)V", "collectHistoryForRevision", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;[Ljava/lang/String;)Ljava/util/List;", "collectHistory", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;[Ljava/lang/String;)Ljava/util/List;", "FileHistoryStart", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final FilePath filePath(GitLogFullRecord $this$filePath, VirtualFile root) {
            List<VcsFileStatusInfo> list = $this$filePath.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatusInfos(...)");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list);
            if (vcsFileStatusInfo == null) {
                return null;
            }
            VcsFileStatusInfo statusInfo = vcsFileStatusInfo;
            String string = root.getPath();
            String string2 = statusInfo.getSecondPath();
            if (string2 == null) {
                string2 = statusInfo.getFirstPath();
            }
            return VcsUtil.getFilePath((String)(string + "/" + string2), (boolean)false);
        }

        @NotNull
        public final GitFileRevision createGitFileRevision$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogFullRecord record, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            Couple couple = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
            Couple authorPair = couple;
            Couple couple2 = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple2, (String)"of(...)");
            Couple committerPair = couple2;
            String[] stringArray = record.getParentsHashes();
            List parents = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
            FilePath filePath2 = this.filePath(record, root);
            if (filePath2 == null) {
                filePath2 = filePath;
            }
            FilePath revisionPath = filePath2;
            List<VcsFileStatusInfo> list = record.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatusInfos(...)");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list);
            boolean deleted = (vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.DELETED;
            return new GitFileRevision(project, root, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
        }

        @NotNull
        public final GitLogParser<GitLogFullRecord> createLogParser$intellij_vcs_git(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME};
            GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(project, GitLogParser.NameStatus.STATUS, gitLogOptionArray);
            Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"createDefaultParser(...)");
            return gitLogParser;
        }

        public final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Function1<? super GitFileRevision, Unit> consumer, @NotNull Function1<? super FileRename, Unit> renameConsumer, String ... parameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter(renameConsumer, (String)"renameConsumer");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            VirtualFile virtualFile = GitUtil.getRootForFile(project, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRootForFile(...)");
            VirtualFile detectedRoot = virtualFile;
            VirtualFile virtualFile2 = GitLogProvider.getCorrectedVcsRoot(GitRepositoryManager.getInstance(project), detectedRoot, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getCorrectedVcsRoot(...)");
            VirtualFile repositoryRoot = virtualFile2;
            Object object = startingFrom;
            if (object == null || (object = object.asString()) == null) {
                object = "HEAD";
            }
            Object revision = object;
            new GitFileHistory(project, repositoryRoot, path, CollectionsKt.listOf((Object)revision), false, 16, null).load$intellij_vcs_git(consumer, renameConsumer, Arrays.copyOf(parameters, parameters.length));
        }

        public static /* synthetic */ void loadHistory$default(Companion companion, Project project, FilePath filePath, VcsRevisionNumber vcsRevisionNumber, Function1 function1, Function1 function12, String[] stringArray, int n, Object object) {
            if ((n & 0x10) != 0) {
                function12 = Companion::loadHistory$lambda$0;
            }
            companion.loadHistory(project, filePath, vcsRevisionNumber, (Function1<? super GitFileRevision, Unit>)function1, (Function1<? super FileRename, Unit>)function12, stringArray);
        }

        @JvmStatic
        public final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer, @NotNull Consumer<? super VcsException> exceptionConsumer, @NotNull Consumer<FileRename> renameConsumer, String ... parameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter(exceptionConsumer, (String)"exceptionConsumer");
            Intrinsics.checkNotNullParameter(renameConsumer, (String)"renameConsumer");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            try {
                this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<GitFileRevision, Unit>(consumer){

                    public final void invoke(GitFileRevision p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Consumer)this.receiver).accept(p0);
                    }
                }), (Function1<? super FileRename, Unit>)((Function1)new Function1<FileRename, Unit>(renameConsumer){

                    public final void invoke(FileRename p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Consumer)this.receiver).accept(p0);
                    }
                }), Arrays.copyOf(parameters, parameters.length));
            }
            catch (VcsException e) {
                exceptionConsumer.accept(e);
            }
        }

        public static /* synthetic */ void loadHistory$default(Companion companion, Project project, FilePath filePath, VcsRevisionNumber vcsRevisionNumber, Consumer consumer, Consumer consumer2, Consumer consumer3, String[] stringArray, int n, Object object) {
            if ((n & 0x20) != 0) {
                consumer3 = Companion::loadHistory$lambda$1;
            }
            companion.loadHistory(project, filePath, vcsRevisionNumber, consumer, consumer2, consumer3, stringArray);
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)startingFrom, (String)"startingFrom");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            List revisions = new ArrayList();
            this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<VcsFileRevision, Unit>((Object)revisions){

                public final void invoke(VcsFileRevision p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }), (Function1<? super FileRename, Unit>)((Function1)Companion::collectHistoryForRevision$lambda$2), Arrays.copyOf(parameters, parameters.length));
            return revisions;
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.HEAD;
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"HEAD");
            return this.collectHistoryForRevision(project, path, (VcsRevisionNumber)gitRevisionNumber, Arrays.copyOf(parameters, parameters.length));
        }

        private static final Unit loadHistory$lambda$0(FileRename it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final void loadHistory$lambda$1(FileRename it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        }

        private static final Unit collectHistoryForRevision$lambda$2(FileRename it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lgit4idea/history/GitFileHistory$Companion$FileHistoryStart;", "", "revisions", "", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/vcs/FilePath;)V", "revision", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;)V", "getRevisions", "()Ljava/util/List;", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
        private static final class FileHistoryStart {
            @NotNull
            private final List<String> revisions;
            @NotNull
            private final FilePath path;

            public FileHistoryStart(@NotNull List<String> revisions, @NotNull FilePath path) {
                Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this.revisions = revisions;
                this.path = path;
            }

            @NotNull
            public final List<String> getRevisions() {
                return this.revisions;
            }

            @NotNull
            public final FilePath getPath() {
                return this.path;
            }

            public FileHistoryStart(@NotNull String revision, @NotNull FilePath path) {
                Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                this(CollectionsKt.listOf((Object)revision), path);
            }

            @NotNull
            public final List<String> component1() {
                return this.revisions;
            }

            @NotNull
            public final FilePath component2() {
                return this.path;
            }

            @NotNull
            public final FileHistoryStart copy(@NotNull List<String> revisions, @NotNull FilePath path) {
                Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return new FileHistoryStart(revisions, path);
            }

            public static /* synthetic */ FileHistoryStart copy$default(FileHistoryStart fileHistoryStart, List list, FilePath filePath, int n, Object object) {
                if ((n & 1) != 0) {
                    list = fileHistoryStart.revisions;
                }
                if ((n & 2) != 0) {
                    filePath = fileHistoryStart.path;
                }
                return fileHistoryStart.copy(list, filePath);
            }

            @NotNull
            public String toString() {
                return "FileHistoryStart(revisions=" + this.revisions + ", path=" + this.path + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.revisions).hashCode();
                result2 = result2 * 31 + this.path.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FileHistoryStart)) {
                    return false;
                }
                FileHistoryStart fileHistoryStart = (FileHistoryStart)other;
                if (!Intrinsics.areEqual(this.revisions, fileHistoryStart.revisions)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.path, (Object)fileHistoryStart.path);
            }
        }
    }
}

