/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.Prefs;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.PathManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/llmInstaller/Agreement;", "", "<init>", "()V", "AGREEMENT_DOC", "", "AGREEMENT_DOC_CN", "AI_RELATIVE_RESOURCE_PATH", "getDocumentName", "getAiDocumentContentFile", "Ljava/nio/file/Path;", "docName", "isAiPrivacyPolicyAccepted", "", "getAcceptedAiPrivacyPolicyVersion", "Lcom/intellij/ide/gdpr/Version;", "isChinaAgreementDocName", "getAcceptedVersionKey", "dropAiAgreement", "", "intellij.llmInstaller"})
@ApiStatus.Internal
public final class Agreement {
    @NotNull
    public static final Agreement INSTANCE = new Agreement();
    @NotNull
    private static final String AGREEMENT_DOC = "aiEua";
    @NotNull
    private static final String AGREEMENT_DOC_CN = "aiEua_cn";
    @NotNull
    private static final String AI_RELATIVE_RESOURCE_PATH = "PrivacyPolicy";

    private Agreement() {
    }

    @NotNull
    public final String getDocumentName() {
        return RegionSettings.getRegion() == Region.CHINA ? AGREEMENT_DOC_CN : AGREEMENT_DOC;
    }

    @NotNull
    public final Path getAiDocumentContentFile(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        Path path = PathManager.getCommonDataPath().resolve(AI_RELATIVE_RESOURCE_PATH).resolve(docName + ".cached");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public final boolean isAiPrivacyPolicyAccepted(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        return !this.getAcceptedAiPrivacyPolicyVersion(docName).isUnknown();
    }

    @NotNull
    public final Version getAcceptedAiPrivacyPolicyVersion(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        Version version = Version.fromString((String)Prefs.get((String)this.getAcceptedVersionKey(docName), null));
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"fromString(...)");
        return version;
    }

    public final boolean isChinaAgreementDocName(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        return Intrinsics.areEqual((Object)docName, (Object)AGREEMENT_DOC_CN);
    }

    private final String getAcceptedVersionKey(String docName) {
        return "JetBrains.privacy_policy." + docName + "_accepted_version";
    }

    @TestOnly
    public final void dropAiAgreement() {
        Prefs.remove((String)this.getAcceptedVersionKey(this.getDocumentName()));
    }
}

