/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference;

import com.vladsch.flexmark.ext.enumerated.reference.CompoundEnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBase;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.ArrayList;
import java.util.HashMap;

public class EnumeratedReferences {
    public static final String EMPTY_TYPE = "";
    public static final int[] EMPTY_ORDINALS = new int[0];
    private final EnumeratedReferenceRepository referenceRepository;
    private final HashMap<String, Integer> enumerationCounters;
    private final HashMap<String, int[]> enumeratedReferenceOrdinals;

    public EnumeratedReferences(DataHolder options) {
        this.referenceRepository = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.get(options);
        this.enumerationCounters = new HashMap();
        this.enumeratedReferenceOrdinals = new HashMap();
    }

    public void add(String text2) {
        String type2 = EnumeratedReferenceRepository.getType(text2);
        String[] types = type2.split(":");
        int[] ordinals = new int[types.length];
        StringBuilder nestedType = new StringBuilder();
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            int ordinal;
            String typeText = types[i];
            nestedType.append(typeText);
            String nestedTypeKey = nestedType.toString();
            if (i < iMax - 1) {
                Integer ordinalInt = this.enumerationCounters.get(nestedTypeKey);
                int typeOrdinal = ordinalInt == null ? 0 : ordinalInt;
                nestedType.append(':').append(typeOrdinal).append(':');
                ordinals[i] = typeOrdinal;
                continue;
            }
            if (!this.enumerationCounters.containsKey(nestedTypeKey)) {
                this.enumerationCounters.put(nestedTypeKey, 1);
                ordinal = 1;
            } else {
                ordinal = this.enumerationCounters.get(nestedTypeKey) + 1;
                this.enumerationCounters.put(nestedTypeKey, ordinal);
            }
            ordinals[i] = ordinal;
        }
        this.enumeratedReferenceOrdinals.put(text2, ordinals);
    }

    public EnumeratedReferenceRendering[] getEnumeratedReferenceOrdinals(String text2) {
        String type2 = EnumeratedReferenceRepository.getType(text2);
        String[] types = type2.split(":");
        EnumeratedReferenceRendering[] renderings = new EnumeratedReferenceRendering[types.length];
        int[] ordinals = this.enumeratedReferenceOrdinals.get(text2);
        if (ordinals == null) {
            ordinals = EMPTY_ORDINALS;
        }
        int iMax = types.length;
        for (int i = 0; i < iMax; ++i) {
            String typeText = types[i];
            EnumeratedReferenceBlock referenceFormat = (EnumeratedReferenceBlock)this.referenceRepository.get(typeText);
            int ordinal = i < ordinals.length ? ordinals[i] : 0;
            renderings[i] = new EnumeratedReferenceRendering(referenceFormat, typeText, ordinal);
        }
        return renderings;
    }

    public void renderReferenceOrdinals(String text2, EnumeratedOrdinalRenderer renderer) {
        EnumeratedReferenceRendering[] renderings = this.getEnumeratedReferenceOrdinals(text2);
        EnumeratedReferences.renderReferenceOrdinals(renderings, renderer);
    }

    public static void renderReferenceOrdinals(EnumeratedReferenceRendering[] renderings, EnumeratedOrdinalRenderer renderer) {
        renderer.startRendering(renderings);
        ArrayList<CompoundEnumeratedReferenceRendering> compoundReferences = new ArrayList<CompoundEnumeratedReferenceRendering>();
        EnumeratedReferenceRendering lastRendering = renderings[renderings.length - 1];
        for (EnumeratedReferenceRendering rendering : renderings) {
            int ordinal = rendering.referenceOrdinal;
            String defaultText = rendering.referenceType;
            boolean needSeparator = false;
            if (rendering != lastRendering) {
                if (rendering.referenceFormat != null) {
                    Node lastChild;
                    for (lastChild = rendering.referenceFormat.getLastChild(); lastChild != null && !(lastChild instanceof EnumeratedReferenceBase); lastChild = lastChild.getLastChild()) {
                    }
                    needSeparator = lastChild instanceof EnumeratedReferenceBase && ((EnumeratedReferenceBase)lastChild).getText().isEmpty();
                } else {
                    needSeparator = true;
                }
            }
            compoundReferences.add(new CompoundEnumeratedReferenceRendering(ordinal, rendering.referenceFormat, defaultText, needSeparator));
        }
        int iMax = compoundReferences.size() - 1;
        Runnable wasRunnable = renderer.getEnumOrdinalRunnable();
        renderer.setEnumOrdinalRunnable(() -> {
            for (int i = 0; i < iMax; ++i) {
                CompoundEnumeratedReferenceRendering rendering = (CompoundEnumeratedReferenceRendering)compoundReferences.get(i);
                Runnable wasRunnable1 = renderer.getEnumOrdinalRunnable();
                renderer.setEnumOrdinalRunnable(null);
                renderer.render(rendering.ordinal, rendering.referenceFormat, rendering.defaultText, rendering.needSeparator);
                renderer.setEnumOrdinalRunnable(wasRunnable1);
            }
        });
        CompoundEnumeratedReferenceRendering rendering = (CompoundEnumeratedReferenceRendering)compoundReferences.get(iMax);
        renderer.render(rendering.ordinal, rendering.referenceFormat, rendering.defaultText, rendering.needSeparator);
        renderer.setEnumOrdinalRunnable(wasRunnable);
        renderer.endRendering();
    }
}

