/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/inline/completion/java/features/JavaMLCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosures", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "bracketsSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "intellij.ml.inline.completion.java"})
public final class JavaMLCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenSet bracketsSet;

    public JavaMLCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosures) {
        Intrinsics.checkNotNullParameter((Object)enclosures, (String)"enclosures");
        super(enclosures);
        IElementType[] iElementTypeArray = new IElementType[]{JavaTokenType.LPARENTH, JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.RBRACE, JavaTokenType.LBRACKET, JavaTokenType.RBRACKET};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.bracketsSet = tokenSet;
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)Companion.createJavaLexer();
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (this.bracketsSet.contains(token)) {
            collector.bracket(StringsKt.first((CharSequence)text), offset);
            return;
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.CHARACTER_LITERAL)) {
            char quote = StringsKt.first((CharSequence)text);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset, null, 4, null);
                if (StringsKt.last((CharSequence)text) == quote && text.length() > 1 && (text.length() - 3 < 0 || text.charAt(text.length() - 2) != '\\' || text.charAt(text.length() - 3) == '\\')) {
                    MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STRING_TEMPLATE_BEGIN)) {
            char quote = StringsKt.first((CharSequence)text);
            if (this.getEnclosures().isStringMarker(quote)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset, null, 4, null);
            }
            if (StringsKt.endsWith$default((String)text, (String)"\\{", (boolean)false, (int)2, null) && text.length() > 1) {
                collector.stringTemplate('{', offset + text.length() - 1, "\\{");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STRING_TEMPLATE_MID)) {
            if (StringsKt.startsWith$default((String)text, (String)"}", (boolean)false, (int)2, null)) {
                collector.stringTemplate('}', offset, "}");
            }
            if (StringsKt.endsWith$default((String)text, (String)"\\{", (boolean)false, (int)2, null) && text.length() > 1) {
                collector.stringTemplate('{', offset + text.length() - 1, "\\{");
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.STRING_TEMPLATE_END)) {
            if (StringsKt.startsWith$default((String)text, (String)"}", (boolean)false, (int)2, null)) {
                collector.stringTemplate('}', offset, "}");
            }
            char quote = StringsKt.last((CharSequence)text);
            if (this.getEnclosures().isStringMarker(quote) && text.length() > 1) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector, quote, offset + text.length() - 1, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.COLON) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.COMMA) || Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.SEMICOLON)) {
            collector.special(text, offset);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/inline/completion/java/features/JavaMLCompletionLexer$Companion;", "", "<init>", "()V", "createJavaLexer", "Lcom/intellij/lang/java/lexer/JavaLexer;", "intellij.ml.inline.completion.java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLexer createJavaLexer() {
            return new JavaLexer(LanguageLevel.HIGHEST);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

