/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.serviceView.ServiceModel;
import com.intellij.platform.execution.serviceView.ServiceView;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewModel;
import com.intellij.platform.execution.serviceView.ServiceViewUi;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class ServiceSingleView
extends ServiceView {
    private final AtomicReference<ServiceModel.ServiceViewItem> myRef;
    private boolean mySelected;
    private final ServiceViewModel.ServiceViewModelListener myListener;

    ServiceSingleView(@NotNull Project project, @NotNull ServiceViewModel model, @NotNull ServiceViewUi ui) {
        if (project == null) {
            ServiceSingleView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ServiceSingleView.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            ServiceSingleView.$$$reportNull$$$0(2);
        }
        super(new BorderLayout(), project, model, ui);
        this.myRef = new AtomicReference();
        ui.setServiceToolbar(ServiceViewActionProvider.getInstance());
        this.add((Component)ui.getComponent(), "Center");
        this.myListener = this::updateItem;
        model.addModelListener(this.myListener);
        model.getInvoker().invokeLater(this::updateItem);
    }

    @Override
    @NotNull
    Promise<Void> select(@NotNull Object service, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item;
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(3);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(4);
        }
        if ((item = this.myRef.get()) == null || !item.getValue().equals(service)) {
            Promise promise = Promises.rejectedPromise((String)"Service not found");
            if (promise == null) {
                ServiceSingleView.$$$reportNull$$$0(5);
            }
            return promise;
        }
        this.showContent();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ServiceSingleView.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Override
    Promise<Void> expand(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(7);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(8);
        }
        return this.matches(service);
    }

    @Override
    Promise<Void> extract(@NotNull Object service, @NotNull Class<?> contributorClass) {
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(9);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(10);
        }
        return this.matches(service);
    }

    private Promise<Void> matches(@NotNull Object service) {
        ServiceModel.ServiceViewItem item;
        if (service == null) {
            ServiceSingleView.$$$reportNull$$$0(11);
        }
        return (item = this.myRef.get()) == null || !item.getValue().equals(service) ? Promises.rejectedPromise((String)"Service not found") : Promises.resolvedPromise();
    }

    @Override
    void onViewSelected() {
        this.showContent();
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            item.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        List list = ContainerUtil.createMaybeSingletonList((Object)item);
        if (list == null) {
            ServiceSingleView.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    void jumpToServices() {
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
    }

    private void updateItem() {
        WeakReference<ServiceModel.ServiceViewItem> oldValueRef = new WeakReference<ServiceModel.ServiceViewItem>(this.myRef.get());
        ServiceModel.ServiceViewItem newValue = (ServiceModel.ServiceViewItem)ContainerUtil.getOnlyItem(this.getModel().getRoots());
        WeakReference<ServiceModel.ServiceViewItem> newValueRef = new WeakReference<ServiceModel.ServiceViewItem>(newValue);
        this.myRef.set(newValue);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this)).submit(() -> {
            ServiceModel.ServiceViewItem value;
            if (this.mySelected && (value = (ServiceModel.ServiceViewItem)newValueRef.get()) != null) {
                ServiceViewDescriptor descriptor = value.getViewDescriptor();
                if (oldValueRef.get() == null) {
                    this.onViewSelected(descriptor);
                }
                this.myUi.setDetailsComponentVisible(descriptor.isContentPartVisible());
                this.myUi.setDetailsComponent(descriptor.getContentComponent());
            }
        });
    }

    private void showContent() {
        if (this.mySelected) {
            return;
        }
        this.mySelected = true;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            ServiceViewDescriptor descriptor = item.getViewDescriptor();
            this.onViewSelected(descriptor);
            this.myUi.setDetailsComponentVisible(descriptor.isContentPartVisible());
            this.myUi.setDetailsComponent(descriptor.getContentComponent());
        }
    }

    @Override
    List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath, @NotNull Class<?> contributorClass) {
        if (valueSubPath == null) {
            ServiceSingleView.$$$reportNull$$$0(13);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(14);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceSingleView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceSingleView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 12 -> new IllegalStateException(string);
        };
    }
}

