/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Color;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/documentation/PyRuntimeDocstringFormatter;", "", "<init>", "()V", "runExternalTool", "", "module", "Lcom/intellij/openapi/module/Module;", "format", "Lcom/jetbrains/python/documentation/docstrings/DocStringFormat;", "input", "formatterFlags", "", "logErrorAndReturnMessage", "logScriptError", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "DEFAULT_CHARSET", "Ljava/nio/charset/Charset;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyRuntimeDocstringFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRuntimeDocstringFormatter.kt\ncom/jetbrains/python/documentation/PyRuntimeDocstringFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class PyRuntimeDocstringFormatter {
    @NotNull
    public static final PyRuntimeDocstringFormatter INSTANCE = new PyRuntimeDocstringFormatter();
    @NotNull
    private static final Lazy LOG$delegate = LazyKt.lazy(PyRuntimeDocstringFormatter::LOG_delegate$lambda$2);
    @NotNull
    private static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    private PyRuntimeDocstringFormatter() {
    }

    @Nullable
    public final String runExternalTool(@NotNull Module module, @NotNull DocStringFormat format, @NotNull String input, @NotNull List<String> formatterFlags) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(formatterFlags, (String)"formatterFlags");
        Sdk sdk2 = PythonSdkType.findLocalCPython(module);
        if (sdk2 == null) {
            return this.logErrorAndReturnMessage(format);
        }
        Sdk sdk3 = sdk2;
        String string = sdk3.getHomePath();
        if (string == null) {
            return null;
        }
        String sdkHome = string;
        ByteBuffer encodedInput = DEFAULT_CHARSET.encode(input);
        byte[] byArray = new byte[encodedInput.limit()];
        Object it = byArray;
        boolean bl = false;
        encodedInput.get((byte[])it);
        byte[] data = byArray;
        Object $this$runExternalTool_u24lambda_u241 = it = (Object)CollectionsKt.toMutableList((Collection)formatterFlags);
        boolean bl2 = false;
        $this$runExternalTool_u24lambda_u241.add("--format");
        String string2 = format.getFormatterCommand();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormatterCommand(...)");
        $this$runExternalTool_u24lambda_u241.add(string2);
        Object arguments = it;
        GeneralCommandLine generalCommandLine = PythonHelper.DOCSTRING_FORMATTER.newCommandLine(sdk3, (List<String>)arguments).withCharset(DEFAULT_CHARSET);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withCharset(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        this.getLOG().debug("Command for launching docstring formatter: " + commandLine.getCommandLineString());
        ProcessOutput output2 = PySdkUtil.getProcessOutput(commandLine, new File(sdkHome).getParent(), null, 5000, data, false);
        return output2.checkSuccess(this.getLOG()) ? output2.getStdout() : this.logScriptError(input);
    }

    private final String logErrorAndReturnMessage(DocStringFormat format) {
        this.getLOG().warn("Python SDK for input formatter " + format + " is not found");
        String string = PyPsiBundle.message("QDOC.local.sdk.not.found", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String missingInterpreterMessage = string;
        String string2 = HtmlChunk.p().attr("color", ColorUtil.toHtmlColor((Color)((Color)JBColor.RED))).addRaw(missingInterpreterMessage).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String logScriptError(String input) {
        this.getLOG().warn("Malformed input or internal script error:\n" + input);
        return null;
    }

    private final Logger getLOG() {
        Lazy lazy = LOG$delegate;
        return (Logger)lazy.getValue();
    }

    private static final Logger LOG_delegate$lambda$2() {
        Logger logger = Logger.getInstance(PyRuntimeDocstringFormatter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }
}

