/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.black;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.black.BlackFormatterUtil;
import com.jetbrains.python.black.configuration.BlackFormatterConfigurable;
import com.jetbrains.python.black.configuration.BlackFormatterConfiguration;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/black/BlackFormatterAdvertiserService;", "", "<init>", "()V", "alreadyShown", "", "suggestBlack", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "blackFormatterConfiguration", "Lcom/jetbrains/python/black/configuration/BlackFormatterConfiguration;", "showBlackFormatterSupportNotification", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBlackFormatterAdvertiserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlackFormatterAdvertiserService.kt\ncom/jetbrains/python/black/BlackFormatterAdvertiserService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n11483#2,9:84\n13409#2:93\n13410#2:95\n11492#2:96\n1#3:94\n1755#4,3:97\n*S KotlinDebug\n*F\n+ 1 BlackFormatterAdvertiserService.kt\ncom/jetbrains/python/black/BlackFormatterAdvertiserService\n*L\n43#1:84,9\n43#1:93\n43#1:95\n43#1:96\n43#1:94\n44#1:97,3\n*E\n"})
public final class BlackFormatterAdvertiserService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean alreadyShown;
    @NonNls
    @NotNull
    public static final String SHOW_BLACK_FORMATTER_SUPPORT_NOTIFICATION = "black.formatter.show.support.notification";

    private BlackFormatterAdvertiserService() {
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void suggestBlack(@NotNull PsiFile psiFile, @NotNull BlackFormatterConfiguration blackFormatterConfiguration) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)blackFormatterConfiguration, (String)"blackFormatterConfiguration");
        if (!this.alreadyShown && Intrinsics.areEqual((Object)blackFormatterConfiguration, (Object)new BlackFormatterConfiguration())) {
            boolean blackInstalled;
            Project project;
            block8: {
                void $this$any$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Project project2 = psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                Module[] moduleArray = ProjectUtil.getModules((Project)project);
                boolean $i$f$mapNotNull = false;
                Iterator iterator = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    Sdk it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    if (PySdkExtKt.getPythonSdk((Module)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Sdk it = (Sdk)element$iv;
                        boolean bl = false;
                        if (!BlackFormatterUtil.Companion.isBlackFormatterInstalledOnProjectSdk(it)) continue;
                        v1 = true;
                        break block8;
                    }
                    v1 = blackInstalled = false;
                }
            }
            if (blackInstalled) {
                String string = PyBundle.message("black.advertising.service.found.in.packages", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showBlackFormatterSupportNotification(project, string);
            } else if (BlackFormatterUtil.Companion.isBlackExecutableDetected()) {
                Object[] objectArray = new Object[]{SystemInfo.isWindows ? 0 : 1};
                String string = PyBundle.message("black.advertising.service.found.in.PATH", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showBlackFormatterSupportNotification(project, string);
            }
        }
    }

    private final void showBlackFormatterSupportNotification(Project project, @Nls String message) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (!propertiesComponent.getBoolean(SHOW_BLACK_FORMATTER_SUPPORT_NOTIFICATION, true)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Black Formatter Integration");
        String string = PyBundle.message("black.advertising.service.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, message, NotificationType.INFORMATION).setDisplayId("black.formatter").setSuggestionType(true).setImportantSuggestion(true).addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("black.advertising.service.configure.button.label", new Object[0]), () -> BlackFormatterAdvertiserService.showBlackFormatterSupportNotification$lambda$2(project))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)PyBundle.message("black.advertising.service.dont.show.again.label", new Object[0]), () -> BlackFormatterAdvertiserService.showBlackFormatterSupportNotification$lambda$3(propertiesComponent)));
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
        Notification notification2 = notification;
        notification2.notify(project);
        this.alreadyShown = true;
    }

    private static final void showBlackFormatterSupportNotification$lambda$2(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, BlackFormatterConfigurable.class);
    }

    private static final void showBlackFormatterSupportNotification$lambda$3(PropertiesComponent $propertiesComponent) {
        $propertiesComponent.setValue(SHOW_BLACK_FORMATTER_SUPPORT_NOTIFICATION, "false", "true");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/black/BlackFormatterAdvertiserService$Companion;", "", "<init>", "()V", "SHOW_BLACK_FORMATTER_SUPPORT_NOTIFICATION", "", "getInstance", "Lcom/jetbrains/python/black/BlackFormatterAdvertiserService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlackFormatterAdvertiserService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(BlackFormatterAdvertiserService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BlackFormatterAdvertiserService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

