/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharBufferVisualizer;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDoubleAssociativeContainer;
import com.carrotsearch.hppc.CharDoubleMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharDoubleCursor;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.CharDoublePredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.procedures.CharDoubleProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharDoubleHashMap
implements CharDoubleMap,
Preallocable,
Cloneable,
Accountable {
    public char[] keys;
    public double[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public CharDoubleHashMap() {
        this(4);
    }

    public CharDoubleHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharDoubleHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public CharDoubleHashMap(CharDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(char key2, double value) {
        char existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key2 == '\u0000') {
            this.hasEmptyKey = true;
            double previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                double previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key2, value);
        } else {
            keys[slot] = key2;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(CharDoubleAssociativeContainer container) {
        int count = this.size();
        for (CharDoubleCursor c : container) {
            this.put(c.key, c.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends CharDoubleCursor> iterable) {
        int count = this.size();
        for (CharDoubleCursor charDoubleCursor : iterable) {
            this.put(charDoubleCursor.key, charDoubleCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public double putOrAdd(char key2, double putValue, double incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public double addTo(char key2, double incrementValue) {
        return this.putOrAdd(key2, incrementValue, incrementValue);
    }

    @Override
    public double remove(char key2) {
        char existing;
        int mask = this.mask;
        if (key2 == '\u0000') {
            this.hasEmptyKey = false;
            double previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0.0;
            return previousValue;
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                double previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    @Override
    public int removeAll(CharContainer other) {
        int before2 = this.size();
        if (other.size() >= this.size() && other instanceof CharLookupContainer) {
            if (this.hasEmptyKey && other.contains('\u0000')) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            char[] keys = this.keys;
            int slot = 0;
            int max = this.mask;
            while (slot <= max) {
                char existing = keys[slot];
                if (existing != '\u0000' && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (CharCursor c : other) {
                this.remove(c.value);
            }
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(CharDoublePredicate predicate) {
        int before2 = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply('\u0000', this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0.0;
        }
        char[] keys = this.keys;
        double[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        int before2 = this.size();
        if (this.hasEmptyKey && predicate.apply('\u0000')) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        char[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            char existing = keys[slot];
            if (existing != '\u0000' && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public double get(char key2) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0.0;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(char key2, double defaultValue) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(char key2) {
        char existing;
        if (key2 == '\u0000') {
            return this.hasEmptyKey;
        }
        char[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(char key2) {
        char existing;
        int mask = this.mask;
        if (key2 == '\u0000') {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        char[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != '\u0000') {
            if (key2 == existing) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public double indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public double indexReplace(int index, double newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        double previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, char key2, double value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key2 == '\u0000') {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == '\u0000');
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key2, value);
            } else {
                this.keys[index] = key2;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public double indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        double previousValue = this.values[index];
        if (index > this.mask) {
            this.hasEmptyKey = false;
            this.values[index] = 0.0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, '\u0000');
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (CharDoubleCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((CharDoubleHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharDoubleHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (CharDoubleCursor c : other) {
            char key2 = c.key;
            if (this.containsKey(key2) && Double.doubleToLongBits(c.value) == Double.doubleToLongBits(this.get(key2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            char[] prevKeys = this.keys;
            double[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<CharDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends CharDoubleProcedure> T forEach(T procedure) {
        char[] keys = this.keys;
        double[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply('\u0000', values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != '\u0000') {
                procedure.apply(keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends CharDoublePredicate> T forEach(T predicate) {
        char[] keys = this.keys;
        double[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply('\u0000', values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == '\u0000' || predicate.apply(keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    public CharDoubleHashMap clone() {
        try {
            CharDoubleHashMap cloned = (CharDoubleHashMap)super.clone();
            cloned.keys = (char[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (CharDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return CharBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static CharDoubleHashMap from(char[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleHashMap map = new CharDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(char key2) {
        assert (key2 != '\u0000');
        return BitMixer.mixPhi(key2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(char[] fromKeys, double[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        char[] keys = this.keys;
        double[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            char existing = fromKeys[from];
            if (existing == '\u0000') continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != '\u0000') {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        char[] prevKeys = this.keys;
        double[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new char[arraySize + emptyElementSlot];
            this.values = new double[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, char pendingKey, double pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == '\u0000' && pendingKey != '\u0000');
        char[] prevKeys = this.keys;
        double[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        char existing;
        char[] keys = this.keys;
        double[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != '\u0000') {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = '\u0000';
        values[gapSlot] = 0.0;
        --this.assigned;
    }

    private final class EntryIterator
    extends AbstractIterator<CharDoubleCursor> {
        private final CharDoubleCursor cursor = new CharDoubleCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = CharDoubleHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharDoubleHashMap.this.mask;
        }

        @Override
        protected CharDoubleCursor fetch() {
            int mask = CharDoubleHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharDoubleHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = '\u0000';
                this.cursor.value = CharDoubleHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (CharDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final CharDoubleHashMap owner;

        public KeysContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(char e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final CharDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = CharDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (CharDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            for (CharDoubleCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            for (CharDoubleCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            return this.owner.removeAll((char key2, double value) -> Double.doubleToLongBits(e) == Double.doubleToLongBits(value));
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll((char key2, double value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = CharDoubleHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharDoubleHashMap.this.mask;
        }

        @Override
        protected DoubleCursor fetch() {
            int mask = CharDoubleHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (CharDoubleHashMap.this.keys[this.slot] == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = CharDoubleHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = CharDoubleHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = CharDoubleHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & CharDoubleHashMap.this.mask;
        }

        @Override
        protected CharCursor fetch() {
            int mask = CharDoubleHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                char existing = CharDoubleHashMap.this.keys[this.slot];
                if (existing == '\u0000') continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && CharDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = '\u0000';
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

