/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.attributes;

import ai.grazie.utils.attributes.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\u0004\b\u0002\u0010\u00052\u00020\u0006:\t\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00028\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor;", "K", "Lai/grazie/utils/attributes/Attributes$Key;", "V", "Lai/grazie/utils/attributes/Attributes$Value;", "T", "", "name", "", "optional", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getOptional", "()Z", "key", "()Lai/grazie/utils/attributes/Attributes$Key;", "unwrap", "value", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Object;", "(Ljava/lang/Object;)Lai/grazie/utils/attributes/Attributes$Value;", "Bool", "Int", "Json", "OptBool", "OptInt", "OptRawJson", "OptText", "RawJson", "Text", "utils-common"})
public abstract class AttributeDescriptor<K extends Attributes.Key, V extends Attributes.Value, T> {
    @NotNull
    private final String name;
    private final boolean optional;

    public AttributeDescriptor(@NotNull String name, boolean optional) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.optional = optional;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getOptional() {
        return this.optional;
    }

    @NotNull
    public abstract K key();

    @Nullable
    public abstract V value(T var1);

    public T unwrap(@NotNull Attributes.Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Attributes.Companion.unwrap((Attributes.Key)this.key(), value);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$Bool;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Bool;", "Lai/grazie/utils/attributes/Attributes$Value$Bool;", "", "name", "", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Boolean;", "utils-common"})
    public static final class Bool
    extends AttributeDescriptor<Attributes.Key.Bool, Attributes.Value.Bool, Boolean> {
        public Bool(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        @Override
        @NotNull
        public Attributes.Key.Bool key() {
            return new Attributes.Key.Bool(this.getName());
        }

        @Override
        @NotNull
        public Attributes.Value.Bool value(boolean value) {
            return new Attributes.Value.Bool(value, null, 2, null);
        }

        @Override
        @NotNull
        public Boolean unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (Boolean)Attributes.Companion.unwrap(this.key(), value);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\r"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$Int;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Long;", "Lai/grazie/utils/attributes/Attributes$Value$Long;", "", "name", "", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Integer;", "utils-common"})
    public static final class Int
    extends AttributeDescriptor<Attributes.Key.Long, Attributes.Value.Long, Integer> {
        public Int(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        @Override
        @NotNull
        public Attributes.Key.Long key() {
            return new Attributes.Key.Long(this.getName());
        }

        @Override
        @NotNull
        public Attributes.Value.Long value(int value) {
            return new Attributes.Value.Long(value, null, 2, null);
        }

        @Override
        @NotNull
        public Integer unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (int)((Number)Attributes.Companion.unwrap(this.key(), value)).longValue();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0003\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\b\u00028\u00032\u0006\u0010\u000b\u001a\u00020\u0006H$\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u0003J\u001a\u0010\u000e\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\b\u00028\u0003H$\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00028\u00032\u0006\u0010\u000b\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0014"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$Json;", "T", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Json;", "Lai/grazie/utils/attributes/Attributes$Value$Json;", "name", "", "optional", "", "(Ljava/lang/String;Z)V", "fromJson", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "key", "toJson", "(Ljava/lang/Object;)Ljava/lang/String;", "unwrap", "Lai/grazie/utils/attributes/Attributes$Value;", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Object;", "(Ljava/lang/Object;)Lai/grazie/utils/attributes/Attributes$Value$Json;", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeDescriptor.kt\nai/grazie/utils/attributes/AttributeDescriptor$Json\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static abstract class Json<T>
    extends AttributeDescriptor<Attributes.Key.Json, Attributes.Value.Json, T> {
        public Json(@NotNull String name, boolean optional) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, optional);
        }

        @Override
        @NotNull
        public final Attributes.Key.Json key() {
            return new Attributes.Key.Json(this.getName(), null, 2, null);
        }

        @Override
        @Nullable
        public final Attributes.Value.Json value(T value) {
            Attributes.Value.Json json;
            T t = value;
            if (t != null) {
                T it = t;
                boolean bl = false;
                json = new Attributes.Value.Json(this.toJson(value), null, 2, null);
            } else {
                json = null;
            }
            return json;
        }

        @Override
        public final T unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!(value instanceof Attributes.Value.Json)) {
                throw new IllegalStateException(("Expected json for " + this.key() + " attribute").toString());
            }
            return this.fromJson(((Attributes.Value.Json)value).getValue());
        }

        @NotNull
        protected abstract String toJson(@NotNull T var1);

        @NotNull
        protected abstract T fromJson(@NotNull String var1);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$OptBool;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Bool;", "Lai/grazie/utils/attributes/Attributes$Value$Bool;", "", "name", "", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Boolean;", "(Ljava/lang/Boolean;)Lai/grazie/utils/attributes/Attributes$Value$Bool;", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeDescriptor.kt\nai/grazie/utils/attributes/AttributeDescriptor$OptBool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class OptBool
    extends AttributeDescriptor<Attributes.Key.Bool, Attributes.Value.Bool, Boolean> {
        public OptBool(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, true);
        }

        @Override
        @NotNull
        public Attributes.Key.Bool key() {
            return new Attributes.Key.Bool(this.getName());
        }

        @Override
        @Nullable
        public Attributes.Value.Bool value(@Nullable Boolean value) {
            Attributes.Value.Bool bool;
            Boolean bl = value;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                bool = new Attributes.Value.Bool(value, null, 2, null);
            } else {
                bool = null;
            }
            return bool;
        }

        @Override
        @NotNull
        public Boolean unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (Boolean)Attributes.Companion.unwrap(this.key(), value);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$OptInt;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Long;", "Lai/grazie/utils/attributes/Attributes$Value$Long;", "", "name", "", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "(Lai/grazie/utils/attributes/Attributes$Value;)Ljava/lang/Integer;", "(Ljava/lang/Integer;)Lai/grazie/utils/attributes/Attributes$Value$Long;", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeDescriptor.kt\nai/grazie/utils/attributes/AttributeDescriptor$OptInt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class OptInt
    extends AttributeDescriptor<Attributes.Key.Long, Attributes.Value.Long, Integer> {
        public OptInt(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, true);
        }

        @Override
        @NotNull
        public Attributes.Key.Long key() {
            return new Attributes.Key.Long(this.getName());
        }

        @Override
        @Nullable
        public Attributes.Value.Long value(@Nullable Integer value) {
            Attributes.Value.Long longVal;
            Integer n = value;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                longVal = new Attributes.Value.Long(value.intValue(), null, 2, null);
            } else {
                longVal = null;
            }
            return longVal;
        }

        @Override
        @NotNull
        public Integer unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (int)((Number)Attributes.Companion.unwrap(this.key(), value)).longValue();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$OptRawJson;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Json;", "Lai/grazie/utils/attributes/Attributes$Value$Json;", "", "name", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeDescriptor.kt\nai/grazie/utils/attributes/AttributeDescriptor$OptRawJson\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class OptRawJson
    extends AttributeDescriptor<Attributes.Key.Json, Attributes.Value.Json, String> {
        public OptRawJson(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, true);
        }

        @Override
        @NotNull
        public Attributes.Key.Json key() {
            return new Attributes.Key.Json(this.getName(), null, 2, null);
        }

        @Override
        @Nullable
        public Attributes.Value.Json value(@Nullable String value) {
            Attributes.Value.Json json;
            String string2 = value;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                json = new Attributes.Value.Json(value, null, 2, null);
            } else {
                json = null;
            }
            return json;
        }

        @Override
        @NotNull
        public String unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (String)Attributes.Companion.unwrap(this.key(), value);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\t"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$OptText;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Text;", "Lai/grazie/utils/attributes/Attributes$Value$Text;", "", "name", "(Ljava/lang/String;)V", "key", "value", "utils-common"})
    @SourceDebugExtension(value={"SMAP\nAttributeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeDescriptor.kt\nai/grazie/utils/attributes/AttributeDescriptor$OptText\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
    public static final class OptText
    extends AttributeDescriptor<Attributes.Key.Text, Attributes.Value.Text, String> {
        public OptText(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, true);
        }

        @Override
        @NotNull
        public Attributes.Key.Text key() {
            return new Attributes.Key.Text(this.getName(), null, 2, null);
        }

        @Override
        @Nullable
        public Attributes.Value.Text value(@Nullable String value) {
            Attributes.Value.Text text2;
            String string2 = value;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                text2 = new Attributes.Value.Text(value, null, 2, null);
            } else {
                text2 = null;
            }
            return text2;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$RawJson;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Json;", "Lai/grazie/utils/attributes/Attributes$Value$Json;", "", "name", "(Ljava/lang/String;)V", "key", "unwrap", "value", "Lai/grazie/utils/attributes/Attributes$Value;", "utils-common"})
    public static final class RawJson
    extends AttributeDescriptor<Attributes.Key.Json, Attributes.Value.Json, String> {
        public RawJson(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        @Override
        @NotNull
        public Attributes.Key.Json key() {
            return new Attributes.Key.Json(this.getName(), null, 2, null);
        }

        @Override
        @NotNull
        public Attributes.Value.Json value(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Attributes.Value.Json(value, null, 2, null);
        }

        @Override
        @NotNull
        public String unwrap(@NotNull Attributes.Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return (String)Attributes.Companion.unwrap(this.key(), value);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lai/grazie/utils/attributes/AttributeDescriptor$Text;", "Lai/grazie/utils/attributes/AttributeDescriptor;", "Lai/grazie/utils/attributes/Attributes$Key$Text;", "Lai/grazie/utils/attributes/Attributes$Value$Text;", "", "name", "(Ljava/lang/String;)V", "key", "value", "utils-common"})
    public static final class Text
    extends AttributeDescriptor<Attributes.Key.Text, Attributes.Value.Text, String> {
        public Text(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, false);
        }

        @Override
        @NotNull
        public Attributes.Key.Text key() {
            return new Attributes.Key.Text(this.getName(), null, 2, null);
        }

        @Override
        @NotNull
        public Attributes.Value.Text value(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Attributes.Value.Text(value, null, 2, null);
        }
    }
}

