/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.Counters;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleDependencyException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.Messages;
import org.pentaho.di.repository.RepositoryCreationHelper;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryUtil;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.trans.TransMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository {
    public static final String TABLE_R_VERSION = "R_VERSION";
    public static final String FIELD_VERSION_ID_VERSION = "ID_VERSION";
    public static final String FIELD_VERSION_MAJOR_VERSION = "MAJOR_VERSION";
    public static final String FIELD_VERSION_MINOR_VERSION = "MINOR_VERSION";
    public static final String FIELD_VERSION_IS_UPGRADE = "IS_UPGRADE";
    public static final String FIELD_VERSION_UPGRADE_DATE = "UPGRADE_DATE";
    public static final String TABLE_R_REPOSITORY_LOG = "R_REPOSITORY_LOG";
    public static final String FIELD_REPOSITORY_LOG_ID_REPOSITORY_LOG = "ID_REPOSITORY_LOG";
    public static final String FIELD_REPOSITORY_LOG_REP_VERSION = "REP_VERSION";
    public static final String FIELD_REPOSITORY_LOG_LOG_DATE = "LOG_DATE";
    public static final String FIELD_REPOSITORY_LOG_LOG_USER = "LOG_USER";
    public static final String FIELD_REPOSITORY_LOG_OPERATION_DESC = "OPERATION_DESC";
    public static final String TABLE_R_DATABASE_TYPE = "R_DATABASE_TYPE";
    public static final String FIELD_DATABASE_TYPE_ID_DATABASE_TYPE = "ID_DATABASE_TYPE";
    public static final String FIELD_DATABASE_TYPE_CODE = "CODE";
    public static final String FIELD_DATABASE_TYPE_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_DATABASE_CONTYPE = "R_DATABASE_CONTYPE";
    public static final String FIELD_DATABASE_CONTYPE_ID_DATABASE_CONTYPE = "ID_DATABASE_CONTYPE";
    public static final String FIELD_DATABASE_CONTYPE_CODE = "CODE";
    public static final String FIELD_DATABASE_CONTYPE_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_DATABASE = "R_DATABASE";
    public static final String FIELD_DATABASE_ID_DATABASE = "ID_DATABASE";
    public static final String FIELD_DATABASE_NAME = "NAME";
    public static final String FIELD_DATABASE_ID_DATABASE_TYPE = "ID_DATABASE_TYPE";
    public static final String FIELD_DATABASE_ID_DATABASE_CONTYPE = "ID_DATABASE_CONTYPE";
    public static final String FIELD_DATABASE_HOST_NAME = "HOST_NAME";
    public static final String FIELD_DATABASE_DATABASE_NAME = "DATABASE_NAME";
    public static final String FIELD_DATABASE_PORT = "PORT";
    public static final String FIELD_DATABASE_USERNAME = "USERNAME";
    public static final String FIELD_DATABASE_DATA_TBS = "DATA_TBS";
    public static final String FIELD_DATABASE_PASSWORD = "PASSWORD";
    public static final String FIELD_DATABASE_SERVERNAME = "SERVERNAME";
    public static final String FIELD_DATABASE_INDEX_TBS = "INDEX_TBS";
    public static final String TABLE_R_DATABASE_ATTRIBUTE = "R_DATABASE_ATTRIBUTE";
    public static final String FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE = "ID_DATABASE_ATTRIBUTE";
    public static final String FIELD_DATABASE_ATTRIBUTE_ID_DATABASE = "ID_DATABASE";
    public static final String FIELD_DATABASE_ATTRIBUTE_CODE = "CODE";
    public static final String FIELD_DATABASE_ATTRIBUTE_VALUE_STR = "VALUE_STR";
    public static final String TABLE_R_NOTE = "R_NOTE";
    public static final String FIELD_NOTE_ID_NOTE = "ID_NOTE";
    public static final String FIELD_NOTE_VALUE_STR = "VALUE_STR";
    public static final String FIELD_NOTE_GUI_LOCATION_X = "GUI_LOCATION_X";
    public static final String FIELD_NOTE_GUI_LOCATION_Y = "GUI_LOCATION_Y";
    public static final String FIELD_NOTE_GUI_LOCATION_WIDTH = "GUI_LOCATION_WIDTH";
    public static final String FIELD_NOTE_GUI_LOCATION_HEIGHT = "GUI_LOCATION_HEIGHT";
    public static final String TABLE_R_TRANSFORMATION = "R_TRANSFORMATION";
    public static final String FIELD_TRANSFORMATION_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANSFORMATION_ID_DIRECTORY = "ID_DIRECTORY";
    public static final String FIELD_TRANSFORMATION_NAME = "NAME";
    public static final String FIELD_TRANSFORMATION_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_TRANSFORMATION_EXTENDED_DESCRIPTION = "EXTENDED_DESCRIPTION";
    public static final String FIELD_TRANSFORMATION_TRANS_VERSION = "TRANS_VERSION";
    public static final String FIELD_TRANSFORMATION_TRANS_STATUS = "TRANS_STATUS";
    public static final String FIELD_TRANSFORMATION_ID_STEP_READ = "ID_STEP_READ";
    public static final String FIELD_TRANSFORMATION_ID_STEP_WRITE = "ID_STEP_WRITE";
    public static final String FIELD_TRANSFORMATION_ID_STEP_INPUT = "ID_STEP_INPUT";
    public static final String FIELD_TRANSFORMATION_ID_STEP_OUTPUT = "ID_STEP_OUTPUT";
    public static final String FIELD_TRANSFORMATION_ID_STEP_UPDATE = "ID_STEP_UPDATE";
    public static final String FIELD_TRANSFORMATION_ID_DATABASE_LOG = "ID_DATABASE_LOG";
    public static final String FIELD_TRANSFORMATION_TABLE_NAME_LOG = "TABLE_NAME_LOG";
    public static final String FIELD_TRANSFORMATION_USE_BATCHID = "USE_BATCHID";
    public static final String FIELD_TRANSFORMATION_USE_LOGFIELD = "USE_LOGFIELD";
    public static final String FIELD_TRANSFORMATION_ID_DATABASE_MAXDATE = "ID_DATABASE_MAXDATE";
    public static final String FIELD_TRANSFORMATION_TABLE_NAME_MAXDATE = "TABLE_NAME_MAXDATE";
    public static final String FIELD_TRANSFORMATION_FIELD_NAME_MAXDATE = "FIELD_NAME_MAXDATE";
    public static final String FIELD_TRANSFORMATION_OFFSET_MAXDATE = "OFFSET_MAXDATE";
    public static final String FIELD_TRANSFORMATION_DIFF_MAXDATE = "DIFF_MAXDATE";
    public static final String FIELD_TRANSFORMATION_CREATED_USER = "CREATED_USER";
    public static final String FIELD_TRANSFORMATION_CREATED_DATE = "CREATED_DATE";
    public static final String FIELD_TRANSFORMATION_MODIFIED_USER = "MODIFIED_USER";
    public static final String FIELD_TRANSFORMATION_MODIFIED_DATE = "MODIFIED_DATE";
    public static final String FIELD_TRANSFORMATION_SIZE_ROWSET = "SIZE_ROWSET";
    public static final String TABLE_R_DIRECTORY = "R_DIRECTORY";
    public static final String FIELD_DIRECTORY_ID_DIRECTORY = "ID_DIRECTORY";
    public static final String FIELD_DIRECTORY_ID_DIRECTORY_PARENT = "ID_DIRECTORY_PARENT";
    public static final String FIELD_DIRECTORY_DIRECTORY_NAME = "DIRECTORY_NAME";
    public static final String TABLE_R_TRANS_ATTRIBUTE = "R_TRANS_ATTRIBUTE";
    public static final String FIELD_TRANS_ATTRIBUTE_ID_TRANS_ATTRIBUTE = "ID_TRANS_ATTRIBUTE";
    public static final String FIELD_TRANS_ATTRIBUTE_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_ATTRIBUTE_NR = "NR";
    public static final String FIELD_TRANS_ATTRIBUTE_CODE = "CODE";
    public static final String FIELD_TRANS_ATTRIBUTE_VALUE_NUM = "VALUE_NUM";
    public static final String FIELD_TRANS_ATTRIBUTE_VALUE_STR = "VALUE_STR";
    public static final String TABLE_R_JOB_ATTRIBUTE = "R_JOB_ATTRIBUTE";
    public static final String FIELD_JOB_ATTRIBUTE_ID_JOB_ATTRIBUTE = "ID_JOB_ATTRIBUTE";
    public static final String FIELD_JOB_ATTRIBUTE_ID_JOB = "ID_JOB";
    public static final String FIELD_JOB_ATTRIBUTE_NR = "NR";
    public static final String FIELD_JOB_ATTRIBUTE_CODE = "CODE";
    public static final String FIELD_JOB_ATTRIBUTE_VALUE_NUM = "VALUE_NUM";
    public static final String FIELD_JOB_ATTRIBUTE_VALUE_STR = "VALUE_STR";
    public static final String TABLE_R_DEPENDENCY = "R_DEPENDENCY";
    public static final String FIELD_DEPENDENCY_ID_DEPENDENCY = "ID_DEPENDENCY";
    public static final String FIELD_DEPENDENCY_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_DEPENDENCY_ID_DATABASE = "ID_DATABASE";
    public static final String FIELD_DEPENDENCY_TABLE_NAME = "TABLE_NAME";
    public static final String FIELD_DEPENDENCY_FIELD_NAME = "FIELD_NAME";
    public static final String TABLE_R_TRANS_STEP_CONDITION = "R_TRANS_STEP_CONDITION";
    public static final String FIELD_TRANS_STEP_CONDITION_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_STEP_CONDITION_ID_STEP = "ID_STEP";
    public static final String FIELD_TRANS_STEP_CONDITION_ID_CONDITION = "ID_CONDITION";
    public static final String TABLE_R_CONDITION = "R_CONDITION";
    public static final String FIELD_CONDITION_ID_CONDITION = "ID_CONDITION";
    public static final String FIELD_CONDITION_ID_CONDITION_PARENT = "ID_CONDITION_PARENT";
    public static final String FIELD_CONDITION_NEGATED = "NEGATED";
    public static final String FIELD_CONDITION_OPERATOR = "OPERATOR";
    public static final String FIELD_CONDITION_LEFT_NAME = "LEFT_NAME";
    public static final String FIELD_CONDITION_CONDITION_FUNCTION = "CONDITION_FUNCTION";
    public static final String FIELD_CONDITION_RIGHT_NAME = "RIGHT_NAME";
    public static final String FIELD_CONDITION_ID_VALUE_RIGHT = "ID_VALUE_RIGHT";
    public static final String TABLE_R_VALUE = "R_VALUE";
    public static final String FIELD_VALUE_ID_VALUE = "ID_VALUE";
    public static final String FIELD_VALUE_NAME = "NAME";
    public static final String FIELD_VALUE_VALUE_TYPE = "VALUE_TYPE";
    public static final String FIELD_VALUE_VALUE_STR = "VALUE_STR";
    public static final String FIELD_VALUE_IS_NULL = "IS_NULL";
    public static final String TABLE_R_TRANS_HOP = "R_TRANS_HOP";
    public static final String FIELD_TRANS_HOP_ID_TRANS_HOP = "ID_TRANS_HOP";
    public static final String FIELD_TRANS_HOP_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_HOP_ID_STEP_FROM = "ID_STEP_FROM";
    public static final String FIELD_TRANS_HOP_ID_STEP_TO = "ID_STEP_TO";
    public static final String FIELD_TRANS_HOP_ENABLED = "ENABLED";
    public static final String TABLE_R_STEP_TYPE = "R_STEP_TYPE";
    public static final String FIELD_STEP_TYPE_ID_STEP_TYPE = "ID_STEP_TYPE";
    public static final String FIELD_STEP_TYPE_CODE = "CODE";
    public static final String FIELD_STEP_TYPE_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_STEP_TYPE_HELPTEXT = "HELPTEXT";
    public static final String TABLE_R_STEP = "R_STEP";
    public static final String FIELD_STEP_ID_STEP = "ID_STEP";
    public static final String FIELD_STEP_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_STEP_NAME = "NAME";
    public static final String FIELD_STEP_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_STEP_ID_STEP_TYPE = "ID_STEP_TYPE";
    public static final String FIELD_STEP_DISTRIBUTE = "DISTRIBUTE";
    public static final String FIELD_STEP_COPIES = "COPIES";
    public static final String FIELD_STEP_GUI_LOCATION_X = "GUI_LOCATION_X";
    public static final String FIELD_STEP_GUI_LOCATION_Y = "GUI_LOCATION_Y";
    public static final String FIELD_STEP_GUI_DRAW = "GUI_DRAW";
    public static final String TABLE_R_STEP_ATTRIBUTE = "R_STEP_ATTRIBUTE";
    public static final String FIELD_STEP_ATTRIBUTE_ID_STEP_ATTRIBUTE = "ID_STEP_ATTRIBUTE";
    public static final String FIELD_STEP_ATTRIBUTE_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_STEP_ATTRIBUTE_ID_STEP = "ID_STEP";
    public static final String FIELD_STEP_ATTRIBUTE_CODE = "CODE";
    public static final String FIELD_STEP_ATTRIBUTE_NR = "NR";
    public static final String FIELD_STEP_ATTRIBUTE_VALUE_NUM = "VALUE_NUM";
    public static final String FIELD_STEP_ATTRIBUTE_VALUE_STR = "VALUE_STR";
    public static final String TABLE_R_TRANS_NOTE = "R_TRANS_NOTE";
    public static final String FIELD_TRANS_NOTE_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_NOTE_ID_NOTE = "ID_NOTE";
    public static final String TABLE_R_JOB = "R_JOB";
    public static final String FIELD_JOB_ID_JOB = "ID_JOB";
    public static final String FIELD_JOB_ID_DIRECTORY = "ID_DIRECTORY";
    public static final String FIELD_JOB_NAME = "NAME";
    public static final String FIELD_JOB_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_JOB_EXTENDED_DESCRIPTION = "EXTENDED_DESCRIPTION";
    public static final String FIELD_JOB_JOB_VERSION = "JOB_VERSION";
    public static final String FIELD_JOB_JOB_STATUS = "JOB_STATUS";
    public static final String FIELD_JOB_ID_DATABASE_LOG = "ID_DATABASE_LOG";
    public static final String FIELD_JOB_TABLE_NAME_LOG = "TABLE_NAME_LOG";
    public static final String FIELD_JOB_CREATED_USER = "CREATED_USER";
    public static final String FIELD_JOB_CREATED_DATE = "CREATED_DATE";
    public static final String FIELD_JOB_MODIFIED_USER = "MODIFIED_USER";
    public static final String FIELD_JOB_MODIFIED_DATE = "MODIFIED_DATE";
    public static final String FIELD_JOB_USE_BATCH_ID = "USE_BATCH_ID";
    public static final String FIELD_JOB_PASS_BATCH_ID = "PASS_BATCH_ID";
    public static final String FIELD_JOB_USE_LOGFIELD = "USE_LOGFIELD";
    public static final String FIELD_JOB_SHARED_FILE = "SHARED_FILE";
    public static final String TABLE_R_LOGLEVEL = "R_LOGLEVEL";
    public static final String FIELD_LOGLEVEL_ID_LOGLEVEL = "ID_LOGLEVEL";
    public static final String FIELD_LOGLEVEL_CODE = "CODE";
    public static final String FIELD_LOGLEVEL_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_LOG = "R_LOG";
    public static final String FIELD_LOG_ID_LOG = "ID_LOG";
    public static final String FIELD_LOG_NAME = "NAME";
    public static final String FIELD_LOG_ID_LOGLEVEL = "ID_LOGLEVEL";
    public static final String FIELD_LOG_LOGTYPE = "LOGTYPE";
    public static final String FIELD_LOG_FILENAME = "FILENAME";
    public static final String FIELD_LOG_FILEEXTENTION = "FILEEXTENTION";
    public static final String FIELD_LOG_ADD_DATE = "ADD_DATE";
    public static final String FIELD_LOG_ADD_TIME = "ADD_TIME";
    public static final String FIELD_LOG_ID_DATABASE_LOG = "ID_DATABASE_LOG";
    public static final String FIELD_LOG_TABLE_NAME_LOG = "TABLE_NAME_LOG";
    public static final String TABLE_R_JOBENTRY = "R_JOBENTRY";
    public static final String FIELD_JOBENTRY_ID_JOBENTRY = "ID_JOBENTRY";
    public static final String FIELD_JOBENTRY_ID_JOB = "ID_JOB";
    public static final String FIELD_JOBENTRY_ID_JOBENTRY_TYPE = "ID_JOBENTRY_TYPE";
    public static final String FIELD_JOBENTRY_NAME = "NAME";
    public static final String FIELD_JOBENTRY_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_JOBENTRY_COPY = "R_JOBENTRY_COPY";
    public static final String FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY = "ID_JOBENTRY_COPY";
    public static final String FIELD_JOBENTRY_COPY_ID_JOBENTRY = "ID_JOBENTRY";
    public static final String FIELD_JOBENTRY_COPY_ID_JOB = "ID_JOB";
    public static final String FIELD_JOBENTRY_COPY_ID_JOBENTRY_TYPE = "ID_JOBENTRY_TYPE";
    public static final String FIELD_JOBENTRY_COPY_NR = "NR";
    public static final String FIELD_JOBENTRY_COPY_GUI_LOCATION_X = "GUI_LOCATION_X";
    public static final String FIELD_JOBENTRY_COPY_GUI_LOCATION_Y = "GUI_LOCATION_Y";
    public static final String FIELD_JOBENTRY_COPY_GUI_DRAW = "GUI_DRAW";
    public static final String FIELD_JOBENTRY_COPY_PARALLEL = "PARALLEL";
    public static final String TABLE_R_JOBENTRY_TYPE = "R_JOBENTRY_TYPE";
    public static final String FIELD_JOBENTRY_TYPE_ID_JOBENTRY_TYPE = "ID_JOBENTRY_TYPE";
    public static final String FIELD_JOBENTRY_TYPE_CODE = "CODE";
    public static final String FIELD_JOBENTRY_TYPE_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_JOBENTRY_ATTRIBUTE = "R_JOBENTRY_ATTRIBUTE";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_ID_JOBENTRY_ATTRIBUTE = "ID_JOBENTRY_ATTRIBUTE";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_ID_JOB = "ID_JOB";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_ID_JOBENTRY = "ID_JOBENTRY";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_NR = "NR";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_CODE = "CODE";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_VALUE_NUM = "VALUE_NUM";
    public static final String FIELD_JOBENTRY_ATTRIBUTE_VALUE_STR = "VALUE_STR";
    public static final String TABLE_R_JOB_HOP = "R_JOB_HOP";
    public static final String FIELD_JOB_HOP_ID_JOB_HOP = "ID_JOB_HOP";
    public static final String FIELD_JOB_HOP_ID_JOB = "ID_JOB";
    public static final String FIELD_JOB_HOP_ID_JOBENTRY_COPY_FROM = "ID_JOBENTRY_COPY_FROM";
    public static final String FIELD_JOB_HOP_ID_JOBENTRY_COPY_TO = "ID_JOBENTRY_COPY_TO";
    public static final String FIELD_JOB_HOP_ENABLED = "ENABLED";
    public static final String FIELD_JOB_HOP_EVALUATION = "EVALUATION";
    public static final String FIELD_JOB_HOP_UNCONDITIONAL = "UNCONDITIONAL";
    public static final String TABLE_R_JOB_NOTE = "R_JOB_NOTE";
    public static final String FIELD_JOB_NOTE_ID_JOB = "ID_JOB";
    public static final String FIELD_JOB_NOTE_ID_NOTE = "ID_NOTE";
    public static final String TABLE_R_PROFILE = "R_PROFILE";
    public static final String FIELD_PROFILE_ID_PROFILE = "ID_PROFILE";
    public static final String FIELD_PROFILE_NAME = "NAME";
    public static final String FIELD_PROFILE_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_USER = "R_USER";
    public static final String FIELD_USER_ID_USER = "ID_USER";
    public static final String FIELD_USER_ID_PROFILE = "ID_PROFILE";
    public static final String FIELD_USER_LOGIN = "LOGIN";
    public static final String FIELD_USER_PASSWORD = "PASSWORD";
    public static final String FIELD_USER_NAME = "NAME";
    public static final String FIELD_USER_DESCRIPTION = "DESCRIPTION";
    public static final String FIELD_USER_ENABLED = "ENABLED";
    public static final String TABLE_R_PERMISSION = "R_PERMISSION";
    public static final String FIELD_PERMISSION_ID_PERMISSION = "ID_PERMISSION";
    public static final String FIELD_PERMISSION_CODE = "CODE";
    public static final String FIELD_PERMISSION_DESCRIPTION = "DESCRIPTION";
    public static final String TABLE_R_PROFILE_PERMISSION = "R_PROFILE_PERMISSION";
    public static final String FIELD_PROFILE_PERMISSION_ID_PROFILE = "ID_PROFILE";
    public static final String FIELD_PROFILE_PERMISSION_ID_PERMISSION = "ID_PERMISSION";
    public static final String TABLE_R_STEP_DATABASE = "R_STEP_DATABASE";
    public static final String FIELD_STEP_DATABASE_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_STEP_DATABASE_ID_STEP = "ID_STEP";
    public static final String FIELD_STEP_DATABASE_ID_DATABASE = "ID_DATABASE";
    public static final String TABLE_R_PARTITION_SCHEMA = "R_PARTITION_SCHEMA";
    public static final String FIELD_PARTITION_SCHEMA_ID_PARTITION_SCHEMA = "ID_PARTITION_SCHEMA";
    public static final String FIELD_PARTITION_SCHEMA_NAME = "NAME";
    public static final String FIELD_PARTITION_SCHEMA_DYNAMIC_DEFINITION = "DYNAMIC_DEFINITION";
    public static final String FIELD_PARTITION_SCHEMA_PARTITIONS_PER_SLAVE = "PARTITIONS_PER_SLAVE";
    public static final String TABLE_R_PARTITION = "R_PARTITION";
    public static final String FIELD_PARTITION_ID_PARTITION = "ID_PARTITION";
    public static final String FIELD_PARTITION_ID_PARTITION_SCHEMA = "ID_PARTITION_SCHEMA";
    public static final String FIELD_PARTITION_PARTITION_ID = "PARTITION_ID";
    public static final String TABLE_R_TRANS_PARTITION_SCHEMA = "R_TRANS_PARTITION_SCHEMA";
    public static final String FIELD_TRANS_PARTITION_SCHEMA_ID_TRANS_PARTITION_SCHEMA = "ID_TRANS_PARTITION_SCHEMA";
    public static final String FIELD_TRANS_PARTITION_SCHEMA_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_PARTITION_SCHEMA_ID_PARTITION_SCHEMA = "ID_PARTITION_SCHEMA";
    public static final String TABLE_R_CLUSTER = "R_CLUSTER";
    public static final String FIELD_CLUSTER_ID_CLUSTER = "ID_CLUSTER";
    public static final String FIELD_CLUSTER_NAME = "NAME";
    public static final String FIELD_CLUSTER_BASE_PORT = "BASE_PORT";
    public static final String FIELD_CLUSTER_SOCKETS_BUFFER_SIZE = "SOCKETS_BUFFER_SIZE";
    public static final String FIELD_CLUSTER_SOCKETS_FLUSH_INTERVAL = "SOCKETS_FLUSH_INTERVAL";
    public static final String FIELD_CLUSTER_SOCKETS_COMPRESSED = "SOCKETS_COMPRESSED";
    public static final String FIELD_CLUSTER_DYNAMIC = "DYNAMIC_CLUSTER";
    public static final String TABLE_R_SLAVE = "R_SLAVE";
    public static final String FIELD_SLAVE_ID_SLAVE = "ID_SLAVE";
    public static final String FIELD_SLAVE_NAME = "NAME";
    public static final String FIELD_SLAVE_HOST_NAME = "HOST_NAME";
    public static final String FIELD_SLAVE_PORT = "PORT";
    public static final String FIELD_SLAVE_USERNAME = "USERNAME";
    public static final String FIELD_SLAVE_PASSWORD = "PASSWORD";
    public static final String FIELD_SLAVE_PROXY_HOST_NAME = "PROXY_HOST_NAME";
    public static final String FIELD_SLAVE_PROXY_PORT = "PROXY_PORT";
    public static final String FIELD_SLAVE_NON_PROXY_HOSTS = "NON_PROXY_HOSTS";
    public static final String FIELD_SLAVE_MASTER = "MASTER";
    public static final String TABLE_R_CLUSTER_SLAVE = "R_CLUSTER_SLAVE";
    public static final String FIELD_CLUSTER_SLAVE_ID_CLUSTER_SLAVE = "ID_CLUSTER_SLAVE";
    public static final String FIELD_CLUSTER_SLAVE_ID_CLUSTER = "ID_CLUSTER";
    public static final String FIELD_CLUSTER_SLAVE_ID_SLAVE = "ID_SLAVE";
    public static final String TABLE_R_TRANS_CLUSTER = "R_TRANS_CLUSTER";
    public static final String FIELD_TRANS_CLUSTER_ID_TRANS_CLUSTER = "ID_TRANS_CLUSTER";
    public static final String FIELD_TRANS_CLUSTER_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_CLUSTER_ID_CLUSTER = "ID_CLUSTER";
    public static final String TABLE_R_TRANS_SLAVE = "R_TRANS_SLAVE";
    public static final String FIELD_TRANS_SLAVE_ID_TRANS_SLAVE = "ID_TRANS_SLAVE";
    public static final String FIELD_TRANS_SLAVE_ID_TRANSFORMATION = "ID_TRANSFORMATION";
    public static final String FIELD_TRANS_SLAVE_ID_SLAVE = "ID_SLAVE";
    public static final String[] repositoryTableNames = new String[]{"R_CLUSTER", "R_CLUSTER_SLAVE", "R_CONDITION", "R_DATABASE", "R_DATABASE_ATTRIBUTE", "R_DATABASE_CONTYPE", "R_DATABASE_TYPE", "R_DEPENDENCY", "R_DIRECTORY", "R_JOB", "R_JOBENTRY", "R_JOBENTRY_ATTRIBUTE", "R_JOBENTRY_COPY", "R_JOBENTRY_TYPE", "R_JOB_HOP", "R_JOB_NOTE", "R_LOG", "R_LOGLEVEL", "R_NOTE", "R_PARTITION", "R_PARTITION_SCHEMA", "R_PERMISSION", "R_PROFILE", "R_PROFILE_PERMISSION", "R_REPOSITORY_LOG", "R_SLAVE", "R_STEP", "R_STEP_ATTRIBUTE", "R_STEP_DATABASE", "R_STEP_TYPE", "R_TRANSFORMATION", "R_TRANS_ATTRIBUTE", "R_JOB_ATTRIBUTE", "R_TRANS_CLUSTER", "R_TRANS_HOP", "R_TRANS_NOTE", "R_TRANS_PARTITION_SCHEMA", "R_TRANS_SLAVE", "R_TRANS_STEP_CONDITION", "R_USER", "R_VALUE", "R_VERSION"};
    private static final int[] KEY_POSITIONS = new int[]{0, 1, 2};
    public static final int REQUIRED_MAJOR_VERSION = 3;
    public static final int REQUIRED_MINOR_VERSION = 2;
    private RepositoryMeta repinfo;
    public UserInfo userinfo;
    private RepositoryDirectory directoryTree;
    private RepositoryDirectory importBaseDirectory;
    private Database database;
    public LogWriter log;
    private String locksource;
    private PreparedStatement psStepAttributesLookup;
    private PreparedStatement psStepAttributesInsert;
    private PreparedStatement psTransAttributesLookup;
    private PreparedStatement psTransAttributesInsert;
    private PreparedStatement psJobAttributesLookup;
    private PreparedStatement psJobAttributesInsert;
    private List<Object[]> stepAttributesBuffer;
    private RowMetaInterface stepAttributesRowMeta;
    private PreparedStatement pstmt_entry_attributes;
    private int majorVersion;
    private int minorVersion;
    private DatabaseMeta databaseMeta;
    private boolean useBatchProcessing;
    public static final int REP_STRING_LENGTH = 2000000;
    public static final int REP_STRING_CODE_LENGTH = 255;
    public static final String TRANS_ATTRIBUTE_ID_STEP_REJECTED = "ID_STEP_REJECTED";
    public static final String TRANS_ATTRIBUTE_UNIQUE_CONNECTIONS = "UNIQUE_CONNECTIONS";
    public static final String TRANS_ATTRIBUTE_FEEDBACK_SHOWN = "FEEDBACK_SHOWN";
    public static final String TRANS_ATTRIBUTE_FEEDBACK_SIZE = "FEEDBACK_SIZE";
    public static final String TRANS_ATTRIBUTE_USING_THREAD_PRIORITIES = "USING_THREAD_PRIORITIES";
    public static final String TRANS_ATTRIBUTE_SHARED_FILE = "SHARED_FILE";
    public static final String TRANS_ATTRIBUTE_CAPTURE_STEP_PERFORMANCE = "CAPTURE_STEP_PERFORMANCE";
    public static final String TRANS_ATTRIBUTE_STEP_PERFORMANCE_CAPTURING_DELAY = "STEP_PERFORMANCE_CAPTURING_DELAY";
    public static final String TRANS_ATTRIBUTE_STEP_PERFORMANCE_LOG_TABLE = "STEP_PERFORMANCE_LOG_TABLE";
    public static final String TRANS_ATTRIBUTE_LOG_SIZE_LIMIT = "LOG_SIZE_LIMIT";
    public static final String TRANS_ATTRIBUTE_PARAM_KEY = "PARAM_KEY";
    public static final String TRANS_ATTRIBUTE_PARAM_DEFAULT = "PARAM_DEFAULT";
    public static final String TRANS_ATTRIBUTE_PARAM_DESCRIPTION = "PARAM_DESC";
    public static final String JOB_ATTRIBUTE_PARAM_KEY = "PARAM_KEY";
    public static final String JOB_ATTRIBUTE_PARAM_DEFAULT = "PARAM_DEFAULT";
    public static final String JOB_ATTRIBUTE_PARAM_DESCRIPTION = "PARAM_DESC";
    public static final String JOB_ATTRIBUTE_LOG_SIZE_LIMIT = "LOG_SIZE_LIMIT";
    private static Repository currentRepository;
    private RepositoryCreationHelper creationHelper;

    public Repository(LogWriter log, RepositoryMeta repinfo, UserInfo userinfo) {
        this.repinfo = repinfo;
        this.log = log;
        this.userinfo = userinfo;
        this.useBatchProcessing = true;
        this.database = new Database(repinfo.getConnection());
        this.databaseMeta = this.database.getDatabaseMeta();
        this.psStepAttributesLookup = null;
        this.psStepAttributesInsert = null;
        this.psTransAttributesLookup = null;
        this.pstmt_entry_attributes = null;
        this.majorVersion = 3;
        this.minorVersion = 2;
        this.directoryTree = null;
        this.creationHelper = new RepositoryCreationHelper(this);
    }

    public RepositoryMeta getRepositoryInfo() {
        return this.repinfo;
    }

    public UserInfo getUserInfo() {
        return this.userinfo;
    }

    public String getName() {
        if (this.repinfo == null) {
            return null;
        }
        return this.repinfo.getName();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public static final String getRequiredVersion() {
        return "3.2";
    }

    public String getLocksource() {
        return this.locksource;
    }

    public synchronized boolean connect(String locksource) throws KettleException {
        return this.connect(false, true, locksource, false);
    }

    public synchronized boolean connect(boolean no_lookup, boolean readDirectory, String locksource) throws KettleException {
        return this.connect(no_lookup, readDirectory, locksource, false);
    }

    public synchronized boolean connect(boolean no_lookup, boolean readDirectory, String locksource, boolean ignoreVersion) throws KettleException {
        if (this.repinfo.isLocked()) {
            this.log.logError(this.toString(), "Repository is locked by class " + locksource, new Object[0]);
            return false;
        }
        boolean retval = true;
        try {
            this.database.initializeVariablesFrom(null);
            this.database.connect();
            if (!ignoreVersion) {
                this.verifyVersion();
            }
            this.setAutoCommit(false);
            this.repinfo.setLock(true);
            this.locksource = locksource;
            if (!no_lookup) {
                try {
                    this.setLookupStepAttribute();
                    this.setLookupTransAttribute();
                    this.setLookupJobEntryAttribute();
                }
                catch (KettleException dbe) {
                    this.log.logError(this.toString(), "Error setting lookup prep.statements: " + dbe.getMessage(), new Object[0]);
                }
            }
            if (readDirectory) {
                try {
                    this.refreshRepositoryDirectoryTree();
                }
                catch (KettleException e) {
                    this.log.logError(this.toString(), e.toString(), new Object[0]);
                }
            } else {
                this.directoryTree = new RepositoryDirectory();
            }
            currentRepository = this;
        }
        catch (KettleException e) {
            retval = false;
            this.log.logError(this.toString(), "Error connecting to the repository!" + e.getMessage(), new Object[0]);
            throw new KettleException((Throwable)e);
        }
        return retval;
    }

    private void verifyVersion() throws KettleException {
        RowMetaAndData lastUpgrade = null;
        String versionTable = this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_VERSION);
        try {
            lastUpgrade = this.database.getOneRow("SELECT " + this.quote(FIELD_VERSION_MAJOR_VERSION) + ", " + this.quote(FIELD_VERSION_MINOR_VERSION) + ", " + this.quote(FIELD_VERSION_UPGRADE_DATE) + " FROM " + versionTable + " ORDER BY " + this.quote(FIELD_VERSION_UPGRADE_DATE) + " DESC");
        }
        catch (Exception e) {
            try {
                String userTable = this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER);
                this.database.getOneRow("SELECT * FROM " + userTable);
                if (this.log.isBasic()) {
                    this.log.logBasic(this.toString(), Messages.getString("Repository.Error.GettingInfoVersionTable", versionTable), new Object[0]);
                    this.log.logBasic(this.toString(), Messages.getString("Repository.Error.NewTable"), new Object[0]);
                    this.log.logBasic(this.toString(), "Stack trace: " + Const.getStackTracker((Throwable)e), new Object[0]);
                }
                this.majorVersion = 2;
                this.minorVersion = 2;
                lastUpgrade = null;
            }
            catch (Exception ex) {
                throw new KettleException(Messages.getString("Repository.NoRepositoryExists.Messages"));
            }
        }
        if (lastUpgrade != null) {
            this.majorVersion = (int)lastUpgrade.getInteger(FIELD_VERSION_MAJOR_VERSION, -1L);
            this.minorVersion = (int)lastUpgrade.getInteger(FIELD_VERSION_MINOR_VERSION, -1L);
        }
        if (this.majorVersion < 3 || this.majorVersion == 3 && this.minorVersion < 2) {
            throw new KettleException(Messages.getString("Repository.UpgradeRequired.Message", this.getVersion(), Repository.getRequiredVersion()));
        }
        if (this.majorVersion == 3 && this.minorVersion == 0) {
            String tableName = this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_PARTITION_SCHEMA);
            String errorColumn = "TRANSFORMATION";
            RowMetaInterface tableFields = this.database.getTableFields(tableName);
            if (tableFields.indexOfValue(errorColumn) >= 0) {
                throw new KettleException(Messages.getString("Repository.FixFor300Required.Message"));
            }
        }
    }

    public synchronized void refreshRepositoryDirectoryTree() throws KettleException {
        try {
            this.directoryTree = new RepositoryDirectory(this);
        }
        catch (KettleException e) {
            this.directoryTree = new RepositoryDirectory();
            throw new KettleException("Unable to read the directory tree from the repository!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        try {
            currentRepository = null;
            this.closeStepAttributeLookupPreparedStatement();
            this.closeTransAttributeLookupPreparedStatement();
            this.closeLookupJobEntryAttribute();
            if (!this.database.isAutoCommit()) {
                this.commit();
            }
            this.repinfo.setLock(false);
        }
        catch (KettleException dbe) {
            this.log.logError(this.toString(), "Error disconnecting from database : " + dbe.getMessage(), new Object[0]);
        }
        finally {
            this.database.disconnect();
        }
    }

    public synchronized void setAutoCommit(boolean autocommit) {
        if (!autocommit) {
            this.database.setCommit(99999999);
        } else {
            this.database.setCommit(0);
        }
    }

    public synchronized void commit() throws KettleException {
        try {
            if (!this.database.isAutoCommit()) {
                this.database.commit();
            }
            Counters.getInstance().clear();
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to commit repository connection", (Throwable)dbe);
        }
    }

    public synchronized void rollback() {
        try {
            this.database.rollback();
            Counters.getInstance().clear();
        }
        catch (KettleException dbe) {
            this.log.logError(this.toString(), "Error rolling back repository.", new Object[0]);
        }
    }

    public List<Object[]> getStepAttributesBuffer() {
        return this.stepAttributesBuffer;
    }

    public void setStepAttributesBuffer(List<Object[]> stepAttributesBuffer) {
        this.stepAttributesBuffer = stepAttributesBuffer;
    }

    public synchronized void fillStepAttributesBuffer(long id_transformation) throws KettleException {
        String sql = "SELECT " + this.quote("ID_STEP") + ", " + this.quote("CODE") + ", " + this.quote("NR") + ", " + this.quote("VALUE_NUM") + ", " + this.quote("VALUE_STR") + " " + "FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE) + " " + "WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation + " " + "ORDER BY " + this.quote("ID_STEP") + ", " + this.quote("CODE") + ", " + this.quote("NR");
        this.stepAttributesBuffer = this.database.getRows(sql, -1);
        this.stepAttributesRowMeta = this.database.getReturnRowMeta();
        Collections.sort(this.stepAttributesBuffer, new StepAttributeComparator());
    }

    private synchronized RowMetaAndData searchStepAttributeInBuffer(long id_step, String code, long nr) throws KettleValueException {
        int index = this.searchStepAttributeIndexInBuffer(id_step, code, nr);
        if (index < 0) {
            return null;
        }
        Object[] r = this.stepAttributesBuffer.get(index);
        return new RowMetaAndData(this.stepAttributesRowMeta, r);
    }

    private synchronized int searchStepAttributeIndexInBuffer(long id_step, String code, long nr) throws KettleValueException {
        Object[] key = new Object[]{new Long(id_step), code, new Long(nr)};
        int index = Collections.binarySearch(this.stepAttributesBuffer, key, new StepAttributeComparator());
        if (index >= this.stepAttributesBuffer.size() || index < 0) {
            return -1;
        }
        Object[] look = this.stepAttributesBuffer.get(index);
        if (this.stepAttributesRowMeta.compare(look, key, KEY_POSITIONS) == 0) {
            return index;
        }
        return -1;
    }

    private synchronized int searchNrStepAttributes(long id_step, String code) throws KettleValueException {
        int idx = this.searchStepAttributeIndexInBuffer(id_step, code, 0L);
        if (idx < 0) {
            return 0;
        }
        int nr = 1;
        int offset = 1;
        if (idx + offset >= this.stepAttributesBuffer.size()) {
            return 1;
        }
        Object[] look = this.stepAttributesBuffer.get(idx + offset);
        RowMetaInterface rowMeta = this.stepAttributesRowMeta;
        long lookID = rowMeta.getInteger(look, 0);
        String lookCode = rowMeta.getString(look, 1);
        while (lookID == id_step && code.equalsIgnoreCase(lookCode)) {
            nr = rowMeta.getInteger(look, 2).intValue() + 1;
            if (idx + ++offset < this.stepAttributesBuffer.size()) {
                look = this.stepAttributesBuffer.get(idx + offset);
                lookID = rowMeta.getInteger(look, 0);
                lookCode = rowMeta.getString(look, 1);
                continue;
            }
            return nr;
        }
        return nr;
    }

    public synchronized long getJobID(String name, long id_directory) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB), this.quote("ID_JOB"), this.quote("NAME"), name, this.quote("ID_DIRECTORY"), id_directory);
    }

    public synchronized long getTransformationID(String name, long id_directory) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION), this.quote("ID_TRANSFORMATION"), this.quote("NAME"), name, this.quote("ID_DIRECTORY"), id_directory);
    }

    public synchronized long getNoteID(String note) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_NOTE), this.quote("ID_NOTE"), this.quote("VALUE_STR"), note);
    }

    public synchronized long getDatabaseID(String name) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE), this.quote("ID_DATABASE"), this.quote("NAME"), name);
    }

    public synchronized long getPartitionSchemaID(String name) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA), this.quote("ID_PARTITION_SCHEMA"), this.quote("NAME"), name);
    }

    public synchronized long getSlaveID(String name) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE), this.quote("ID_SLAVE"), this.quote("NAME"), name);
    }

    public synchronized long getClusterID(String name) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER), this.quote("ID_CLUSTER"), this.quote("NAME"), name);
    }

    public synchronized long getDatabaseTypeID(String code) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_TYPE), this.quote("ID_DATABASE_TYPE"), this.quote("CODE"), code);
    }

    public synchronized long getDatabaseConTypeID(String code) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_CONTYPE), this.quote("ID_DATABASE_CONTYPE"), this.quote("CODE"), code);
    }

    public synchronized long getStepTypeID(String code) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_TYPE), this.quote("ID_STEP_TYPE"), this.quote("CODE"), code);
    }

    public synchronized long getJobEntryID(String name, long id_job) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY), this.quote("ID_JOBENTRY"), this.quote("NAME"), name, this.quote("ID_JOB"), id_job);
    }

    public synchronized long getJobEntryTypeID(String code) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_TYPE), this.quote("ID_JOBENTRY_TYPE"), this.quote("CODE"), code);
    }

    public synchronized long getStepID(String name, long id_transformation) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP), this.quote("ID_STEP"), this.quote("NAME"), name, this.quote("ID_TRANSFORMATION"), id_transformation);
    }

    public synchronized long getUserID(String login) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER), this.quote(FIELD_USER_ID_USER), this.quote(FIELD_USER_LOGIN), login);
    }

    public synchronized long getProfileID(String profilename) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE), this.quote("ID_PROFILE"), this.quote("NAME"), profilename);
    }

    public synchronized long getPermissionID(String code) throws KettleException {
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PERMISSION), this.quote("ID_PERMISSION"), this.quote("CODE"), code);
    }

    public synchronized long getTransHopID(long id_transformation, long id_step_from, long id_step_to) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_TRANSFORMATION"), this.quote(FIELD_TRANS_HOP_ID_STEP_FROM), this.quote(FIELD_TRANS_HOP_ID_STEP_TO)};
        long[] key = new long[]{id_transformation, id_step_from, id_step_to};
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP), this.quote(FIELD_TRANS_HOP_ID_TRANS_HOP), lookupkey, key);
    }

    public synchronized long getJobHopID(long id_job, long id_jobentry_copy_from, long id_jobentry_copy_to) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_JOB"), this.quote(FIELD_JOB_HOP_ID_JOBENTRY_COPY_FROM), this.quote(FIELD_JOB_HOP_ID_JOBENTRY_COPY_TO)};
        long[] key = new long[]{id_job, id_jobentry_copy_from, id_jobentry_copy_to};
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP), this.quote(FIELD_JOB_HOP_ID_JOB_HOP), lookupkey, key);
    }

    public synchronized long getDependencyID(long id_transformation, long id_database, String tablename) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_TRANSFORMATION"), this.quote("ID_DATABASE")};
        long[] key = new long[]{id_transformation, id_database};
        return this.getIDWithValue(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY), this.quote(FIELD_DEPENDENCY_ID_DEPENDENCY), this.quote(FIELD_DEPENDENCY_TABLE_NAME), tablename, lookupkey, key);
    }

    public synchronized long getRootDirectoryID() throws KettleException {
        RowMetaAndData result = this.database.getOneRow("SELECT " + this.quote("ID_DIRECTORY") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote(FIELD_DIRECTORY_ID_DIRECTORY_PARENT) + " = 0");
        if (result != null && result.isNumeric(0)) {
            return result.getInteger(0, -1L);
        }
        return -1L;
    }

    public synchronized int getNrSubDirectories(long id_directory) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote(FIELD_DIRECTORY_ID_DIRECTORY_PARENT) + " = " + id_directory;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized long[] getSubDirectoryIDs(long id_directory) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_DIRECTORY") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote(FIELD_DIRECTORY_ID_DIRECTORY_PARENT) + " = " + id_directory + " ORDER BY " + this.quote(FIELD_DIRECTORY_DIRECTORY_NAME));
    }

    private synchronized long getIDWithValue(String tablename, String idfield, String lookupfield, String value) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("value", 2), (Object)value);
        RowMetaAndData result = this.database.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ?", par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return result.getInteger(0, 0L);
        }
        return -1L;
    }

    private synchronized long getIDWithValue(String tablename, String idfield, String lookupfield, String value, String lookupkey, long key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("value", 2), (Object)value);
        par.addValue(new ValueMeta("key", 5), (Object)new Long(key));
        RowMetaAndData result = this.database.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? AND " + lookupkey + " = ?", par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return result.getInteger(0, 0L);
        }
        return -1L;
    }

    private synchronized long getIDWithValue(String tablename, String idfield, String[] lookupkey, long[] key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        String sql = "SELECT " + idfield + " FROM " + tablename + " ";
        for (int i = 0; i < lookupkey.length; ++i) {
            sql = i == 0 ? sql + "WHERE " : sql + "AND   ";
            par.addValue(new ValueMeta(lookupkey[i], 5), (Object)new Long(key[i]));
            sql = sql + lookupkey[i] + " = ? ";
        }
        RowMetaAndData result = this.database.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return result.getInteger(0, 0L);
        }
        return -1L;
    }

    private synchronized long getIDWithValue(String tablename, String idfield, String lookupfield, String value, String[] lookupkey, long[] key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta(lookupfield, 2), (Object)value);
        String sql = "SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? ";
        for (int i = 0; i < lookupkey.length; ++i) {
            par.addValue(new ValueMeta(lookupkey[i], 2), (Object)new Long(key[i]));
            sql = sql + "AND " + lookupkey[i] + " = ? ";
        }
        RowMetaAndData result = this.database.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return result.getInteger(0, 0L);
        }
        return -1L;
    }

    public synchronized String getDatabaseTypeCode(long id_database_type) throws KettleException {
        return this.getStringWithID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_TYPE), this.quote("ID_DATABASE_TYPE"), id_database_type, this.quote("CODE"));
    }

    public synchronized String getDatabaseConTypeCode(long id_database_contype) throws KettleException {
        return this.getStringWithID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_CONTYPE), this.quote("ID_DATABASE_CONTYPE"), id_database_contype, this.quote("CODE"));
    }

    public synchronized String getStepTypeCode(long id_database_type) throws KettleException {
        return this.getStringWithID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_TYPE), this.quote("ID_STEP_TYPE"), id_database_type, this.quote("CODE"));
    }

    private synchronized String getStringWithID(String tablename, String keyfield, long id, String fieldname) throws KettleException {
        String sql = "SELECT " + fieldname + " FROM " + tablename + " WHERE " + keyfield + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta(keyfield, 5), (Object)new Long(id));
        RowMetaAndData result = this.database.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getData() != null) {
            return result.getString(0, null);
        }
        return null;
    }

    public synchronized void moveTransformation(String transname, long id_directory_from, long id_directory_to) throws KettleException {
        String nameField = this.quote("NAME");
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION) + " SET " + this.quote("ID_DIRECTORY") + " = ? WHERE " + nameField + " = ? AND " + this.quote("ID_DIRECTORY") + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(id_directory_to));
        par.addValue(new ValueMeta("NAME", 2), (Object)transname);
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(id_directory_from));
        this.database.execStatement(sql, par.getRowMeta(), par.getData());
    }

    public synchronized void moveJob(String jobname, long id_directory_from, long id_directory_to) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " SET " + this.quote("ID_DIRECTORY") + " = ? WHERE " + this.quote("NAME") + " = ? AND " + this.quote("ID_DIRECTORY") + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(id_directory_to));
        par.addValue(new ValueMeta("NAME", 2), (Object)jobname);
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(id_directory_from));
        this.database.execStatement(sql, par.getRowMeta(), par.getData());
    }

    public synchronized long getNextTransformationID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION), this.quote("ID_TRANSFORMATION"));
    }

    public synchronized long getNextJobID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB), this.quote("ID_JOB"));
    }

    public synchronized long getNextNoteID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_NOTE), this.quote("ID_NOTE"));
    }

    public synchronized long getNextLogID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_REPOSITORY_LOG), this.quote(FIELD_REPOSITORY_LOG_ID_REPOSITORY_LOG));
    }

    public synchronized long getNextDatabaseID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE), this.quote("ID_DATABASE"));
    }

    public synchronized long getNextDatabaseTypeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_TYPE), this.quote("ID_DATABASE_TYPE"));
    }

    public synchronized long getNextDatabaseConnectionTypeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_CONTYPE), this.quote("ID_DATABASE_CONTYPE"));
    }

    public synchronized long getNextLoglevelID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_LOGLEVEL), this.quote("ID_LOGLEVEL"));
    }

    public synchronized long getNextStepTypeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_TYPE), this.quote("ID_STEP_TYPE"));
    }

    public synchronized long getNextStepID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP), this.quote("ID_STEP"));
    }

    public synchronized long getNextJobEntryID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY), this.quote("ID_JOBENTRY"));
    }

    public synchronized long getNextJobEntryTypeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_TYPE), this.quote("ID_JOBENTRY_TYPE"));
    }

    public synchronized long getNextJobEntryCopyID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY), this.quote(FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY));
    }

    public synchronized long getNextStepAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE), this.quote(FIELD_STEP_ATTRIBUTE_ID_STEP_ATTRIBUTE));
    }

    public synchronized long getNextTransAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_ATTRIBUTE), this.quote(FIELD_TRANS_ATTRIBUTE_ID_TRANS_ATTRIBUTE));
    }

    public synchronized long getNextJobAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_ATTRIBUTE), this.quote(FIELD_JOB_ATTRIBUTE_ID_JOB_ATTRIBUTE));
    }

    public synchronized long getNextDatabaseAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE), this.quote(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE));
    }

    public synchronized long getNextTransHopID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP), this.quote(FIELD_TRANS_HOP_ID_TRANS_HOP));
    }

    public synchronized long getNextJobHopID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP), this.quote(FIELD_JOB_HOP_ID_JOB_HOP));
    }

    public synchronized long getNextDepencencyID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY), this.quote(FIELD_DEPENDENCY_ID_DEPENDENCY));
    }

    public synchronized long getNextPartitionSchemaID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA), this.quote("ID_PARTITION_SCHEMA"));
    }

    public synchronized long getNextPartitionID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION), this.quote(FIELD_PARTITION_ID_PARTITION));
    }

    public synchronized long getNextTransformationPartitionSchemaID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_PARTITION_SCHEMA), this.quote(FIELD_TRANS_PARTITION_SCHEMA_ID_TRANS_PARTITION_SCHEMA));
    }

    public synchronized long getNextClusterID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER), this.quote("ID_CLUSTER"));
    }

    public synchronized long getNextSlaveServerID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE), this.quote("ID_SLAVE"));
    }

    public synchronized long getNextClusterSlaveID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER_SLAVE), this.quote(FIELD_CLUSTER_SLAVE_ID_CLUSTER_SLAVE));
    }

    public synchronized long getNextTransformationSlaveID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_SLAVE), this.quote(FIELD_TRANS_SLAVE_ID_TRANS_SLAVE));
    }

    public synchronized long getNextTransformationClusterID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_CLUSTER), this.quote(FIELD_TRANS_CLUSTER_ID_TRANS_CLUSTER));
    }

    public synchronized long getNextConditionID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CONDITION), this.quote("ID_CONDITION"));
    }

    public synchronized long getNextValueID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_VALUE), this.quote(FIELD_VALUE_ID_VALUE));
    }

    public synchronized long getNextUserID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER), this.quote(FIELD_USER_ID_USER));
    }

    public synchronized long getNextProfileID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE), this.quote("ID_PROFILE"));
    }

    public synchronized long getNextPermissionID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PERMISSION), this.quote("ID_PERMISSION"));
    }

    public synchronized long getNextJobEntryAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_ATTRIBUTE), this.quote(FIELD_JOBENTRY_ATTRIBUTE_ID_JOBENTRY_ATTRIBUTE));
    }

    public synchronized long getNextID(String tableName, String fieldName) throws KettleException {
        String counterName = tableName + "." + fieldName;
        Counter counter = Counters.getInstance().getCounter(counterName);
        if (counter == null) {
            long id = this.getNextTableID(tableName, fieldName);
            counter = new Counter(id);
            Counters.getInstance().setCounter(counterName, counter);
            return counter.next();
        }
        return counter.next();
    }

    public synchronized void clearNextIDCounters() {
        Counters.getInstance().clear();
    }

    public synchronized long getNextDirectoryID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY), this.quote("ID_DIRECTORY"));
    }

    private synchronized long getNextTableID(String tablename, String idfield) throws KettleException {
        long retval = -1L;
        RowMetaAndData r = this.database.getOneRow("SELECT MAX(" + idfield + ") FROM " + tablename);
        if (r != null) {
            Long id = r.getInteger(0);
            if (id == null) {
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), "no max(" + idfield + ") found in table " + tablename, new Object[0]);
                }
                retval = 1L;
            } else {
                if (this.log.isDebug()) {
                    this.log.logDebug(this.toString(), "max(" + idfield + ") found in table " + tablename + " --> " + idfield + " number: " + id, new Object[0]);
                }
                retval = id + 1L;
            }
        }
        return retval;
    }

    public synchronized void insertTransformation(TransMeta transMeta) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(transMeta.getId()));
        table.addValue(new ValueMeta("NAME", 2), (Object)transMeta.getName());
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)transMeta.getDescription());
        table.addValue(new ValueMeta("EXTENDED_DESCRIPTION", 2), (Object)transMeta.getExtendedDescription());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_TRANS_VERSION, 2), (Object)transMeta.getTransversion());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_TRANS_STATUS, 5), (Object)new Long(transMeta.getTransstatus() < 0 ? -1L : (long)transMeta.getTransstatus()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_STEP_READ, 5), (Object)new Long(transMeta.getReadStep() == null ? -1L : transMeta.getReadStep().getID()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_STEP_WRITE, 5), (Object)new Long(transMeta.getWriteStep() == null ? -1L : transMeta.getWriteStep().getID()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_STEP_INPUT, 5), (Object)new Long(transMeta.getInputStep() == null ? -1L : transMeta.getInputStep().getID()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_STEP_OUTPUT, 5), (Object)new Long(transMeta.getOutputStep() == null ? -1L : transMeta.getOutputStep().getID()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_STEP_UPDATE, 5), (Object)new Long(transMeta.getUpdateStep() == null ? -1L : transMeta.getUpdateStep().getID()));
        table.addValue(new ValueMeta("ID_DATABASE_LOG", 5), (Object)new Long(transMeta.getLogConnection() == null ? -1L : transMeta.getLogConnection().getID()));
        table.addValue(new ValueMeta("TABLE_NAME_LOG", 2), (Object)transMeta.getLogTable());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_USE_BATCHID, 4), (Object)transMeta.isBatchIdUsed());
        table.addValue(new ValueMeta("USE_LOGFIELD", 4), (Object)transMeta.isLogfieldUsed());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_ID_DATABASE_MAXDATE, 5), (Object)new Long(transMeta.getMaxDateConnection() == null ? -1L : transMeta.getMaxDateConnection().getID()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_TABLE_NAME_MAXDATE, 2), (Object)transMeta.getMaxDateTable());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_FIELD_NAME_MAXDATE, 2), (Object)transMeta.getMaxDateField());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_OFFSET_MAXDATE, 1), (Object)new Double(transMeta.getMaxDateOffset()));
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_DIFF_MAXDATE, 1), (Object)new Double(transMeta.getMaxDateDifference()));
        table.addValue(new ValueMeta("CREATED_USER", 2), (Object)transMeta.getCreatedUser());
        table.addValue(new ValueMeta("CREATED_DATE", 3), (Object)transMeta.getCreatedDate());
        table.addValue(new ValueMeta("MODIFIED_USER", 2), (Object)transMeta.getModifiedUser());
        table.addValue(new ValueMeta("MODIFIED_DATE", 3), (Object)transMeta.getModifiedDate());
        table.addValue(new ValueMeta(FIELD_TRANSFORMATION_SIZE_ROWSET, 5), (Object)new Long(transMeta.getSizeRowset()));
        table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(transMeta.getDirectory().getID()));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANSFORMATION);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        if (transMeta.getRejectedStep() != null) {
            this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_ID_STEP_REJECTED, transMeta.getRejectedStep().getID(), null);
        }
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_UNIQUE_CONNECTIONS, 0L, transMeta.isUsingUniqueConnections() ? "Y" : "N");
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_FEEDBACK_SHOWN, 0L, transMeta.isFeedbackShown() ? "Y" : "N");
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_FEEDBACK_SIZE, transMeta.getFeedbackSize(), "");
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_USING_THREAD_PRIORITIES, 0L, transMeta.isUsingThreadPriorityManagment() ? "Y" : "N");
        this.insertTransAttribute(transMeta.getId(), 0L, "SHARED_FILE", 0L, transMeta.getSharedObjectsFile());
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_CAPTURE_STEP_PERFORMANCE, 0L, transMeta.isCapturingStepPerformanceSnapShots() ? "Y" : "N");
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_STEP_PERFORMANCE_CAPTURING_DELAY, transMeta.getStepPerformanceCapturingDelay(), "");
        this.insertTransAttribute(transMeta.getId(), 0L, TRANS_ATTRIBUTE_STEP_PERFORMANCE_LOG_TABLE, 0L, transMeta.getStepPerformanceLogTable());
        this.insertTransAttribute(transMeta.getId(), 0L, "LOG_SIZE_LIMIT", 0L, transMeta.getLogSizeLimit());
        if (transMeta.getLogConnection() != null) {
            this.insertStepDatabase(transMeta.getId(), -1L, transMeta.getLogConnection().getID());
        }
        if (transMeta.getMaxDateConnection() != null) {
            this.insertStepDatabase(transMeta.getId(), -1L, transMeta.getMaxDateConnection().getID());
        }
    }

    public synchronized void insertJob(JobMeta jobMeta) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)jobMeta.getID());
        table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)jobMeta.getDirectory().getID());
        table.addValue(new ValueMeta("NAME", 2), (Object)jobMeta.getName());
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)jobMeta.getDescription());
        table.addValue(new ValueMeta("EXTENDED_DESCRIPTION", 2), (Object)jobMeta.getExtendedDescription());
        table.addValue(new ValueMeta(FIELD_JOB_JOB_VERSION, 2), (Object)jobMeta.getJobversion());
        table.addValue(new ValueMeta(FIELD_JOB_JOB_STATUS, 5), (Object)new Long(jobMeta.getJobstatus() < 0 ? -1L : (long)jobMeta.getJobstatus()));
        table.addValue(new ValueMeta("ID_DATABASE_LOG", 5), (Object)(jobMeta.getLogConnection() != null ? jobMeta.getLogConnection().getID() : -1L));
        table.addValue(new ValueMeta("TABLE_NAME_LOG", 2), (Object)jobMeta.getLogTable());
        table.addValue(new ValueMeta("CREATED_USER", 2), (Object)jobMeta.getCreatedUser());
        table.addValue(new ValueMeta("CREATED_DATE", 3), (Object)jobMeta.getCreatedDate());
        table.addValue(new ValueMeta("MODIFIED_USER", 2), (Object)jobMeta.getModifiedUser());
        table.addValue(new ValueMeta("MODIFIED_DATE", 3), (Object)jobMeta.getModifiedDate());
        table.addValue(new ValueMeta(FIELD_JOB_USE_BATCH_ID, 4), (Object)jobMeta.isBatchIdUsed());
        table.addValue(new ValueMeta(FIELD_JOB_PASS_BATCH_ID, 4), (Object)jobMeta.isBatchIdPassed());
        table.addValue(new ValueMeta("USE_LOGFIELD", 4), (Object)jobMeta.isLogfieldUsed());
        table.addValue(new ValueMeta("SHARED_FILE", 2), (Object)jobMeta.getSharedObjectsFile());
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOB);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "Inserted new record into table " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " with data : " + table, new Object[0]);
        }
        this.database.closeInsert();
        this.insertJobAttribute(jobMeta.getID(), 0L, "LOG_SIZE_LIMIT", 0L, jobMeta.getLogSizeLimit());
    }

    public synchronized long insertNote(String note, long gui_location_x, long gui_location_y, long gui_location_width, long gui_location_height) throws KettleException {
        long id = this.getNextNoteID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_NOTE", 5), (Object)new Long(id));
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)note);
        table.addValue(new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue(new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue(new ValueMeta(FIELD_NOTE_GUI_LOCATION_WIDTH, 5), (Object)new Long(gui_location_width));
        table.addValue(new ValueMeta(FIELD_NOTE_GUI_LOCATION_HEIGHT, 5), (Object)new Long(gui_location_height));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_NOTE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertLogEntry(String description) throws KettleException {
        long id = this.getNextLogID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_REPOSITORY_LOG_ID_REPOSITORY_LOG, 5), (Object)new Long(id));
        table.addValue(new ValueMeta(FIELD_REPOSITORY_LOG_REP_VERSION, 2), (Object)this.getVersion());
        table.addValue(new ValueMeta(FIELD_REPOSITORY_LOG_LOG_DATE, 3), (Object)new Date());
        table.addValue(new ValueMeta(FIELD_REPOSITORY_LOG_LOG_USER, 2), (Object)(this.userinfo != null ? this.userinfo.getLogin() : "admin"));
        table.addValue(new ValueMeta(FIELD_REPOSITORY_LOG_OPERATION_DESC, 2), (Object)description);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_REPOSITORY_LOG);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void insertTransNote(long id_transformation, long id_note) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_NOTE", 5), (Object)new Long(id_note));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANS_NOTE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public synchronized void insertJobNote(long id_job, long id_note) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("ID_NOTE", 5), (Object)new Long(id_note));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOB_NOTE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public synchronized long insertDatabase(String name, String type, String access, String host, String dbname, String port, String user, String pass, String servername, String data_tablespace, String index_tablespace) throws KettleException {
        long id = this.getNextDatabaseID();
        long id_database_type = this.getDatabaseTypeID(type);
        if (id_database_type < 0L) {
            id_database_type = this.getNextDatabaseTypeID();
            String tablename = TABLE_R_DATABASE_TYPE;
            RowMeta tableMeta = new RowMeta();
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, 5, 0));
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
            this.database.prepareInsert((RowMetaInterface)tableMeta, tablename);
            Object[] tableData = new Object[3];
            int tableIndex = 0;
            tableData[tableIndex++] = new Long(id_database_type);
            tableData[tableIndex++] = type;
            tableData[tableIndex++] = type;
            this.database.setValuesInsert((RowMetaInterface)tableMeta, tableData);
            this.database.insertRow();
            this.database.closeInsert();
        }
        long id_database_contype = this.getDatabaseConTypeID(access);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)new Long(id));
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("ID_DATABASE_TYPE", 5), (Object)new Long(id_database_type));
        table.addValue(new ValueMeta("ID_DATABASE_CONTYPE", 5), (Object)new Long(id_database_contype));
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)host);
        table.addValue(new ValueMeta(FIELD_DATABASE_DATABASE_NAME, 2), (Object)dbname);
        table.addValue(new ValueMeta("PORT", 5), (Object)new Long(Const.toInt((String)port, (int)-1)));
        table.addValue(new ValueMeta("USERNAME", 2), (Object)user);
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)pass));
        table.addValue(new ValueMeta(FIELD_DATABASE_SERVERNAME, 2), (Object)servername);
        table.addValue(new ValueMeta(FIELD_DATABASE_DATA_TBS, 2), (Object)data_tablespace);
        table.addValue(new ValueMeta(FIELD_DATABASE_INDEX_TBS, 2), (Object)index_tablespace);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_DATABASE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertStep(long id_transformation, String name, String description, String steptype, boolean distribute, long copies, long gui_location_x, long gui_location_y, boolean gui_draw) throws KettleException {
        long id = this.getNextStepID();
        long id_step_type = this.getStepTypeID(steptype);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)description);
        table.addValue(new ValueMeta("ID_STEP_TYPE", 5), (Object)new Long(id_step_type));
        table.addValue(new ValueMeta(FIELD_STEP_DISTRIBUTE, 4), (Object)distribute);
        table.addValue(new ValueMeta(FIELD_STEP_COPIES, 5), (Object)new Long(copies));
        table.addValue(new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue(new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue(new ValueMeta("GUI_DRAW", 4), (Object)gui_draw);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_STEP);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertStepAttribute(long id_transformation, long id_step, long nr, String code, double value_num, String value_str) throws KettleException {
        long id = this.getNextStepAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_STEP_ATTRIBUTE_ID_STEP_ATTRIBUTE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id_step));
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_NUM", 1), (Object)new Double(value_num));
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        if (this.psStepAttributesInsert == null) {
            String sql = this.database.getInsertStatement(TABLE_R_STEP_ATTRIBUTE, table.getRowMeta());
            this.psStepAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psStepAttributesInsert);
        this.database.insertRow(this.psStepAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "saved attribute [" + code + "]", new Object[0]);
        }
        return id;
    }

    public synchronized long insertTransAttribute(long id_transformation, long nr, String code, long value_num, String value_str) throws KettleException {
        long id = this.getNextTransAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_TRANS_ATTRIBUTE_ID_TRANS_ATTRIBUTE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_NUM", 5), (Object)new Long(value_num));
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        if (this.psTransAttributesInsert == null) {
            String sql = this.database.getInsertStatement(TABLE_R_TRANS_ATTRIBUTE, table.getRowMeta());
            this.psTransAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psTransAttributesInsert);
        this.database.insertRow(this.psTransAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "saved transformation attribute [" + code + "]", new Object[0]);
        }
        return id;
    }

    public synchronized long insertJobAttribute(long id_job, long nr, String code, long value_num, String value_str) throws KettleException {
        long id = this.getNextJobAttributeID();
        System.out.println("Insert job attribute : id_job=" + id_job + ", code=" + code + ", value_str=" + value_str);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_JOB_ATTRIBUTE_ID_JOB_ATTRIBUTE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_NUM", 5), (Object)new Long(value_num));
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        if (this.psJobAttributesInsert == null) {
            String sql = this.database.getInsertStatement(TABLE_R_JOB_ATTRIBUTE, table.getRowMeta());
            this.psJobAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psJobAttributesInsert);
        this.database.insertRow(this.psJobAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "saved job attribute [" + code + "]", new Object[0]);
        }
        return id;
    }

    public synchronized void insertStepDatabase(long id_transformation, long id_step, long id_database) throws KettleException {
        RowMetaAndData check = this.getStepDatabase(id_step);
        if (check == null) {
            RowMetaAndData table = new RowMetaAndData();
            table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
            table.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id_step));
            table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)new Long(id_database));
            this.database.insertRow(TABLE_R_STEP_DATABASE, table.getRowMeta(), table.getData());
        }
    }

    public synchronized long insertDatabaseAttribute(long id_database, String code, String value_str) throws KettleException {
        long id = this.getNextDatabaseAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)new Long(id_database));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_DATABASE_ATTRIBUTE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), "saved database attribute [" + code + "]", new Object[0]);
        }
        return id;
    }

    public synchronized long insertJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, double value_num, String value_str) throws KettleException {
        long id = this.getNextJobEntryAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_JOBENTRY_ATTRIBUTE_ID_JOBENTRY_ATTRIBUTE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)new Long(id_jobentry));
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_NUM", 1), (Object)new Double(value_num));
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOBENTRY_ATTRIBUTE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertTransHop(long id_transformation, long id_step_from, long id_step_to, boolean enabled) throws KettleException {
        long id = this.getNextTransHopID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_TRANS_HOP_ID_TRANS_HOP, 5), (Object)id);
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)id_transformation);
        table.addValue(new ValueMeta(FIELD_TRANS_HOP_ID_STEP_FROM, 5), (Object)id_step_from);
        table.addValue(new ValueMeta(FIELD_TRANS_HOP_ID_STEP_TO, 5), (Object)id_step_to);
        table.addValue(new ValueMeta("ENABLED", 4), (Object)enabled);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANS_HOP);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertJobHop(long id_job, long id_jobentry_copy_from, long id_jobentry_copy_to, boolean enabled, boolean evaluation, boolean unconditional) throws KettleException {
        long id = this.getNextJobHopID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_JOB_HOP_ID_JOB_HOP, 5), (Object)id);
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)id_job);
        table.addValue(new ValueMeta(FIELD_JOB_HOP_ID_JOBENTRY_COPY_FROM, 5), (Object)id_jobentry_copy_from);
        table.addValue(new ValueMeta(FIELD_JOB_HOP_ID_JOBENTRY_COPY_TO, 5), (Object)id_jobentry_copy_to);
        table.addValue(new ValueMeta("ENABLED", 4), (Object)enabled);
        table.addValue(new ValueMeta(FIELD_JOB_HOP_EVALUATION, 4), (Object)evaluation);
        table.addValue(new ValueMeta(FIELD_JOB_HOP_UNCONDITIONAL, 4), (Object)unconditional);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOB_HOP);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertDependency(long id_transformation, long id_database, String tablename, String fieldname) throws KettleException {
        long id = this.getNextDepencencyID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_DEPENDENCY_ID_DEPENDENCY, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)new Long(id_database));
        table.addValue(new ValueMeta(FIELD_DEPENDENCY_TABLE_NAME, 2), (Object)tablename);
        table.addValue(new ValueMeta(FIELD_DEPENDENCY_FIELD_NAME, 2), (Object)fieldname);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_DEPENDENCY);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertPartitionSchema(PartitionSchema partitionSchema) throws KettleException {
        long id = this.getNextPartitionSchemaID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)new Long(id));
        table.addValue(new ValueMeta("NAME", 2), (Object)partitionSchema.getName());
        table.addValue(new ValueMeta(FIELD_PARTITION_SCHEMA_DYNAMIC_DEFINITION, 4), (Object)partitionSchema.isDynamicallyDefined());
        table.addValue(new ValueMeta(FIELD_PARTITION_SCHEMA_PARTITIONS_PER_SLAVE, 2), (Object)partitionSchema.getNumberOfPartitionsPerSlave());
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_PARTITION_SCHEMA);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void updatePartitionSchema(PartitionSchema partitionSchema) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)partitionSchema.getName());
        table.addValue(new ValueMeta(FIELD_PARTITION_SCHEMA_DYNAMIC_DEFINITION, 4), (Object)partitionSchema.isDynamicallyDefined());
        table.addValue(new ValueMeta(FIELD_PARTITION_SCHEMA_PARTITIONS_PER_SLAVE, 2), (Object)partitionSchema.getNumberOfPartitionsPerSlave());
        this.updateTableRow(TABLE_R_PARTITION_SCHEMA, "ID_PARTITION_SCHEMA", table, partitionSchema.getId());
    }

    public synchronized long insertPartition(long id_partition_schema, String partition_id) throws KettleException {
        long id = this.getNextPartitionID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_PARTITION_ID_PARTITION, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)new Long(id_partition_schema));
        table.addValue(new ValueMeta(FIELD_PARTITION_PARTITION_ID, 2), (Object)partition_id);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_PARTITION);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertTransformationPartitionSchema(long id_transformation, long id_partition_schema) throws KettleException {
        long id = this.getNextTransformationPartitionSchemaID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_TRANS_PARTITION_SCHEMA_ID_TRANS_PARTITION_SCHEMA, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_PARTITION_SCHEMA", 5), (Object)new Long(id_partition_schema));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANS_PARTITION_SCHEMA);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertCluster(ClusterSchema clusterSchema) throws KettleException {
        long id = this.getNextClusterID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_CLUSTER", 5), (Object)id);
        table.addValue(new ValueMeta("NAME", 2), (Object)clusterSchema.getName());
        table.addValue(new ValueMeta(FIELD_CLUSTER_BASE_PORT, 2), (Object)clusterSchema.getBasePort());
        table.addValue(new ValueMeta(FIELD_CLUSTER_SOCKETS_BUFFER_SIZE, 2), (Object)clusterSchema.getSocketsBufferSize());
        table.addValue(new ValueMeta(FIELD_CLUSTER_SOCKETS_FLUSH_INTERVAL, 2), (Object)clusterSchema.getSocketsFlushInterval());
        table.addValue(new ValueMeta(FIELD_CLUSTER_SOCKETS_COMPRESSED, 4), (Object)clusterSchema.isSocketsCompressed());
        table.addValue(new ValueMeta(FIELD_CLUSTER_DYNAMIC, 4), (Object)clusterSchema.isDynamic());
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_CLUSTER);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertSlave(SlaveServer slaveServer) throws KettleException {
        long id = this.getNextSlaveServerID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_SLAVE", 5), (Object)id);
        table.addValue(new ValueMeta("NAME", 2), (Object)slaveServer.getName());
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)slaveServer.getHostname());
        table.addValue(new ValueMeta("PORT", 2), (Object)slaveServer.getPort());
        table.addValue(new ValueMeta("USERNAME", 2), (Object)slaveServer.getUsername());
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)slaveServer.getPassword());
        table.addValue(new ValueMeta(FIELD_SLAVE_PROXY_HOST_NAME, 2), (Object)slaveServer.getProxyHostname());
        table.addValue(new ValueMeta(FIELD_SLAVE_PROXY_PORT, 2), (Object)slaveServer.getProxyPort());
        table.addValue(new ValueMeta(FIELD_SLAVE_NON_PROXY_HOSTS, 2), (Object)slaveServer.getNonProxyHosts());
        table.addValue(new ValueMeta(FIELD_SLAVE_MASTER, 4), (Object)slaveServer.isMaster());
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_SLAVE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void updateSlave(SlaveServer slaveServer) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)slaveServer.getName());
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)slaveServer.getHostname());
        table.addValue(new ValueMeta("PORT", 2), (Object)slaveServer.getPort());
        table.addValue(new ValueMeta("USERNAME", 2), (Object)slaveServer.getUsername());
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)slaveServer.getPassword());
        table.addValue(new ValueMeta(FIELD_SLAVE_PROXY_HOST_NAME, 2), (Object)slaveServer.getProxyHostname());
        table.addValue(new ValueMeta(FIELD_SLAVE_PROXY_PORT, 2), (Object)slaveServer.getProxyPort());
        table.addValue(new ValueMeta(FIELD_SLAVE_NON_PROXY_HOSTS, 2), (Object)slaveServer.getNonProxyHosts());
        table.addValue(new ValueMeta(FIELD_SLAVE_MASTER, 4), (Object)slaveServer.isMaster());
        this.updateTableRow(TABLE_R_SLAVE, "ID_SLAVE", table, slaveServer.getId());
    }

    public synchronized long insertClusterSlave(ClusterSchema clusterSchema, SlaveServer slaveServer) throws KettleException {
        long id = this.getNextClusterSlaveID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_CLUSTER_SLAVE_ID_CLUSTER_SLAVE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_CLUSTER", 5), (Object)new Long(clusterSchema.getId()));
        table.addValue(new ValueMeta("ID_SLAVE", 5), (Object)new Long(slaveServer.getId()));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_CLUSTER_SLAVE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertTransformationCluster(long id_transformation, long id_cluster) throws KettleException {
        long id = this.getNextTransformationClusterID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_TRANS_CLUSTER_ID_TRANS_CLUSTER, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_CLUSTER", 5), (Object)new Long(id_cluster));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANS_CLUSTER);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertTransformationSlave(long id_transformation, long id_slave) throws KettleException {
        long id = this.getNextTransformationSlaveID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_TRANS_SLAVE_ID_TRANS_SLAVE, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_SLAVE", 5), (Object)new Long(id_slave));
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_TRANS_SLAVE);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertCondition(long id_condition_parent, Condition condition) throws KettleException {
        long id = this.getNextConditionID();
        String tablename = TABLE_R_CONDITION;
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_CONDITION", 5), (Object)id);
        table.addValue(new ValueMeta(FIELD_CONDITION_ID_CONDITION_PARENT, 5), (Object)id_condition_parent);
        table.addValue(new ValueMeta(FIELD_CONDITION_NEGATED, 4), (Object)condition.isNegated());
        table.addValue(new ValueMeta(FIELD_CONDITION_OPERATOR, 2), (Object)condition.getOperatorDesc());
        table.addValue(new ValueMeta(FIELD_CONDITION_LEFT_NAME, 2), (Object)condition.getLeftValuename());
        table.addValue(new ValueMeta(FIELD_CONDITION_CONDITION_FUNCTION, 2), (Object)condition.getFunctionDesc());
        table.addValue(new ValueMeta(FIELD_CONDITION_RIGHT_NAME, 2), (Object)condition.getRightValuename());
        long id_value = -1L;
        ValueMetaAndData v = condition.getRightExact();
        if (v != null) {
            ValueMetaInterface valueMeta = v.getValueMeta();
            valueMeta.setDecimalSymbol(".");
            valueMeta.setGroupingSymbol(",");
            switch (valueMeta.getType()) {
                case 1: {
                    valueMeta.setConversionMask("#.#");
                    break;
                }
                case 5: {
                    valueMeta.setConversionMask("#");
                    break;
                }
                case 3: {
                    valueMeta.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
                    break;
                }
            }
            String stringValue = valueMeta.getString(v.getValueData());
            id_value = this.insertValue(valueMeta.getName(), valueMeta.getTypeDesc(), stringValue, valueMeta.isNull(v.getValueData()), condition.getRightExactID());
            condition.setRightExactID(id_value);
        }
        table.addValue(new ValueMeta(FIELD_CONDITION_ID_VALUE_RIGHT, 5), (Object)new Long(id_value));
        this.database.prepareInsert(table.getRowMeta(), tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void insertTransStepCondition(long id_transformation, long id_step, long id_condition) throws KettleException {
        String tablename = TABLE_R_TRANS_STEP_CONDITION;
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id_step));
        table.addValue(new ValueMeta("ID_CONDITION", 5), (Object)new Long(id_condition));
        this.database.prepareInsert(table.getRowMeta(), tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public synchronized long insertDirectory(long id_directory_parent, RepositoryDirectory dir) throws KettleException {
        long id = this.getNextDirectoryID();
        String tablename = TABLE_R_DIRECTORY;
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)new Long(id));
        table.addValue(new ValueMeta(FIELD_DIRECTORY_ID_DIRECTORY_PARENT, 5), (Object)new Long(id_directory_parent));
        table.addValue(new ValueMeta(FIELD_DIRECTORY_DIRECTORY_NAME, 2), (Object)dir.getDirectoryName());
        this.database.prepareInsert(table.getRowMeta(), tablename);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void deleteDirectory(long id_directory) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory;
        this.database.execStatement(sql);
    }

    public synchronized void renameDirectory(long id_directory, String name) throws KettleException {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue(new ValueMeta(FIELD_DIRECTORY_DIRECTORY_NAME, 2), (Object)name);
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " SET " + this.quote(FIELD_DIRECTORY_DIRECTORY_NAME) + " = ? WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory;
        this.log.logBasic(this.toString(), "sql = [" + sql + "]", new Object[0]);
        this.log.logBasic(this.toString(), "row = [" + r + "]", new Object[0]);
        this.database.execStatement(sql, r.getRowMeta(), r.getData());
    }

    public synchronized long lookupValue(String name, String type, String value_str, boolean isnull) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta(FIELD_VALUE_VALUE_TYPE, 2), (Object)type);
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        table.addValue(new ValueMeta(FIELD_VALUE_IS_NULL, 4), (Object)isnull);
        String sql = "SELECT " + this.quote(FIELD_VALUE_ID_VALUE) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_VALUE) + " ";
        sql = sql + "WHERE " + this.quote("NAME") + "       = ? ";
        sql = sql + "AND   " + this.quote(FIELD_VALUE_VALUE_TYPE) + " = ? ";
        sql = sql + "AND   " + this.quote("VALUE_STR") + "  = ? ";
        sql = sql + "AND   " + this.quote(FIELD_VALUE_IS_NULL) + "    = ? ";
        RowMetaAndData result = this.database.getOneRow(sql, table.getRowMeta(), table.getData());
        if (result != null && result.getData() != null && result.isNumeric(0)) {
            return result.getInteger(0, 0L);
        }
        return -1L;
    }

    public synchronized long insertValue(String name, String type, String value_str, boolean isnull, long id_value_prev) throws KettleException {
        long id_value = this.lookupValue(name, type, value_str, isnull);
        if (id_value < 0L) {
            id_value = this.getNextValueID();
            String tablename = TABLE_R_VALUE;
            RowMetaAndData table = new RowMetaAndData();
            table.addValue(new ValueMeta(FIELD_VALUE_ID_VALUE, 5), (Object)id_value);
            table.addValue(new ValueMeta("NAME", 2), (Object)name);
            table.addValue(new ValueMeta(FIELD_VALUE_VALUE_TYPE, 2), (Object)type);
            table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
            table.addValue(new ValueMeta(FIELD_VALUE_IS_NULL, 4), (Object)isnull);
            this.database.prepareInsert(table.getRowMeta(), tablename);
            this.database.setValuesInsert(table);
            this.database.insertRow();
            this.database.closeInsert();
        }
        return id_value;
    }

    public synchronized long insertJobEntry(long id_job, JobEntryBase jobEntryBase) throws KettleException {
        long id = this.getNextJobEntryID();
        long id_jobentry_type = this.getJobEntryTypeID(jobEntryBase.getTypeCode());
        this.log.logDebug(this.toString(), "ID_JobEntry_type = " + id_jobentry_type + " for type = [" + jobEntryBase.getTypeCode() + "]", new Object[0]);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)new Long(id_jobentry_type));
        table.addValue(new ValueMeta("NAME", 2), (Object)jobEntryBase.getName());
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)jobEntryBase.getDescription());
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOBENTRY);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized long insertJobEntryCopy(long id_job, long id_jobentry, long id_jobentry_type, int nr, long gui_location_x, long gui_location_y, boolean gui_draw, boolean parallel) throws KettleException {
        long id = this.getNextJobEntryCopyID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta(FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY, 5), (Object)new Long(id));
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)new Long(id_jobentry));
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)new Long(id_jobentry_type));
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue(new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue(new ValueMeta("GUI_DRAW", 4), (Object)gui_draw);
        table.addValue(new ValueMeta(FIELD_JOBENTRY_COPY_PARALLEL, 4), (Object)parallel);
        this.database.prepareInsert(table.getRowMeta(), TABLE_R_JOBENTRY_COPY);
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized void insertTableRow(String tablename, RowMetaAndData values) throws KettleException {
        this.database.prepareInsert(values.getRowMeta(), tablename);
        this.database.setValuesInsert(values);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public synchronized void updateDatabase(long id_database, String name, String type, String access, String host, String dbname, String port, String user, String pass, String servername, String data_tablespace, String index_tablespace) throws KettleException {
        long id_database_type = this.getDatabaseTypeID(type);
        long id_database_contype = this.getDatabaseConTypeID(access);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("ID_DATABASE_TYPE", 5), (Object)new Long(id_database_type));
        table.addValue(new ValueMeta("ID_DATABASE_CONTYPE", 5), (Object)new Long(id_database_contype));
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)host);
        table.addValue(new ValueMeta(FIELD_DATABASE_DATABASE_NAME, 2), (Object)dbname);
        table.addValue(new ValueMeta("PORT", 5), (Object)new Long(Const.toInt((String)port, (int)-1)));
        table.addValue(new ValueMeta("USERNAME", 2), (Object)user);
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)pass));
        table.addValue(new ValueMeta(FIELD_DATABASE_SERVERNAME, 2), (Object)servername);
        table.addValue(new ValueMeta(FIELD_DATABASE_DATA_TBS, 2), (Object)data_tablespace);
        table.addValue(new ValueMeta(FIELD_DATABASE_INDEX_TBS, 2), (Object)index_tablespace);
        this.updateTableRow(TABLE_R_DATABASE, "ID_DATABASE", table, id_database);
    }

    public synchronized void updateTableRow(String tablename, String idfield, RowMetaAndData values, long id) throws KettleException {
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValueMeta(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue(new ValueMeta(idfield, 5), (Object)new Long(id));
        this.database.setValuesUpdate(values.getRowMeta(), values.getData());
        this.database.updateRow();
        this.database.closeUpdate();
    }

    public synchronized void updateTableRow(String tablename, String idfield, RowMetaAndData values) throws KettleException {
        long id = values.getInteger(idfield, 0L);
        values.removeValue(idfield);
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValueMeta(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue(new ValueMeta(idfield, 5), (Object)new Long(id));
        this.database.setValuesUpdate(values.getRowMeta(), values.getData());
        this.database.updateRow();
    }

    public synchronized int getNrJobs() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB);
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransformations(long id_directory) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION) + " WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobs(long id_directory) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDirectories(long id_directory) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote(FIELD_DIRECTORY_ID_DIRECTORY_PARENT) + " = " + id_directory;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrConditions(long id_transforamtion) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_STEP_CONDITION) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transforamtion;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDatabases(long id_transforamtion) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transforamtion;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrSubConditions(long id_condition) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CONDITION) + " WHERE " + this.quote(FIELD_CONDITION_ID_CONDITION_PARENT) + " = " + id_condition;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransNotes(long id_transformation) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_NOTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobNotes(long id_job) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_NOTE) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDatabases() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE);
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDatabaseAttributes(long id_database) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrSteps(long id_transformation) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrStepDatabases(long id_database) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrStepAttributes(long id_step) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE) + " WHERE " + this.quote("ID_STEP") + " = " + id_step;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransHops(long id_transformation) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobHops(long id_job) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrTransDependencies(long id_transformation) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobEntries(long id_job) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobEntryCopies(long id_job, long id_jobentry) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job + " AND " + this.quote("ID_JOBENTRY") + " = " + id_jobentry;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobEntryCopies(long id_job) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrUsers() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER);
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrPermissions(long id_profile) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE_PERMISSION) + " WHERE " + this.quote("ID_PROFILE") + " = " + id_profile;
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrProfiles() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE);
        RowMetaAndData r = this.database.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized String[] getTransformationNames(long id_directory) throws KettleException {
        return this.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION) + " WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory + " ORDER BY " + this.quote("NAME"));
    }

    public List<RepositoryObject> getJobObjects(long id_directory) throws KettleException {
        return this.getRepositoryObjects(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB), "Job", id_directory);
    }

    public List<RepositoryObject> getTransformationObjects(long id_directory) throws KettleException {
        return this.getRepositoryObjects(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION), "Transformation", id_directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<RepositoryObject> getRepositoryObjects(String tableName, String objectType, long id_directory) throws KettleException {
        String sql = "SELECT " + this.quote("NAME") + ", " + this.quote("MODIFIED_USER") + ", " + this.quote("MODIFIED_DATE") + ", " + this.quote("DESCRIPTION") + " " + "FROM " + tableName + " " + "WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory + " ";
        ArrayList<RepositoryObject> repositoryObjects = new ArrayList<RepositoryObject>();
        ResultSet rs = this.database.openQuery(sql);
        if (rs != null) {
            try {
                Object[] r = this.database.getRow(rs);
                while (r != null) {
                    RowMetaInterface rowMeta = this.database.getReturnRowMeta();
                    repositoryObjects.add(new RepositoryObject(rowMeta.getString(r, 0), rowMeta.getString(r, 1), rowMeta.getDate(r, 2), objectType, rowMeta.getString(r, 3)));
                    r = this.database.getRow(rs);
                }
            }
            finally {
                if (rs != null) {
                    this.database.closeQuery(rs);
                }
            }
        }
        return repositoryObjects;
    }

    public synchronized String[] getJobNames(long id_directory) throws KettleException {
        return this.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " WHERE " + this.quote("ID_DIRECTORY") + " = " + id_directory + " ORDER BY " + this.quote("NAME"));
    }

    public synchronized String[] getDirectoryNames(long id_directory) throws KettleException {
        return this.getStrings("SELECT " + this.quote(FIELD_DIRECTORY_DIRECTORY_NAME) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY) + " WHERE " + this.quote(FIELD_DIRECTORY_ID_DIRECTORY_PARENT) + " = " + id_directory + " ORDER BY " + this.quote(FIELD_DIRECTORY_DIRECTORY_NAME));
    }

    public synchronized String[] getJobNames() throws KettleException {
        return this.getStrings("SELECT " + this.quote("NAME") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " ORDER BY " + this.quote("NAME"));
    }

    public long[] getSubConditionIDs(long id_condition) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_CONDITION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CONDITION) + " WHERE " + this.quote(FIELD_CONDITION_ID_CONDITION_PARENT) + " = " + id_condition);
    }

    public long[] getTransNoteIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_NOTE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_NOTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getConditionIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_CONDITION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_STEP_CONDITION) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getDatabaseIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_DATABASE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getJobNoteIDs(long id_job) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_NOTE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_NOTE) + " WHERE " + this.quote("ID_JOB") + " = " + id_job);
    }

    public long[] getDatabaseIDs() throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_DATABASE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE) + " ORDER BY " + this.quote("ID_DATABASE"));
    }

    public long[] getDatabaseAttributeIDs(long id_database) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database);
    }

    public long[] getPartitionSchemaIDs() throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_PARTITION_SCHEMA") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA) + " ORDER BY " + this.quote("NAME"));
    }

    public long[] getPartitionIDs(long id_partition_schema) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_PARTITION_ID_PARTITION) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION) + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = " + id_partition_schema);
    }

    public long[] getTransformationPartitionSchemaIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_TRANS_PARTITION_SCHEMA_ID_TRANS_PARTITION_SCHEMA) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_PARTITION_SCHEMA) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getTransformationClusterSchemaIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT ID_TRANS_CLUSTER FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_CLUSTER) + " WHERE ID_TRANSFORMATION = " + id_transformation);
    }

    public long[] getClusterIDs() throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_CLUSTER") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER) + " ORDER BY " + this.quote("NAME"));
    }

    public long[] getSlaveIDs() throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_SLAVE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE));
    }

    public long[] getSlaveIDs(long id_cluster_schema) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_SLAVE") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER_SLAVE) + " WHERE " + this.quote("ID_CLUSTER") + " = " + id_cluster_schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getIDs(String sql) throws KettleException {
        ArrayList<Long> ids = new ArrayList<Long>();
        ResultSet rs = this.database.openQuery(sql);
        try {
            Object[] r = this.database.getRow(rs);
            while (r != null) {
                RowMetaInterface rowMeta = this.database.getReturnRowMeta();
                Long id = rowMeta.getInteger(r, 0);
                if (id == null) {
                    id = new Long(0L);
                }
                ids.add(id);
                r = this.database.getRow(rs);
            }
        }
        finally {
            if (rs != null) {
                this.database.closeQuery(rs);
            }
        }
        return this.convertLongList(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getStrings(String sql) throws KettleException {
        ArrayList<String> ids = new ArrayList<String>();
        ResultSet rs = this.database.openQuery(sql);
        try {
            Object[] r = this.database.getRow(rs);
            while (r != null) {
                RowMetaInterface rowMeta = this.database.getReturnRowMeta();
                ids.add(rowMeta.getString(r, 0));
                r = this.database.getRow(rs);
            }
        }
        finally {
            if (rs != null) {
                this.database.closeQuery(rs);
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    private long[] convertLongList(List<Long> list) {
        long[] ids = new long[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = list.get(i);
        }
        return ids;
    }

    public synchronized String[] getDatabaseNames() throws KettleException {
        String nameField = this.quote("NAME");
        return this.getStrings("SELECT " + nameField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE) + " ORDER BY " + nameField);
    }

    public synchronized String[] getPartitionSchemaNames() throws KettleException {
        String nameField = this.quote("NAME");
        return this.getStrings("SELECT " + nameField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA) + " ORDER BY " + nameField);
    }

    public synchronized String[] getSlaveNames() throws KettleException {
        String nameField = this.quote("NAME");
        return this.getStrings("SELECT " + nameField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE) + " ORDER BY " + nameField);
    }

    public synchronized String[] getClusterNames() throws KettleException {
        String nameField = this.quote("NAME");
        return this.getStrings("SELECT " + nameField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER) + " ORDER BY " + nameField);
    }

    public long[] getStepIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_STEP") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public synchronized String[] getTransformationsUsingDatabase(long id_database) throws KettleException {
        String sql = "SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        return this.getTransformationsWithIDList(this.database.getRows(sql, 100), this.database.getReturnRowMeta());
    }

    public synchronized String[] getClustersUsingSlave(long id_slave) throws KettleException {
        String sql = "SELECT DISTINCT " + this.quote("ID_CLUSTER") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER_SLAVE) + " WHERE " + this.quote("ID_SLAVE") + " = " + id_slave;
        List list = this.database.getRows(sql, 100);
        RowMetaInterface rowMeta = this.database.getReturnRowMeta();
        ArrayList<String> clusterList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String clusterName;
            RowMetaAndData transRow;
            long id_cluster_schema = rowMeta.getInteger((Object[])list.get(i), this.quote("ID_CLUSTER"), Long.valueOf(-1L));
            if (id_cluster_schema <= 0L || (transRow = this.getClusterSchema(id_cluster_schema)) == null || (clusterName = transRow.getString(this.quote("NAME"), "<name not found>")) == null) continue;
            clusterList.add(clusterName);
        }
        return clusterList.toArray(new String[clusterList.size()]);
    }

    public synchronized String[] getTransformationsUsingSlave(long id_slave) throws KettleException {
        String sql = "SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_SLAVE) + " WHERE " + this.quote("ID_SLAVE") + " = " + id_slave;
        return this.getTransformationsWithIDList(this.database.getRows(sql, 100), this.database.getReturnRowMeta());
    }

    public synchronized String[] getTransformationsUsingPartitionSchema(long id_partition_schema) throws KettleException {
        String sql = "SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_PARTITION_SCHEMA) + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = " + id_partition_schema;
        return this.getTransformationsWithIDList(this.database.getRows(sql, 100), this.database.getReturnRowMeta());
    }

    public synchronized String[] getTransformationsUsingCluster(long id_cluster) throws KettleException {
        String sql = "SELECT DISTINCT " + this.quote("ID_TRANSFORMATION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_CLUSTER) + " WHERE " + this.quote("ID_CLUSTER") + " = " + id_cluster;
        return this.getTransformationsWithIDList(this.database.getRows(sql, 100), this.database.getReturnRowMeta());
    }

    private String[] getTransformationsWithIDList(List<Object[]> list, RowMetaInterface rowMeta) throws KettleException {
        String[] transList = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RowMetaAndData transRow;
            long id_transformation = rowMeta.getInteger(list.get(i), this.quote("ID_TRANSFORMATION"), Long.valueOf(-1L));
            if (id_transformation <= 0L || (transRow = this.getTransformation(id_transformation)) == null) continue;
            String transName = transRow.getString(this.quote("NAME"), "<name not found>");
            long id_directory = transRow.getInteger(this.quote("ID_DIRECTORY"), -1L);
            RepositoryDirectory dir = this.directoryTree.findDirectory(id_directory);
            transList[i] = dir.getPathObjectCombination(transName);
        }
        return transList;
    }

    public long[] getTransHopIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_TRANS_HOP_ID_TRANS_HOP) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getJobHopIDs(long id_job) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_JOB_HOP_ID_JOB_HOP) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP) + " WHERE " + this.quote("ID_JOB") + " = " + id_job);
    }

    public long[] getTransDependencyIDs(long id_transformation) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_DEPENDENCY_ID_DEPENDENCY) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation);
    }

    public long[] getUserIDs() throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_USER_ID_USER) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER));
    }

    public synchronized String[] getUserLogins() throws KettleException {
        String loginField = this.quote(FIELD_USER_LOGIN);
        return this.getStrings("SELECT " + loginField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER) + " ORDER BY " + loginField);
    }

    public long[] getPermissionIDs(long id_profile) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_PERMISSION") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE_PERMISSION) + " WHERE " + this.quote("ID_PROFILE") + " = " + id_profile);
    }

    public long[] getJobEntryIDs(long id_job) throws KettleException {
        return this.getIDs("SELECT " + this.quote("ID_JOBENTRY") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job);
    }

    public long[] getJobEntryCopyIDs(long id_job) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job);
    }

    public long[] getJobEntryCopyIDs(long id_job, long id_jobentry) throws KettleException {
        return this.getIDs("SELECT " + this.quote(FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY) + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job + " AND " + this.quote("ID_JOBENTRY") + " = " + id_jobentry);
    }

    public synchronized String[] getProfiles() throws KettleException {
        String nameField = this.quote("NAME");
        return this.getStrings("SELECT " + nameField + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE) + " ORDER BY " + nameField);
    }

    public RowMetaAndData getNote(long id_note) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_NOTE), this.quote("ID_NOTE"), id_note);
    }

    public RowMetaAndData getDatabase(long id_database) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE), this.quote("ID_DATABASE"), id_database);
    }

    public RowMetaAndData getDatabaseAttribute(long id_database_attribute) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE), this.quote(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE), id_database_attribute);
    }

    public Collection<RowMetaAndData> getDatabaseAttributes() throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        List rows = this.database.getRows("SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE), 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.database.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public Collection<RowMetaAndData> getDatabaseAttributes(long id_database) throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        List rows = this.database.getRows("SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database, 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.database.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote(FIELD_DATABASE_ATTRIBUTE_ID_DATABASE_ATTRIBUTE), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public RowMetaAndData getCondition(long id_condition) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CONDITION), this.quote("ID_CONDITION"), id_condition);
    }

    public RowMetaAndData getValue(long id_value) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_VALUE), this.quote(FIELD_VALUE_ID_VALUE), id_value);
    }

    public RowMetaAndData getStep(long id_step) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP), this.quote("ID_STEP"), id_step);
    }

    public RowMetaAndData getStepType(long id_step_type) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_TYPE), this.quote("ID_STEP_TYPE"), id_step_type);
    }

    public RowMetaAndData getStepAttribute(long id_step_attribute) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE), this.quote(FIELD_STEP_ATTRIBUTE_ID_STEP_ATTRIBUTE), id_step_attribute);
    }

    public RowMetaAndData getStepDatabase(long id_step) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE), this.quote("ID_STEP"), id_step);
    }

    public RowMetaAndData getTransHop(long id_trans_hop) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP), this.quote(FIELD_TRANS_HOP_ID_TRANS_HOP), id_trans_hop);
    }

    public RowMetaAndData getJobHop(long id_job_hop) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP), this.quote(FIELD_JOB_HOP_ID_JOB_HOP), id_job_hop);
    }

    public RowMetaAndData getTransDependency(long id_dependency) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY), this.quote(FIELD_DEPENDENCY_ID_DEPENDENCY), id_dependency);
    }

    public RowMetaAndData getTransformation(long id_transformation) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION), this.quote("ID_TRANSFORMATION"), id_transformation);
    }

    public RowMetaAndData getUser(long id_user) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER), this.quote(FIELD_USER_ID_USER), id_user);
    }

    public RowMetaAndData getProfile(long id_profile) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE), this.quote("ID_PROFILE"), id_profile);
    }

    public RowMetaAndData getPermission(long id_permission) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PERMISSION), this.quote("ID_PERMISSION"), id_permission);
    }

    public RowMetaAndData getJob(long id_job) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB), this.quote("ID_JOB"), id_job);
    }

    public RowMetaAndData getJobEntry(long id_jobentry) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY), this.quote("ID_JOBENTRY"), id_jobentry);
    }

    public RowMetaAndData getJobEntryCopy(long id_jobentry_copy) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY), this.quote(FIELD_JOBENTRY_COPY_ID_JOBENTRY_COPY), id_jobentry_copy);
    }

    public RowMetaAndData getJobEntryType(long id_jobentry_type) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_TYPE), this.quote("ID_JOBENTRY_TYPE"), id_jobentry_type);
    }

    public RowMetaAndData getDirectory(long id_directory) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DIRECTORY), this.quote("ID_DIRECTORY"), id_directory);
    }

    public RowMetaAndData getPartitionSchema(long id_partition_schema) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA), this.quote("ID_PARTITION_SCHEMA"), id_partition_schema);
    }

    public RowMetaAndData getPartition(long id_partition) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION), this.quote(FIELD_PARTITION_ID_PARTITION), id_partition);
    }

    public RowMetaAndData getClusterSchema(long id_cluster_schema) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER), this.quote("ID_CLUSTER"), id_cluster_schema);
    }

    public RowMetaAndData getSlaveServer(long id_slave) throws KettleException {
        return this.getOneRow(this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE), this.quote("ID_SLAVE"), id_slave);
    }

    private RowMetaAndData getOneRow(String tablename, String keyfield, long id) throws KettleException {
        String sql = "SELECT * FROM " + tablename + " WHERE " + keyfield + " = " + id;
        return this.database.getOneRow(sql);
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, String code, String value) throws KettleException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, 0.0, value);
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, String code, double value) throws KettleException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, value, null);
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, String code, boolean value) throws KettleException {
        return this.saveStepAttribute(code, 0L, id_transformation, id_step, 0.0, value ? "Y" : "N");
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, long nr, String code, String value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value);
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, long nr, String code, double value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, value, null);
    }

    public synchronized long saveStepAttribute(long id_transformation, long id_step, long nr, String code, boolean value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value ? "Y" : "N");
    }

    private long saveStepAttribute(String code, long nr, long id_transformation, long id_step, double value_num, String value_str) throws KettleException {
        return this.insertStepAttribute(id_transformation, id_step, nr, code, value_num, value_str);
    }

    public static final String byteArrayToString(byte[] val) throws IOException {
        String string;
        if (val == null) {
            string = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            BufferedOutputStream bos = new BufferedOutputStream(gzos);
            bos.write(val);
            bos.flush();
            bos.close();
            string = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
        }
        return string;
    }

    public synchronized void setLookupStepAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE) + " WHERE " + this.quote("ID_STEP") + " = ?  AND " + this.quote("CODE") + " = ?  AND " + this.quote("NR") + " = ? ";
        this.psStepAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void setLookupTransAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_ATTRIBUTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?  AND " + this.quote("CODE") + " = ? AND " + "NR" + " = ? ";
        this.psTransAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void closeTransAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psTransAttributesLookup);
        this.psTransAttributesLookup = null;
    }

    public synchronized void setLookupJobAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_ATTRIBUTE) + " WHERE " + this.quote("ID_JOB") + " = ?  AND " + this.quote("CODE") + " = ? AND " + "NR" + " = ? ";
        this.psJobAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void closeJobAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psTransAttributesLookup);
        this.psJobAttributesLookup = null;
    }

    public synchronized void closeStepAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psStepAttributesLookup);
        this.psStepAttributesLookup = null;
    }

    public synchronized void closeStepAttributeInsertPreparedStatement() throws KettleException {
        if (this.psStepAttributesInsert != null) {
            this.database.emptyAndCommit(this.psStepAttributesInsert, this.useBatchProcessing, 1);
            this.psStepAttributesInsert = null;
        }
    }

    public synchronized void closeTransAttributeInsertPreparedStatement() throws KettleException {
        if (this.psTransAttributesInsert != null) {
            this.database.emptyAndCommit(this.psTransAttributesInsert, this.useBatchProcessing, 1);
            this.psTransAttributesInsert = null;
        }
    }

    private RowMetaAndData getStepAttributeRow(long id_step, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id_step));
        par.addValue(new ValueMeta("CODE", 2), (Object)code);
        par.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        this.database.setValues(par.getRowMeta(), par.getData(), this.psStepAttributesLookup);
        Object[] rowData = this.database.getLookup(this.psStepAttributesLookup);
        return new RowMetaAndData(this.database.getReturnRowMeta(), rowData);
    }

    public RowMetaAndData getTransAttributeRow(long id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        par.addValue(new ValueMeta("CODE", 2), (Object)code);
        par.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        this.database.setValues(par, this.psTransAttributesLookup);
        Object[] r = this.database.getLookup(this.psTransAttributesLookup);
        if (r == null) {
            return null;
        }
        return new RowMetaAndData(this.database.getReturnRowMeta(), r);
    }

    public RowMetaAndData getJobAttributeRow(long id_job, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        par.addValue(new ValueMeta("CODE", 2), (Object)code);
        par.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        this.database.setValues(par, this.psJobAttributesLookup);
        Object[] r = this.database.getLookup(this.psJobAttributesLookup);
        if (r == null) {
            return null;
        }
        return new RowMetaAndData(this.database.getReturnRowMeta(), r);
    }

    public synchronized long getStepAttributeInteger(long id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized long findStepAttributeID(long id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return -1L;
        }
        return r.getInteger("ID_STEP", -1L);
    }

    public synchronized String getStepAttributeString(long id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public boolean getStepAttributeBoolean(long id_step, int nr, String code, boolean def) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return def;
        }
        String v = r.getString("VALUE_STR", null);
        if (v == null || Const.isEmpty((String)v)) {
            return def;
        }
        return ValueMeta.convertStringToBoolean((String)v);
    }

    public boolean getStepAttributeBoolean(long id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return false;
        }
        return ValueMeta.convertStringToBoolean((String)r.getString("VALUE_STR", null));
    }

    public synchronized long getStepAttributeInteger(long id_step, String code) throws KettleException {
        return this.getStepAttributeInteger(id_step, 0, code);
    }

    public synchronized String getStepAttributeString(long id_step, String code) throws KettleException {
        return this.getStepAttributeString(id_step, 0, code);
    }

    public boolean getStepAttributeBoolean(long id_step, String code) throws KettleException {
        return this.getStepAttributeBoolean(id_step, 0, code);
    }

    public synchronized int countNrStepAttributes(long id_step, String code) throws KettleException {
        if (this.stepAttributesBuffer != null) {
            int nr = this.searchNrStepAttributes(id_step, code);
            return nr;
        }
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE) + " WHERE " + this.quote("ID_STEP") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_STEP", 5), (Object)new Long(id_step));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        RowMetaAndData r = this.database.getOneRow(sql, table.getRowMeta(), table.getData());
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized String getTransAttributeString(long id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getTransAttributeBoolean(long id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return false;
        }
        return r.getBoolean("VALUE_STR", false);
    }

    public synchronized double getTransAttributeNumber(long id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized long getTransAttributeInteger(long id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized int countNrTransAttributes(long id_transformation, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_ATTRIBUTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        RowMetaAndData r = this.database.getOneRow(sql, table.getRowMeta(), table.getData());
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized List<Object[]> getTransAttributes(long id_transformation, String code, long nr) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_ATTRIBUTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? AND " + this.quote("CODE") + " = ? AND " + this.quote("NR") + " = ?" + " ORDER BY " + this.quote("VALUE_NUM");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        return this.database.getRows(sql, 0);
    }

    public synchronized String getJobAttributeString(long id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_job, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getJobAttributeBoolean(long id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_job, nr, code);
        if (r == null) {
            return false;
        }
        return r.getBoolean("VALUE_STR", false);
    }

    public synchronized double getJobAttributeNumber(long id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized long getJobAttributeInteger(long id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized int countNrJobAttributes(long id_job, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_ATTRIBUTE) + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        RowMetaAndData r = this.database.getOneRow(sql, table.getRowMeta(), table.getData());
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized List<Object[]> getJobAttributes(long id_job, String code, long nr) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_ATTRIBUTE) + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("CODE") + " = ? AND " + this.quote("NR") + " = ?" + " ORDER BY " + this.quote("VALUE_NUM");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        return this.database.getRows(sql, 0);
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, String code, String value) throws KettleException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, 0.0, value);
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, String code, double value) throws KettleException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, value, null);
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, String code, boolean value) throws KettleException {
        return this.saveJobEntryAttribute(code, 0L, id_job, id_jobentry, 0.0, value ? "Y" : "N");
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, String value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value);
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, double value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, value, null);
    }

    public synchronized long saveJobEntryAttribute(long id_job, long id_jobentry, long nr, String code, boolean value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value ? "Y" : "N");
    }

    private long saveJobEntryAttribute(String code, long nr, long id_job, long id_jobentry, double value_num, String value_str) throws KettleException {
        return this.insertJobEntryAttribute(id_job, id_jobentry, nr, code, value_num, value_str);
    }

    public synchronized void setLookupJobEntryAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_ATTRIBUTE) + " WHERE " + this.quote("ID_JOBENTRY") + " = ? AND " + this.quote("CODE") + " = ?  AND " + this.quote("NR") + " = ? ";
        this.pstmt_entry_attributes = this.database.prepareSQL(sql);
    }

    public synchronized void closeLookupJobEntryAttribute() throws KettleException {
        this.database.closePreparedStatement(this.pstmt_entry_attributes);
        this.pstmt_entry_attributes = null;
    }

    private RowMetaAndData getJobEntryAttributeRow(long id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)new Long(id_jobentry));
        par.addValue(new ValueMeta("CODE", 2), (Object)code);
        par.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        this.database.setValues(par.getRowMeta(), par.getData(), this.pstmt_entry_attributes);
        Object[] rowData = this.database.getLookup(this.pstmt_entry_attributes);
        return new RowMetaAndData(this.database.getReturnRowMeta(), rowData);
    }

    public synchronized long getJobEntryAttributeInteger(long id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public double getJobEntryAttributeNumber(long id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized String getJobEntryAttributeString(long id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, int nr, String code) throws KettleException {
        return this.getJobEntryAttributeBoolean(id_jobentry, nr, code, false);
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, int nr, String code, boolean def) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return def;
        }
        String v = r.getString("VALUE_STR", null);
        if (v == null || Const.isEmpty((String)v)) {
            return def;
        }
        return ValueMeta.convertStringToBoolean((String)v);
    }

    public double getJobEntryAttributeNumber(long id_jobentry, String code) throws KettleException {
        return this.getJobEntryAttributeNumber(id_jobentry, 0, code);
    }

    public synchronized long getJobEntryAttributeInteger(long id_jobentry, String code) throws KettleException {
        return this.getJobEntryAttributeInteger(id_jobentry, 0, code);
    }

    public synchronized String getJobEntryAttributeString(long id_jobentry, String code) throws KettleException {
        return this.getJobEntryAttributeString(id_jobentry, 0, code);
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, String code) throws KettleException {
        return this.getJobEntryAttributeBoolean(id_jobentry, 0, code, false);
    }

    public boolean getJobEntryAttributeBoolean(long id_jobentry, String code, boolean def) throws KettleException {
        return this.getJobEntryAttributeBoolean(id_jobentry, 0, code, def);
    }

    public synchronized int countNrJobEntryAttributes(long id_jobentry, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_ATTRIBUTE) + " WHERE " + this.quote("ID_JOBENTRY") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)new Long(id_jobentry));
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        RowMetaAndData r = this.database.getOneRow(sql, table.getRowMeta(), table.getData());
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized void delSteps(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delCondition(long id_condition) throws KettleException {
        boolean ok = true;
        long[] ids = this.getSubConditionIDs(id_condition);
        if (ids.length > 0) {
            for (int i = 0; i < ids.length && ok; ++i) {
                this.delCondition(ids[i]);
            }
            this.delCondition(id_condition);
        } else {
            String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CONDITION) + " WHERE " + this.quote("ID_CONDITION") + " = " + id_condition;
            this.database.execStatement(sql);
        }
    }

    public synchronized void delStepConditions(long id_transformation) throws KettleException {
        long[] ids = this.getConditionIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            this.delCondition(ids[i]);
        }
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_STEP_CONDITION) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delStepDatabases(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_DATABASE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJobEntries(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delJobEntryCopies(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_COPY) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delDependencies(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DEPENDENCY) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delStepAttributes(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_STEP_ATTRIBUTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delTransAttributes(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_ATTRIBUTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJobAttributes(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_ATTRIBUTE) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delPartitionSchemas(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_PARTITION_SCHEMA) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delPartitions(long id_partition_schema) throws KettleException {
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION) + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = " + id_partition_schema);
    }

    public synchronized void delClusterSlaves(long id_cluster) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER_SLAVE) + " WHERE " + this.quote("ID_CLUSTER") + " = " + id_cluster;
        this.database.execStatement(sql);
    }

    public synchronized void delTransformationClusters(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_CLUSTER) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delTransformationSlaves(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_SLAVE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJobEntryAttributes(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOBENTRY_ATTRIBUTE) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delTransHops(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_HOP) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJobHops(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_HOP) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delTransNotes(long id_transformation) throws KettleException {
        long[] ids = this.getTransNoteIDs(id_transformation);
        for (int i = 0; i < ids.length; ++i) {
            String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_NOTE) + " WHERE " + this.quote("ID_NOTE") + " = " + ids[i];
            this.database.execStatement(sql);
        }
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_NOTE) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJobNotes(long id_job) throws KettleException {
        long[] ids = this.getJobNoteIDs(id_job);
        for (int i = 0; i < ids.length; ++i) {
            String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_NOTE) + " WHERE " + this.quote("ID_NOTE") + " = " + ids[i];
            this.database.execStatement(sql);
        }
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB_NOTE) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delTrans(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delJob(long id_job) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " WHERE " + this.quote("ID_JOB") + " = " + id_job;
        this.database.execStatement(sql);
    }

    public synchronized void delDatabase(long id_database) throws KettleException {
        String[] transList = this.getTransformationsUsingDatabase(id_database);
        if (transList.length != 0) {
            String message = "Database used by the following transformations:" + Const.CR;
            for (int i = 0; i < transList.length; ++i) {
                message = message + "\t" + transList[i] + Const.CR;
            }
            KettleDependencyException e = new KettleDependencyException(message);
            throw new KettleDependencyException("This database is still in use by one or more transformations (" + transList.length + " references)", (Throwable)e);
        }
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        this.database.execStatement(sql);
    }

    public synchronized void delDatabaseAttributes(long id_database) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE_ATTRIBUTE) + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        this.database.execStatement(sql);
    }

    public synchronized void delTransStepCondition(long id_transformation) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_STEP_CONDITION) + " WHERE " + this.quote("ID_TRANSFORMATION") + " = " + id_transformation;
        this.database.execStatement(sql);
    }

    public synchronized void delValue(long id_value) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_VALUE) + " WHERE " + this.quote(FIELD_VALUE_ID_VALUE) + " = " + id_value;
        this.database.execStatement(sql);
    }

    public synchronized void delUser(long id_user) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER) + " WHERE " + this.quote(FIELD_USER_ID_USER) + " = " + id_user;
        this.database.execStatement(sql);
    }

    public synchronized void delProfile(long id_profile) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE) + " WHERE " + this.quote("ID_PROFILE") + " = " + id_profile;
        this.database.execStatement(sql);
    }

    public synchronized void delProfilePermissions(long id_profile) throws KettleException {
        String sql = "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE_PERMISSION) + " WHERE " + this.quote("ID_PROFILE") + " = " + id_profile;
        this.database.execStatement(sql);
    }

    public synchronized void delSlave(long id_slave) throws KettleException {
        String[] transList = this.getTransformationsUsingSlave(id_slave);
        String[] clustList = this.getClustersUsingSlave(id_slave);
        if (transList.length != 0 || clustList.length != 0) {
            int i;
            StringBuffer message = new StringBuffer();
            if (transList.length > 0) {
                message.append("Slave used by the following transformations:").append(Const.CR);
                for (i = 0; i < transList.length; ++i) {
                    message.append("  ").append(transList[i]).append(Const.CR);
                }
                message.append(Const.CR);
            }
            if (clustList.length > 0) {
                message.append("Slave used by the following cluster schemas:").append(Const.CR);
                for (i = 0; i < clustList.length; ++i) {
                    message.append("  ").append(clustList[i]).append(Const.CR);
                }
            }
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This slave server is still in use by one or more transformations (" + transList.length + ") or cluster schemas (" + clustList.length + ") :", (Throwable)e);
        }
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_SLAVE) + " WHERE " + this.quote("ID_SLAVE") + " = " + id_slave);
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANS_SLAVE) + " WHERE " + this.quote("ID_SLAVE") + " = " + id_slave);
    }

    public synchronized void delPartitionSchema(long id_partition_schema) throws KettleException {
        String[] transList = this.getTransformationsUsingPartitionSchema(id_partition_schema);
        if (transList.length != 0) {
            StringBuffer message = new StringBuffer();
            message.append("The partition schema is used by the following transformations:").append(Const.CR);
            for (int i = 0; i < transList.length; ++i) {
                message.append("  ").append(transList[i]).append(Const.CR);
            }
            message.append(Const.CR);
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This partition schema is still in use by one or more transformations (" + transList.length + ") :", (Throwable)e);
        }
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION) + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = " + id_partition_schema);
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PARTITION_SCHEMA) + " WHERE " + this.quote("ID_PARTITION_SCHEMA") + " = " + id_partition_schema);
    }

    public synchronized void delClusterSchema(long id_cluster) throws KettleException {
        String[] transList = this.getTransformationsUsingCluster(id_cluster);
        if (transList.length != 0) {
            StringBuffer message = new StringBuffer();
            message.append("The cluster schema is used by the following transformations:").append(Const.CR);
            for (int i = 0; i < transList.length; ++i) {
                message.append("  ").append(transList[i]).append(Const.CR);
            }
            message.append(Const.CR);
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This cluster schema is still in use by one or more transformations (" + transList.length + ") :", (Throwable)e);
        }
        this.database.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_CLUSTER) + " WHERE " + this.quote("ID_CLUSTER") + " = " + id_cluster);
    }

    public synchronized void delAllFromTrans(long id_transformation) throws KettleException {
        this.delTransNotes(id_transformation);
        this.delStepAttributes(id_transformation);
        this.delSteps(id_transformation);
        this.delStepConditions(id_transformation);
        this.delStepDatabases(id_transformation);
        this.delTransHops(id_transformation);
        this.delDependencies(id_transformation);
        this.delTransAttributes(id_transformation);
        this.delPartitionSchemas(id_transformation);
        this.delTransformationClusters(id_transformation);
        this.delTransformationSlaves(id_transformation);
        this.delTrans(id_transformation);
    }

    public synchronized void renameTransformation(long id_transformation, String newname) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_TRANSFORMATION) + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote("ID_TRANSFORMATION") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta("ID_TRANSFORMATION", 5), (Object)new Long(id_transformation));
        this.database.execStatement(sql, table.getRowMeta(), table.getData());
    }

    public synchronized void renameUser(long id_user, String newname) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_USER) + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote(FIELD_USER_ID_USER) + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta(FIELD_USER_ID_USER, 5), (Object)new Long(id_user));
        this.database.execStatement(sql, table.getRowMeta(), table.getData());
    }

    public synchronized void renameProfile(long id_profile, String newname) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_PROFILE) + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote("ID_PROFILE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta("ID_PROFILE", 5), (Object)new Long(id_profile));
        this.database.execStatement(sql, table.getRowMeta(), table.getData());
    }

    public synchronized void renameDatabase(long id_database, String newname) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_DATABASE) + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote("ID_DATABASE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)new Long(id_database));
        this.database.execStatement(sql, table.getRowMeta(), table.getData());
    }

    public synchronized void delAllFromJob(long id_job) throws KettleException {
        this.delJobNotes(id_job);
        this.delJobAttributes(id_job);
        this.delJobEntryAttributes(id_job);
        this.delJobEntries(id_job);
        this.delJobEntryCopies(id_job);
        this.delJobHops(id_job);
        this.delJob(id_job);
    }

    public synchronized void renameJob(long id_job, String newname) throws KettleException {
        String sql = "UPDATE " + this.databaseMeta.getQuotedSchemaTableCombination(null, TABLE_R_JOB) + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote("ID_JOB") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)new Long(id_job));
        this.database.execStatement(sql, table.getRowMeta(), table.getData());
    }

    public boolean dropRepositorySchema() throws KettleException {
        this.closeStepAttributeInsertPreparedStatement();
        this.closeLookupJobEntryAttribute();
        for (int i = 0; i < repositoryTableNames.length; ++i) {
            try {
                this.database.execStatement("DROP TABLE " + this.databaseMeta.getQuotedSchemaTableCombination(null, repositoryTableNames[i]));
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed(this.toString(), "dropped table " + repositoryTableNames[i], new Object[0]);
                continue;
            }
            catch (KettleException dbe) {
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed(this.toString(), "Unable to drop table: " + repositoryTableNames[i], new Object[0]);
            }
        }
        this.log.logBasic(this.toString(), "Dropped all " + repositoryTableNames.length + " repository tables.", new Object[0]);
        if (!this.database.isAutoCommit()) {
            this.database.commit();
        }
        return true;
    }

    public void updateStepTypes() throws KettleException {
        this.creationHelper.updateStepTypes(new ArrayList<String>(), false, false);
    }

    public void updateJobEntryTypes() throws KettleException {
        this.creationHelper.updateJobEntryTypes(new ArrayList<String>(), false, false);
    }

    public synchronized String toString() {
        if (this.repinfo == null) {
            return this.getClass().getName();
        }
        return this.repinfo.getName();
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
        this.databaseMeta = database.getDatabaseMeta();
    }

    public RepositoryDirectory getDirectoryTree() {
        return this.directoryTree;
    }

    public synchronized void setDirectoryTree(RepositoryDirectory directoryTree) {
        this.directoryTree = directoryTree;
    }

    public synchronized void lockRepository() throws KettleException {
        if (this.database.getDatabaseMeta().needsToLockAllTables()) {
            this.database.lockTables(repositoryTableNames);
        } else {
            this.database.lockTables(new String[]{TABLE_R_REPOSITORY_LOG});
        }
    }

    public synchronized void unlockRepository() throws KettleException {
        if (this.database.getDatabaseMeta().needsToLockAllTables()) {
            this.database.unlockTables(repositoryTableNames);
        } else {
            this.database.unlockTables(new String[]{TABLE_R_REPOSITORY_LOG});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exportAllObjects(ProgressMonitorListener monitor, String xmlFilename, RepositoryDirectory root, String exportType) throws KettleException {
        BufferedOutputStream os = null;
        OutputStreamWriter writer = null;
        try {
            os = new BufferedOutputStream(KettleVFS.getOutputStream((String)xmlFilename, (boolean)false));
            writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
            if (monitor != null) {
                monitor.beginTask("Exporting the repository to XML...", 3);
            }
            root = null == root ? this.getDirectoryTree() : root;
            writer.write(XMLHandler.getXMLHeader());
            writer.write("<repository>" + Const.CR + Const.CR);
            if (exportType.equals("all") || exportType.equals("trans")) {
                writer.write("<transformations>" + Const.CR);
                this.exportTransformations(monitor, root, writer);
                writer.write("</transformations>" + Const.CR);
            }
            if (exportType.equals("all") || exportType.equals("jobs")) {
                writer.write("<jobs>" + Const.CR);
                this.exportJobs(monitor, root, writer);
                writer.write("</jobs>" + Const.CR);
            }
            writer.write("</repository>" + Const.CR + Const.CR);
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask("Saving XML to file [" + xmlFilename + "]");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (IOException e) {
            System.out.println("Couldn't create file [" + xmlFilename + "]");
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {
                System.out.println("Exception closing XML file writer to [" + xmlFilename + "]");
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void exportJobs(ProgressMonitorListener monitor, RepositoryDirectory dirTree, OutputStreamWriter writer) throws KettleException {
        try {
            long[] dirids = dirTree.getDirectoryIDs();
            System.out.println("Going through " + dirids.length + " directories in directory [" + dirTree.getPath() + "]");
            if (monitor != null) {
                monitor.subTask("Exporting the jobs...");
            }
            for (int d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                RepositoryDirectory repdir = dirTree.findDirectory(dirids[d]);
                String[] jobs = this.getJobNames(dirids[d]);
                for (int i = 0; i < jobs.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        JobMeta ji = new JobMeta(this.log, this, jobs[i], repdir);
                        System.out.println("Loading/Exporting job [" + repdir.getPath() + " : " + jobs[i] + "]");
                        if (monitor != null) {
                            monitor.subTask("Exporting job [" + jobs[i] + "]");
                        }
                        writer.write(ji.getXML() + Const.CR);
                        continue;
                    }
                    catch (KettleException ke) {
                        this.log.logError(this.toString(), "An error occurred reading job [" + jobs[i] + "] from directory [" + repdir + "] : " + ke.getMessage(), new Object[0]);
                        this.log.logError(this.toString(), "Job [" + jobs[i] + "] from directory [" + repdir + "] was not exported because of a loading error!", new Object[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository jobs", (Throwable)e);
        }
    }

    private void exportTransformations(ProgressMonitorListener monitor, RepositoryDirectory dirTree, OutputStreamWriter writer) throws KettleException {
        try {
            if (monitor != null) {
                monitor.subTask("Exporting the transformations...");
            }
            long[] dirids = dirTree.getDirectoryIDs();
            System.out.println("Going through " + dirids.length + " directories in directory [" + dirTree.getPath() + "]");
            for (int d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                RepositoryDirectory repdir = dirTree.findDirectory(dirids[d]);
                System.out.println("Directory ID #" + d + " : " + dirids[d] + " : " + repdir);
                String[] trans = this.getTransformationNames(dirids[d]);
                for (int i = 0; i < trans.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        TransMeta ti = new TransMeta(this, trans[i], repdir);
                        System.out.println("Loading/Exporting transformation [" + repdir.getPath() + " : " + trans[i] + "]  (" + ti.getDirectory().getPath() + ")");
                        if (monitor != null) {
                            monitor.subTask("Exporting transformation [" + trans[i] + "]");
                        }
                        writer.write(ti.getXML() + Const.CR);
                        continue;
                    }
                    catch (KettleException ke) {
                        this.log.logError(this.toString(), "An error occurred reading transformation [" + trans[i] + "] from directory [" + repdir + "] : " + ke.getMessage(), new Object[0]);
                        this.log.logError(this.toString(), "Transformation [" + trans[i] + "] from directory [" + repdir + "] was not exported because of a loading error!", new Object[0]);
                    }
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository transformations", (Throwable)e);
        }
    }

    public static synchronized Repository getCurrentRepository() {
        return currentRepository;
    }

    public static synchronized void setCurrentRepository(Repository currentRepository) {
        Repository.currentRepository = currentRepository;
    }

    public List<DatabaseMeta> getDatabases() throws KettleException {
        ArrayList<DatabaseMeta> list = new ArrayList<DatabaseMeta>();
        long[] databaseIDs = this.getDatabaseIDs();
        for (int i = 0; i < databaseIDs.length; ++i) {
            DatabaseMeta databaseMeta = RepositoryUtil.loadDatabaseMeta(this, databaseIDs[i]);
            list.add(databaseMeta);
        }
        return list;
    }

    public List<SlaveServer> getSlaveServers() throws KettleException {
        ArrayList<SlaveServer> list = new ArrayList<SlaveServer>();
        long[] slaveIDs = this.getSlaveIDs();
        for (int i = 0; i < slaveIDs.length; ++i) {
            SlaveServer slaveServer = new SlaveServer(this, slaveIDs[i]);
            list.add(slaveServer);
        }
        return list;
    }

    public RowMetaInterface getStepAttributesRowMeta() {
        return this.stepAttributesRowMeta;
    }

    public void setStepAttributesRowMeta(RowMetaInterface stepAttributesRowMeta) {
        this.stepAttributesRowMeta = stepAttributesRowMeta;
    }

    public String quote(String identifier) {
        return this.databaseMeta.quoteField(identifier);
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public List<DatabaseMeta> readDatabases() throws KettleException {
        ArrayList<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
        long[] ids = this.getDatabaseIDs();
        for (int i = 0; i < ids.length; ++i) {
            DatabaseMeta databaseMeta = RepositoryUtil.loadDatabaseMeta(this, ids[i]);
            databases.add(databaseMeta);
        }
        return databases;
    }

    public boolean isUseBatchProcessing() {
        return this.useBatchProcessing;
    }

    public void setUseBatchProcessing(boolean useBatchProcessing) {
        this.useBatchProcessing = useBatchProcessing;
    }

    public void setImportBaseDirectory(RepositoryDirectory importBaseDirectory) {
        this.importBaseDirectory = importBaseDirectory;
    }

    public RepositoryDirectory getImportBaseDirectory() {
        return this.importBaseDirectory;
    }

    public void setUserInfo(UserInfo userinfo) {
        this.userinfo = userinfo;
    }

    public void createRepositorySchema(ProgressMonitorListener monitor, boolean upgrade, List<String> statements, boolean dryRun) throws KettleException {
        this.creationHelper.createRepositorySchema(monitor, upgrade, statements, dryRun);
    }

    public int countTransParameter(long id_transformation) throws KettleException {
        return this.countNrTransAttributes(id_transformation, "PARAM_KEY");
    }

    public String getTransParameterKey(long id_transformation, int nr) throws KettleException {
        return this.getTransAttributeString(id_transformation, nr, "PARAM_KEY");
    }

    public String getTransParameterDefault(long id_transformation, int nr) throws KettleException {
        return this.getTransAttributeString(id_transformation, nr, "PARAM_DEFAULT");
    }

    public String getTransParameterDescription(long id_transformation, int nr) throws KettleException {
        return this.getTransAttributeString(id_transformation, nr, "PARAM_DESC");
    }

    public void insertTransParameter(long id_transformation, long nr, String key, String defValue, String description) throws KettleException {
        this.insertTransAttribute(id_transformation, nr, "PARAM_KEY", 0L, key != null ? key : "");
        this.insertTransAttribute(id_transformation, nr, "PARAM_DEFAULT", 0L, defValue != null ? defValue : "");
        this.insertTransAttribute(id_transformation, nr, "PARAM_DESC", 0L, description != null ? description : "");
    }

    public int countJobParameter(long id_job) throws KettleException {
        return this.countNrTransAttributes(id_job, "PARAM_KEY");
    }

    public String getJobParameterKey(long id_job, int nr) throws KettleException {
        return this.getJobAttributeString(id_job, nr, "PARAM_KEY");
    }

    public String getJobParameterDefault(long id_job, int nr) throws KettleException {
        return this.getTransAttributeString(id_job, nr, "PARAM_DEFAULT");
    }

    public String getJobParameterDescription(long id_job, int nr) throws KettleException {
        return this.getTransAttributeString(id_job, nr, "PARAM_DESC");
    }

    public void insertJobParameter(long id_job, long nr, String key, String defValue, String description) throws KettleException {
        this.insertJobAttribute(id_job, nr, "PARAM_KEY", 0L, key != null ? key : "");
        this.insertJobAttribute(id_job, nr, "PARAM_DEFAULT", 0L, defValue != null ? defValue : "");
        this.insertJobAttribute(id_job, nr, "PARAM_DESC", 0L, description != null ? description : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StepAttributeComparator
    implements Comparator<Object[]> {
        private StepAttributeComparator() {
        }

        @Override
        public int compare(Object[] r1, Object[] r2) {
            try {
                return Repository.this.stepAttributesRowMeta.compare(r1, r2, KEY_POSITIONS);
            }
            catch (KettleValueException e) {
                return 0;
            }
        }
    }
}

