/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.XmlaConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DictionaryImpl<E extends Enum<E>>
implements XmlaConstant.Dictionary<E> {
    private final Class<E> clazz;
    private final Map<String, E> byName = new HashMap<String, E>();
    private final Map<Integer, E> byOrdinal = new HashMap<Integer, E>();
    private List<E> values;
    private static final Map<Class, DictionaryImpl> map = new HashMap<Class, DictionaryImpl>();

    public DictionaryImpl(Class<E> clazz) {
        this.clazz = clazz;
        this.init();
    }

    private void init() {
        Enum[] constants;
        if (this.values != null) {
            return;
        }
        try {
            constants = (Enum[])this.clazz.getEnumConstants();
        }
        catch (NullPointerException e) {
            return;
        }
        this.values = Collections.unmodifiableList(Arrays.asList(constants));
        for (Enum e : this.values) {
            this.byName.put(((XmlaConstant)((Object)e)).xmlaName(), e);
            this.byOrdinal.put(((XmlaConstant)((Object)e)).xmlaOrdinal(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Enum<E>> DictionaryImpl<E> forClass(Class<E> clazz) {
        assert (clazz != null);
        Map<Class, DictionaryImpl> map = DictionaryImpl.map;
        synchronized (map) {
            DictionaryImpl<E> directory = DictionaryImpl.map.get(clazz);
            if (directory == null) {
                directory = new DictionaryImpl<E>(clazz);
                DictionaryImpl.map.put(clazz, directory);
            }
            return directory;
        }
    }

    @Override
    public E forOrdinal(int xmlaOrdinal) {
        this.init();
        return (E)((Enum)this.byOrdinal.get(xmlaOrdinal));
    }

    @Override
    public E forName(String xmlaName) {
        this.init();
        return (E)((Enum)this.byName.get(xmlaName));
    }

    @Override
    public Set<E> forMask(int xmlaOrdinalMask) {
        this.init();
        Set<Enum> set = Olap4jUtil.enumSetNoneOf(this.clazz);
        for (Enum e : this.values) {
            if ((xmlaOrdinalMask & ((XmlaConstant)((Object)e)).xmlaOrdinal()) == 0) continue;
            set.add(e);
        }
        return set;
    }

    @Override
    public int toMask(Set<E> set) {
        int mask = 0;
        for (Enum e : set) {
            mask |= ((XmlaConstant)((Object)e)).xmlaOrdinal();
        }
        return mask;
    }

    @Override
    public List<E> getValues() {
        this.init();
        return this.values;
    }

    @Override
    public Class<E> getEnumClass() {
        return this.clazz;
    }
}

