/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.ui.options.general.GeneralOptionsModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AdvancedProxyPanel
extends JPanel {
    private GeneralOptionsModel options;
    private String oldHttpsHost;
    private String oldHttpsPort;
    private String oldSocksHost;
    private String oldSocksPort;
    private JCheckBox cbSameProxySettings;
    private JCheckBox cbUseProxyAuthentication;
    private JLabel lHttpProxyHost;
    private JLabel lHttpProxyPort;
    private JLabel lHttpsProxyHost;
    private JLabel lHttpsProxyPort;
    private JLabel lNonProxyHosts;
    private JLabel lNonProxyHostsDescription;
    private JLabel lSocksHost;
    private JLabel lSocksPort;
    private JLabel lUserName;
    private JLabel lUserPassword;
    private JPasswordField pfUserPassword;
    private JSeparator sSeparator;
    private JTextField tfHttpProxyHost;
    private JTextField tfHttpProxyPort;
    private JTextField tfHttpsProxyHost;
    private JTextField tfHttpsProxyPort;
    private JTextField tfNonProxyHosts;
    private JTextField tfSocksHost;
    private JTextField tfSocksPort;
    private JTextField tfUserName;

    AdvancedProxyPanel(GeneralOptionsModel generalOptionsModel) {
        this.options = generalOptionsModel;
        this.initComponents();
        this.tfHttpProxyHost.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpHostIfDemand();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpHostIfDemand();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpHostIfDemand();
            }
        });
        this.tfHttpProxyPort.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpPortIfDemand();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpPortIfDemand();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                AdvancedProxyPanel.this.followHttpPortIfDemand();
            }
        });
    }

    public void update(String string, String string2) {
        this.readOptions();
        if (!this.options.getHttpProxyHost().equals(string)) {
            this.tfHttpProxyHost.setText(string);
        }
        if (!this.options.getHttpProxyPort().equals(string2)) {
            this.tfHttpProxyPort.setText(string2);
        }
    }

    public void applyChanges() {
        this.writeOptions();
    }

    private void readOptions() {
        this.cbSameProxySettings.setSelected(this.options.useProxyAllProtocols());
        this.cbUseProxyAuthentication.setSelected(this.options.useProxyAuthentication());
        this.tfHttpProxyHost.setText(this.options.getHttpProxyHost());
        this.tfHttpProxyPort.setText(this.options.getHttpProxyPort());
        this.tfHttpsProxyHost.setText(this.options.getHttpsProxyHost());
        this.tfHttpsProxyPort.setText(this.options.getHttpsProxyPort());
        this.tfSocksHost.setText(this.options.getSocksHost());
        this.tfSocksPort.setText(this.options.getSocksPort());
        this.tfUserName.setText(this.options.getProxyAuthenticationUsername());
        this.pfUserPassword.setText(new String(this.options.getProxyAuthenticationPassword()));
        this.tfNonProxyHosts.setText(this.options.getNonProxyHosts());
        this.oldHttpsHost = this.options.getOriginalHttpsHost();
        this.oldHttpsPort = this.options.getOriginalHttpsPort();
        this.oldSocksHost = this.options.getOriginalSocksHost();
        this.oldSocksPort = this.options.getOriginalSocksPort();
        this.followHttpProxyIfDemand();
        this.updateAuthentication();
    }

    private void writeOptions() {
        this.options.setUseProxyAllProtocols(this.cbSameProxySettings.isSelected());
        this.options.setUseProxyAuthentication(this.cbUseProxyAuthentication.isSelected());
        this.options.setHttpProxyHost(this.tfHttpProxyHost.getText());
        this.options.setHttpProxyPort(this.tfHttpProxyPort.getText());
        if (!this.cbSameProxySettings.isSelected()) {
            this.options.setHttpsProxyHost(this.tfHttpsProxyHost.getText());
            this.options.setHttpsProxyPort(this.tfHttpsProxyPort.getText());
            this.options.setSocksHost(this.tfSocksHost.getText());
            this.options.setSocksPort(this.tfSocksPort.getText());
        }
        this.options.setNonProxyHosts(this.tfNonProxyHosts.getText());
        this.options.setAuthenticationUsername(this.tfUserName.getText());
        this.options.setAuthenticationPassword(this.pfUserPassword.getPassword());
    }

    private void followHttpProxyIfDemand() {
        boolean bl = this.cbSameProxySettings.isSelected();
        this.tfHttpsProxyHost.setEnabled(!bl);
        this.tfHttpsProxyPort.setEnabled(!bl);
        this.tfSocksHost.setEnabled(!bl);
        this.tfSocksPort.setEnabled(!bl);
        this.lHttpsProxyHost.setEnabled(!bl);
        this.lHttpsProxyPort.setEnabled(!bl);
        this.lSocksHost.setEnabled(!bl);
        this.lSocksPort.setEnabled(!bl);
        this.followHttpHostIfDemand();
        this.followHttpPortIfDemand();
    }

    private void updateAuthentication() {
        boolean bl = this.cbUseProxyAuthentication.isSelected();
        this.tfUserName.setEnabled(bl);
        this.lUserName.setEnabled(bl);
        this.pfUserPassword.setEnabled(bl);
        this.lUserPassword.setEnabled(bl);
    }

    private void followHttpHostIfDemand() {
        if (!this.cbSameProxySettings.isSelected()) {
            return;
        }
        String string = this.tfHttpProxyHost.getText();
        this.tfHttpsProxyHost.setText(string);
        this.tfSocksHost.setText(string);
    }

    private void followHttpPortIfDemand() {
        if (!this.cbSameProxySettings.isSelected()) {
            return;
        }
        String string = this.tfHttpProxyPort.getText();
        this.tfHttpsProxyPort.setText(string);
        this.tfSocksPort.setText(string);
    }

    private void initComponents() {
        this.lHttpProxyHost = new JLabel();
        this.tfHttpProxyHost = new JTextField();
        this.cbSameProxySettings = new JCheckBox();
        this.lHttpsProxyHost = new JLabel();
        this.tfHttpsProxyHost = new JTextField();
        this.lSocksHost = new JLabel();
        this.tfSocksHost = new JTextField();
        this.lHttpProxyPort = new JLabel();
        this.lHttpsProxyPort = new JLabel();
        this.lSocksPort = new JLabel();
        this.tfHttpProxyPort = new JTextField();
        this.tfHttpsProxyPort = new JTextField();
        this.tfSocksPort = new JTextField();
        this.lNonProxyHosts = new JLabel();
        this.tfNonProxyHosts = new JTextField();
        this.lNonProxyHostsDescription = new JLabel();
        this.sSeparator = new JSeparator();
        this.cbUseProxyAuthentication = new JCheckBox();
        this.lUserName = new JLabel();
        this.lUserPassword = new JLabel();
        this.tfUserName = new JTextField();
        this.pfUserPassword = new JPasswordField();
        this.lHttpProxyHost.setLabelFor(this.tfHttpProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lHttpProxyHost, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lHttpProxyHost"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSameProxySettings, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_cbSameProxySettings"));
        this.cbSameProxySettings.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSameProxySettings.setMargin(new Insets(0, 0, 0, 0));
        this.cbSameProxySettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedProxyPanel.this.cbSameProxySettingsActionPerformed(actionEvent);
            }
        });
        this.lHttpsProxyHost.setLabelFor(this.tfHttpsProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lHttpsProxyHost, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lHttpsProxyHots"));
        this.lSocksHost.setLabelFor(this.tfSocksHost);
        Mnemonics.setLocalizedText((JLabel)this.lSocksHost, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lSocksHost"));
        this.lHttpProxyPort.setLabelFor(this.tfHttpProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lHttpProxyPort, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lHttpProxyPort"));
        this.lHttpsProxyPort.setLabelFor(this.tfHttpsProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lHttpsProxyPort, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lHttpsProxyPort"));
        this.lSocksPort.setLabelFor(this.tfSocksPort);
        Mnemonics.setLocalizedText((JLabel)this.lSocksPort, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lSocksPort"));
        this.tfHttpProxyPort.setColumns(4);
        this.tfHttpsProxyPort.setColumns(4);
        this.tfSocksPort.setColumns(4);
        this.lNonProxyHosts.setLabelFor(this.tfNonProxyHosts);
        Mnemonics.setLocalizedText((JLabel)this.lNonProxyHosts, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lNonProxyHosts"));
        Mnemonics.setLocalizedText((JLabel)this.lNonProxyHostsDescription, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lNonProxyHostsDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUseProxyAuthentication, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_cbUseProxyAuthentication"));
        this.cbUseProxyAuthentication.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUseProxyAuthentication.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedProxyPanel.this.cbUseProxyAuthenticationActionPerformed(actionEvent);
            }
        });
        this.lUserName.setLabelFor(this.tfUserName);
        Mnemonics.setLocalizedText((JLabel)this.lUserName, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lUserName"));
        this.lUserPassword.setLabelFor(this.pfUserPassword);
        Mnemonics.setLocalizedText((JLabel)this.lUserPassword, (String)NbBundle.getMessage(AdvancedProxyPanel.class, (String)"LBL_AdvancedProxyPanel_lUserPassword"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.cbUseProxyAuthentication)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lUserName).add((Component)this.lUserPassword)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.pfUserPassword).add((Component)this.tfUserName, -1, 399, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.sSeparator, -2, 414, -2)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lHttpProxyHost).add((Component)this.lHttpsProxyHost).add((Component)this.lSocksHost).add((Component)this.lNonProxyHosts)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.lNonProxyHostsDescription, -2, 349, -2).add((Component)this.cbSameProxySettings, -2, 325, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add(1, (Component)this.tfHttpProxyHost).add(1, (Component)this.tfSocksHost).add(1, (Component)this.tfHttpsProxyHost, -1, 281, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lHttpProxyPort).add((Component)this.lHttpsProxyPort).add((Component)this.lSocksPort)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.tfHttpProxyPort).add((Component)this.tfSocksPort).add((Component)this.tfHttpsProxyPort))).add((Component)this.tfNonProxyHosts))))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lHttpProxyHost).add((Component)this.tfHttpProxyHost, -2, -1, -2).add((Component)this.lHttpProxyPort).add((Component)this.tfHttpProxyPort, -2, -1, -2)).addPreferredGap(0).add((Component)this.cbSameProxySettings).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lHttpsProxyHost).add((Component)this.tfHttpsProxyHost, -2, -1, -2).add((Component)this.lHttpsProxyPort).add((Component)this.tfHttpsProxyPort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lSocksHost).add((Component)this.tfSocksHost, -2, -1, -2).add((Component)this.lSocksPort).add((Component)this.tfSocksPort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lNonProxyHosts).add((Component)this.tfNonProxyHosts, -2, -1, -2)).addPreferredGap(0).add((Component)this.lNonProxyHostsDescription).addPreferredGap(0).add((Component)this.sSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.cbUseProxyAuthentication).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lUserName).add((Component)this.tfUserName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lUserPassword).add((Component)this.pfUserPassword, -2, -1, -2)).addContainerGap(30, Short.MAX_VALUE)));
        this.tfHttpProxyHost.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfHttpProxyHost"));
        this.cbSameProxySettings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_cbSameProxySettings"));
        this.tfHttpsProxyHost.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfHttpsProxyHost"));
        this.tfSocksHost.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfSocksHost"));
        this.tfHttpProxyPort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfHttpProxyPort"));
        this.tfHttpsProxyPort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfHttpsProxyPort"));
        this.tfSocksPort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfSocksPort"));
        this.tfNonProxyHosts.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfNonProxyHosts"));
        this.cbUseProxyAuthentication.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_cbUseProxyAuthentication"));
        this.tfUserName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_tfUserName"));
        this.pfUserPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel_pfUserPassword"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AdvancedProxyPanel.class, (String)"ACD_AdvancedProxyPanel"));
    }

    private void cbUseProxyAuthenticationActionPerformed(ActionEvent actionEvent) {
        this.updateAuthentication();
    }

    private void cbSameProxySettingsActionPerformed(ActionEvent actionEvent) {
        if (this.cbSameProxySettings.isSelected()) {
            this.oldHttpsHost = this.tfHttpsProxyHost.getText();
            this.oldHttpsPort = this.tfHttpsProxyPort.getText();
            this.oldSocksHost = this.tfSocksHost.getText();
            this.oldSocksPort = this.tfSocksPort.getText();
        } else {
            this.tfHttpsProxyHost.setText(this.oldHttpsHost);
            this.tfHttpsProxyPort.setText(this.oldHttpsPort);
            this.tfSocksHost.setText(this.oldSocksHost);
            this.tfSocksPort.setText(this.oldSocksPort);
        }
        this.followHttpProxyIfDemand();
    }
}

