/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;

public class CssComparator
extends CssValue {
    public static final int type = 23;
    private Comp value;
    CssExpression parameters;

    public static boolean checkCompatibility(CssComparator first, CssComparator second) {
        return first.value != Comp.EQ && second.value != Comp.EQ;
    }

    public static boolean checkUsefulness(CssComparator first, CssComparator second) {
        switch (first.value) {
            case GE: 
            case GT: {
                return second.value == Comp.GE || second.value == Comp.GT;
            }
            case LE: 
            case LT: {
                if (second.value != Comp.LE && second.value != Comp.LT) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getType() {
        return 23;
    }

    public void set(String s, CssExpression ex, ApplContext ac) throws InvalidParamException {
        Comp c = Comp.resolve(s.trim());
        if (c == null) {
            throw new InvalidParamException("value", s, ac);
        }
        this.value = c;
        this.parameters = ex;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        Comp c = Comp.resolve(s.trim());
        if (c == null) {
            throw new InvalidParamException("value", s, ac);
        }
        this.value = c;
    }

    public CssExpression getParameters() {
        return this.parameters;
    }

    public void setParameters(CssExpression nex) {
        this.parameters = nex;
    }

    @Override
    public Object get() {
        return this.toString();
    }

    public String toString() {
        return String.valueOf((Object)this.value);
    }

    @Override
    public boolean equals(Object value) {
        try {
            CssComparator other = (CssComparator)value;
            return value == other.value;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public static enum Comp {
        GE(">="),
        LE("<="),
        GT(">"),
        LT("<"),
        EQ("=");

        private String comp;

        private Comp(String val) {
            this.comp = val;
        }

        public static Comp resolve(String s) {
            for (Comp v : Comp.values()) {
                if (!v.toString().equals(s)) continue;
                return v;
            }
            return null;
        }

        public String toString() {
            return this.comp;
        }
    }
}

