/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl.drown;

import de.rub.nds.tlsattacker.attacks.impl.drown.ServerVerifyChecker;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import java.util.Arrays;

class LeakyExportBenchmarkRunnable
implements Runnable {
    private int firstByteFrom;
    private int firstByteTo;
    private SSL2CipherSuite cipherSuite;
    private byte[] encrypted;
    private byte[] baseMasterKey;
    private byte[] challenge;
    private byte[] sessionId;
    private byte[] iv;

    public LeakyExportBenchmarkRunnable(SSL2CipherSuite cipherSuite, int firstByteFrom, int firstByteTo) {
        this.cipherSuite = cipherSuite;
        this.firstByteFrom = firstByteFrom;
        this.firstByteTo = firstByteTo;
    }

    public void init(byte[] encrypted, byte[] baseMasterKey, byte[] challenge, byte[] sessionId, byte[] iv) {
        this.encrypted = encrypted;
        this.baseMasterKey = baseMasterKey;
        this.challenge = challenge;
        this.sessionId = sessionId;
        this.iv = iv;
    }

    @Override
    public void run() {
        for (int a = this.firstByteFrom; a < this.firstByteTo; ++a) {
            for (int b = -128; b < 128; ++b) {
                for (int c = -128; c < 128; ++c) {
                    byte[] masterKey = Arrays.copyOf(this.baseMasterKey, this.baseMasterKey.length);
                    masterKey[0] = (byte)a;
                    masterKey[1] = (byte)b;
                    masterKey[2] = (byte)c;
                    byte[] key = ServerVerifyChecker.makeKeyMaterial(masterKey, this.challenge, this.sessionId, "0");
                    if (this.cipherSuite == SSL2CipherSuite.SSL_CK_RC4_128_EXPORT40_WITH_MD5) {
                        ServerVerifyChecker.decryptRC4(key, this.encrypted);
                        continue;
                    }
                    if (this.cipherSuite != SSL2CipherSuite.SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5) continue;
                    ServerVerifyChecker.decryptRC2(key, this.encrypted, this.iv, 0);
                }
            }
        }
    }
}

