/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.decompiler;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.config.Settings$Setting$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.File$;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import scala.io.Codec$;
import scala.quoted.runtime.impl.QuotesImpl$;

public class DecompilationPrinter
extends Phases.Phase {
    @Override
    public String phaseName() {
        return "decompilationPrinter";
    }

    @Override
    public void run(Contexts.Context x$1) {
        if (Settings$Setting$.MODULE$.isDefault(x$1.settings().outputDir(), x$1)) {
            this.printToOutput(System.out, x$1);
            return;
        }
        AbstractFile outputDir = (AbstractFile)Settings$Setting$.MODULE$.value(x$1.settings().outputDir(), x$1);
        OutputStream os = null;
        PrintStream ps = null;
        try {
            os = File$.MODULE$.apply(outputDir.fileNamed("decompiled.scala").path(), Codec$.MODULE$.UTF8()).outputStream(true);
            ps = new PrintStream(os, false, StandardCharsets.UTF_8.name());
            this.printToOutput(ps, x$1);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void printToOutput(PrintStream out, Contexts.Context x$2) {
        CompilationUnit unit = x$2.compilationUnit();
        String unitFile = unit.source().toString().replace("\\", "/").replace(".class", ".tasty");
        out.println(new StringBuilder(23).append("/** Decompiled from ").append(unitFile).append(" */").toString());
        out.println(QuotesImpl$.MODULE$.showDecompiledTree(unit.tpdTree(), x$2));
    }
}

