/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-0.0lf, -0.0lf, -0.0lf)
 * (0.0lf * dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.0lf, 0.0lf, 0.0lf)
 * (-1.3333333333333333lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(1.7777777777777777lf, 1.1333333333333333lf, 1.2533333333333332lf)
 * (-1.3333333333333333lf * dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(-2.2266666666666666lf, -0.88lf, -2.493333333333333lf)
 * (0.85lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-1.1333333333333333lf, -0.7224999999999999lf, -0.7989999999999999lf)
 * (0.85lf * dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(1.4195lf, 0.561lf, 1.5895000000000001lf)
 */
#version 400

void main()
{
  double[distance((0.0lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-0.0lf, -0.0lf, -0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf * dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(1.7777777777777777lf, 1.1333333333333333lf, 1.2533333333333332lf)) <= 2.452709260399484e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf * dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(-2.2266666666666666lf, -0.88lf, -2.493333333333333lf)) <= 3.45675506155058e-05lf ? 1 : -1] array3;
  double[distance((0.85lf * dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-1.1333333333333333lf, -0.7224999999999999lf, -0.7989999999999999lf)) <= 1.563602153504671e-05lf ? 1 : -1] array4;
  double[distance((0.85lf * dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(1.4195lf, 0.561lf, 1.5895000000000001lf)) <= 2.2036813517384954e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
