/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec2(10ul, 12ul) - 0ul) => u64vec2(10ul, 12ul)
 * (u64vec2(10ul, 12ul) - 3ul) => u64vec2(7ul, 9ul)
 * (u64vec2(10ul, 12ul) - 1192ul) => u64vec2(18446744073709550434ul, 18446744073709550436ul)
 * (u64vec2(10ul, 12ul) - 1048576ul) => u64vec2(18446744073708503050ul, 18446744073708503052ul)
 * (u64vec2(10ul, 12ul) - 4251475ul) => u64vec2(18446744073705300151ul, 18446744073705300153ul)
 * (u64vec2(10ul, 12ul) - 29852643761ul) => u64vec2(18446744043856907865ul, 18446744043856907867ul)
 * (u64vec2(10ul, 12ul) - 4398046511104ul) => u64vec2(18446739675663040522ul, 18446739675663040524ul)
 * (u64vec2(10ul, 12ul) - 3948976685146ul) => u64vec2(18446740124732866480ul, 18446740124732866482ul)
 * (u64vec2(10ul, 12ul) - 135763469567146206ul) => u64vec2(18310980604142405420ul, 18310980604142405422ul)
 * (u64vec2(10ul, 12ul) - 11654173250180970009ul) => u64vec2(6792570823528581617ul, 6792570823528581619ul)
 * (u64vec2(42ul, 48ul) - 0ul) => u64vec2(42ul, 48ul)
 * (u64vec2(42ul, 48ul) - 3ul) => u64vec2(39ul, 45ul)
 * (u64vec2(42ul, 48ul) - 1192ul) => u64vec2(18446744073709550466ul, 18446744073709550472ul)
 * (u64vec2(42ul, 48ul) - 1048576ul) => u64vec2(18446744073708503082ul, 18446744073708503088ul)
 * (u64vec2(42ul, 48ul) - 4251475ul) => u64vec2(18446744073705300183ul, 18446744073705300189ul)
 * (u64vec2(42ul, 48ul) - 29852643761ul) => u64vec2(18446744043856907897ul, 18446744043856907903ul)
 * (u64vec2(42ul, 48ul) - 4398046511104ul) => u64vec2(18446739675663040554ul, 18446739675663040560ul)
 * (u64vec2(42ul, 48ul) - 3948976685146ul) => u64vec2(18446740124732866512ul, 18446740124732866518ul)
 * (u64vec2(42ul, 48ul) - 135763469567146206ul) => u64vec2(18310980604142405452ul, 18310980604142405458ul)
 * (u64vec2(42ul, 48ul) - 11654173250180970009ul) => u64vec2(6792570823528581649ul, 6792570823528581655ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec2(10ul, 12ul) - 0ul), u64vec2(10ul, 12ul))) ? 1 : -1] array0;
  float[all(equal((u64vec2(10ul, 12ul) - 3ul), u64vec2(7ul, 9ul))) ? 1 : -1] array1;
  float[all(equal((u64vec2(10ul, 12ul) - 1192ul), u64vec2(18446744073709550434ul, 18446744073709550436ul))) ? 1 : -1] array2;
  float[all(equal((u64vec2(10ul, 12ul) - 1048576ul), u64vec2(18446744073708503050ul, 18446744073708503052ul))) ? 1 : -1] array3;
  float[all(equal((u64vec2(10ul, 12ul) - 4251475ul), u64vec2(18446744073705300151ul, 18446744073705300153ul))) ? 1 : -1] array4;
  float[all(equal((u64vec2(10ul, 12ul) - 29852643761ul), u64vec2(18446744043856907865ul, 18446744043856907867ul))) ? 1 : -1] array5;
  float[all(equal((u64vec2(10ul, 12ul) - 4398046511104ul), u64vec2(18446739675663040522ul, 18446739675663040524ul))) ? 1 : -1] array6;
  float[all(equal((u64vec2(10ul, 12ul) - 3948976685146ul), u64vec2(18446740124732866480ul, 18446740124732866482ul))) ? 1 : -1] array7;
  float[all(equal((u64vec2(10ul, 12ul) - 135763469567146206ul), u64vec2(18310980604142405420ul, 18310980604142405422ul))) ? 1 : -1] array8;
  float[all(equal((u64vec2(10ul, 12ul) - 11654173250180970009ul), u64vec2(6792570823528581617ul, 6792570823528581619ul))) ? 1 : -1] array9;
  float[all(equal((u64vec2(42ul, 48ul) - 0ul), u64vec2(42ul, 48ul))) ? 1 : -1] array10;
  float[all(equal((u64vec2(42ul, 48ul) - 3ul), u64vec2(39ul, 45ul))) ? 1 : -1] array11;
  float[all(equal((u64vec2(42ul, 48ul) - 1192ul), u64vec2(18446744073709550466ul, 18446744073709550472ul))) ? 1 : -1] array12;
  float[all(equal((u64vec2(42ul, 48ul) - 1048576ul), u64vec2(18446744073708503082ul, 18446744073708503088ul))) ? 1 : -1] array13;
  float[all(equal((u64vec2(42ul, 48ul) - 4251475ul), u64vec2(18446744073705300183ul, 18446744073705300189ul))) ? 1 : -1] array14;
  float[all(equal((u64vec2(42ul, 48ul) - 29852643761ul), u64vec2(18446744043856907897ul, 18446744043856907903ul))) ? 1 : -1] array15;
  float[all(equal((u64vec2(42ul, 48ul) - 4398046511104ul), u64vec2(18446739675663040554ul, 18446739675663040560ul))) ? 1 : -1] array16;
  float[all(equal((u64vec2(42ul, 48ul) - 3948976685146ul), u64vec2(18446740124732866512ul, 18446740124732866518ul))) ? 1 : -1] array17;
  float[all(equal((u64vec2(42ul, 48ul) - 135763469567146206ul), u64vec2(18310980604142405452ul, 18310980604142405458ul))) ? 1 : -1] array18;
  float[all(equal((u64vec2(42ul, 48ul) - 11654173250180970009ul), u64vec2(6792570823528581649ul, 6792570823528581655ul))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
