/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333333333333259l, -85l, -94l)
 * (0l - i64vec3(167l, 66l, 187l)) => i64vec3(-167l, -66l, -187l)
 * (3l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333333333333262l, -82l, -91l)
 * (3l - i64vec3(167l, 66l, 187l)) => i64vec3(-164l, -63l, -184l)
 * (-1192l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333333333332067l, -1277l, -1286l)
 * (-1192l - i64vec3(167l, 66l, 187l)) => i64vec3(-1359l, -1258l, -1379l)
 * (1048576l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333333334381835l, 1048491l, 1048482l)
 * (1048576l - i64vec3(167l, 66l, 187l)) => i64vec3(1048409l, 1048510l, 1048389l)
 * (4251475l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333333337584734l, 4251390l, 4251381l)
 * (4251475l - i64vec3(167l, 66l, 187l)) => i64vec3(4251308l, 4251409l, 4251288l)
 * (29852643761l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333333363185977020l, 29852643676l, 29852643667l)
 * (29852643761l - i64vec3(167l, 66l, 187l)) => i64vec3(29852643594l, 29852643695l, 29852643574l)
 * (-4398046511104l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333328935286822155l, -4398046511189l, -4398046511198l)
 * (-4398046511104l - i64vec3(167l, 66l, 187l)) => i64vec3(-4398046511271l, -4398046511170l, -4398046511291l)
 * (-3948976685146l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1333329384356648113l, -3948976685231l, -3948976685240l)
 * (-3948976685146l - i64vec3(167l, 66l, 187l)) => i64vec3(-3948976685313l, -3948976685212l, -3948976685333l)
 * (-135763469567146206l - i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1197569863766187053l, -135763469567146291l, -135763469567146300l)
 * (-135763469567146206l - i64vec3(167l, 66l, 187l)) => i64vec3(-135763469567146373l, -135763469567146272l, -135763469567146393l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333333333333259l, -85l, -94l))) ? 1 : -1] array0;
  float[all(equal((0l - i64vec3(167l, 66l, 187l)), i64vec3(-167l, -66l, -187l))) ? 1 : -1] array1;
  float[all(equal((3l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333333333333262l, -82l, -91l))) ? 1 : -1] array2;
  float[all(equal((3l - i64vec3(167l, 66l, 187l)), i64vec3(-164l, -63l, -184l))) ? 1 : -1] array3;
  float[all(equal((-1192l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333333333332067l, -1277l, -1286l))) ? 1 : -1] array4;
  float[all(equal((-1192l - i64vec3(167l, 66l, 187l)), i64vec3(-1359l, -1258l, -1379l))) ? 1 : -1] array5;
  float[all(equal((1048576l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333333334381835l, 1048491l, 1048482l))) ? 1 : -1] array6;
  float[all(equal((1048576l - i64vec3(167l, 66l, 187l)), i64vec3(1048409l, 1048510l, 1048389l))) ? 1 : -1] array7;
  float[all(equal((4251475l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333333337584734l, 4251390l, 4251381l))) ? 1 : -1] array8;
  float[all(equal((4251475l - i64vec3(167l, 66l, 187l)), i64vec3(4251308l, 4251409l, 4251288l))) ? 1 : -1] array9;
  float[all(equal((29852643761l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333333363185977020l, 29852643676l, 29852643667l))) ? 1 : -1] array10;
  float[all(equal((29852643761l - i64vec3(167l, 66l, 187l)), i64vec3(29852643594l, 29852643695l, 29852643574l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333328935286822155l, -4398046511189l, -4398046511198l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l - i64vec3(167l, 66l, 187l)), i64vec3(-4398046511271l, -4398046511170l, -4398046511291l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1333329384356648113l, -3948976685231l, -3948976685240l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l - i64vec3(167l, 66l, 187l)), i64vec3(-3948976685313l, -3948976685212l, -3948976685333l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l - i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1197569863766187053l, -135763469567146291l, -135763469567146300l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l - i64vec3(167l, 66l, 187l)), i64vec3(-135763469567146373l, -135763469567146272l, -135763469567146393l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
