/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.env.Environment;
import org.opensearch.index.mapper.MapperService;

public class ProcessorDocumentUtils {
    public static void validateMapTypeValue(String sourceKey, Map<String, Object> sourceValue, Object fieldMap, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        ProcessorDocumentUtils.validateMapTypeValue(sourceKey, sourceValue, fieldMap, 1L, indexName, clusterService, environment, allowEmpty);
    }

    private static void validateMapTypeValue(String sourceKey, Map<String, Object> sourceValue, Object fieldMap, long depth, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        if (Objects.isNull(sourceValue)) {
            return;
        }
        ProcessorDocumentUtils.validateDepth(sourceKey, depth, indexName, clusterService, environment);
        if (!(fieldMap instanceof Map)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] configuration doesn't match actual value type, configuration type is: %s, actual value type is: %s", sourceKey, fieldMap.getClass().getName(), sourceValue.getClass().getName()));
        }
        ((Map)fieldMap).forEach((key, nextFieldMap) -> {
            Object nextSourceValue = sourceValue.get(key);
            if (nextSourceValue != null) {
                if (nextSourceValue instanceof List) {
                    ProcessorDocumentUtils.validateListTypeValue(key, (List)nextSourceValue, fieldMap, depth + 1L, indexName, clusterService, environment, allowEmpty);
                } else if (nextSourceValue instanceof Map) {
                    ProcessorDocumentUtils.validateMapTypeValue(key, (Map)nextSourceValue, nextFieldMap, depth + 1L, indexName, clusterService, environment, allowEmpty);
                } else {
                    if (!(nextSourceValue instanceof String)) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] is neither string nor nested type, cannot process it", key));
                    }
                    if (!allowEmpty && StringUtils.isBlank((CharSequence)((String)nextSourceValue))) {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] has empty string value, cannot process it", key));
                    }
                }
            }
        });
    }

    private static void validateListTypeValue(String sourceKey, List sourceValue, Object fieldMap, long depth, String indexName, ClusterService clusterService, Environment environment, boolean allowEmpty) {
        ProcessorDocumentUtils.validateDepth(sourceKey, depth, indexName, clusterService, environment);
        if (CollectionUtils.isEmpty((Collection)sourceValue)) {
            return;
        }
        for (Object element : sourceValue) {
            if (Objects.isNull(element)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has null, cannot process it", sourceKey));
            }
            if (element instanceof List) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] is nested list type, cannot process it", sourceKey));
            }
            if (element instanceof Map) {
                ProcessorDocumentUtils.validateMapTypeValue(sourceKey, (Map)element, ((Map)fieldMap).get(sourceKey), depth + 1L, indexName, clusterService, environment, allowEmpty);
                continue;
            }
            if (!(element instanceof String)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has non string value, cannot process it", sourceKey));
            }
            if (allowEmpty || !StringUtils.isBlank((CharSequence)element.toString())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "list type field [%s] has empty string, cannot process it", sourceKey));
        }
    }

    private static void validateDepth(String sourceKey, long depth, String indexName, ClusterService clusterService, Environment environment) {
        Settings settings = Optional.ofNullable(clusterService.state().metadata().index(indexName)).map(IndexMetadata::getSettings).orElse(environment.settings());
        long maxDepth = (Long)MapperService.INDEX_MAPPING_DEPTH_LIMIT_SETTING.get(settings);
        if (depth > maxDepth) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "map type field [%s] reaches max depth limit, cannot process it", sourceKey));
        }
    }
}

