/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.model;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.SnapshotManagementException;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMState;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00073456789B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005BE\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\rH\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003JQ\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\rH\u00d6\u0001J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006:"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "policySeqNo", "", "policyPrimaryTerm", "creation", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;", "deletion", "id", "", "seqNo", "primaryTerm", "(JJLorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;Ljava/lang/String;JJ)V", "getCreation", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;", "getDeletion", "getId", "()Ljava/lang/String;", "getPolicyPrimaryTerm", "()J", "getPolicySeqNo", "getPrimaryTerm", "getSeqNo", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Builder", "Companion", "Info", "LatestExecution", "Retry", "Trigger", "WorkflowMetadata", "opensearch-index-management"})
public final class SMMetadata
implements Writeable,
ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long policySeqNo;
    private final long policyPrimaryTerm;
    @NotNull
    private final WorkflowMetadata creation;
    @Nullable
    private final WorkflowMetadata deletion;
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    public static final String SM_METADATA_TYPE = "sm_metadata";
    @NotNull
    public static final String POLICY_SEQ_NO_FIELD = "policy_seq_no";
    @NotNull
    public static final String POLICY_PRIMARY_TERM_FIELD = "policy_primary_term";
    @NotNull
    public static final String CREATION_FIELD = "creation";
    @NotNull
    public static final String DELETION_FIELD = "deletion";

    public SMMetadata(long policySeqNo, long policyPrimaryTerm, @NotNull WorkflowMetadata creation, @Nullable WorkflowMetadata deletion, @NotNull String id2, long seqNo, long primaryTerm) {
        Intrinsics.checkNotNullParameter((Object)creation, (String)CREATION_FIELD);
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.policySeqNo = policySeqNo;
        this.policyPrimaryTerm = policyPrimaryTerm;
        this.creation = creation;
        this.deletion = deletion;
        this.id = id2;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public /* synthetic */ SMMetadata(long l, long l2, WorkflowMetadata workflowMetadata, WorkflowMetadata workflowMetadata2, String string, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string = "";
        }
        if ((n & 0x20) != 0) {
            l3 = -2L;
        }
        if ((n & 0x40) != 0) {
            l4 = 0L;
        }
        this(l, l2, workflowMetadata, workflowMetadata2, string, l3, l4);
    }

    public final long getPolicySeqNo() {
        return this.policySeqNo;
    }

    public final long getPolicyPrimaryTerm() {
        return this.policyPrimaryTerm;
    }

    @NotNull
    public final WorkflowMetadata getCreation() {
        return this.creation;
    }

    @Nullable
    public final WorkflowMetadata getDeletion() {
        return this.deletion;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(SM_METADATA_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field("name", SMUtilsKt.smMetadataDocIdToPolicyName(this.id)).field(POLICY_SEQ_NO_FIELD, this.policySeqNo).field(POLICY_PRIMARY_TERM_FIELD, this.policyPrimaryTerm).field(CREATION_FIELD, (ToXContent)this.creation);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(NAME_FIELD\u2026CREATION_FIELD, creation)");
        OpenSearchExtensionsKt.optionalField(xContentBuilder, DELETION_FIELD, this.deletion);
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder2 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.endObject()");
        return xContentBuilder2;
    }

    public SMMetadata(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        long l = sin.readLong();
        long l2 = sin.readLong();
        WorkflowMetadata workflowMetadata = new WorkflowMetadata(sin);
        WorkflowMetadata workflowMetadata2 = (WorkflowMetadata)sin.readOptionalWriteable(SMMetadata::_init_$lambda$0);
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        this(l, l2, workflowMetadata, workflowMetadata2, string, sin.readLong(), sin.readLong());
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeLong(this.policySeqNo);
        out.writeLong(this.policyPrimaryTerm);
        this.creation.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.deletion);
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
    }

    public final long component1() {
        return this.policySeqNo;
    }

    public final long component2() {
        return this.policyPrimaryTerm;
    }

    @NotNull
    public final WorkflowMetadata component3() {
        return this.creation;
    }

    @Nullable
    public final WorkflowMetadata component4() {
        return this.deletion;
    }

    @NotNull
    public final String component5() {
        return this.id;
    }

    public final long component6() {
        return this.seqNo;
    }

    public final long component7() {
        return this.primaryTerm;
    }

    @NotNull
    public final SMMetadata copy(long policySeqNo, long policyPrimaryTerm, @NotNull WorkflowMetadata creation, @Nullable WorkflowMetadata deletion, @NotNull String id2, long seqNo, long primaryTerm) {
        Intrinsics.checkNotNullParameter((Object)creation, (String)CREATION_FIELD);
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return new SMMetadata(policySeqNo, policyPrimaryTerm, creation, deletion, id2, seqNo, primaryTerm);
    }

    public static /* synthetic */ SMMetadata copy$default(SMMetadata sMMetadata, long l, long l2, WorkflowMetadata workflowMetadata, WorkflowMetadata workflowMetadata2, String string, long l3, long l4, int n, Object object) {
        if ((n & 1) != 0) {
            l = sMMetadata.policySeqNo;
        }
        if ((n & 2) != 0) {
            l2 = sMMetadata.policyPrimaryTerm;
        }
        if ((n & 4) != 0) {
            workflowMetadata = sMMetadata.creation;
        }
        if ((n & 8) != 0) {
            workflowMetadata2 = sMMetadata.deletion;
        }
        if ((n & 0x10) != 0) {
            string = sMMetadata.id;
        }
        if ((n & 0x20) != 0) {
            l3 = sMMetadata.seqNo;
        }
        if ((n & 0x40) != 0) {
            l4 = sMMetadata.primaryTerm;
        }
        return sMMetadata.copy(l, l2, workflowMetadata, workflowMetadata2, string, l3, l4);
    }

    @NotNull
    public String toString() {
        return "SMMetadata(policySeqNo=" + this.policySeqNo + ", policyPrimaryTerm=" + this.policyPrimaryTerm + ", creation=" + this.creation + ", deletion=" + this.deletion + ", id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ")";
    }

    public int hashCode() {
        int result2 = Long.hashCode(this.policySeqNo);
        result2 = result2 * 31 + Long.hashCode(this.policyPrimaryTerm);
        result2 = result2 * 31 + this.creation.hashCode();
        result2 = result2 * 31 + (this.deletion == null ? 0 : this.deletion.hashCode());
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SMMetadata)) {
            return false;
        }
        SMMetadata sMMetadata = (SMMetadata)other;
        if (this.policySeqNo != sMMetadata.policySeqNo) {
            return false;
        }
        if (this.policyPrimaryTerm != sMMetadata.policyPrimaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.creation, (Object)sMMetadata.creation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.deletion, (Object)sMMetadata.deletion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.id, (Object)sMMetadata.id)) {
            return false;
        }
        if (this.seqNo != sMMetadata.seqNo) {
            return false;
        }
        return this.primaryTerm == sMMetadata.primaryTerm;
    }

    private static final WorkflowMetadata _init_$lambda$0(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new WorkflowMetadata(it);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0010\u001a\u00020\u0000J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00002\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tJL\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001c2\u0010\b\u0002\u0010\u001f\u001a\n\u0018\u00010 j\u0004\u0018\u0001`!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020#J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020#J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder;", "", "metadata", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;)V", "workflowType", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/WorkflowType;", "build", "getStartedSnapshots", "", "", "getWorkflowMetadata", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;", "getWorkflowType", "resetDeletion", "resetRetry", "resetWorkflow", "setCreationStarted", "snapshot", "setCurrentState", "state", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMState;", "setDeletionStarted", "snapshots", "setLatestExecution", "status", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;", "updateMessage", "", "message", "updateCause", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "endTime", "Ljava/time/Instant;", "setNextCreationTime", "time", "setNextDeletionTime", "setRetry", "count", "", "setSeqNoPrimaryTerm", "seqNo", "", "primaryTerm", "workflow", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
    public static final class Builder {
        @NotNull
        private SMMetadata metadata;
        private WorkflowType workflowType;

        public Builder(@NotNull SMMetadata metadata2) {
            Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
            this.metadata = metadata2;
        }

        @NotNull
        public final SMMetadata build() {
            return this.metadata;
        }

        @NotNull
        public final Builder workflow(@NotNull WorkflowType workflowType) {
            Intrinsics.checkNotNullParameter((Object)((Object)workflowType), (String)"workflowType");
            this.workflowType = workflowType;
            return this;
        }

        @NotNull
        public final Builder setCurrentState(@NotNull SMState state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, WorkflowMetadata.copy$default(this.metadata.getCreation(), state, null, null, null, null, 30, null), null, null, 0L, 0L, 123, null);
                    break;
                }
                case 2: {
                    WorkflowMetadata workflowMetadata = this.metadata.getDeletion();
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, null, workflowMetadata != null ? WorkflowMetadata.copy$default(workflowMetadata, state, null, null, null, null, 30, null) : null, null, 0L, 0L, 119, null);
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder resetWorkflow() {
            WorkflowMetadata workflowMetadata;
            SMState creationCurrentState = this.metadata.getCreation().getCurrentState();
            List<String> startedCreation = this.metadata.getCreation().getStarted();
            Retry creationRetry = this.metadata.getCreation().getRetry();
            WorkflowMetadata workflowMetadata2 = this.metadata.getDeletion();
            SMState deletionCurrentState = workflowMetadata2 != null ? workflowMetadata2.getCurrentState() : null;
            List<String> startedDeletion = null;
            WorkflowMetadata workflowMetadata3 = this.metadata.getDeletion();
            startedDeletion = workflowMetadata3 != null ? workflowMetadata3.getStarted() : null;
            Retry deletionRetry = null;
            WorkflowMetadata workflowMetadata4 = this.metadata.getDeletion();
            deletionRetry = workflowMetadata4 != null ? workflowMetadata4.getRetry() : null;
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    creationCurrentState = SMState.CREATION_START;
                    startedCreation = null;
                    creationRetry = null;
                    break;
                }
                case 2: {
                    deletionCurrentState = SMState.DELETION_START;
                    startedDeletion = null;
                    deletionRetry = null;
                }
            }
            Builder builder = this;
            SMMetadata sMMetadata = this.metadata;
            long l = 0L;
            long l2 = 0L;
            WorkflowMetadata workflowMetadata5 = WorkflowMetadata.copy$default(this.metadata.getCreation(), creationCurrentState, null, startedCreation, null, creationRetry, 10, null);
            SMState sMState = deletionCurrentState;
            if (sMState != null) {
                void it;
                SMState sMState2 = sMState;
                WorkflowMetadata workflowMetadata6 = workflowMetadata5;
                long l3 = l2;
                long l4 = l;
                SMMetadata sMMetadata2 = sMMetadata;
                Builder builder2 = builder;
                boolean bl = false;
                WorkflowMetadata workflowMetadata7 = this.metadata.getDeletion();
                WorkflowMetadata workflowMetadata8 = workflowMetadata7 != null ? WorkflowMetadata.copy$default(workflowMetadata7, (SMState)it, null, startedDeletion, null, deletionRetry, 10, null) : null;
                builder = builder2;
                sMMetadata = sMMetadata2;
                l = l4;
                l2 = l3;
                workflowMetadata5 = workflowMetadata6;
                workflowMetadata = workflowMetadata8;
            } else {
                workflowMetadata = null;
            }
            builder.metadata = SMMetadata.copy$default(sMMetadata, l, l2, workflowMetadata5, workflowMetadata, null, 0L, 0L, 115, null);
            return this;
        }

        @NotNull
        public final Builder resetDeletion() {
            this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, null, null, null, 0L, 0L, 119, null);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setLatestExecution(@NotNull LatestExecution.Status status, boolean updateMessage, @Nullable String message, boolean updateCause, @Nullable Exception cause, @Nullable Instant endTime) {
            SMMetadata sMMetadata;
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            String string = message;
            String messageWithTime = string != null ? SMUtilsKt.preFixTimeStamp(string) : null;
            Exception exception = cause;
            String causeWithTime = exception != null ? SMUtilsKt.preFixTimeStamp(SnapshotManagementException.Companion.getUserErrorMessage$default(SnapshotManagementException.Companion, exception, null, 2, null).getMessage()) : null;
            Builder builder = this;
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    sMMetadata = SMMetadata.copy$default(this.metadata, 0L, 0L, Builder.setLatestExecution$getUpdatedWorkflowMetadata(status, messageWithTime, causeWithTime, updateMessage, this, updateCause, endTime, this.metadata.getCreation()), null, null, 0L, 0L, 123, null);
                    break;
                }
                case 2: {
                    WorkflowMetadata workflowMetadata;
                    SMMetadata sMMetadata2 = this.metadata;
                    long l = 0L;
                    long l2 = 0L;
                    WorkflowMetadata workflowMetadata2 = null;
                    WorkflowMetadata workflowMetadata3 = this.metadata.getDeletion();
                    if (workflowMetadata3 != null) {
                        void it;
                        WorkflowMetadata workflowMetadata4 = workflowMetadata3;
                        WorkflowMetadata workflowMetadata5 = workflowMetadata2;
                        long l3 = l2;
                        long l4 = l;
                        SMMetadata sMMetadata3 = sMMetadata2;
                        Builder builder2 = builder;
                        boolean bl = false;
                        WorkflowMetadata workflowMetadata6 = Builder.setLatestExecution$getUpdatedWorkflowMetadata(status, messageWithTime, causeWithTime, updateMessage, this, updateCause, endTime, (WorkflowMetadata)it);
                        builder = builder2;
                        sMMetadata2 = sMMetadata3;
                        l = l4;
                        l2 = l3;
                        workflowMetadata2 = workflowMetadata5;
                        workflowMetadata = workflowMetadata6;
                    } else {
                        workflowMetadata = null;
                    }
                    sMMetadata = SMMetadata.copy$default(sMMetadata2, l, l2, workflowMetadata2, workflowMetadata, null, 0L, 0L, 119, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            builder.metadata = sMMetadata;
            return this;
        }

        public static /* synthetic */ Builder setLatestExecution$default(Builder builder, LatestExecution.Status status, boolean bl, String string, boolean bl2, Exception exception, Instant instant, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                exception = null;
            }
            if ((n & 0x20) != 0) {
                instant = null;
            }
            return builder.setLatestExecution(status, bl, string, bl2, exception, instant);
        }

        @Nullable
        public final WorkflowMetadata getWorkflowMetadata() {
            WorkflowMetadata workflowMetadata;
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    workflowMetadata = this.metadata.getCreation();
                    break;
                }
                case 2: {
                    workflowMetadata = this.metadata.getDeletion();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return workflowMetadata;
        }

        @NotNull
        public final WorkflowType getWorkflowType() {
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            return workflowType;
        }

        @Nullable
        public final List<String> getStartedSnapshots() {
            List<String> list;
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    list = this.metadata.getCreation().getStarted();
                    break;
                }
                case 2: {
                    WorkflowMetadata workflowMetadata = this.metadata.getDeletion();
                    if (workflowMetadata != null) {
                        list = workflowMetadata.getStarted();
                        break;
                    }
                    list = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return list;
        }

        @NotNull
        public final Builder setRetry(int count) {
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, WorkflowMetadata.copy$default(this.metadata.getCreation(), null, null, null, null, new Retry(count), 15, null), null, null, 0L, 0L, 123, null);
                    break;
                }
                case 2: {
                    WorkflowMetadata workflowMetadata = this.metadata.getDeletion();
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, null, workflowMetadata != null ? WorkflowMetadata.copy$default(workflowMetadata, null, null, null, null, new Retry(count), 15, null) : null, null, 0L, 0L, 119, null);
                }
            }
            return this;
        }

        @NotNull
        public final Builder resetRetry() {
            WorkflowType workflowType = this.workflowType;
            if (workflowType == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"workflowType");
                workflowType = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[workflowType.ordinal()]) {
                case 1: {
                    if (this.metadata.getCreation().getRetry() == null) break;
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, WorkflowMetadata.copy$default(this.metadata.getCreation(), null, null, null, null, null, 15, null), null, null, 0L, 0L, 123, null);
                    break;
                }
                case 2: {
                    WorkflowMetadata workflowMetadata = this.metadata.getDeletion();
                    if ((workflowMetadata != null ? workflowMetadata.getRetry() : null) == null) break;
                    WorkflowMetadata workflowMetadata2 = this.metadata.getDeletion();
                    this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, null, workflowMetadata2 != null ? WorkflowMetadata.copy$default(workflowMetadata2, null, null, null, null, null, 15, null) : null, null, 0L, 0L, 119, null);
                }
            }
            return this;
        }

        @NotNull
        public final Builder setSeqNoPrimaryTerm(long seqNo, long primaryTerm) {
            this.metadata = SMMetadata.copy$default(this.metadata, seqNo, primaryTerm, null, null, null, 0L, 0L, 124, null);
            return this;
        }

        @NotNull
        public final Builder setNextCreationTime(@NotNull Instant time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, WorkflowMetadata.copy$default(this.metadata.getCreation(), null, this.metadata.getCreation().getTrigger().copy(time), null, null, null, 29, null), null, null, 0L, 0L, 123, null);
            return this;
        }

        @NotNull
        public final Builder setCreationStarted(@Nullable String snapshot) {
            String string = snapshot;
            this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, WorkflowMetadata.copy$default(this.metadata.getCreation(), null, null, (List)(string == null ? null : CollectionsKt.listOf((Object)string)), null, null, 27, null), null, null, 0L, 0L, 123, null);
            return this;
        }

        @NotNull
        public final Builder setNextDeletionTime(@NotNull Instant time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            WorkflowMetadata deletion = this.metadata.getDeletion();
            this.metadata = deletion != null ? SMMetadata.copy$default(this.metadata, 0L, 0L, null, WorkflowMetadata.copy$default(deletion, null, deletion.getTrigger().copy(time), null, null, null, 29, null), null, 0L, 0L, 119, null) : SMMetadata.copy$default(this.metadata, 0L, 0L, null, new WorkflowMetadata(SMState.DELETION_START, new Trigger(time), null, null, null, 28, null), null, 0L, 0L, 119, null);
            return this;
        }

        @NotNull
        public final Builder setDeletionStarted(@Nullable List<String> snapshots) {
            WorkflowMetadata workflowMetadata = this.metadata.getDeletion();
            this.metadata = SMMetadata.copy$default(this.metadata, 0L, 0L, null, workflowMetadata != null ? WorkflowMetadata.copy$default(workflowMetadata, null, null, snapshots, null, null, 27, null) : null, null, 0L, 0L, 119, null);
            return this;
        }

        private static final WorkflowMetadata setLatestExecution$getUpdatedWorkflowMetadata(LatestExecution.Status $status, String messageWithTime, String causeWithTime, boolean $updateMessage, Builder this$0, boolean $updateCause, Instant $endTime, WorkflowMetadata workflowMetadata) {
            LatestExecution latestExecution;
            if (workflowMetadata.getStarted() == null) {
                return WorkflowMetadata.copy$default(workflowMetadata, null, null, null, LatestExecution.Companion.init($status, new Info(messageWithTime, causeWithTime)), null, 23, null);
            }
            LatestExecution latestExecution2 = workflowMetadata.getLatestExecution();
            if (latestExecution2 != null) {
                Object object;
                Object object2;
                Info info = new Info($updateMessage ? messageWithTime : ((object2 = this$0.metadata.getCreation().getLatestExecution()) != null && (object2 = ((LatestExecution)object2).getInfo()) != null ? ((Info)object2).getMessage() : null), $updateCause ? causeWithTime : ((object = this$0.metadata.getCreation().getLatestExecution()) != null && (object = ((LatestExecution)object).getInfo()) != null ? ((Info)object).getCause() : null));
                latestExecution = LatestExecution.copy$default(latestExecution2, $status, null, $endTime, info, 2, null);
            } else {
                latestExecution = null;
            }
            return WorkflowMetadata.copy$default(workflowMetadata, null, null, null, latestExecution, null, 23, null);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[WorkflowType.values().length];
                try {
                    nArray[WorkflowType.CREATION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WorkflowType.DELETION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ:\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012j\u0004\u0018\u0001`\u0013*\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\u0006\u0010\u0014\u001a\u00020\u0004JB\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0012j\u0002`\u0013*\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012j\u0004\u0018\u0001`\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Companion;", "", "()V", "CREATION_FIELD", "", "DELETION_FIELD", "POLICY_PRIMARY_TERM_FIELD", "POLICY_SEQ_NO_FIELD", "SM_METADATA_TYPE", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "remove", "", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/InfoType;", "key", "upsert", "keyValuePair", "Lkotlin/Pair;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SMMetadata parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Long policySeqNo = null;
            Long policyPrimaryTerm = null;
            WorkflowMetadata creation = null;
            WorkflowMetadata deletion = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case -1924472498: {
                        if (string.equals(SMMetadata.POLICY_SEQ_NO_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 819717070: {
                        if (string.equals(SMMetadata.DELETION_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 3373707: {
                        if (string.equals("name")) {
                            n = 3;
                        }
                        break;
                    }
                    case -2077383050: {
                        if (string.equals(SMMetadata.POLICY_PRIMARY_TERM_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 1820421855: {
                        if (string.equals(SMMetadata.CREATION_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        if (xcp.text() == null) {
                            boolean bl = false;
                            String string2 = "The name field of SMPolicy must not be null.";
                            throw new IllegalArgumentException(string2.toString());
                        }
                        break;
                    }
                    case 1: {
                        policySeqNo = xcp.longValue();
                        break;
                    }
                    case 4: {
                        policyPrimaryTerm = xcp.longValue();
                        break;
                    }
                    case 5: {
                        creation = WorkflowMetadata.Companion.parse(xcp);
                        break;
                    }
                    case 2: {
                        deletion = WorkflowMetadata.Companion.parse(xcp);
                    }
                }
            }
            Long l = policySeqNo;
            if (l == null) {
                boolean $i$a$-requireNotNull-SMMetadata$Companion$parse$52 = false;
                String $i$a$-requireNotNull-SMMetadata$Companion$parse$52 = "policy_seq_no field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-SMMetadata$Companion$parse$52.toString());
            }
            long l2 = ((Number)l).longValue();
            Long l3 = policyPrimaryTerm;
            if (l3 == null) {
                long l4 = l2;
                boolean $i$a$-requireNotNull-SMMetadata$Companion$parse$62 = false;
                String string = "policy_primary_term field must not be null";
                long l5 = l4;
                String $i$a$-requireNotNull-SMMetadata$Companion$parse$62 = string;
                throw new IllegalArgumentException($i$a$-requireNotNull-SMMetadata$Companion$parse$62.toString());
            }
            long l6 = ((Number)l3).longValue();
            WorkflowMetadata workflowMetadata = creation;
            if (workflowMetadata == null) {
                long l7 = l6;
                long l8 = l2;
                boolean bl = false;
                String string = "creation field must not be null";
                long l9 = l8;
                long l10 = l7;
                String string3 = string;
                throw new IllegalArgumentException(string3.toString());
            }
            long l11 = primaryTerm;
            long l12 = seqNo;
            String string = id2;
            WorkflowMetadata workflowMetadata2 = deletion;
            WorkflowMetadata workflowMetadata3 = workflowMetadata;
            long l13 = l6;
            long l14 = l2;
            return new SMMetadata(l14, l13, workflowMetadata3, workflowMetadata2, string, l12, l11);
        }

        public static /* synthetic */ SMMetadata parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @NotNull
        public final Map<String, Object> upsert(@Nullable Map<String, ? extends Object> $this$upsert, @NotNull Pair<String, String> keyValuePair) {
            Intrinsics.checkNotNullParameter(keyValuePair, (String)"keyValuePair");
            Map map = $this$upsert;
            if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
                map = new LinkedHashMap();
            }
            Map info = map;
            info.put(keyValuePair.getFirst(), keyValuePair.getSecond());
            return info;
        }

        @Nullable
        public final Map<String, Object> remove(@Nullable Map<String, ? extends Object> $this$remove, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Map<String, ? extends Object> map = $this$remove;
            return this.remove(map != null ? MapsKt.toMutableMap(map) : null, key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/String;)V", "getCause", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
    public static final class Info
    implements Writeable,
    ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String message;
        @Nullable
        private final String cause;
        @NotNull
        public static final String MESSAGE_FIELD = "message";
        @NotNull
        public static final String CAUSE_FIELD = "cause";

        public Info(@Nullable String message, @Nullable String cause) {
            this.message = message;
            this.cause = cause;
        }

        public /* synthetic */ Info(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getCause() {
            return this.cause;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(OpenSearchExtensionsKt.optionalField(xContentBuilder, MESSAGE_FIELD, this.message), CAUSE_FIELD, this.cause).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
            return xContentBuilder2;
        }

        public Info(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            this(sin.readOptionalString(), sin.readOptionalString());
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeOptionalString(this.message);
            out.writeOptionalString(this.cause);
        }

        @Nullable
        public final String component1() {
            return this.message;
        }

        @Nullable
        public final String component2() {
            return this.cause;
        }

        @NotNull
        public final Info copy(@Nullable String message, @Nullable String cause) {
            return new Info(message, cause);
        }

        public static /* synthetic */ Info copy$default(Info info, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = info.message;
            }
            if ((n & 2) != 0) {
                string2 = info.cause;
            }
            return info.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Info(message=" + this.message + ", cause=" + this.cause + ")";
        }

        public int hashCode() {
            int result2 = this.message == null ? 0 : this.message.hashCode();
            result2 = result2 * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Info)) {
                return false;
            }
            Info info = (Info)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)info.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)info.cause);
        }

        public Info() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info$Companion;", "", "()V", "CAUSE_FIELD", "", "MESSAGE_FIELD", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Info parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                String message = null;
                String cause = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (Intrinsics.areEqual((Object)string, (Object)Info.MESSAGE_FIELD)) {
                        message = xcp.text();
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)string, (Object)Info.CAUSE_FIELD)) continue;
                    cause = xcp.text();
                }
                return new Info(message, cause);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0002+,B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "status", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;", "startTime", "Ljava/time/Instant;", "endTime", "info", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;)V", "getEndTime", "()Ljava/time/Instant;", "getInfo", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;", "getStartTime", "getStatus", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "Status", "opensearch-index-management"})
    public static final class LatestExecution
    implements Writeable,
    ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Status status;
        @NotNull
        private final Instant startTime;
        @Nullable
        private final Instant endTime;
        @Nullable
        private final Info info;
        @NotNull
        public static final String STATUS_FIELD = "status";
        @NotNull
        public static final String START_TIME_FIELD = "start_time";
        @NotNull
        public static final String END_TIME_FIELD = "end_time";
        @NotNull
        public static final String INFO_FIELD = "info";

        public LatestExecution(@NotNull Status status, @NotNull Instant startTime, @Nullable Instant endTime, @Nullable Info info) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            this.status = status;
            this.startTime = startTime;
            this.endTime = endTime;
            this.info = info;
        }

        public /* synthetic */ LatestExecution(Status status, Instant instant, Instant instant2, Info info, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                instant2 = null;
            }
            if ((n & 8) != 0) {
                info = null;
            }
            this(status, instant, instant2, info);
        }

        @NotNull
        public final Status getStatus() {
            return this.status;
        }

        @NotNull
        public final Instant getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final Instant getEndTime() {
            return this.endTime;
        }

        @Nullable
        public final Info getInfo() {
            return this.info;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().field(STATUS_FIELD, this.status.toString());
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026FIELD, status.toString())");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalInfoField(OpenSearchExtensionsKt.optionalTimeField(OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, START_TIME_FIELD, this.startTime), END_TIME_FIELD, this.endTime), INFO_FIELD, this.info).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
            return xContentBuilder2;
        }

        public LatestExecution(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            Enum enum_ = sin.readEnum(Status.class);
            Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(Status::class.java)");
            Status status = (Status)enum_;
            Instant instant = sin.readInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
            this(status, instant, sin.readOptionalInstant(), (Info)sin.readOptionalWriteable(LatestExecution::_init_$lambda$0));
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeEnum((Enum)this.status);
            out.writeInstant(this.startTime);
            out.writeOptionalInstant(this.endTime);
            out.writeOptionalWriteable((Writeable)this.info);
        }

        @NotNull
        public final Status component1() {
            return this.status;
        }

        @NotNull
        public final Instant component2() {
            return this.startTime;
        }

        @Nullable
        public final Instant component3() {
            return this.endTime;
        }

        @Nullable
        public final Info component4() {
            return this.info;
        }

        @NotNull
        public final LatestExecution copy(@NotNull Status status, @NotNull Instant startTime, @Nullable Instant endTime, @Nullable Info info) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            return new LatestExecution(status, startTime, endTime, info);
        }

        public static /* synthetic */ LatestExecution copy$default(LatestExecution latestExecution, Status status, Instant instant, Instant instant2, Info info, int n, Object object) {
            if ((n & 1) != 0) {
                status = latestExecution.status;
            }
            if ((n & 2) != 0) {
                instant = latestExecution.startTime;
            }
            if ((n & 4) != 0) {
                instant2 = latestExecution.endTime;
            }
            if ((n & 8) != 0) {
                info = latestExecution.info;
            }
            return latestExecution.copy(status, instant, instant2, info);
        }

        @NotNull
        public String toString() {
            return "LatestExecution(status=" + this.status + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", info=" + this.info + ")";
        }

        public int hashCode() {
            int result2 = this.status.hashCode();
            result2 = result2 * 31 + this.startTime.hashCode();
            result2 = result2 * 31 + (this.endTime == null ? 0 : this.endTime.hashCode());
            result2 = result2 * 31 + (this.info == null ? 0 : this.info.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LatestExecution)) {
                return false;
            }
            LatestExecution latestExecution = (LatestExecution)other;
            if (this.status != latestExecution.status) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startTime, (Object)latestExecution.startTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endTime, (Object)latestExecution.endTime)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)latestExecution.info);
        }

        private static final Info _init_$lambda$0(StreamInput it) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            return new Info(it);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Companion;", "", "()V", "END_TIME_FIELD", "", "INFO_FIELD", "START_TIME_FIELD", "STATUS_FIELD", "init", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution;", "status", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;", "info", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Info;", "parse", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final LatestExecution parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                Status status = null;
                Instant startTime = null;
                Instant endTime = null;
                Info info = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1573145462: {
                            if (string.equals(LatestExecution.START_TIME_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case 1725551537: {
                            if (string.equals(LatestExecution.END_TIME_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -892481550: {
                            if (string.equals(LatestExecution.STATUS_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case 3237038: {
                            if (string.equals(LatestExecution.INFO_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            String string2 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                            status = Status.valueOf(string2);
                            break;
                        }
                        case 1: {
                            startTime = OpenSearchExtensionsKt.instant(xcp);
                            break;
                        }
                        case 2: {
                            endTime = OpenSearchExtensionsKt.instant(xcp);
                            break;
                        }
                        case 4: {
                            info = Info.Companion.parse(xcp);
                        }
                    }
                }
                Status status2 = status;
                if (status2 == null) {
                    boolean $i$a$-requireNotNull-SMMetadata$LatestExecution$Companion$parse$32 = false;
                    String $i$a$-requireNotNull-SMMetadata$LatestExecution$Companion$parse$32 = "last_execution.status must not be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-SMMetadata$LatestExecution$Companion$parse$32.toString());
                }
                Instant instant = startTime;
                if (instant == null) {
                    Status status3 = status2;
                    boolean bl = false;
                    Status status4 = status3;
                    String string = "last_execution.start_time must not be null";
                    throw new IllegalArgumentException(string.toString());
                }
                Info info2 = info;
                Instant instant2 = endTime;
                Instant instant3 = instant;
                Status status5 = status2;
                return new LatestExecution(status5, instant3, instant2, info2);
            }

            @NotNull
            public final LatestExecution init(@NotNull Status status, @Nullable Info info) {
                Intrinsics.checkNotNullParameter((Object)((Object)status), (String)LatestExecution.STATUS_FIELD);
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                return new LatestExecution(status, instant, null, info, 4, null);
            }

            public static /* synthetic */ LatestExecution init$default(Companion companion, Status status, Info info, int n, Object object) {
                if ((n & 2) != 0) {
                    info = null;
                }
                return companion.init(status, info);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution$Status;", "", "(Ljava/lang/String;I)V", "IN_PROGRESS", "RETRYING", "SUCCESS", "FAILED", "TIME_LIMIT_EXCEEDED", "opensearch-index-management"})
        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status IN_PROGRESS = new Status();
            public static final /* enum */ Status RETRYING = new Status();
            public static final /* enum */ Status SUCCESS = new Status();
            public static final /* enum */ Status FAILED = new Status();
            public static final /* enum */ Status TIME_LIMIT_EXCEEDED = new Status();
            private static final /* synthetic */ Status[] $VALUES;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String value) {
                return Enum.valueOf(Status.class, value);
            }

            static {
                $VALUES = statusArray = new Status[]{Status.IN_PROGRESS, Status.RETRYING, Status.SUCCESS, Status.FAILED, Status.TIME_LIMIT_EXCEEDED};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "count", "", "(I)V", "getCount", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
    public static final class Retry
    implements Writeable,
    ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int count;
        @NotNull
        public static final String RETRY_FIELD = "retry";
        @NotNull
        public static final String COUNT_FIELD = "count";

        public Retry(int count) {
            this.count = count;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().field(COUNT_FIELD, this.count).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026             .endObject()");
            return xContentBuilder;
        }

        public Retry(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            this(sin.readInt());
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInt(this.count);
        }

        public final int component1() {
            return this.count;
        }

        @NotNull
        public final Retry copy(int count) {
            return new Retry(count);
        }

        public static /* synthetic */ Retry copy$default(Retry retry2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = retry2.count;
            }
            return retry2.copy(n);
        }

        @NotNull
        public String toString() {
            return "Retry(count=" + this.count + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.count);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Retry)) {
                return false;
            }
            Retry retry2 = (Retry)other;
            return this.count == retry2.count;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry$Companion;", "", "()V", "COUNT_FIELD", "", "RETRY_FIELD", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Retry parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                Integer count = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    if (!Intrinsics.areEqual((Object)fieldName, (Object)Retry.COUNT_FIELD)) continue;
                    count = xcp.intValue();
                }
                Integer n = count;
                if (n == null) {
                    boolean bl = false;
                    String string = "count field in Retry must not be null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int n2 = ((Number)n).intValue();
                return new Retry(n2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "time", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "getTime", "()Ljava/time/Instant;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
    public static final class Trigger
    implements Writeable,
    ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Instant time;
        @NotNull
        public static final String TIME_FIELD = "time";

        public Trigger(@NotNull Instant time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)TIME_FIELD);
            this.time = time;
        }

        @NotNull
        public final Instant getTime() {
            return this.time;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, TIME_FIELD, this.time).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
            return xContentBuilder2;
        }

        public Trigger(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            Instant instant = sin.readInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
            this(instant);
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeInstant(this.time);
        }

        @NotNull
        public final Instant component1() {
            return this.time;
        }

        @NotNull
        public final Trigger copy(@NotNull Instant time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)TIME_FIELD);
            return new Trigger(time);
        }

        public static /* synthetic */ Trigger copy$default(Trigger trigger, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                instant = trigger.time;
            }
            return trigger.copy(instant);
        }

        @NotNull
        public String toString() {
            return "Trigger(time=" + this.time + ")";
        }

        public int hashCode() {
            return this.time.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trigger)) {
                return false;
            }
            Trigger trigger = (Trigger)other;
            return Intrinsics.areEqual((Object)this.time, (Object)trigger.time);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger$Companion;", "", "()V", "TIME_FIELD", "", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n1#2:696\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Trigger parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                Instant nextExecutionTime = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    if (!Intrinsics.areEqual((Object)fieldName, (Object)Trigger.TIME_FIELD)) continue;
                    nextExecutionTime = OpenSearchExtensionsKt.instant(xcp);
                }
                Instant instant = nextExecutionTime;
                if (instant == null) {
                    boolean bl = false;
                    String string = "trigger time field must not be null.";
                    throw new IllegalArgumentException(string.toString());
                }
                Instant instant2 = instant;
                return new Trigger(instant2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B?\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\u0011\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0010H\u00c6\u0003JG\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\fH\u00d6\u0001J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "currentState", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMState;", "trigger", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger;", "started", "", "", "latestExecution", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution;", "retry", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMState;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger;Ljava/util/List;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution;Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry;)V", "getCurrentState", "()Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMState;", "getLatestExecution", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$LatestExecution;", "getRetry", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Retry;", "getStarted", "()Ljava/util/List;", "getTrigger", "()Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$Trigger;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
    public static final class WorkflowMetadata
    implements Writeable,
    ToXContentObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SMState currentState;
        @NotNull
        private final Trigger trigger;
        @Nullable
        private final List<String> started;
        @Nullable
        private final LatestExecution latestExecution;
        @Nullable
        private final Retry retry;
        @NotNull
        public static final String CURRENT_STATE_FIELD = "current_state";
        @NotNull
        public static final String TRIGGER_FIELD = "trigger";
        @NotNull
        public static final String STARTED_FIELD = "started";
        @NotNull
        public static final String LAST_EXECUTION_FIELD = "latest_execution";

        public WorkflowMetadata(@NotNull SMState currentState, @NotNull Trigger trigger, @Nullable List<String> started, @Nullable LatestExecution latestExecution, @Nullable Retry retry2) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentState), (String)"currentState");
            Intrinsics.checkNotNullParameter((Object)trigger, (String)TRIGGER_FIELD);
            this.currentState = currentState;
            this.trigger = trigger;
            this.started = started;
            this.latestExecution = latestExecution;
            this.retry = retry2;
        }

        public /* synthetic */ WorkflowMetadata(SMState sMState, Trigger trigger, List list, LatestExecution latestExecution, Retry retry2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list = null;
            }
            if ((n & 8) != 0) {
                latestExecution = null;
            }
            if ((n & 0x10) != 0) {
                retry2 = null;
            }
            this(sMState, trigger, list, latestExecution, retry2);
        }

        @NotNull
        public final SMState getCurrentState() {
            return this.currentState;
        }

        @NotNull
        public final Trigger getTrigger() {
            return this.trigger;
        }

        @Nullable
        public final List<String> getStarted() {
            return this.started;
        }

        @Nullable
        public final LatestExecution getLatestExecution() {
            return this.latestExecution;
        }

        @Nullable
        public final Retry getRetry() {
            return this.retry;
        }

        @NotNull
        public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            XContentBuilder xContentBuilder = builder.startObject().field(CURRENT_STATE_FIELD, this.currentState.toString()).field(TRIGGER_FIELD, (ToXContent)this.trigger);
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026d(TRIGGER_FIELD, trigger)");
            XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalField(OpenSearchExtensionsKt.optionalField(OpenSearchExtensionsKt.optionalField(xContentBuilder, STARTED_FIELD, this.started), LAST_EXECUTION_FIELD, this.latestExecution), "retry", this.retry).endObject();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026             .endObject()");
            return xContentBuilder2;
        }

        public WorkflowMetadata(@NotNull StreamInput sin) {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            Enum enum_ = sin.readEnum(SMState.class);
            Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(SMState::class.java)");
            this((SMState)enum_, new Trigger(sin), sin.readOptionalStringList(), (LatestExecution)sin.readOptionalWriteable(WorkflowMetadata::_init_$lambda$0), (Retry)sin.readOptionalWriteable(WorkflowMetadata::_init_$lambda$1));
        }

        public void writeTo(@NotNull StreamOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeEnum((Enum)this.currentState);
            this.trigger.writeTo(out);
            out.writeOptionalStringCollection((Collection)this.started);
            out.writeOptionalWriteable((Writeable)this.latestExecution);
            out.writeOptionalWriteable((Writeable)this.retry);
        }

        @NotNull
        public final SMState component1() {
            return this.currentState;
        }

        @NotNull
        public final Trigger component2() {
            return this.trigger;
        }

        @Nullable
        public final List<String> component3() {
            return this.started;
        }

        @Nullable
        public final LatestExecution component4() {
            return this.latestExecution;
        }

        @Nullable
        public final Retry component5() {
            return this.retry;
        }

        @NotNull
        public final WorkflowMetadata copy(@NotNull SMState currentState, @NotNull Trigger trigger, @Nullable List<String> started, @Nullable LatestExecution latestExecution, @Nullable Retry retry2) {
            Intrinsics.checkNotNullParameter((Object)((Object)currentState), (String)"currentState");
            Intrinsics.checkNotNullParameter((Object)trigger, (String)TRIGGER_FIELD);
            return new WorkflowMetadata(currentState, trigger, started, latestExecution, retry2);
        }

        public static /* synthetic */ WorkflowMetadata copy$default(WorkflowMetadata workflowMetadata, SMState sMState, Trigger trigger, List list, LatestExecution latestExecution, Retry retry2, int n, Object object) {
            if ((n & 1) != 0) {
                sMState = workflowMetadata.currentState;
            }
            if ((n & 2) != 0) {
                trigger = workflowMetadata.trigger;
            }
            if ((n & 4) != 0) {
                list = workflowMetadata.started;
            }
            if ((n & 8) != 0) {
                latestExecution = workflowMetadata.latestExecution;
            }
            if ((n & 0x10) != 0) {
                retry2 = workflowMetadata.retry;
            }
            return workflowMetadata.copy(sMState, trigger, list, latestExecution, retry2);
        }

        @NotNull
        public String toString() {
            return "WorkflowMetadata(currentState=" + this.currentState + ", trigger=" + this.trigger + ", started=" + this.started + ", latestExecution=" + this.latestExecution + ", retry=" + this.retry + ")";
        }

        public int hashCode() {
            int result2 = this.currentState.hashCode();
            result2 = result2 * 31 + this.trigger.hashCode();
            result2 = result2 * 31 + (this.started == null ? 0 : ((Object)this.started).hashCode());
            result2 = result2 * 31 + (this.latestExecution == null ? 0 : this.latestExecution.hashCode());
            result2 = result2 * 31 + (this.retry == null ? 0 : this.retry.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WorkflowMetadata)) {
                return false;
            }
            WorkflowMetadata workflowMetadata = (WorkflowMetadata)other;
            if (this.currentState != workflowMetadata.currentState) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trigger, (Object)workflowMetadata.trigger)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.started, workflowMetadata.started)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.latestExecution, (Object)workflowMetadata.latestExecution)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.retry, (Object)workflowMetadata.retry);
        }

        private static final LatestExecution _init_$lambda$0(StreamInput it) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            return new LatestExecution(it);
        }

        private static final Retry _init_$lambda$1(StreamInput it) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            return new Retry(it);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata$Companion;", "", "()V", "CURRENT_STATE_FIELD", "", "LAST_EXECUTION_FIELD", "STARTED_FIELD", "TRIGGER_FIELD", "parse", "Lorg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
        @SourceDebugExtension(value={"SMAP\nSMMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata$Companion\n+ 2 OpenSearchExtensions.kt\norg/opensearch/indexmanagement/opensearchapi/OpenSearchExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,695:1\n345#2,10:696\n345#2:706\n345#2:707\n1#3:708\n*S KotlinDebug\n*F\n+ 1 SMMetadata.kt\norg/opensearch/indexmanagement/snapshotmanagement/model/SMMetadata$WorkflowMetadata$Companion\n*L\n173#1:696,10\n174#1:706\n175#1:707\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final WorkflowMetadata parse(@NotNull XContentParser xcp) {
                Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
                SMState currentState = null;
                Trigger trigger = null;
                List started = null;
                LatestExecution latestExecution = null;
                Retry retry2 = null;
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) continue;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -91875232: {
                            if (string.equals(WorkflowMetadata.LAST_EXECUTION_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case -1708972469: {
                            if (string.equals(WorkflowMetadata.CURRENT_STATE_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -1897185151: {
                            if (string.equals(WorkflowMetadata.STARTED_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case -1059891784: {
                            if (string.equals(WorkflowMetadata.TRIGGER_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 108405416: {
                            if (string.equals("retry")) {
                                n = 5;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            String string2 = xcp.text();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"xcp.text()");
                            currentState = SMState.valueOf(string2);
                            break;
                        }
                        case 4: {
                            trigger = Trigger.Companion.parse(xcp);
                            break;
                        }
                        case 3: {
                            List list;
                            XContentParser $this$nullValueHandler$iv = xcp;
                            boolean $i$f$nullValueHandler = false;
                            if ($this$nullValueHandler$iv.currentToken() == XContentParser.Token.VALUE_NULL) {
                                list = null;
                            } else {
                                XContentParser $this$parse_u24lambda_u241 = $this$nullValueHandler$iv;
                                boolean bl = false;
                                XContentParser $this$parseArray$iv = $this$parse_u24lambda_u241;
                                boolean $i$f$parseArray = false;
                                List resArr$iv = new ArrayList();
                                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)$this$parseArray$iv.currentToken(), (XContentParser)$this$parseArray$iv);
                                while ($this$parseArray$iv.nextToken() != XContentParser.Token.END_ARRAY) {
                                    void $this$parse_u24lambda_u241_u24lambda_u240;
                                    XContentParser xContentParser = $this$parseArray$iv;
                                    List list2 = resArr$iv;
                                    boolean bl2 = false;
                                    list2.add($this$parse_u24lambda_u241_u24lambda_u240.text());
                                }
                                list = resArr$iv;
                            }
                            started = list;
                            break;
                        }
                        case 1: {
                            LatestExecution latestExecution2;
                            XContentParser $this$nullValueHandler$iv = xcp;
                            boolean $i$f$nullValueHandler = false;
                            if ($this$nullValueHandler$iv.currentToken() == XContentParser.Token.VALUE_NULL) {
                                latestExecution2 = null;
                            } else {
                                XContentParser $this$parse_u24lambda_u242 = $this$nullValueHandler$iv;
                                boolean bl = false;
                                latestExecution2 = LatestExecution.Companion.parse(xcp);
                            }
                            latestExecution = latestExecution2;
                            break;
                        }
                        case 5: {
                            Retry retry3;
                            XContentParser $this$nullValueHandler$iv = xcp;
                            boolean $i$f$nullValueHandler = false;
                            if ($this$nullValueHandler$iv.currentToken() == XContentParser.Token.VALUE_NULL) {
                                retry3 = null;
                            } else {
                                XContentParser $this$parse_u24lambda_u243 = $this$nullValueHandler$iv;
                                boolean bl = false;
                                retry3 = Retry.Companion.parse(xcp);
                            }
                            retry2 = retry3;
                        }
                    }
                }
                SMState sMState = currentState;
                if (sMState == null) {
                    boolean $i$a$-requireNotNull-SMMetadata$WorkflowMetadata$Companion$parse$62 = false;
                    String $i$a$-requireNotNull-SMMetadata$WorkflowMetadata$Companion$parse$62 = "current_state field must not be null";
                    throw new IllegalArgumentException($i$a$-requireNotNull-SMMetadata$WorkflowMetadata$Companion$parse$62.toString());
                }
                Trigger trigger2 = trigger;
                if (trigger2 == null) {
                    SMState sMState2 = sMState;
                    boolean bl = false;
                    SMState sMState3 = sMState2;
                    String string = "trigger field must not be null.";
                    throw new IllegalArgumentException(string.toString());
                }
                Retry retry4 = retry2;
                LatestExecution latestExecution3 = latestExecution;
                List list = started;
                Trigger trigger3 = trigger2;
                SMState sMState4 = sMState;
                return new WorkflowMetadata(sMState4, trigger3, list, latestExecution3, retry4);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

