/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.AccessMode;
import org.opensearch.ml.common.MLModelGroup;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupRequest;
import org.opensearch.ml.common.transport.model_group.MLUpdateModelGroupResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelGroupManager;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportUpdateModelGroupAction
extends HandledTransportAction<ActionRequest, MLUpdateModelGroupResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUpdateModelGroupAction.class);
    private final TransportService transportService;
    private final ActionFilters actionFilters;
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    ClusterService clusterService;
    ModelAccessControlHelper modelAccessControlHelper;
    MLModelGroupManager mlModelGroupManager;

    @Inject
    public TransportUpdateModelGroupAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLModelGroupManager mlModelGroupManager) {
        super("cluster:admin/opensearch/ml/update_model_group", transportService, actionFilters, MLUpdateModelGroupRequest::new);
        this.actionFilters = actionFilters;
        this.transportService = transportService;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlModelGroupManager = mlModelGroupManager;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLUpdateModelGroupResponse> listener) {
        MLUpdateModelGroupRequest updateModelGroupRequest = MLUpdateModelGroupRequest.fromActionRequest((ActionRequest)request);
        MLUpdateModelGroupInput updateModelGroupInput = updateModelGroupRequest.getUpdateModelGroupInput();
        String modelGroupId = updateModelGroupInput.getModelGroupID();
        User user = RestActionUtils.getUserContext(this.client);
        GetRequest getModelGroupRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> context.restore());
            this.client.get(getModelGroupRequest, ActionListener.wrap(modelGroup -> {
                if (modelGroup.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(NamedXContentRegistry.EMPTY, modelGroup.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                        if (this.modelAccessControlHelper.isSecurityEnabledAndModelAccessControlEnabled(user)) {
                            this.validateRequestForAccessControl(updateModelGroupInput, user, mlModelGroup);
                        } else {
                            this.validateSecurityDisabledOrModelAccessControlDisabled(updateModelGroupInput);
                        }
                        this.updateModelGroup(modelGroupId, modelGroup.getSource(), updateModelGroupInput, (ActionListener<MLUpdateModelGroupResponse>)wrappedListener, user);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml model group" + modelGroup.getId(), (Throwable)e);
                        wrappedListener.onFailure(e);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model group", RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                } else {
                    MLExceptionUtils.logException("Failed to get model group", e, log);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException("Failed to Update model group", e2, log);
            listener.onFailure(e2);
        }
    }

    private void updateModelGroup(String modelGroupId, Map<String, Object> source, MLUpdateModelGroupInput updateModelGroupInput, ActionListener<MLUpdateModelGroupResponse> listener, User user) {
        String modelGroupName = (String)source.get("name");
        if (updateModelGroupInput.getModelAccessMode() != null) {
            source.put("access", updateModelGroupInput.getModelAccessMode().getValue());
            if (AccessMode.RESTRICTED != updateModelGroupInput.getModelAccessMode()) {
                source.put("backend_roles", ImmutableList.of());
            }
        } else if (updateModelGroupInput.getBackendRoles() != null || Boolean.TRUE.equals(updateModelGroupInput.getIsAddAllBackendRoles())) {
            source.put("access", AccessMode.RESTRICTED.getValue());
        }
        if (updateModelGroupInput.getBackendRoles() != null) {
            source.put("backend_roles", updateModelGroupInput.getBackendRoles());
        }
        if (Boolean.TRUE.equals(updateModelGroupInput.getIsAddAllBackendRoles())) {
            source.put("backend_roles", user.getBackendRoles());
        }
        if (StringUtils.isNotBlank((CharSequence)updateModelGroupInput.getDescription())) {
            source.put("description", updateModelGroupInput.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)updateModelGroupInput.getName()) && !updateModelGroupInput.getName().equals(modelGroupName)) {
            this.mlModelGroupManager.validateUniqueModelGroupName(updateModelGroupInput.getName(), (ActionListener<SearchResponse>)ActionListener.wrap(modelGroups -> {
                if (modelGroups != null && modelGroups.getHits().getTotalHits() != null && modelGroups.getHits().getTotalHits().value != 0L) {
                    Iterator iterator = modelGroups.getHits().iterator();
                    while (iterator.hasNext()) {
                        String id = ((SearchHit)iterator.next()).getId();
                        listener.onFailure((Exception)new IllegalArgumentException("The name you provided is already being used by another model with ID: " + id + ". Please provide a different name"));
                    }
                } else {
                    source.put("name", updateModelGroupInput.getName());
                    this.updateModelGroup(modelGroupId, source, listener);
                }
            }, e -> {
                log.error("Failed to search model group index", (Throwable)e);
                listener.onFailure(e);
            }));
        } else {
            this.updateModelGroup(modelGroupId, source, listener);
        }
    }

    private void updateModelGroup(String modelGroupId, Map<String, Object> source, ActionListener<MLUpdateModelGroupResponse> listener) {
        UpdateRequest updateModelGroupRequest = new UpdateRequest();
        updateModelGroupRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ((UpdateRequest)updateModelGroupRequest.index(".plugins-ml-model-group")).id(modelGroupId).doc(source);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> context.restore());
            this.client.update(updateModelGroupRequest, ActionListener.wrap(r -> wrappedListener.onResponse((Object)new MLUpdateModelGroupResponse("Updated")), e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group"));
                } else {
                    log.error("Failed to update model group", e, (Object)log);
                    wrappedListener.onFailure((Exception)new MLValidationException("Failed to update Model Group"));
                }
            }));
        }
        catch (Exception e2) {
            MLExceptionUtils.logException("Failed to Update model group ", e2, log);
            listener.onFailure(e2);
        }
    }

    private void validateRequestForAccessControl(MLUpdateModelGroupInput input, User user, MLModelGroup mlModelGroup) {
        if (this.hasAccessControlChange(input) && !this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) && !this.modelAccessControlHelper.isAdmin(user)) {
            throw new IllegalArgumentException("Only owner or admin can update access control data.");
        }
        if (!(this.modelAccessControlHelper.isAdmin(user) || this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) || this.modelAccessControlHelper.isUserHasBackendRole(user, mlModelGroup))) {
            throw new IllegalArgumentException("You don't have permission to update this model group.");
        }
        if (this.modelAccessControlHelper.isOwner(mlModelGroup.getOwner(), user) && !this.modelAccessControlHelper.isAdmin(user) && !this.modelAccessControlHelper.isOwnerStillHasPermission(user, mlModelGroup)) {
            throw new IllegalArgumentException("You don't have the specified backend role to update this model group. For more information, contact your administrator.");
        }
        AccessMode accessMode = input.getModelAccessMode();
        if (!(AccessMode.PUBLIC != accessMode && AccessMode.PRIVATE != accessMode || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(input.getIsAddAllBackendRoles()))) {
            throw new IllegalArgumentException("You can specify backend roles only for a model group with the restricted access mode.");
        }
        if (accessMode == null || AccessMode.RESTRICTED == accessMode) {
            if (this.modelAccessControlHelper.isAdmin(user) && Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("Admin users cannot add all backend roles to a model group.");
            }
            if (Boolean.TRUE.equals(input.getIsAddAllBackendRoles()) && CollectionUtils.isEmpty((Collection)user.getBackendRoles())) {
                throw new IllegalArgumentException("You don't have any backend roles.");
            }
            if (CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.FALSE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You have to specify backend roles when add all backend roles is set to false.");
            }
            if (!CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You cannot specify backend roles and add all backend roles at the same time.");
            }
            if (AccessMode.RESTRICTED == accessMode && CollectionUtils.isEmpty((Collection)input.getBackendRoles()) && !Boolean.TRUE.equals(input.getIsAddAllBackendRoles())) {
                throw new IllegalArgumentException("You must specify one or more backend roles or add all backend roles to register a restricted model group.");
            }
            if (!(this.modelAccessControlHelper.isAdmin(user) || CollectionUtils.isEmpty((Collection)input.getBackendRoles()) || new HashSet(user.getBackendRoles()).containsAll(input.getBackendRoles()))) {
                throw new IllegalArgumentException("You don't have the backend roles specified.");
            }
        }
    }

    private boolean hasAccessControlChange(MLUpdateModelGroupInput input) {
        return input.getModelAccessMode() != null || input.getIsAddAllBackendRoles() != null || input.getBackendRoles() != null;
    }

    private void validateSecurityDisabledOrModelAccessControlDisabled(MLUpdateModelGroupInput input) {
        if (input.getModelAccessMode() != null || input.getIsAddAllBackendRoles() != null || !CollectionUtils.isEmpty((Collection)input.getBackendRoles())) {
            throw new IllegalArgumentException("You cannot specify model access control parameters because the Security plugin or model access control is disabled on your cluster.");
        }
    }
}

