/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.controller;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.controller.MLController;
import org.opensearch.ml.common.transport.controller.MLControllerGetRequest;
import org.opensearch.ml.common.transport.controller.MLControllerGetResponse;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetControllerTransportAction
extends HandledTransportAction<ActionRequest, MLControllerGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetControllerTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final MLModelManager mlModelManager;
    private final ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public GetControllerTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, MLModelManager mlModelManager, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/controllers/get", transportService, actionFilters, MLControllerGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.mlModelManager = mlModelManager;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLControllerGetResponse> actionListener) {
        MLControllerGetRequest controllerGetRequest = MLControllerGetRequest.fromActionRequest((ActionRequest)request);
        String modelId = controllerGetRequest.getModelId();
        FetchSourceContext fetchSourceContext = RestActionUtils.getFetchSourceContext(controllerGetRequest.isReturnContent());
        GetRequest getRequest = new GetRequest(".plugins-ml-controller").id(modelId).fetchSourceContext(fetchSourceContext);
        User user = RestActionUtils.getUserContext(this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLController controller = MLController.parse((XContentParser)parser);
                        this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListener.wrap(mlModel -> {
                            Boolean isHidden = mlModel.getIsHidden();
                            this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(hasPermission -> {
                                if (hasPermission.booleanValue()) {
                                    wrappedListener.onResponse((Object)MLControllerGetResponse.builder().controller(controller).build());
                                } else {
                                    wrappedListener.onFailure((Exception)new OpenSearchStatusException(StringUtils.getErrorMessage((String)"User doesn't have privilege to perform this operation on this model controller.", (String)modelId, (Boolean)isHidden), RestStatus.FORBIDDEN, new Object[0]));
                                }
                            }, exception -> {
                                log.error(StringUtils.getErrorMessage((String)"Permission denied: Unable to create the model controller for the given model.", (String)modelId, (Boolean)isHidden), (Throwable)exception);
                                wrappedListener.onFailure(exception);
                            }));
                        }, e -> wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model to get the corresponding model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]))));
                    }
                    catch (Exception e2) {
                        log.error("Failed to find model controller with the provided model ID", (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model controller with the provided model ID", RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get model controller index", (Throwable)e);
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model controller", RestStatus.NOT_FOUND, new Object[0]));
                } else {
                    log.error("Failed to get model controller for the provided model ID", (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get model controller ", (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

