/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.ml;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.config.TransformMethod;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADCheckpointDao;
import org.opensearch.ad.ml.IgnoreSimilarExtractor;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.ratelimit.ADCheckpointWriteWorker;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.ratelimit.RequestPriority;

public class ADColdStart
extends ModelColdStart<ThresholdedRandomCutForest, ADIndex, ADIndexManagement, ADCheckpointDao, ADCheckpointWriteWorker> {
    private static final Logger logger = LogManager.getLogger(ADColdStart.class);

    public ADColdStart(Clock clock, ThreadPool threadPool, NodeStateManager nodeStateManager, int rcfSampleSize, int numberOfTrees, int numMinSamples, int defaultSampleStride, int defaultTrainSamples, SearchFeatureDao searchFeatureDao, double thresholdMinPvalue, FeatureManager featureManager, Duration modelTtl, ADCheckpointWriteWorker checkpointWriteWorker, long rcfSeed, int maxRoundofColdStart, int coolDownMinutes) {
        super(modelTtl, coolDownMinutes, clock, threadPool, numMinSamples, checkpointWriteWorker, rcfSeed, numberOfTrees, rcfSampleSize, thresholdMinPvalue, nodeStateManager, defaultSampleStride, defaultTrainSamples, searchFeatureDao, featureManager, maxRoundofColdStart, "ad-threadpool", AnalysisType.AD);
    }

    public ADColdStart(Clock clock, ThreadPool threadPool, NodeStateManager nodeStateManager, int rcfSampleSize, int numberOfTrees, int numMinSamples, int maxSampleStride, int maxTrainSamples, SearchFeatureDao searchFeatureDao, double thresholdMinPvalue, FeatureManager featureManager, Duration modelTtl, ADCheckpointWriteWorker checkpointWriteQueue, int maxRoundofColdStart, int coolDownMinutes) {
        this(clock, threadPool, nodeStateManager, rcfSampleSize, numberOfTrees, numMinSamples, maxSampleStride, maxTrainSamples, searchFeatureDao, thresholdMinPvalue, featureManager, modelTtl, checkpointWriteQueue, -1L, maxRoundofColdStart, coolDownMinutes);
    }

    @Override
    protected List<Sample> trainModelFromDataSegments(List<Sample> pointSamples, ModelState<ThresholdedRandomCutForest> entityState, Config config, String taskId) {
        AnomalyDetector detector;
        IgnoreSimilarExtractor.ThresholdArrays thresholdArrays;
        if (pointSamples == null || pointSamples.size() == 0) {
            logger.info("Return early since data points must not be empty.");
            return null;
        }
        double[] firstPoint = pointSamples.get(0).getValueList();
        if (firstPoint == null || firstPoint.length == 0) {
            logger.info("Return early since data points must not be empty.");
            return null;
        }
        int shingleSize = config.getShingleSize();
        int baseDimension = firstPoint.length;
        int dimensions = baseDimension * shingleSize;
        ThresholdedRandomCutForest.Builder rcfBuilder = ThresholdedRandomCutForest.builder().dimensions(dimensions).sampleSize(this.rcfSampleSize).numberOfTrees(this.numberOfTrees).timeDecay(config.getTimeDecay().doubleValue()).transformDecay(config.getTimeDecay().doubleValue()).outputAfter(Math.max(shingleSize, this.numMinSamples)).initialAcceptFraction(this.initialAcceptFraction).parallelExecutionEnabled(false).compact(true).precision(Precision.FLOAT_32).boundingBoxCacheFraction(0.0).shingleSize(shingleSize).internalShinglingEnabled(true).anomalyRate(1.0 - this.thresholdMinPvalue).transformMethod(TransformMethod.NORMALIZE).alertOnce(true).autoAdjust(true);
        if (shingleSize > 1) {
            rcfBuilder.forestMode(ForestMode.STREAMING_IMPUTE);
            rcfBuilder = ADColdStart.applyImputationMethod(config, rcfBuilder);
        } else {
            rcfBuilder.forestMode(ForestMode.STANDARD);
        }
        if (this.rcfSeed > 0L) {
            rcfBuilder.randomSeed(this.rcfSeed);
        }
        if ((thresholdArrays = IgnoreSimilarExtractor.processDetectorRules(detector = (AnomalyDetector)config)) != null) {
            if (thresholdArrays.ignoreSimilarFromAbove != null && thresholdArrays.ignoreSimilarFromAbove.length > 0) {
                rcfBuilder.ignoreNearExpectedFromAbove(thresholdArrays.ignoreSimilarFromAbove);
            }
            if (thresholdArrays.ignoreSimilarFromBelow != null && thresholdArrays.ignoreSimilarFromBelow.length > 0) {
                rcfBuilder.ignoreNearExpectedFromBelow(thresholdArrays.ignoreSimilarFromBelow);
            }
            if (thresholdArrays.ignoreSimilarFromAboveByRatio != null && thresholdArrays.ignoreSimilarFromAboveByRatio.length > 0) {
                rcfBuilder.ignoreNearExpectedFromAboveByRatio(thresholdArrays.ignoreSimilarFromAboveByRatio);
            }
            if (thresholdArrays.ignoreSimilarFromBelowByRatio != null && thresholdArrays.ignoreSimilarFromBelowByRatio.length > 0) {
                rcfBuilder.ignoreNearExpectedFromBelowByRatio(thresholdArrays.ignoreSimilarFromBelowByRatio);
            }
        }
        ThresholdedRandomCutForest trcf = rcfBuilder.build();
        for (int i = 0; i < pointSamples.size(); ++i) {
            Sample dataSample = pointSamples.get(i);
            double[] dataValue = dataSample.getValueList();
            trcf.process(dataValue, dataSample.getDataEndTime().getEpochSecond());
        }
        entityState.setModel(trcf);
        entityState.setLastUsedTime(this.clock.instant());
        ((ADCheckpointWriteWorker)this.checkpointWriteWorker).write(entityState, true, RequestPriority.MEDIUM);
        return pointSamples;
    }
}

