/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support.values;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.lucene.search.Scorable;
import org.opensearch.common.lucene.ScorerAware;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.index.fielddata.SortingBinaryDocValues;
import org.opensearch.script.AggregationScript;

public class ScriptBytesValues
extends SortingBinaryDocValues
implements ScorerAware {
    private final AggregationScript script;

    public ScriptBytesValues(AggregationScript script) {
        this.script = script;
    }

    private void set(int i, Object o) {
        if (o == null) {
            this.values[i].clear();
        } else {
            CollectionUtils.ensureNoSelfReferences((Object)o, (String)"ScriptBytesValues value");
            this.values[i].copyChars((CharSequence)o.toString());
        }
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        this.script.setDocument(doc);
        Object value = this.script.execute();
        if (value == null) {
            return false;
        }
        if (value.getClass().isArray()) {
            this.count = Array.getLength(value);
            if (this.count == 0) {
                return false;
            }
            this.grow();
            for (int i = 0; i < this.count; ++i) {
                this.set(i, Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.count = coll.size();
            if (this.count == 0) {
                return false;
            }
            this.grow();
            int i = 0;
            for (Object v : coll) {
                this.set(i++, v);
            }
        } else {
            this.count = 1;
            this.set(0, value);
        }
        this.sort();
        return true;
    }

    @Override
    public void setScorer(Scorable scorer) {
        this.script.setScorer(scorer);
    }
}

