/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.DocIdSetBuilder;
import org.opensearch.common.Numbers;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesCollectorQueue;
import org.opensearch.search.aggregations.bucket.composite.SortedDocsProducer;

class UnsignedLongPointsSortedDocsProducer
extends SortedDocsProducer {
    private final byte[] lowerPointQuery;
    private final byte[] upperPointQuery;

    UnsignedLongPointsSortedDocsProducer(String field, byte[] lowerPointQuery, byte[] upperPointQuery) {
        super(field);
        this.lowerPointQuery = lowerPointQuery;
        this.upperPointQuery = upperPointQuery;
    }

    @Override
    DocIdSet processLeaf(Query query, CompositeValuesCollectorQueue queue, LeafReaderContext context, boolean fillDocIdSet) throws IOException {
        PointValues values = context.reader().getPointValues(this.field);
        if (values == null) {
            return DocIdSet.EMPTY;
        }
        BigInteger lowerBucket = Numbers.MIN_UNSIGNED_LONG_VALUE;
        Comparable lowerValue = queue.getLowerValueLeadSource();
        if (lowerValue != null) {
            if (lowerValue.getClass() != BigInteger.class) {
                throw new IllegalStateException("expected BigInteger, got " + String.valueOf(lowerValue.getClass()));
            }
            lowerBucket = (BigInteger)lowerValue;
        }
        BigInteger upperBucket = Numbers.MAX_UNSIGNED_LONG_VALUE;
        Comparable upperValue = queue.getUpperValueLeadSource();
        if (upperValue != null) {
            if (upperValue.getClass() != BigInteger.class) {
                throw new IllegalStateException("expected BigInteger, got " + String.valueOf(upperValue.getClass()));
            }
            upperBucket = (BigInteger)upperValue;
        }
        DocIdSetBuilder builder = fillDocIdSet ? new DocIdSetBuilder(context.reader().maxDoc(), values, this.field) : null;
        Visitor visitor = new Visitor(context, queue, builder, values.getBytesPerDimension(), lowerBucket.longValue(), upperBucket.longValue());
        try {
            values.intersect((PointValues.IntersectVisitor)visitor);
            visitor.flush();
        }
        catch (CollectionTerminatedException collectionTerminatedException) {
            // empty catch block
        }
        return fillDocIdSet ? builder.build() : DocIdSet.EMPTY;
    }

    private class Visitor
    implements PointValues.IntersectVisitor {
        final LeafReaderContext context;
        final CompositeValuesCollectorQueue queue;
        final DocIdSetBuilder builder;
        final int maxDoc;
        final int bytesPerDim;
        final long lowerBucket;
        final long upperBucket;
        DocIdSetBuilder bucketDocsBuilder;
        DocIdSetBuilder.BulkAdder adder;
        int remaining;
        long lastBucket;
        boolean first = true;

        Visitor(LeafReaderContext context, CompositeValuesCollectorQueue queue, DocIdSetBuilder builder, int bytesPerDim, long lowerBucket, long upperBucket) {
            this.context = context;
            this.maxDoc = context.reader().maxDoc();
            this.queue = queue;
            this.builder = builder;
            this.lowerBucket = lowerBucket;
            this.upperBucket = upperBucket;
            this.bucketDocsBuilder = new DocIdSetBuilder(this.maxDoc);
            this.bytesPerDim = bytesPerDim;
        }

        public void grow(int count) {
            this.remaining = count;
            this.adder = this.bucketDocsBuilder.grow(count);
        }

        public void visit(int docID) throws IOException {
            throw new IllegalStateException("should never be called");
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            if (this.compare(packedValue, packedValue) != PointValues.Relation.CELL_CROSSES_QUERY) {
                --this.remaining;
                return;
            }
            long bucket = BigIntegerPoint.decodeDimension((byte[])packedValue, (int)0).longValue();
            if (!this.first && Long.compareUnsigned(bucket, this.lastBucket) != 0) {
                DocIdSet docIdSet = this.bucketDocsBuilder.build();
                if (UnsignedLongPointsSortedDocsProducer.this.processBucket(this.queue, this.context, docIdSet.iterator(), Long.valueOf(this.lastBucket), this.builder) && Long.compareUnsigned(this.lowerBucket, this.lastBucket) != 0) {
                    throw new CollectionTerminatedException();
                }
                this.bucketDocsBuilder = new DocIdSetBuilder(this.maxDoc);
                assert (this.remaining > 0);
                this.adder = this.bucketDocsBuilder.grow(this.remaining);
            }
            this.lastBucket = bucket;
            this.first = false;
            this.adder.add(docID);
            --this.remaining;
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            long minBucket;
            long maxBucket;
            if (UnsignedLongPointsSortedDocsProducer.this.upperPointQuery != null && Arrays.compareUnsigned(minPackedValue, 0, this.bytesPerDim, UnsignedLongPointsSortedDocsProducer.this.upperPointQuery, 0, this.bytesPerDim) > 0 || UnsignedLongPointsSortedDocsProducer.this.lowerPointQuery != null && Arrays.compareUnsigned(maxPackedValue, 0, this.bytesPerDim, UnsignedLongPointsSortedDocsProducer.this.lowerPointQuery, 0, this.bytesPerDim) < 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Long.compareUnsigned(this.lowerBucket, Numbers.MIN_UNSIGNED_LONG_VALUE_AS_LONG) != 0 && Long.compareUnsigned(maxBucket = BigIntegerPoint.decodeDimension((byte[])maxPackedValue, (int)0).longValue(), this.lowerBucket) < 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Long.compareUnsigned(this.upperBucket, Numbers.MAX_UNSIGNED_LONG_VALUE_AS_LONG) != 0 && Long.compareUnsigned(minBucket = BigIntegerPoint.decodeDimension((byte[])minPackedValue, (int)0).longValue(), this.upperBucket) > 0) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        public void flush() throws IOException {
            if (!this.first) {
                DocIdSet docIdSet = this.bucketDocsBuilder.build();
                UnsignedLongPointsSortedDocsProducer.this.processBucket(this.queue, this.context, docIdSet.iterator(), Long.valueOf(this.lastBucket), this.builder);
                this.bucketDocsBuilder = null;
            }
        }
    }
}

