/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.opensearch.common.settings.Setting;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MergePolicyProvider;
import org.opensearch.index.OpenSearchTieredMergePolicy;

public final class TieredMergePolicyProvider
implements MergePolicyProvider {
    private final OpenSearchTieredMergePolicy tieredMergePolicy = new OpenSearchTieredMergePolicy();
    private final Logger logger;
    private final boolean mergesEnabled;
    public static final double DEFAULT_EXPUNGE_DELETES_ALLOWED = 10.0;
    public static final ByteSizeValue DEFAULT_FLOOR_SEGMENT = new ByteSizeValue(2L, ByteSizeUnit.MB);
    public static final int DEFAULT_MAX_MERGE_AT_ONCE = 10;
    public static final ByteSizeValue DEFAULT_MAX_MERGED_SEGMENT = new ByteSizeValue(5L, ByteSizeUnit.GB);
    public static final double DEFAULT_SEGMENTS_PER_TIER = 10.0;
    public static final double DEFAULT_RECLAIM_DELETES_WEIGHT = 2.0;
    public static final double DEFAULT_DELETES_PCT_ALLOWED = 20.0;
    public static final Setting<Double> INDEX_COMPOUND_FORMAT_SETTING = new Setting<Double>("index.compound_format", Double.toString(0.1), TieredMergePolicyProvider::parseNoCFSRatio, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING = Setting.doubleSetting("index.merge.policy.expunge_deletes_allowed", 10.0, 0.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.floor_segment", DEFAULT_FLOOR_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING = Setting.intSetting("index.merge.policy.max_merge_at_once", 10, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<ByteSizeValue> INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING = Setting.byteSizeSetting("index.merge.policy.max_merged_segment", DEFAULT_MAX_MERGED_SEGMENT, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING = Setting.doubleSetting("index.merge.policy.segments_per_tier", 10.0, 2.0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Double> INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING = Setting.doubleSetting("index.merge.policy.reclaim_deletes_weight", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    public static final Setting<Double> INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING = Setting.doubleSetting("index.merge.policy.deletes_pct_allowed", 20.0, 5.0, 50.0, Setting.Property.Dynamic, Setting.Property.IndexScope);

    TieredMergePolicyProvider(Logger logger, IndexSettings indexSettings) {
        this.logger = logger;
        double forceMergeDeletesPctAllowed = indexSettings.getValue(INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING);
        ByteSizeValue floorSegment = indexSettings.getValue(INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING);
        int maxMergeAtOnce = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING);
        ByteSizeValue maxMergedSegment = indexSettings.getValue(INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING);
        double segmentsPerTier = indexSettings.getValue(INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING);
        double reclaimDeletesWeight = indexSettings.getValue(INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING);
        double deletesPctAllowed = indexSettings.getValue(INDEX_MERGE_POLICY_DELETES_PCT_ALLOWED_SETTING);
        this.mergesEnabled = indexSettings.getSettings().getAsBoolean("index.merge.enabled", true);
        if (!this.mergesEnabled) {
            logger.warn("[{}] is set to false, this should only be used in tests and can cause serious problems in production environments", (Object)"index.merge.enabled");
        }
        maxMergeAtOnce = this.adjustMaxMergeAtOnceIfNeeded(maxMergeAtOnce, segmentsPerTier);
        this.tieredMergePolicy.setNoCFSRatio(indexSettings.getValue(INDEX_COMPOUND_FORMAT_SETTING));
        this.tieredMergePolicy.setForceMergeDeletesPctAllowed(forceMergeDeletesPctAllowed);
        this.tieredMergePolicy.setFloorSegmentMB(floorSegment.getMbFrac());
        this.tieredMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
        this.tieredMergePolicy.setMaxMergedSegmentMB(maxMergedSegment.getMbFrac());
        this.tieredMergePolicy.setSegmentsPerTier(segmentsPerTier);
        this.tieredMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
    }

    void setSegmentsPerTier(Double segmentsPerTier) {
        this.tieredMergePolicy.setSegmentsPerTier(segmentsPerTier);
    }

    void setMaxMergedSegment(ByteSizeValue maxMergedSegment) {
        this.tieredMergePolicy.setMaxMergedSegmentMB(maxMergedSegment.getMbFrac());
    }

    void setMaxMergesAtOnce(Integer maxMergeAtOnce) {
        this.tieredMergePolicy.setMaxMergeAtOnce(maxMergeAtOnce);
    }

    void setFloorSegmentSetting(ByteSizeValue floorSegementSetting) {
        this.tieredMergePolicy.setFloorSegmentMB(floorSegementSetting.getMbFrac());
    }

    void setExpungeDeletesAllowed(Double value) {
        this.tieredMergePolicy.setForceMergeDeletesPctAllowed(value);
    }

    void setNoCFSRatio(Double noCFSRatio) {
        this.tieredMergePolicy.setNoCFSRatio(noCFSRatio);
    }

    void setDeletesPctAllowed(Double deletesPctAllowed) {
        this.tieredMergePolicy.setDeletesPctAllowed(deletesPctAllowed);
    }

    private int adjustMaxMergeAtOnceIfNeeded(int maxMergeAtOnce, double segmentsPerTier) {
        if (!(segmentsPerTier >= (double)maxMergeAtOnce)) {
            int newMaxMergeAtOnce = (int)segmentsPerTier;
            if (newMaxMergeAtOnce <= 1) {
                newMaxMergeAtOnce = 2;
            }
            this.logger.debug("changing max_merge_at_once from [{}] to [{}] because segments_per_tier [{}] has to be higher or equal to it", (Object)maxMergeAtOnce, (Object)newMaxMergeAtOnce, (Object)segmentsPerTier);
            maxMergeAtOnce = newMaxMergeAtOnce;
        }
        return maxMergeAtOnce;
    }

    @Override
    public MergePolicy getMergePolicy() {
        return this.mergesEnabled ? this.tieredMergePolicy : NoMergePolicy.INSTANCE;
    }

    public static double parseNoCFSRatio(String noCFSRatio) {
        if ((noCFSRatio = noCFSRatio.trim()).equalsIgnoreCase("true")) {
            return 1.0;
        }
        if (noCFSRatio.equalsIgnoreCase("false")) {
            return 0.0;
        }
        try {
            double value = Double.parseDouble(noCFSRatio);
            if (value < 0.0 || value > 1.0) {
                throw new IllegalArgumentException("NoCFSRatio must be in the interval [0..1] but was: [" + value + "]");
            }
            return value;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expected a boolean or a value in the interval [0..1] but was: [" + noCFSRatio + "]", ex);
        }
    }

    public String toString() {
        return "TieredMergePolicyProvider{expungeDeletesAllowed=" + this.tieredMergePolicy.getForceMergeDeletesPctAllowed() + ", floorSegment=" + this.tieredMergePolicy.getFloorSegmentMB() + ", maxMergeAtOnce=" + this.tieredMergePolicy.getMaxMergeAtOnce() + ", maxMergedSegment=" + this.tieredMergePolicy.getMaxMergedSegmentMB() + ", segmentsPerTier=" + this.tieredMergePolicy.getSegmentsPerTier() + ", deletesPctAllowed=" + this.tieredMergePolicy.getDeletesPctAllowed() + "}";
    }
}

