/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.remote;

import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.common.remote.RemoteWriteableEntity;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;

public abstract class AbstractRemoteWritableBlobEntity<T>
implements RemoteWriteableEntity<T> {
    protected String blobFileName;
    protected String blobName;
    private final String clusterUUID;
    private final Compressor compressor;
    private final NamedXContentRegistry namedXContentRegistry;
    private String[] pathTokens;

    public AbstractRemoteWritableBlobEntity(String clusterUUID, Compressor compressor, NamedXContentRegistry namedXContentRegistry) {
        this.clusterUUID = clusterUUID;
        this.compressor = compressor;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public AbstractRemoteWritableBlobEntity(String clusterUUID, Compressor compressor) {
        this(clusterUUID, compressor, null);
    }

    public abstract BlobPathParameters getBlobPathParameters();

    public abstract String getType();

    public String getFullBlobName() {
        return this.blobName;
    }

    public String getBlobFileName() {
        if (this.blobFileName == null) {
            String[] pathTokens = this.getBlobPathTokens();
            if (pathTokens == null || pathTokens.length < 1) {
                return null;
            }
            this.blobFileName = pathTokens[pathTokens.length - 1];
        }
        return this.blobFileName;
    }

    public String[] getBlobPathTokens() {
        if (this.pathTokens != null) {
            return this.pathTokens;
        }
        if (this.blobName == null) {
            return null;
        }
        this.pathTokens = this.blobName.split("/");
        return this.pathTokens;
    }

    public abstract String generateBlobFileName();

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public abstract ClusterMetadataManifest.UploadedMetadata getUploadedMetadata();

    public void setFullBlobName(BlobPath blobPath) {
        this.blobName = blobPath.buildAsString() + this.blobFileName;
    }

    public NamedXContentRegistry getNamedXContentRegistry() {
        return this.namedXContentRegistry;
    }

    protected Compressor getCompressor() {
        return this.compressor;
    }
}

