/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.RoutingTableIncrementalDiff;
import org.opensearch.common.lifecycle.LifecycleComponent;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.gateway.remote.ClusterMetadataManifest;

public interface RemoteRoutingTableService
extends LifecycleComponent {
    public static final DiffableUtils.DiffableValueSerializer<String, IndexRoutingTable> CUSTOM_ROUTING_TABLE_DIFFABLE_VALUE_SERIALIZER = new DiffableUtils.DiffableValueSerializer<String, IndexRoutingTable>(){

        @Override
        public IndexRoutingTable read(StreamInput in, String key) throws IOException {
            return IndexRoutingTable.readFrom(in);
        }

        @Override
        public void write(IndexRoutingTable value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public Diff<IndexRoutingTable> readDiff(StreamInput in, String key) throws IOException {
            return IndexRoutingTable.readDiffFrom(in);
        }

        @Override
        public Diff<IndexRoutingTable> diff(IndexRoutingTable currentState, IndexRoutingTable previousState) {
            ArrayList<IndexShardRoutingTable> diffs = new ArrayList<IndexShardRoutingTable>();
            for (Map.Entry<Integer, IndexShardRoutingTable> entry : currentState.getShards().entrySet()) {
                Integer index = entry.getKey();
                IndexShardRoutingTable currentShardRoutingTable = entry.getValue();
                IndexShardRoutingTable previousShardRoutingTable = previousState.shard(index);
                if (previousShardRoutingTable != null && previousShardRoutingTable.equals(currentShardRoutingTable)) continue;
                diffs.add(currentShardRoutingTable);
            }
            return new RoutingTableIncrementalDiff.IndexRoutingTableIncrementalDiff(diffs);
        }
    };

    public List<IndexRoutingTable> getIndicesRouting(RoutingTable var1);

    public void getAsyncIndexRoutingReadAction(String var1, String var2, LatchedActionListener<IndexRoutingTable> var3);

    public void getAsyncIndexRoutingTableDiffReadAction(String var1, String var2, LatchedActionListener<RoutingTableIncrementalDiff> var3);

    public List<ClusterMetadataManifest.UploadedIndexMetadata> getUpdatedIndexRoutingTableMetadata(List<String> var1, List<ClusterMetadataManifest.UploadedIndexMetadata> var2);

    public DiffableUtils.MapDiff<String, IndexRoutingTable, Map<String, IndexRoutingTable>> getIndicesRoutingMapDiff(RoutingTable var1, RoutingTable var2);

    public void getAsyncIndexRoutingWriteAction(String var1, long var2, long var4, IndexRoutingTable var6, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> var7);

    public void getAsyncIndexRoutingDiffWriteAction(String var1, long var2, long var4, Map<String, Diff<IndexRoutingTable>> var6, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> var7);

    public List<ClusterMetadataManifest.UploadedIndexMetadata> getAllUploadedIndicesRouting(ClusterMetadataManifest var1, List<ClusterMetadataManifest.UploadedIndexMetadata> var2, List<String> var3);

    public void deleteStaleIndexRoutingPaths(List<String> var1) throws IOException;

    public void deleteStaleIndexRoutingDiffPaths(List<String> var1) throws IOException;
}

